/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.openapi.progress.impl;

import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.google.common.collect.ConcurrentHashMultiset;
import org.jetbrains.kotlin.com.intellij.concurrency.JobScheduler;
import org.jetbrains.kotlin.com.intellij.openapi.Disposable;
import org.jetbrains.kotlin.com.intellij.openapi.application.ApplicationManager;
import org.jetbrains.kotlin.com.intellij.openapi.application.ModalityState;
import org.jetbrains.kotlin.com.intellij.openapi.application.ex.ApplicationEx;
import org.jetbrains.kotlin.com.intellij.openapi.progress.EmptyProgressIndicator;
import org.jetbrains.kotlin.com.intellij.openapi.progress.ProcessCanceledException;
import org.jetbrains.kotlin.com.intellij.openapi.progress.ProgressIndicator;
import org.jetbrains.kotlin.com.intellij.openapi.progress.ProgressManager;
import org.jetbrains.kotlin.com.intellij.openapi.progress.StandardProgressIndicator;
import org.jetbrains.kotlin.com.intellij.openapi.progress.Task;
import org.jetbrains.kotlin.com.intellij.openapi.progress.WrappedProgressIndicator;
import org.jetbrains.kotlin.com.intellij.openapi.progress.impl.NonCancelableIndicator;
import org.jetbrains.kotlin.com.intellij.openapi.util.Disposer;
import org.jetbrains.kotlin.com.intellij.openapi.wm.ex.ProgressIndicatorEx;
import org.jetbrains.kotlin.com.intellij.util.containers.ConcurrentLongObjectMap;
import org.jetbrains.kotlin.com.intellij.util.containers.ContainerUtil;
import org.jetbrains.kotlin.com.intellij.util.containers.SmartHashSet;
import org.jetbrains.kotlin.gnu.trove.THashMap;

public class CoreProgressManager
extends ProgressManager
implements Disposable {
    final AtomicInteger myCurrentUnsafeProgressCount = new AtomicInteger(0);
    private final AtomicInteger myCurrentModalProgressCount = new AtomicInteger(0);
    private static final boolean ENABLED = !"disabled".equals(System.getProperty("idea.ProcessCanceledException"));
    private ScheduledFuture<?> myCheckCancelledFuture;
    private static final Map<ProgressIndicator, Set<Thread>> threadsUnderIndicator = new THashMap<ProgressIndicator, Set<Thread>>();
    private static final ConcurrentLongObjectMap<ProgressIndicator> currentIndicators = ContainerUtil.createConcurrentLongObjectMap();
    static final Set<Thread> threadsUnderCanceledIndicator = ContainerUtil.newConcurrentSet();
    private static volatile boolean thereIsProcessUnderCanceledIndicator;
    private static final Collection<ProgressIndicator> nonStandardIndicators;

    @NotNull
    private ScheduledFuture<?> startBackgroundIndicatorPing() {
        ScheduledFuture<?> scheduledFuture = JobScheduler.getScheduler().scheduleWithFixedDelay(new Runnable(){

            @Override
            public void run() {
                for (ProgressIndicator indicator : nonStandardIndicators) {
                    try {
                        indicator.checkCanceled();
                    }
                    catch (ProcessCanceledException e) {
                        CoreProgressManager.this.indicatorCanceled(indicator);
                    }
                }
            }
        }, 0L, 10L, TimeUnit.MILLISECONDS);
        if (scheduledFuture == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/openapi/progress/impl/CoreProgressManager", "startBackgroundIndicatorPing"));
        }
        return scheduledFuture;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dispose() {
        Map<ProgressIndicator, Set<Thread>> map2 = threadsUnderIndicator;
        synchronized (map2) {
            if (this.myCheckCancelledFuture != null) {
                this.myCheckCancelledFuture.cancel(true);
                this.myCheckCancelledFuture = null;
            }
        }
    }

    @Override
    protected void doCheckCanceled() throws ProcessCanceledException {
        ProgressIndicator progress;
        if (thereIsProcessUnderCanceledIndicator && (progress = this.getProgressIndicator()) != null && ENABLED) {
            progress.checkCanceled();
        }
    }

    @Override
    public void runProcess(final @NotNull Runnable process2, final ProgressIndicator progress) {
        if (process2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "process", "org/jetbrains/kotlin/com/intellij/openapi/progress/impl/CoreProgressManager", "runProcess"));
        }
        this.executeProcessUnderProgress(new Runnable(){

            @Override
            public void run() {
                try {
                    try {
                        if (progress != null && !progress.isRunning()) {
                            progress.start();
                        }
                    }
                    catch (RuntimeException e) {
                        throw e;
                    }
                    catch (Throwable e) {
                        throw new RuntimeException(e);
                    }
                    process2.run();
                }
                finally {
                    if (progress != null && progress.isRunning()) {
                        progress.stop();
                        if (progress instanceof ProgressIndicatorEx) {
                            ((ProgressIndicatorEx)progress).processFinish();
                        }
                    }
                }
            }
        }, progress);
    }

    @Override
    public void executeNonCancelableSection(@NotNull Runnable runnable) {
        if (runnable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runnable", "org/jetbrains/kotlin/com/intellij/openapi/progress/impl/CoreProgressManager", "executeNonCancelableSection"));
        }
        this.executeProcessUnderProgress(runnable, new NonCancelableIndicator());
    }

    @Override
    public void run(@NotNull Task task) {
        if (task == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "task", "org/jetbrains/kotlin/com/intellij/openapi/progress/impl/CoreProgressManager", "run"));
        }
        if (task.isHeadless()) {
            if (ApplicationManager.getApplication().isDispatchThread()) {
                this.runProcessWithProgressSynchronously(task, null);
            } else {
                new TaskRunnable(task, new EmptyProgressIndicator()).run();
            }
        } else if (task.isModal()) {
            this.runProcessWithProgressSynchronously(task.asModal(), null);
        } else {
            Task.Backgroundable backgroundable = task.asBackgroundable();
            if (backgroundable.isConditionalModal() && !backgroundable.shouldStartInBackground()) {
                this.runProcessWithProgressSynchronously(task, null);
            } else {
                this.runProcessWithProgressAsynchronously(backgroundable);
            }
        }
    }

    @NotNull
    public Future<?> runProcessWithProgressAsynchronously(@NotNull Task.Backgroundable task) {
        if (task == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "task", "org/jetbrains/kotlin/com/intellij/openapi/progress/impl/CoreProgressManager", "runProcessWithProgressAsynchronously"));
        }
        Future<?> future = this.runProcessWithProgressAsynchronously(task, new EmptyProgressIndicator(), null);
        if (future == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/openapi/progress/impl/CoreProgressManager", "runProcessWithProgressAsynchronously"));
        }
        return future;
    }

    @NotNull
    public Future<?> runProcessWithProgressAsynchronously(@NotNull Task.Backgroundable task, @NotNull ProgressIndicator progressIndicator, @Nullable Runnable continuation) {
        if (task == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "task", "org/jetbrains/kotlin/com/intellij/openapi/progress/impl/CoreProgressManager", "runProcessWithProgressAsynchronously"));
        }
        if (progressIndicator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "progressIndicator", "org/jetbrains/kotlin/com/intellij/openapi/progress/impl/CoreProgressManager", "runProcessWithProgressAsynchronously"));
        }
        Future<?> future = this.runProcessWithProgressAsynchronously(task, progressIndicator, continuation, ModalityState.NON_MODAL);
        if (future == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/openapi/progress/impl/CoreProgressManager", "runProcessWithProgressAsynchronously"));
        }
        return future;
    }

    @NotNull
    public Future<?> runProcessWithProgressAsynchronously(final @NotNull Task.Backgroundable task, final @NotNull ProgressIndicator progressIndicator, @Nullable Runnable continuation, final @NotNull ModalityState modalityState) {
        if (task == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "task", "org/jetbrains/kotlin/com/intellij/openapi/progress/impl/CoreProgressManager", "runProcessWithProgressAsynchronously"));
        }
        if (progressIndicator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "progressIndicator", "org/jetbrains/kotlin/com/intellij/openapi/progress/impl/CoreProgressManager", "runProcessWithProgressAsynchronously"));
        }
        if (modalityState == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modalityState", "org/jetbrains/kotlin/com/intellij/openapi/progress/impl/CoreProgressManager", "runProcessWithProgressAsynchronously"));
        }
        if (progressIndicator instanceof Disposable) {
            Disposer.register(ApplicationManager.getApplication(), (Disposable)((Object)progressIndicator));
        }
        final TaskRunnable process2 = new TaskRunnable(task, progressIndicator, continuation);
        TaskContainer action = new TaskContainer(task){

            @Override
            public void run() {
                boolean canceled = false;
                try {
                    ProgressManager.getInstance().runProcess(process2, progressIndicator);
                }
                catch (ProcessCanceledException e) {
                    canceled = true;
                }
                if (canceled || progressIndicator.isCanceled()) {
                    ApplicationManager.getApplication().invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            task.onCancel();
                        }
                    }, modalityState);
                } else {
                    ApplicationManager.getApplication().invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            task.onSuccess();
                        }
                    }, modalityState);
                }
            }
        };
        Future<?> future = ApplicationManager.getApplication().executeOnPooledThread(action);
        if (future == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/openapi/progress/impl/CoreProgressManager", "runProcessWithProgressAsynchronously"));
        }
        return future;
    }

    protected boolean runProcessWithProgressSynchronously(final @NotNull Task task, @Nullable JComponent parentComponent) {
        if (task == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "task", "org/jetbrains/kotlin/com/intellij/openapi/progress/impl/CoreProgressManager", "runProcessWithProgressSynchronously"));
        }
        boolean result2 = ((ApplicationEx)ApplicationManager.getApplication()).runProcessWithProgressSynchronously(new TaskContainer(task){

            @Override
            public void run() {
                new TaskRunnable(task, ProgressManager.getInstance().getProgressIndicator()).run();
            }
        }, task.getTitle(), task.isCancellable(), task.getProject(), parentComponent, task.getCancelText());
        if (result2) {
            task.onSuccess();
        } else {
            task.onCancel();
        }
        return result2;
    }

    @Override
    public ProgressIndicator getProgressIndicator() {
        return CoreProgressManager.getCurrentIndicator(Thread.currentThread());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void executeProcessUnderProgress(@NotNull Runnable process2, ProgressIndicator progress) throws ProcessCanceledException {
        block12: {
            boolean modal;
            if (process2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "process", "org/jetbrains/kotlin/com/intellij/openapi/progress/impl/CoreProgressManager", "executeProcessUnderProgress"));
            }
            boolean bl = modal = progress != null && progress.isModal();
            if (modal) {
                this.myCurrentModalProgressCount.incrementAndGet();
            }
            if (progress == null) {
                this.myCurrentUnsafeProgressCount.incrementAndGet();
            }
            try {
                boolean set;
                ProgressIndicator oldIndicator = null;
                boolean bl2 = set = progress != null && progress != (oldIndicator = this.getProgressIndicator());
                if (set) {
                    Thread currentThread = Thread.currentThread();
                    CoreProgressManager.setCurrentIndicator(currentThread, progress);
                    try {
                        this.registerIndicatorAndRun(progress, currentThread, oldIndicator, process2);
                        break block12;
                    }
                    finally {
                        CoreProgressManager.setCurrentIndicator(currentThread, oldIndicator);
                    }
                }
                process2.run();
            }
            finally {
                if (progress == null) {
                    this.myCurrentUnsafeProgressCount.decrementAndGet();
                }
                if (modal) {
                    this.myCurrentModalProgressCount.decrementAndGet();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerIndicatorAndRun(@NotNull ProgressIndicator indicator, @NotNull Thread currentThread, ProgressIndicator oldIndicator, @NotNull Runnable process2) {
        boolean isStandard;
        boolean alreadyUnder;
        Set<Thread> underIndicator;
        if (indicator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "org/jetbrains/kotlin/com/intellij/openapi/progress/impl/CoreProgressManager", "registerIndicatorAndRun"));
        }
        if (currentThread == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "currentThread", "org/jetbrains/kotlin/com/intellij/openapi/progress/impl/CoreProgressManager", "registerIndicatorAndRun"));
        }
        if (process2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "process", "org/jetbrains/kotlin/com/intellij/openapi/progress/impl/CoreProgressManager", "registerIndicatorAndRun"));
        }
        Map<ProgressIndicator, Set<Thread>> map2 = threadsUnderIndicator;
        synchronized (map2) {
            underIndicator = threadsUnderIndicator.get(indicator);
            if (underIndicator == null) {
                underIndicator = new SmartHashSet<Thread>();
                threadsUnderIndicator.put(indicator, underIndicator);
            }
            alreadyUnder = !underIndicator.add(currentThread);
            isStandard = indicator instanceof StandardProgressIndicator;
            if (!isStandard) {
                nonStandardIndicators.add(indicator);
                if (this.myCheckCancelledFuture == null) {
                    this.myCheckCancelledFuture = this.startBackgroundIndicatorPing();
                }
            }
            if (indicator.isCanceled()) {
                threadsUnderCanceledIndicator.add(currentThread);
            } else {
                threadsUnderCanceledIndicator.remove(currentThread);
            }
            thereIsProcessUnderCanceledIndicator = !threadsUnderCanceledIndicator.isEmpty();
        }
        try {
            if (indicator instanceof WrappedProgressIndicator) {
                ProgressIndicator wrappee = ((WrappedProgressIndicator)indicator).getOriginalProgressIndicator();
                assert (wrappee != indicator) : indicator + " wraps itself";
                this.registerIndicatorAndRun(wrappee, currentThread, oldIndicator, process2);
            } else {
                process2.run();
            }
            map2 = threadsUnderIndicator;
        }
        catch (Throwable throwable) {
            Map<ProgressIndicator, Set<Thread>> map3 = threadsUnderIndicator;
            synchronized (map3) {
                boolean removed;
                boolean bl = removed = alreadyUnder || underIndicator.remove(currentThread);
                if (removed && underIndicator.isEmpty()) {
                    threadsUnderIndicator.remove(indicator);
                }
                if (!isStandard) {
                    nonStandardIndicators.remove(indicator);
                    if (nonStandardIndicators.isEmpty()) {
                        this.myCheckCancelledFuture.cancel(true);
                        this.myCheckCancelledFuture = null;
                    }
                }
                if (oldIndicator != null && oldIndicator.isCanceled()) {
                    threadsUnderCanceledIndicator.add(currentThread);
                } else {
                    threadsUnderCanceledIndicator.remove(currentThread);
                }
                thereIsProcessUnderCanceledIndicator = !threadsUnderCanceledIndicator.isEmpty();
            }
            throw throwable;
        }
        synchronized (map2) {
            boolean removed;
            boolean bl = removed = alreadyUnder || underIndicator.remove(currentThread);
            if (removed && underIndicator.isEmpty()) {
                threadsUnderIndicator.remove(indicator);
            }
            if (!isStandard) {
                nonStandardIndicators.remove(indicator);
                if (nonStandardIndicators.isEmpty()) {
                    this.myCheckCancelledFuture.cancel(true);
                    this.myCheckCancelledFuture = null;
                }
            }
            if (oldIndicator != null && oldIndicator.isCanceled()) {
                threadsUnderCanceledIndicator.add(currentThread);
            } else {
                threadsUnderCanceledIndicator.remove(currentThread);
            }
            thereIsProcessUnderCanceledIndicator = !threadsUnderCanceledIndicator.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void indicatorCanceled(@NotNull ProgressIndicator indicator) {
        if (indicator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "org/jetbrains/kotlin/com/intellij/openapi/progress/impl/CoreProgressManager", "indicatorCanceled"));
        }
        Map<ProgressIndicator, Set<Thread>> map2 = threadsUnderIndicator;
        synchronized (map2) {
            Set<Thread> threads = threadsUnderIndicator.get(indicator);
            if (threads != null) {
                for (Thread thread2 : threads) {
                    boolean underCancelledIndicator = false;
                    ProgressIndicator currentIndicator = CoreProgressManager.getCurrentIndicator(thread2);
                    while (currentIndicator != null) {
                        if (currentIndicator == indicator) {
                            underCancelledIndicator = true;
                            break;
                        }
                        currentIndicator = currentIndicator instanceof WrappedProgressIndicator ? ((WrappedProgressIndicator)currentIndicator).getOriginalProgressIndicator() : null;
                    }
                    if (!underCancelledIndicator) continue;
                    threadsUnderCanceledIndicator.add(thread2);
                    thereIsProcessUnderCanceledIndicator = true;
                }
            }
        }
    }

    private static void setCurrentIndicator(@NotNull Thread currentThread, ProgressIndicator indicator) {
        if (currentThread == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "currentThread", "org/jetbrains/kotlin/com/intellij/openapi/progress/impl/CoreProgressManager", "setCurrentIndicator"));
        }
        if (indicator == null) {
            currentIndicators.remove(currentThread.getId());
        } else {
            currentIndicators.put(currentThread.getId(), indicator);
        }
    }

    private static ProgressIndicator getCurrentIndicator(@NotNull Thread thread2) {
        if (thread2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "thread", "org/jetbrains/kotlin/com/intellij/openapi/progress/impl/CoreProgressManager", "getCurrentIndicator"));
        }
        return currentIndicators.get(thread2.getId());
    }

    static {
        nonStandardIndicators = ConcurrentHashMultiset.create();
    }

    protected static class TaskRunnable
    extends TaskContainer {
        private final ProgressIndicator myIndicator;
        private final Runnable myContinuation;

        public TaskRunnable(@NotNull Task task, @NotNull ProgressIndicator indicator) {
            if (task == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "task", "org/jetbrains/kotlin/com/intellij/openapi/progress/impl/CoreProgressManager$TaskRunnable", "<init>"));
            }
            if (indicator == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "org/jetbrains/kotlin/com/intellij/openapi/progress/impl/CoreProgressManager$TaskRunnable", "<init>"));
            }
            this(task, indicator, null);
        }

        public TaskRunnable(@NotNull Task task, @NotNull ProgressIndicator indicator, @Nullable Runnable continuation) {
            if (task == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "task", "org/jetbrains/kotlin/com/intellij/openapi/progress/impl/CoreProgressManager$TaskRunnable", "<init>"));
            }
            if (indicator == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "org/jetbrains/kotlin/com/intellij/openapi/progress/impl/CoreProgressManager$TaskRunnable", "<init>"));
            }
            super(task);
            this.myIndicator = indicator;
            this.myContinuation = continuation;
        }

        @Override
        public void run() {
            try {
                this.getTask().run(this.myIndicator);
            }
            finally {
                try {
                    if (this.myIndicator instanceof ProgressIndicatorEx) {
                        ((ProgressIndicatorEx)this.myIndicator).finish(this.getTask());
                    }
                }
                finally {
                    if (this.myContinuation != null) {
                        this.myContinuation.run();
                    }
                }
            }
        }
    }

    protected static abstract class TaskContainer
    implements Runnable {
        private final Task myTask;

        protected TaskContainer(@NotNull Task task) {
            if (task == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "task", "org/jetbrains/kotlin/com/intellij/openapi/progress/impl/CoreProgressManager$TaskContainer", "<init>"));
            }
            this.myTask = task;
        }

        @NotNull
        public Task getTask() {
            Task task = this.myTask;
            if (task == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/openapi/progress/impl/CoreProgressManager$TaskContainer", "getTask"));
            }
            return task;
        }
    }
}

