/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.openapi.editor.impl;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.openapi.editor.event.DocumentEvent;
import org.jetbrains.kotlin.com.intellij.openapi.util.Segment;

class PersistentRangeMarkerUtil {
    static boolean shouldTranslateViaDiff(@NotNull DocumentEvent e, @NotNull Segment rangeMarker) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "org/jetbrains/kotlin/com/intellij/openapi/editor/impl/PersistentRangeMarkerUtil", "shouldTranslateViaDiff"));
        }
        if (rangeMarker == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rangeMarker", "org/jetbrains/kotlin/com/intellij/openapi/editor/impl/PersistentRangeMarkerUtil", "shouldTranslateViaDiff"));
        }
        if (e.isWholeTextReplaced()) {
            return true;
        }
        if (e.getOffset() >= rangeMarker.getEndOffset() || e.getOffset() + e.getOldLength() <= rangeMarker.getStartOffset()) {
            return false;
        }
        return (double)Math.max(e.getNewLength(), e.getOldLength()) * 1.0 / (double)e.getDocument().getTextLength() >= 0.8;
    }
}

