/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.openapi.editor.impl;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.openapi.editor.Document;
import org.jetbrains.kotlin.com.intellij.openapi.editor.event.DocumentEvent;
import org.jetbrains.kotlin.com.intellij.openapi.editor.impl.PersistentRangeMarkerUtil;
import org.jetbrains.kotlin.com.intellij.openapi.editor.impl.RangeMarkerImpl;
import org.jetbrains.kotlin.com.intellij.openapi.editor.impl.event.DocumentEventImpl;
import org.jetbrains.kotlin.com.intellij.openapi.util.Pair;
import org.jetbrains.kotlin.com.intellij.openapi.util.ProperTextRange;
import org.jetbrains.kotlin.com.intellij.openapi.util.Segment;
import org.jetbrains.kotlin.com.intellij.util.diff.FilesTooBigForDiffException;

class PersistentRangeMarker
extends RangeMarkerImpl {
    private LinesCols myLinesCols;

    @Nullable
    static LinesCols storeLinesAndCols(Segment range, Document myDocument) {
        int myEndColumn;
        int myEndLine;
        int myStartColumn;
        int myStartLine;
        int startOffset = range.getStartOffset();
        if (startOffset <= myDocument.getTextLength()) {
            myStartLine = myDocument.getLineNumber(startOffset);
            myStartColumn = startOffset - myDocument.getLineStartOffset(myStartLine);
            if (myStartColumn < 0) {
                return null;
            }
        } else {
            return null;
        }
        int endOffset = range.getEndOffset();
        if (endOffset <= myDocument.getTextLength()) {
            myEndLine = myDocument.getLineNumber(endOffset);
            myEndColumn = endOffset - myDocument.getLineStartOffset(myEndLine);
            if (myEndColumn < 0) {
                return null;
            }
        } else {
            return null;
        }
        return new LinesCols(myStartLine, myStartColumn, myEndLine, myEndColumn);
    }

    @Nullable
    private static Pair<ProperTextRange, LinesCols> translateViaDiff(DocumentEventImpl event, LinesCols linesCols) {
        try {
            int myStartLine = event.translateLineViaDiffStrict(linesCols.myStartLine);
            Document document = event.getDocument();
            if (myStartLine < 0 || myStartLine >= document.getLineCount()) {
                return null;
            }
            int start = document.getLineStartOffset(myStartLine) + linesCols.myStartColumn;
            if (start >= document.getTextLength()) {
                return null;
            }
            int myEndLine = event.translateLineViaDiffStrict(linesCols.myEndLine);
            if (myEndLine < 0 || myEndLine >= document.getLineCount()) {
                return null;
            }
            int end = document.getLineStartOffset(myEndLine) + linesCols.myEndColumn;
            if (end > document.getTextLength() || end < start) {
                return null;
            }
            return Pair.create(new ProperTextRange(start, end), new LinesCols(myStartLine, linesCols.myStartColumn, myEndLine, linesCols.myEndColumn));
        }
        catch (FilesTooBigForDiffException e) {
            return null;
        }
    }

    @Override
    protected void changedUpdateImpl(@NotNull DocumentEvent e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "org/jetbrains/kotlin/com/intellij/openapi/editor/impl/PersistentRangeMarker", "changedUpdateImpl"));
        }
        if (!this.isValid()) {
            return;
        }
        Pair<ProperTextRange, LinesCols> pair = PersistentRangeMarker.applyChange(e, this, this.intervalStart(), this.intervalEnd(), this.isGreedyToLeft(), this.isGreedyToRight(), this.myLinesCols);
        if (pair == null) {
            this.invalidate(e);
            return;
        }
        this.setIntervalStart(((ProperTextRange)pair.first).getStartOffset());
        this.setIntervalEnd(((ProperTextRange)pair.first).getEndOffset());
        this.myLinesCols = (LinesCols)pair.second;
    }

    @Nullable
    static Pair<ProperTextRange, LinesCols> applyChange(DocumentEvent event, Segment range, int intervalStart, int intervalEnd, boolean greedyLeft, boolean greedyRight, LinesCols linesCols) {
        boolean shouldTranslateViaDiff = PersistentRangeMarkerUtil.shouldTranslateViaDiff(event, range);
        Pair<ProperTextRange, LinesCols> translated = null;
        if (shouldTranslateViaDiff) {
            translated = PersistentRangeMarker.translateViaDiff((DocumentEventImpl)event, linesCols);
        }
        if (translated == null) {
            ProperTextRange fallback = PersistentRangeMarker.applyChange(event, intervalStart, intervalEnd, greedyLeft, greedyRight);
            if (fallback == null) {
                return null;
            }
            LinesCols lc = PersistentRangeMarker.storeLinesAndCols(fallback, event.getDocument());
            if (lc == null) {
                return null;
            }
            translated = Pair.create(fallback, lc);
        }
        if (((ProperTextRange)translated.first).getEndOffset() > event.getDocument().getTextLength() || ((LinesCols)translated.second).myEndLine < ((LinesCols)translated.second).myStartLine || ((LinesCols)translated.second).myStartLine == ((LinesCols)translated.second).myEndLine && ((LinesCols)translated.second).myEndColumn < ((LinesCols)translated.second).myStartColumn || event.getDocument().getLineCount() < ((LinesCols)translated.second).myEndLine) {
            return null;
        }
        return translated;
    }

    @Override
    public String toString() {
        return "PersistentRangeMarker" + (this.isGreedyToLeft() ? "[" : "(") + (this.isValid() ? "valid" : "invalid") + "," + this.getStartOffset() + "," + this.getEndOffset() + " " + this.myLinesCols + (this.isGreedyToRight() ? "]" : ")");
    }

    static class LinesCols {
        private final int myStartLine;
        private final int myStartColumn;
        private final int myEndLine;
        private final int myEndColumn;

        LinesCols(int startLine, int startColumn, int endLine, int endColumn) {
            this.myStartLine = startLine;
            this.myStartColumn = startColumn;
            this.myEndLine = endLine;
            this.myEndColumn = endColumn;
        }

        public String toString() {
            return this.myStartLine + ":" + this.myStartColumn + "-" + this.myEndLine + ":" + this.myEndColumn;
        }
    }
}

