/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.openapi.editor.impl;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.openapi.editor.event.DocumentEvent;
import org.jetbrains.kotlin.com.intellij.openapi.editor.impl.FrozenDocument;
import org.jetbrains.kotlin.com.intellij.openapi.editor.impl.PersistentRangeMarker;
import org.jetbrains.kotlin.com.intellij.openapi.editor.impl.RangeMarkerImpl;
import org.jetbrains.kotlin.com.intellij.openapi.editor.impl.event.RetargetRangeMarkers;
import org.jetbrains.kotlin.com.intellij.openapi.util.Pair;
import org.jetbrains.kotlin.com.intellij.openapi.util.ProperTextRange;

public class ManualRangeMarker {
    private final ProperTextRange myRange;
    private final boolean myGreedyLeft;
    private final boolean myGreedyRight;
    private final PersistentRangeMarker.LinesCols myLinesCols;

    public ManualRangeMarker(@NotNull FrozenDocument document, @NotNull ProperTextRange range, boolean greedyLeft, boolean greedyRight, boolean surviveOnExternalChange) {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "org/jetbrains/kotlin/com/intellij/openapi/editor/impl/ManualRangeMarker", "<init>"));
        }
        if (range == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "range", "org/jetbrains/kotlin/com/intellij/openapi/editor/impl/ManualRangeMarker", "<init>"));
        }
        this(range, greedyLeft, greedyRight, surviveOnExternalChange ? PersistentRangeMarker.storeLinesAndCols(range, document) : null);
    }

    private ManualRangeMarker(@NotNull ProperTextRange range, boolean greedyLeft, boolean greedyRight, @Nullable PersistentRangeMarker.LinesCols linesCols) {
        if (range == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "range", "org/jetbrains/kotlin/com/intellij/openapi/editor/impl/ManualRangeMarker", "<init>"));
        }
        this.myRange = range;
        this.myGreedyLeft = greedyLeft;
        this.myGreedyRight = greedyRight;
        this.myLinesCols = linesCols;
    }

    @Nullable
    public ManualRangeMarker getUpdatedRange(@NotNull DocumentEvent event) {
        if (event == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "org/jetbrains/kotlin/com/intellij/openapi/editor/impl/ManualRangeMarker", "getUpdatedRange"));
        }
        if (event instanceof RetargetRangeMarkers) {
            int start = ((RetargetRangeMarkers)event).getStartOffset();
            if (this.myRange.getStartOffset() >= start && this.myRange.getEndOffset() <= ((RetargetRangeMarkers)event).getEndOffset()) {
                ProperTextRange range = this.myRange.shiftRight(((RetargetRangeMarkers)event).getMoveDestinationOffset() - start);
                return new ManualRangeMarker(range, this.myGreedyLeft, this.myGreedyRight, this.myLinesCols == null ? null : PersistentRangeMarker.storeLinesAndCols(range, event.getDocument()));
            }
        }
        if (this.myLinesCols != null) {
            Pair<ProperTextRange, PersistentRangeMarker.LinesCols> pair = PersistentRangeMarker.applyChange(event, this.myRange, this.myRange.getStartOffset(), this.myRange.getEndOffset(), this.myGreedyLeft, this.myGreedyRight, this.myLinesCols);
            return pair == null ? null : new ManualRangeMarker((ProperTextRange)pair.first, this.myGreedyLeft, this.myGreedyRight, (PersistentRangeMarker.LinesCols)pair.second);
        }
        ProperTextRange range = RangeMarkerImpl.applyChange(event, this.myRange.getStartOffset(), this.myRange.getEndOffset(), this.myGreedyLeft, this.myGreedyRight);
        return range == null ? null : new ManualRangeMarker(range, this.myGreedyLeft, this.myGreedyRight, null);
    }

    @NotNull
    public ProperTextRange getRange() {
        ProperTextRange properTextRange = this.myRange;
        if (properTextRange == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/openapi/editor/impl/ManualRangeMarker", "getRange"));
        }
        return properTextRange;
    }

    public String toString() {
        return "ManualRangeMarker" + this.myRange;
    }
}

