/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.openapi.application.ex;

import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.ide.PooledThreadExecutor;
import org.jetbrains.kotlin.com.intellij.openapi.progress.ProcessCanceledException;
import org.jetbrains.kotlin.com.intellij.openapi.progress.ProgressIndicator;
import org.jetbrains.kotlin.com.intellij.openapi.progress.ProgressManager;
import org.jetbrains.kotlin.com.intellij.openapi.util.Ref;
import org.jetbrains.kotlin.com.intellij.util.ExceptionUtil;

public class ApplicationUtil {
    public static <T> T runWithCheckCanceled(@NotNull Callable<T> callable, @NotNull ProgressIndicator indicator) throws Exception {
        if (callable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callable", "org/jetbrains/kotlin/com/intellij/openapi/application/ex/ApplicationUtil", "runWithCheckCanceled"));
        }
        if (indicator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "org/jetbrains/kotlin/com/intellij/openapi/application/ex/ApplicationUtil", "runWithCheckCanceled"));
        }
        return ApplicationUtil.runWithCheckCanceled(callable, indicator, PooledThreadExecutor.INSTANCE);
    }

    public static <T> T runWithCheckCanceled(final @NotNull Callable<T> callable, final @NotNull ProgressIndicator indicator, @NotNull ExecutorService executorService) throws Exception {
        if (callable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callable", "org/jetbrains/kotlin/com/intellij/openapi/application/ex/ApplicationUtil", "runWithCheckCanceled"));
        }
        if (indicator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "org/jetbrains/kotlin/com/intellij/openapi/application/ex/ApplicationUtil", "runWithCheckCanceled"));
        }
        if (executorService == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "executorService", "org/jetbrains/kotlin/com/intellij/openapi/application/ex/ApplicationUtil", "runWithCheckCanceled"));
        }
        final Ref result2 = Ref.create();
        final Ref error = Ref.create();
        Future<?> future = executorService.submit(new Runnable(){

            @Override
            public void run() {
                ProgressManager.getInstance().executeProcessUnderProgress(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            result2.set(callable.call());
                        }
                        catch (Throwable t) {
                            error.set(t);
                        }
                    }
                }, indicator);
            }
        });
        while (true) {
            try {
                indicator.checkCanceled();
            }
            catch (ProcessCanceledException e) {
                future.cancel(true);
                throw e;
            }
            try {
                future.get(200L, TimeUnit.MILLISECONDS);
                ExceptionUtil.rethrowAll((Throwable)error.get());
                return result2.get();
            }
            catch (TimeoutException timeoutException) {
                continue;
            }
            break;
        }
    }
}

