/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.ide.presentation;

import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.ide.TypePresentationService;
import org.jetbrains.kotlin.com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.kotlin.com.intellij.util.PlatformIcons;

public class VirtualFilePresentation {
    public static Icon getIconImpl(@NotNull VirtualFile vFile) {
        if (vFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vFile", "org/jetbrains/kotlin/com/intellij/ide/presentation/VirtualFilePresentation", "getIconImpl"));
        }
        Icon icon = TypePresentationService.getService().getIcon(vFile);
        if (icon != null) {
            return icon;
        }
        if (vFile.isDirectory() && vFile.isInLocalFileSystem()) {
            return PlatformIcons.FOLDER_ICON;
        }
        return vFile.getFileType().getIcon();
    }
}

