/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.cfg;

import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.cfg.UnknownMissingCase;
import org.jetbrains.kotlin.cfg.WhenExhaustivenessChecker;
import org.jetbrains.kotlin.cfg.WhenMissingCase;
import org.jetbrains.kotlin.cfg.WhenOnBooleanExhaustivenessChecker;
import org.jetbrains.kotlin.cfg.WhenOnEnumExhaustivenessChecker;
import org.jetbrains.kotlin.cfg.WhenOnNullableExhaustivenessChecker;
import org.jetbrains.kotlin.cfg.WhenOnSealedExhaustivenessChecker;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.tree.TokenSet;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.diagnostics.DiagnosticSink;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtWhenEntry;
import org.jetbrains.kotlin.psi.KtWhenExpression;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.bindingContextUtil.BindingContextUtilsKt;
import org.jetbrains.kotlin.types.FlexibleTypesKt;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.TypeUtils;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ\u0016\u0010\f\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ\u0016\u0010\r\u001a\u00020\u000e2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u0010J\u0014\u0010\u0011\u001a\u0004\u0018\u00010\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0007J&\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00160\u00042\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0017\u001a\u00020\u0012H\u0007J\u001e\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00160\u00042\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u001e\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00160\u00042\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u0010H\u0007J\"\u0010\u001a\u001a\u00020\u000e2\b\u0010\n\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0018\u0010\u001c\u001a\u00020\u000e2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u0010H\u0007J\u0018\u0010\u001d\u001a\u00020\u000e2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\tH\u0007J\u001f\u0010\u001e\u001a\t\u0018\u00010\u0014\u00a2\u0006\u0002\b\u001f2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lorg/jetbrains/kotlin/cfg/WhenChecker;", "", "()V", "exhaustivenessCheckers", "", "Lorg/jetbrains/kotlin/cfg/WhenExhaustivenessChecker;", "checkDeprecatedWhenSyntax", "", "trace", "Lorg/jetbrains/kotlin/resolve/BindingTrace;", "expression", "Lorg/jetbrains/kotlin/psi/KtWhenExpression;", "checkReservedPrefix", "containsNullCase", "", "context", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "getClassDescriptorOfTypeIfEnum", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "type", "Lorg/jetbrains/kotlin/types/KotlinType;", "getEnumMissingCases", "Lorg/jetbrains/kotlin/cfg/WhenMissingCase;", "enumClassDescriptor", "getMissingCases", "getNecessaryCases", "isNullableTypeWithoutPossibleSmartCast", "Lorg/jetbrains/kotlin/psi/KtExpression;", "isWhenByEnum", "isWhenExhaustive", "whenSubjectType", "Lorg/jetbrains/annotations/Nullable;", "kotlin-compiler"})
public final class WhenChecker {
    private static final List<WhenExhaustivenessChecker> exhaustivenessCheckers;
    public static final WhenChecker INSTANCE;

    @JvmStatic
    @NotNull
    public static final List<WhenMissingCase> getNecessaryCases(@NotNull KtWhenExpression expression, @NotNull BindingContext context) {
        Intrinsics.checkParameterIsNotNull(expression, "expression");
        Intrinsics.checkParameterIsNotNull(context, "context");
        return BindingContextUtilsKt.isUsedAsExpression(expression, context) ? INSTANCE.getMissingCases(expression, context) : CollectionsKt.emptyList();
    }

    @JvmStatic
    public static final boolean isWhenByEnum(@NotNull KtWhenExpression expression, @NotNull BindingContext context) {
        Intrinsics.checkParameterIsNotNull(expression, "expression");
        Intrinsics.checkParameterIsNotNull(context, "context");
        return WhenChecker.getClassDescriptorOfTypeIfEnum(INSTANCE.whenSubjectType(expression, context)) != null;
    }

    @JvmStatic
    @Nullable
    public static final ClassDescriptor getClassDescriptorOfTypeIfEnum(@Nullable KotlinType type2) {
        if (type2 == null) {
            return null;
        }
        ClassDescriptor classDescriptor = TypeUtils.getClassDescriptor(type2);
        if (classDescriptor == null) {
            return null;
        }
        ClassDescriptor classDescriptor2 = classDescriptor;
        if (Intrinsics.areEqual((Object)classDescriptor2.getKind(), (Object)ClassKind.ENUM_CLASS) ^ true) {
            return null;
        }
        return classDescriptor2;
    }

    private final KotlinType whenSubjectType(KtWhenExpression expression, BindingContext context) {
        Object object;
        block3: {
            block2: {
                object = expression.getSubjectExpression();
                if (object == null) break block2;
                KtExpression ktExpression = object;
                KtExpression it = ktExpression;
                object = context.getType(it);
                if (object != null) break block3;
            }
            object = null;
        }
        return object;
    }

    @JvmStatic
    @NotNull
    public static final List<WhenMissingCase> getEnumMissingCases(@NotNull KtWhenExpression expression, @NotNull BindingContext context, @NotNull ClassDescriptor enumClassDescriptor) {
        Intrinsics.checkParameterIsNotNull(expression, "expression");
        Intrinsics.checkParameterIsNotNull(context, "context");
        Intrinsics.checkParameterIsNotNull(enumClassDescriptor, "enumClassDescriptor");
        return WhenOnEnumExhaustivenessChecker.INSTANCE.getMissingCases(expression, context, enumClassDescriptor, false);
    }

    private final boolean isNullableTypeWithoutPossibleSmartCast(KtExpression expression, KotlinType type2, BindingContext context) {
        if (expression == null) {
            return false;
        }
        if (!TypeUtils.isNullableType(type2)) {
            return false;
        }
        return context.get(BindingContext.SMARTCAST, expression) == null;
    }

    /*
     * Unable to fully structure code
     */
    private final List<WhenMissingCase> getMissingCases(KtWhenExpression expression, BindingContext context) {
        v0 = this.whenSubjectType(expression, context);
        if (v0 == null) {
            return CollectionsKt.listOf(UnknownMissingCase.INSTANCE);
        }
        type = v0;
        if (FlexibleTypesKt.isFlexible(type)) ** GOTO lbl-1000
        v1 = expression.getSubjectExpression();
        v2 = type;
        Intrinsics.checkExpressionValueIsNotNull(v2, "type");
        if (this.isNullableTypeWithoutPossibleSmartCast(v1, v2, context)) {
            v3 = true;
        } else lbl-1000:
        // 2 sources

        {
            v3 = false;
        }
        nullable = v3;
        var5_5 = WhenChecker.exhaustivenessCheckers;
        var6_6 = $receiver$iv;
        var7_7 = new ArrayList<E>();
        for (T element$iv$iv : $receiver$iv$iv) {
            it = (WhenExhaustivenessChecker)element$iv$iv;
            v4 = type;
            Intrinsics.checkExpressionValueIsNotNull(v4, "type");
            if (!it.isApplicable(v4)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        checkers = (List)destination$iv$iv;
        if (checkers.isEmpty()) {
            return CollectionsKt.listOf(UnknownMissingCase.INSTANCE);
        }
        $receiver$iv = checkers;
        $receiver$iv$iv = $receiver$iv;
        destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault($receiver$iv, 10));
        for (T item$iv$iv : $receiver$iv$iv) {
            it = (WhenExhaustivenessChecker)item$iv$iv;
            var12_12 = destination$iv$iv;
            var13_13 = it.getMissingCases(expression, context, TypeUtils.getClassDescriptor(type), nullable);
            var12_12.add(var13_13);
        }
        return CollectionsKt.flatten((List)destination$iv$iv);
    }

    @JvmStatic
    public static final boolean isWhenExhaustive(@NotNull KtWhenExpression expression, @NotNull BindingTrace trace) {
        boolean bl;
        Intrinsics.checkParameterIsNotNull(expression, "expression");
        Intrinsics.checkParameterIsNotNull(trace, "trace");
        BindingContext bindingContext = trace.getBindingContext();
        Intrinsics.checkExpressionValueIsNotNull(bindingContext, "trace.bindingContext");
        if (INSTANCE.getMissingCases(expression, bindingContext).isEmpty()) {
            trace.record(BindingContext.EXHAUSTIVE_WHEN, expression);
            bl = true;
        } else {
            bl = false;
        }
        return bl;
    }

    public final boolean containsNullCase(@NotNull KtWhenExpression expression, @NotNull BindingContext context) {
        Intrinsics.checkParameterIsNotNull(expression, "expression");
        Intrinsics.checkParameterIsNotNull(context, "context");
        return WhenOnNullableExhaustivenessChecker.INSTANCE.getMissingCases(expression, context, null, true).isEmpty();
    }

    public final void checkDeprecatedWhenSyntax(@NotNull BindingTrace trace, @NotNull KtWhenExpression expression) {
        Intrinsics.checkParameterIsNotNull(trace, "trace");
        Intrinsics.checkParameterIsNotNull(expression, "expression");
        if (expression.getSubjectExpression() != null) {
            return;
        }
        block0: for (KtWhenEntry entry : expression.getEntries()) {
            if (entry.isElse()) continue;
            for (PsiElement child = entry.getFirstChild(); child != null; child = child.getNextSibling()) {
                if (child.getNode().getElementType() == KtTokens.COMMA) {
                    trace.report(Errors.COMMA_IN_WHEN_CONDITION_WITHOUT_ARGUMENT.on(child));
                }
                if (child.getNode().getElementType() == KtTokens.ARROW) continue block0;
            }
        }
    }

    public final void checkReservedPrefix(@NotNull BindingTrace trace, @NotNull KtWhenExpression expression) {
        Intrinsics.checkParameterIsNotNull(trace, "trace");
        Intrinsics.checkParameterIsNotNull(expression, "expression");
        DiagnosticSink diagnosticSink = trace;
        PsiElement psiElement = expression.getWhenKeyword();
        Intrinsics.checkExpressionValueIsNotNull(psiElement, "expression.whenKeyword");
        TokenSet tokenSet = TokenSet.EMPTY;
        Intrinsics.checkExpressionValueIsNotNull(tokenSet, "TokenSet.EMPTY");
        KtPsiUtilKt.checkReservedPrefixWord(diagnosticSink, psiElement, "sealed", tokenSet, "sealed when");
    }

    private WhenChecker() {
        INSTANCE = this;
        exhaustivenessCheckers = CollectionsKt.listOf(new WhenExhaustivenessChecker[]{WhenOnBooleanExhaustivenessChecker.INSTANCE, WhenOnEnumExhaustivenessChecker.INSTANCE, WhenOnSealedExhaustivenessChecker.INSTANCE});
    }

    static {
        new WhenChecker();
    }
}

