/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.descriptors;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.descriptors.CallableDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.CapturedTypeParameterDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassifierDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.DeclarationDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.PossiblyInnerType;
import kotlin.reflect.jvm.internal.impl.descriptors.TypeParameterDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.TypeParameterUtilsKt;
import kotlin.reflect.jvm.internal.impl.descriptors.annotations.Annotated;
import kotlin.reflect.jvm.internal.impl.resolve.DescriptorUtils;
import kotlin.reflect.jvm.internal.impl.resolve.descriptorUtil.DescriptorUtilsKt;
import kotlin.reflect.jvm.internal.impl.types.ErrorUtils;
import kotlin.reflect.jvm.internal.impl.types.KotlinType;
import kotlin.reflect.jvm.internal.impl.types.TypeProjection;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class TypeParameterUtilsKt {
    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<TypeParameterDescriptor> computeConstructorTypeParameters(@NotNull ClassDescriptor $receiver) {
        void destination$iv$iv;
        void $receiver$iv$iv;
        void $receiver$iv;
        Sequence<DeclarationDescriptor> containingClassTypeConstructorParameters;
        Annotated annotated;
        DeclarationDescriptor declarationDescriptor;
        DeclarationDescriptor element$iv;
        Object object;
        Sequence<DeclarationDescriptor> $receiver$iv2;
        List parametersFromContainingFunctions2;
        List<TypeParameterDescriptor> declaredParameters2;
        block5: {
            Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
            declaredParameters2 = $receiver.getDeclaredTypeParameters();
            if (!$receiver.isInner() && !($receiver.getContainingDeclaration() instanceof CallableDescriptor)) {
                List<TypeParameterDescriptor> list2 = declaredParameters2;
                Intrinsics.checkExpressionValueIsNotNull(list2, "declaredParameters");
                return list2;
            }
            parametersFromContainingFunctions2 = SequencesKt.toList(SequencesKt.flatMap(SequencesKt.takeWhile(DescriptorUtilsKt.getParents($receiver), computeConstructorTypeParameters.parametersFromContainingFunctions.1.INSTANCE), computeConstructorTypeParameters.parametersFromContainingFunctions.2.INSTANCE));
            $receiver$iv2 = DescriptorUtilsKt.getParents($receiver);
            object = $receiver$iv2.iterator();
            while (object.hasNext()) {
                element$iv = object.next();
                if (!(element$iv instanceof ClassDescriptor)) continue;
                declarationDescriptor = element$iv;
                break block5;
            }
            declarationDescriptor = null;
        }
        $receiver$iv2 = (annotated = (ClassDescriptor)declarationDescriptor) != null && (annotated = annotated.getTypeConstructor()) != null ? annotated.getParameters() : null;
        Sequence<DeclarationDescriptor> sequence2 = $receiver$iv2;
        if (sequence2 == null) {
            sequence2 = containingClassTypeConstructorParameters = CollectionsKt.emptyList();
        }
        if (parametersFromContainingFunctions2.isEmpty() && containingClassTypeConstructorParameters.isEmpty()) {
            List<TypeParameterDescriptor> list3 = $receiver.getDeclaredTypeParameters();
            Intrinsics.checkExpressionValueIsNotNull(list3, "declaredTypeParameters");
            return list3;
        }
        object = CollectionsKt.plus((Collection)parametersFromContainingFunctions2, (Iterable)((Object)containingClassTypeConstructorParameters));
        element$iv = $receiver$iv;
        Collection $i$f$firstIsInstanceOrNull = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver$iv, 10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void it;
            TypeParameterDescriptor typeParameterDescriptor = (TypeParameterDescriptor)item$iv$iv;
            void var11_11 = destination$iv$iv;
            CapturedTypeParameterDescriptor capturedTypeParameterDescriptor = TypeParameterUtilsKt.capturedCopyForInnerDeclaration((TypeParameterDescriptor)it, $receiver, declaredParameters2.size());
            var11_11.add(capturedTypeParameterDescriptor);
        }
        List additional = (List)destination$iv$iv;
        return CollectionsKt.plus((Collection)declaredParameters2, (Iterable)additional);
    }

    private static final CapturedTypeParameterDescriptor capturedCopyForInnerDeclaration(@NotNull TypeParameterDescriptor $receiver, DeclarationDescriptor declarationDescriptor, int declaredTypeParametersCount) {
        return new CapturedTypeParameterDescriptor($receiver, declarationDescriptor, declaredTypeParametersCount);
    }

    @Nullable
    public static final PossiblyInnerType buildPossiblyInnerType(@NotNull KotlinType $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        ClassifierDescriptor classifierDescriptor = $receiver.getConstructor().getDeclarationDescriptor();
        if (!(classifierDescriptor instanceof ClassDescriptor)) {
            classifierDescriptor = null;
        }
        return TypeParameterUtilsKt.buildPossiblyInnerType($receiver, (ClassDescriptor)classifierDescriptor, 0);
    }

    private static final PossiblyInnerType buildPossiblyInnerType(@NotNull KotlinType $receiver, ClassDescriptor classDescriptor, int index2) {
        if (classDescriptor == null || ErrorUtils.isError(classDescriptor)) {
            return null;
        }
        int toIndex = classDescriptor.getDeclaredTypeParameters().size() + index2;
        if (!classDescriptor.isInner()) {
            Unit unit;
            boolean bl = toIndex == $receiver.getArguments().size() || DescriptorUtils.isLocal(classDescriptor);
            if (_Assertions.ENABLED) {
                if (!bl) {
                    String string = $receiver.getArguments().size() - toIndex + " trailing arguments were found in " + $receiver + " type";
                    throw (Throwable)((Object)new AssertionError((Object)string));
                }
                unit = Unit.INSTANCE;
            } else {
                unit = Unit.INSTANCE;
            }
            return new PossiblyInnerType(classDescriptor, $receiver.getArguments().subList(index2, $receiver.getArguments().size()), null);
        }
        List<TypeProjection> argumentsSubList = $receiver.getArguments().subList(index2, toIndex);
        DeclarationDescriptor declarationDescriptor = classDescriptor.getContainingDeclaration();
        if (!(declarationDescriptor instanceof ClassDescriptor)) {
            declarationDescriptor = null;
        }
        return new PossiblyInnerType(classDescriptor, argumentsSubList, TypeParameterUtilsKt.buildPossiblyInnerType($receiver, (ClassDescriptor)declarationDescriptor, toIndex));
    }
}

