/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.types;

import java.util.HashSet;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.types.DynamicTypesKt;
import org.jetbrains.kotlin.types.Dynamicity;
import org.jetbrains.kotlin.types.Flexibility;
import org.jetbrains.kotlin.types.FlexibleTypeCapabilities;
import org.jetbrains.kotlin.types.FlexibleTypeDelegation;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.NullAwareness;
import org.jetbrains.kotlin.types.Specificity;
import org.jetbrains.kotlin.types.TypeCapability;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;

@Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u0011B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J7\u0010\u0007\u001a\u0004\u0018\u0001H\b\"\b\b\u0000\u0010\b*\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u0002H\b0\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016\u00a2\u0006\u0002\u0010\u0010R\u0014\u0010\u0003\u001a\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/types/DynamicTypeCapabilities;", "Lorg/jetbrains/kotlin/types/FlexibleTypeCapabilities;", "()V", "id", "", "getId", "()Ljava/lang/String;", "getCapability", "T", "Lorg/jetbrains/kotlin/types/TypeCapability;", "capabilityClass", "Ljava/lang/Class;", "jetType", "Lorg/jetbrains/kotlin/types/KotlinType;", "flexibility", "Lorg/jetbrains/kotlin/types/Flexibility;", "(Ljava/lang/Class;Lorg/jetbrains/kotlin/types/KotlinType;Lorg/jetbrains/kotlin/types/Flexibility;)Lorg/jetbrains/kotlin/types/TypeCapability;", "Impl", "kotlin-compiler"})
public final class DynamicTypeCapabilities
implements FlexibleTypeCapabilities {
    public static final DynamicTypeCapabilities INSTANCE;

    @Override
    @NotNull
    public String getId() {
        return "kotlin.DynamicType";
    }

    @Override
    @Nullable
    public <T extends TypeCapability> T getCapability(@NotNull Class<T> capabilityClass, @NotNull KotlinType jetType, @NotNull Flexibility flexibility) {
        Intrinsics.checkParameterIsNotNull(capabilityClass, "capabilityClass");
        Intrinsics.checkParameterIsNotNull(jetType, "jetType");
        Intrinsics.checkParameterIsNotNull(flexibility, "flexibility");
        return (T)(Impl.Companion.getCapabilityClasses$kotlin_compiler().contains(capabilityClass) ? (TypeCapability)new Impl(flexibility) : (TypeCapability)null);
    }

    private DynamicTypeCapabilities() {
        INSTANCE = this;
    }

    static {
        new DynamicTypeCapabilities();
    }

    @Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0002\u0018\u0000 \u00132\u00020\u00012\u00020\u00022\u00020\u00032\u00020\u0004:\u0001\u0013B\r\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\b\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\tH\u0016J\u0010\u0010\u0011\u001a\u00020\t2\u0006\u0010\u0012\u001a\u00020\rH\u0016R\u0014\u0010\b\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/types/DynamicTypeCapabilities$Impl;", "Lorg/jetbrains/kotlin/types/Dynamicity;", "Lorg/jetbrains/kotlin/types/Specificity;", "Lorg/jetbrains/kotlin/types/NullAwareness;", "Lorg/jetbrains/kotlin/types/FlexibleTypeDelegation;", "flexibility", "Lorg/jetbrains/kotlin/types/Flexibility;", "(Lorg/jetbrains/kotlin/types/Flexibility;)V", "delegateType", "Lorg/jetbrains/kotlin/types/KotlinType;", "getDelegateType", "()Lorg/jetbrains/kotlin/types/KotlinType;", "computeIsNullable", "", "getSpecificityRelationTo", "Lorg/jetbrains/kotlin/types/Specificity$Relation;", "otherType", "makeNullableAsSpecified", "nullable", "Companion", "kotlin-compiler"})
    private static final class Impl
    implements Dynamicity,
    FlexibleTypeDelegation,
    NullAwareness,
    Specificity {
        @NotNull
        private final KotlinType delegateType;
        @NotNull
        private static final HashSet<Class<? extends TypeCapability>> capabilityClasses;
        public static final Companion Companion;

        @Override
        @NotNull
        public KotlinType getDelegateType() {
            return this.delegateType;
        }

        @Override
        @NotNull
        public Specificity.Relation getSpecificityRelationTo(@NotNull KotlinType otherType) {
            Intrinsics.checkParameterIsNotNull(otherType, "otherType");
            return !DynamicTypesKt.isDynamic(otherType) ? Specificity.Relation.LESS_SPECIFIC : Specificity.Relation.DONT_KNOW;
        }

        @Override
        @NotNull
        public KotlinType makeNullableAsSpecified(boolean nullable2) {
            return DynamicTypesKt.createDynamicType(TypeUtilsKt.getBuiltIns(this.getDelegateType()));
        }

        @Override
        public boolean computeIsNullable() {
            return false;
        }

        public Impl(@NotNull Flexibility flexibility) {
            Intrinsics.checkParameterIsNotNull(flexibility, "flexibility");
            this.delegateType = flexibility.getUpperBound();
        }

        static {
            Companion = new Companion(null);
            capabilityClasses = SetsKt.hashSetOf(Dynamicity.class, Specificity.class, NullAwareness.class, FlexibleTypeDelegation.class);
        }

        @Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\"\u0010\u0003\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u00060\u00050\u0004X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/types/DynamicTypeCapabilities$Impl$Companion;", "", "()V", "capabilityClasses", "Ljava/util/HashSet;", "Ljava/lang/Class;", "Lorg/jetbrains/kotlin/types/TypeCapability;", "getCapabilityClasses$kotlin_compiler", "()Ljava/util/HashSet;", "kotlin-compiler"})
        public static final class Companion {
            @NotNull
            public final HashSet<Class<? extends TypeCapability>> getCapabilityClasses$kotlin_compiler() {
                return capabilityClasses;
            }

            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

