/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.inline.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.js.inline.util.collectors.InstanceCollector;
import org.jetbrains.kotlin.js.inline.util.collectors.NameCollector;
import org.jetbrains.kotlin.js.inline.util.collectors.PropertyCollector;
import org.jetbrains.kotlin.js.inline.util.collectors.ReferenceNameCollector;
import org.jetbrains.kotlin.js.translate.expression.InlineMetadata;
import org.jetbrains.kotlin.relocated.com.google.dart.compiler.backend.js.ast.JsExpression;
import org.jetbrains.kotlin.relocated.com.google.dart.compiler.backend.js.ast.JsFunction;
import org.jetbrains.kotlin.relocated.com.google.dart.compiler.backend.js.ast.JsFunctionScope;
import org.jetbrains.kotlin.relocated.com.google.dart.compiler.backend.js.ast.JsName;
import org.jetbrains.kotlin.relocated.com.google.dart.compiler.backend.js.ast.JsNode;
import org.jetbrains.kotlin.relocated.com.google.dart.compiler.backend.js.ast.JsScope;
import org.jetbrains.kotlin.relocated.com.google.dart.compiler.backend.js.ast.metadata.MetadataProperties;

@Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=2, d1={"\u0000.\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u0014\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u0004\u001a,\u0010\u0005\u001a\b\u0012\u0004\u0012\u0002H\u00060\u0001\"\b\b\u0000\u0010\u0006*\u00020\u00042\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u0002H\u00060\b2\u0006\u0010\u0003\u001a\u00020\u0004\u001a\u001a\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\u0003\u001a\u00020\u0004\u001a\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\r\u001a\u00020\u000e\u001a\u001a\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u000e0\n2\u0006\u0010\u0003\u001a\u00020\u0004\u001a\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u0004\u00a8\u0006\u0011"}, d2={"collectFunctionReferencesInside", "", "Lorg/jetbrains/kotlin/relocated/com/google/dart/compiler/backend/js/ast/JsName;", "scope", "Lorg/jetbrains/kotlin/relocated/com/google/dart/compiler/backend/js/ast/JsNode;", "collectInstances", "T", "klass", "Ljava/lang/Class;", "collectJsProperties", "Ljava/util/IdentityHashMap;", "Lorg/jetbrains/kotlin/relocated/com/google/dart/compiler/backend/js/ast/JsExpression;", "collectLocalNames", "function", "Lorg/jetbrains/kotlin/relocated/com/google/dart/compiler/backend/js/ast/JsFunction;", "collectNamedFunctions", "collectReferencesInside", "kotlin-compiler"})
public final class CollectUtilsKt {
    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<JsName> collectFunctionReferencesInside(@NotNull JsNode scope2) {
        void var3_3;
        void $receiver$iv$iv;
        Intrinsics.checkParameterIsNotNull(scope2, "scope");
        Iterable $receiver$iv = CollectUtilsKt.collectReferencesInside(scope2);
        Iterable iterable = $receiver$iv;
        Collection destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            JsName it = (JsName)element$iv$iv;
            if (!(MetadataProperties.getStaticRef(it) instanceof JsFunction)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)var3_3;
    }

    @NotNull
    public static final List<JsName> collectReferencesInside(@NotNull JsNode scope2) {
        Intrinsics.checkParameterIsNotNull(scope2, "scope");
        ReferenceNameCollector receiver$iv = new ReferenceNameCollector();
        ReferenceNameCollector $receiver = receiver$iv;
        $receiver.accept(scope2);
        return $receiver.getReferences();
    }

    @NotNull
    public static final List<JsName> collectLocalNames(@NotNull JsFunction function) {
        Intrinsics.checkParameterIsNotNull(function, "function");
        JsFunctionScope functionScope = function.getScope();
        JsScope jsScope = functionScope;
        Intrinsics.checkExpressionValueIsNotNull(jsScope, "functionScope");
        NameCollector receiver$iv = new NameCollector(jsScope);
        NameCollector $receiver = receiver$iv;
        $receiver.accept((JsNode)function.getBody());
        return CollectionsKt.toList((Iterable)$receiver.getNames().values());
    }

    @NotNull
    public static final IdentityHashMap<JsName, JsExpression> collectJsProperties(@NotNull JsNode scope2) {
        Intrinsics.checkParameterIsNotNull(scope2, "scope");
        PropertyCollector collector2 = new PropertyCollector();
        collector2.accept(scope2);
        return collector2.getProperties();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final IdentityHashMap<JsName, JsFunction> collectNamedFunctions(@NotNull JsNode scope2) {
        Intrinsics.checkParameterIsNotNull(scope2, "scope");
        IdentityHashMap<JsName, JsFunction> namedFunctions = new IdentityHashMap<JsName, JsFunction>();
        Map $receiver$iv = CollectUtilsKt.collectJsProperties(scope2);
        Iterator iterator2 = $receiver$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            void value$iv;
            void $receiver$iv2;
            JsFunction function;
            JsFunction jsFunction;
            void $receiver$iv3;
            void $receiver$iv4;
            Map.Entry entry;
            Map.Entry $i$f$iterator = entry = iterator2.next();
            JsName name = (JsName)$receiver$iv4.getKey();
            Map.Entry $i$f$component1 = entry;
            JsExpression value = (JsExpression)$receiver$iv3.getValue();
            Object $i$f$component2 = value;
            if ($i$f$component2 instanceof JsFunction) {
                jsFunction = (JsFunction)value;
            } else {
                InlineMetadata inlineMetadata = InlineMetadata.Companion.decompose(value);
                jsFunction = inlineMetadata != null ? inlineMetadata.getFunction() : null;
            }
            if ((function = jsFunction) == null) continue;
            $i$f$component2 = namedFunctions;
            JsFunction jsFunction2 = function;
            $receiver$iv2.put(name, value$iv);
        }
        return namedFunctions;
    }

    @NotNull
    public static final <T extends JsNode> List<T> collectInstances(@NotNull Class<T> klass, @NotNull JsNode scope2) {
        Intrinsics.checkParameterIsNotNull(klass, "klass");
        Intrinsics.checkParameterIsNotNull(scope2, "scope");
        InstanceCollector<JsNode> receiver$iv = new InstanceCollector<JsNode>(klass, false);
        InstanceCollector<JsNode> $receiver = receiver$iv;
        $receiver.accept(scope2);
        return $receiver.getCollected();
    }
}

