/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.cfg;

import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.SmartFMap;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.cfg.ControlFlowBuilder;
import org.jetbrains.kotlin.cfg.GenerationTrigger;
import org.jetbrains.kotlin.cfg.Label;
import org.jetbrains.kotlin.cfg.LoopInfo;
import org.jetbrains.kotlin.cfg.WhenChecker;
import org.jetbrains.kotlin.cfg.pseudocode.ControlFlowInstructionsGenerator;
import org.jetbrains.kotlin.cfg.pseudocode.PseudoValue;
import org.jetbrains.kotlin.cfg.pseudocode.Pseudocode;
import org.jetbrains.kotlin.cfg.pseudocode.PseudocodeImpl;
import org.jetbrains.kotlin.cfg.pseudocode.instructions.eval.AccessTarget;
import org.jetbrains.kotlin.cfg.pseudocode.instructions.eval.CallInstruction;
import org.jetbrains.kotlin.cfg.pseudocode.instructions.eval.InstructionWithValue;
import org.jetbrains.kotlin.cfg.pseudocode.instructions.eval.MagicKind;
import org.jetbrains.kotlin.cfg.pseudocode.instructions.eval.ReadValueInstruction;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptor;
import org.jetbrains.kotlin.descriptors.impl.AnonymousFunctionDescriptor;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.lexer.KtToken;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtAnnotatedExpression;
import org.jetbrains.kotlin.psi.KtAnonymousInitializer;
import org.jetbrains.kotlin.psi.KtArrayAccessExpression;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtBinaryExpressionWithTypeRHS;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtBreakExpression;
import org.jetbrains.kotlin.psi.KtCallElement;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtCatchClause;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtConstantExpression;
import org.jetbrains.kotlin.psi.KtContinueExpression;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtDeclarationContainer;
import org.jetbrains.kotlin.psi.KtDeclarationWithBody;
import org.jetbrains.kotlin.psi.KtDelegatedSuperTypeEntry;
import org.jetbrains.kotlin.psi.KtDestructuringDeclaration;
import org.jetbrains.kotlin.psi.KtDestructuringDeclarationEntry;
import org.jetbrains.kotlin.psi.KtDoWhileExpression;
import org.jetbrains.kotlin.psi.KtDoubleColonExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtExpressionWithLabel;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtFinallySection;
import org.jetbrains.kotlin.psi.KtForExpression;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtFunctionLiteral;
import org.jetbrains.kotlin.psi.KtIfExpression;
import org.jetbrains.kotlin.psi.KtIsExpression;
import org.jetbrains.kotlin.psi.KtLabeledExpression;
import org.jetbrains.kotlin.psi.KtLambdaExpression;
import org.jetbrains.kotlin.psi.KtLoopExpression;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtObjectDeclaration;
import org.jetbrains.kotlin.psi.KtObjectLiteralExpression;
import org.jetbrains.kotlin.psi.KtOperationExpression;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtParenthesizedExpression;
import org.jetbrains.kotlin.psi.KtPostfixExpression;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPropertyAccessor;
import org.jetbrains.kotlin.psi.KtPsiUtil;
import org.jetbrains.kotlin.psi.KtQualifiedExpression;
import org.jetbrains.kotlin.psi.KtReturnExpression;
import org.jetbrains.kotlin.psi.KtScript;
import org.jetbrains.kotlin.psi.KtSecondaryConstructor;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.KtStatementExpression;
import org.jetbrains.kotlin.psi.KtStringTemplateEntry;
import org.jetbrains.kotlin.psi.KtStringTemplateEntryWithExpression;
import org.jetbrains.kotlin.psi.KtStringTemplateExpression;
import org.jetbrains.kotlin.psi.KtSuperTypeCallEntry;
import org.jetbrains.kotlin.psi.KtSuperTypeEntry;
import org.jetbrains.kotlin.psi.KtSuperTypeList;
import org.jetbrains.kotlin.psi.KtSuperTypeListEntry;
import org.jetbrains.kotlin.psi.KtThisExpression;
import org.jetbrains.kotlin.psi.KtThrowExpression;
import org.jetbrains.kotlin.psi.KtTryExpression;
import org.jetbrains.kotlin.psi.KtTypeProjection;
import org.jetbrains.kotlin.psi.KtUnaryExpression;
import org.jetbrains.kotlin.psi.KtValueArgument;
import org.jetbrains.kotlin.psi.KtVisitorVoid;
import org.jetbrains.kotlin.psi.KtWhenCondition;
import org.jetbrains.kotlin.psi.KtWhenConditionInRange;
import org.jetbrains.kotlin.psi.KtWhenConditionIsPattern;
import org.jetbrains.kotlin.psi.KtWhenConditionWithExpression;
import org.jetbrains.kotlin.psi.KtWhenEntry;
import org.jetbrains.kotlin.psi.KtWhenExpression;
import org.jetbrains.kotlin.psi.KtWhileExpression;
import org.jetbrains.kotlin.psi.ValueArgument;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import org.jetbrains.kotlin.relocated.com.google.common.collect.Lists;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingContextUtils;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.CompileTimeConstantUtils;
import org.jetbrains.kotlin.resolve.calls.callUtil.CallUtilKt;
import org.jetbrains.kotlin.resolve.calls.model.ArgumentMapping;
import org.jetbrains.kotlin.resolve.calls.model.ArgumentMatch;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedValueArgument;
import org.jetbrains.kotlin.resolve.calls.model.VariableAsFunctionResolvedCall;
import org.jetbrains.kotlin.resolve.calls.tasks.ExplicitReceiverKind;
import org.jetbrains.kotlin.resolve.constants.CompileTimeConstant;
import org.jetbrains.kotlin.resolve.constants.evaluate.ConstantExpressionEvaluator;
import org.jetbrains.kotlin.resolve.scopes.receivers.ExpressionReceiver;
import org.jetbrains.kotlin.resolve.scopes.receivers.ImplicitReceiver;
import org.jetbrains.kotlin.resolve.scopes.receivers.ReceiverValue;
import org.jetbrains.kotlin.resolve.scopes.receivers.TransientReceiver;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.expressions.OperatorConventions;

public class ControlFlowProcessor {
    private final ControlFlowBuilder builder = new ControlFlowInstructionsGenerator();
    private final BindingTrace trace;

    public ControlFlowProcessor(BindingTrace trace) {
        this.trace = trace;
    }

    @NotNull
    public Pseudocode generatePseudocode(@NotNull KtElement subroutine) {
        if (subroutine == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "subroutine", "org/jetbrains/kotlin/cfg/ControlFlowProcessor", "generatePseudocode"));
        }
        Pseudocode pseudocode = this.generate(subroutine);
        ((PseudocodeImpl)pseudocode).postProcess();
        Pseudocode pseudocode2 = pseudocode;
        if (pseudocode2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/cfg/ControlFlowProcessor", "generatePseudocode"));
        }
        return pseudocode2;
    }

    @NotNull
    private Pseudocode generate(@NotNull KtElement subroutine) {
        if (subroutine == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "subroutine", "org/jetbrains/kotlin/cfg/ControlFlowProcessor", "generate"));
        }
        this.builder.enterSubroutine(subroutine);
        CFPVisitor cfpVisitor = new CFPVisitor(this.builder);
        if (subroutine instanceof KtDeclarationWithBody && !(subroutine instanceof KtSecondaryConstructor)) {
            KtDeclarationWithBody declarationWithBody = (KtDeclarationWithBody)subroutine;
            List<KtParameter> valueParameters = declarationWithBody.getValueParameters();
            for (KtParameter valueParameter : valueParameters) {
                cfpVisitor.generateInstructions(valueParameter);
            }
            KtExpression bodyExpression = declarationWithBody.getBodyExpression();
            if (bodyExpression != null) {
                cfpVisitor.generateInstructions(bodyExpression);
                if (!declarationWithBody.hasBlockBody()) {
                    this.generateImplicitReturnValue(bodyExpression, subroutine);
                }
            }
        } else {
            cfpVisitor.generateInstructions(subroutine);
        }
        Pseudocode pseudocode = this.builder.exitSubroutine(subroutine);
        if (pseudocode == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/cfg/ControlFlowProcessor", "generate"));
        }
        return pseudocode;
    }

    private void generateImplicitReturnValue(@NotNull KtExpression bodyExpression, @NotNull KtElement subroutine) {
        if (bodyExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bodyExpression", "org/jetbrains/kotlin/cfg/ControlFlowProcessor", "generateImplicitReturnValue"));
        }
        if (subroutine == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "subroutine", "org/jetbrains/kotlin/cfg/ControlFlowProcessor", "generateImplicitReturnValue"));
        }
        CallableDescriptor subroutineDescriptor = (CallableDescriptor)this.trace.get(BindingContext.DECLARATION_TO_DESCRIPTOR, subroutine);
        if (subroutineDescriptor == null) {
            return;
        }
        KotlinType returnType2 = subroutineDescriptor.getReturnType();
        if (returnType2 != null && KotlinBuiltIns.isUnit(returnType2) && subroutineDescriptor instanceof AnonymousFunctionDescriptor) {
            return;
        }
        PseudoValue returnValue = this.builder.getBoundValue(bodyExpression);
        if (returnValue == null) {
            return;
        }
        this.builder.returnValue(bodyExpression, returnValue, subroutine);
    }

    private void processLocalDeclaration(@NotNull KtDeclaration subroutine) {
        if (subroutine == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "subroutine", "org/jetbrains/kotlin/cfg/ControlFlowProcessor", "processLocalDeclaration"));
        }
        Label afterDeclaration = this.builder.createUnboundLabel("after local declaration");
        this.builder.nondeterministicJump(afterDeclaration, subroutine, null);
        this.generate(subroutine);
        this.builder.bindLabel(afterDeclaration);
    }

    private class CFPVisitor
    extends KtVisitorVoid {
        private final ControlFlowBuilder builder;
        private final KtVisitorVoid conditionVisitor;

        private CFPVisitor(@NotNull ControlFlowBuilder builder) {
            if (builder == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "org/jetbrains/kotlin/cfg/ControlFlowProcessor$CFPVisitor", "<init>"));
            }
            this.conditionVisitor = new KtVisitorVoid(){

                private KtExpression getSubjectExpression(KtWhenCondition condition) {
                    KtWhenExpression whenExpression = PsiTreeUtil.getParentOfType((PsiElement)condition, KtWhenExpression.class);
                    return whenExpression != null ? whenExpression.getSubjectExpression() : null;
                }

                @Override
                public void visitWhenConditionInRange(@NotNull KtWhenConditionInRange condition) {
                    if (condition == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "condition", "org/jetbrains/kotlin/cfg/ControlFlowProcessor$CFPVisitor$1", "visitWhenConditionInRange"));
                    }
                    if (!CFPVisitor.this.generateCall(condition.getOperationReference())) {
                        KtExpression rangeExpression = condition.getRangeExpression();
                        CFPVisitor.this.generateInstructions(rangeExpression);
                        CFPVisitor.this.createNonSyntheticValue(condition, MagicKind.UNRESOLVED_CALL, new KtElement[]{rangeExpression});
                    }
                }

                @Override
                public void visitWhenConditionIsPattern(@NotNull KtWhenConditionIsPattern condition) {
                    if (condition == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "condition", "org/jetbrains/kotlin/cfg/ControlFlowProcessor$CFPVisitor$1", "visitWhenConditionIsPattern"));
                    }
                    CFPVisitor.this.mark(condition);
                    CFPVisitor.this.createNonSyntheticValue(condition, MagicKind.IS, new KtElement[]{this.getSubjectExpression(condition)});
                }

                @Override
                public void visitWhenConditionWithExpression(@NotNull KtWhenConditionWithExpression condition) {
                    if (condition == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "condition", "org/jetbrains/kotlin/cfg/ControlFlowProcessor$CFPVisitor$1", "visitWhenConditionWithExpression"));
                    }
                    CFPVisitor.this.mark(condition);
                    KtExpression expression = condition.getExpression();
                    CFPVisitor.this.generateInstructions(expression);
                    KtExpression subjectExpression = this.getSubjectExpression(condition);
                    if (subjectExpression != null) {
                        CFPVisitor.this.createNonSyntheticValue(condition, MagicKind.EQUALS_IN_WHEN_CONDITION, new KtElement[]{subjectExpression, expression});
                    } else {
                        CFPVisitor.this.copyValue(expression, condition);
                    }
                }

                @Override
                public void visitKtElement(@NotNull KtElement element) {
                    if (element == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/kotlin/cfg/ControlFlowProcessor$CFPVisitor$1", "visitKtElement"));
                    }
                    throw new UnsupportedOperationException("[ControlFlowProcessor] " + element.toString());
                }
            };
            this.builder = builder;
        }

        private void mark(KtElement element) {
            this.builder.mark(element);
        }

        public void generateInstructions(@Nullable KtElement element) {
            if (element == null) {
                return;
            }
            element.accept(this);
            this.checkNothingType(element);
        }

        private void checkNothingType(KtElement element) {
            if (!(element instanceof KtExpression)) {
                return;
            }
            KtExpression expression = KtPsiUtil.deparenthesize((KtExpression)element);
            if (expression == null) {
                return;
            }
            if (expression instanceof KtStatementExpression || expression instanceof KtTryExpression || expression instanceof KtIfExpression || expression instanceof KtWhenExpression) {
                return;
            }
            KotlinType type2 = ControlFlowProcessor.this.trace.getBindingContext().getType(expression);
            if (type2 != null && KotlinBuiltIns.isNothing(type2)) {
                this.builder.jumpToError(expression);
            }
        }

        @NotNull
        private PseudoValue createSyntheticValue(@NotNull KtElement instructionElement, @NotNull MagicKind kind, KtElement ... from) {
            if (instructionElement == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "instructionElement", "org/jetbrains/kotlin/cfg/ControlFlowProcessor$CFPVisitor", "createSyntheticValue"));
            }
            if (kind == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kind", "org/jetbrains/kotlin/cfg/ControlFlowProcessor$CFPVisitor", "createSyntheticValue"));
            }
            List<PseudoValue> values = this.elementsToValues(from.length > 0 ? Arrays.asList(from) : Collections.emptyList());
            PseudoValue pseudoValue = this.builder.magic(instructionElement, null, values, kind).getOutputValue();
            if (pseudoValue == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/cfg/ControlFlowProcessor$CFPVisitor", "createSyntheticValue"));
            }
            return pseudoValue;
        }

        @NotNull
        private PseudoValue createNonSyntheticValue(@NotNull KtElement to, @NotNull List<? extends KtElement> from, @NotNull MagicKind kind) {
            if (to == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "to", "org/jetbrains/kotlin/cfg/ControlFlowProcessor$CFPVisitor", "createNonSyntheticValue"));
            }
            if (from == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "from", "org/jetbrains/kotlin/cfg/ControlFlowProcessor$CFPVisitor", "createNonSyntheticValue"));
            }
            if (kind == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kind", "org/jetbrains/kotlin/cfg/ControlFlowProcessor$CFPVisitor", "createNonSyntheticValue"));
            }
            List<PseudoValue> values = this.elementsToValues(from);
            PseudoValue pseudoValue = this.builder.magic(to, to, values, kind).getOutputValue();
            if (pseudoValue == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/cfg/ControlFlowProcessor$CFPVisitor", "createNonSyntheticValue"));
            }
            return pseudoValue;
        }

        @NotNull
        private PseudoValue createNonSyntheticValue(@NotNull KtElement to, @NotNull MagicKind kind, KtElement ... from) {
            if (to == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "to", "org/jetbrains/kotlin/cfg/ControlFlowProcessor$CFPVisitor", "createNonSyntheticValue"));
            }
            if (kind == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kind", "org/jetbrains/kotlin/cfg/ControlFlowProcessor$CFPVisitor", "createNonSyntheticValue"));
            }
            PseudoValue pseudoValue = this.createNonSyntheticValue(to, Arrays.asList(from), kind);
            if (pseudoValue == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/cfg/ControlFlowProcessor$CFPVisitor", "createNonSyntheticValue"));
            }
            return pseudoValue;
        }

        private void mergeValues(@NotNull List<KtExpression> from, @NotNull KtExpression to) {
            if (from == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "from", "org/jetbrains/kotlin/cfg/ControlFlowProcessor$CFPVisitor", "mergeValues"));
            }
            if (to == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "to", "org/jetbrains/kotlin/cfg/ControlFlowProcessor$CFPVisitor", "mergeValues"));
            }
            this.builder.merge(to, this.elementsToValues(from));
        }

        private void copyValue(@Nullable KtElement from, @NotNull KtElement to) {
            if (to == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "to", "org/jetbrains/kotlin/cfg/ControlFlowProcessor$CFPVisitor", "copyValue"));
            }
            PseudoValue value = this.getBoundOrUnreachableValue(from);
            if (value != null) {
                this.builder.bindValue(value, to);
            }
        }

        @Nullable
        private PseudoValue getBoundOrUnreachableValue(@Nullable KtElement element) {
            if (element == null) {
                return null;
            }
            PseudoValue value = this.builder.getBoundValue(element);
            return value != null || element instanceof KtDeclaration ? value : this.builder.newValue(element);
        }

        private List<PseudoValue> elementsToValues(List<? extends KtElement> from) {
            if (from.isEmpty()) {
                return Collections.emptyList();
            }
            return CollectionsKt.filterNotNull(CollectionsKt.map(from, new Function1<KtElement, PseudoValue>(){

                @Override
                public PseudoValue invoke(KtElement element) {
                    return CFPVisitor.this.getBoundOrUnreachableValue(element);
                }
            }));
        }

        private void generateInitializer(@NotNull KtDeclaration declaration, @NotNull PseudoValue initValue) {
            if (declaration == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declaration", "org/jetbrains/kotlin/cfg/ControlFlowProcessor$CFPVisitor", "generateInitializer"));
            }
            if (initValue == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "initValue", "org/jetbrains/kotlin/cfg/ControlFlowProcessor$CFPVisitor", "generateInitializer"));
            }
            this.builder.write(declaration, declaration, initValue, this.getDeclarationAccessTarget(declaration), Collections.<PseudoValue, ReceiverValue>emptyMap());
        }

        @NotNull
        private AccessTarget getResolvedCallAccessTarget(KtElement element) {
            ResolvedCall<? extends CallableDescriptor> resolvedCall = CallUtilKt.getResolvedCall(element, ControlFlowProcessor.this.trace.getBindingContext());
            AccessTarget accessTarget = resolvedCall != null ? new AccessTarget.Call(resolvedCall) : AccessTarget.BlackBox.INSTANCE;
            if (accessTarget == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/cfg/ControlFlowProcessor$CFPVisitor", "getResolvedCallAccessTarget"));
            }
            return accessTarget;
        }

        @NotNull
        private AccessTarget getDeclarationAccessTarget(KtElement element) {
            DeclarationDescriptor descriptor2 = ControlFlowProcessor.this.trace.get(BindingContext.DECLARATION_TO_DESCRIPTOR, element);
            AccessTarget accessTarget = descriptor2 instanceof VariableDescriptor ? new AccessTarget.Declaration((VariableDescriptor)descriptor2) : AccessTarget.BlackBox.INSTANCE;
            if (accessTarget == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/cfg/ControlFlowProcessor$CFPVisitor", "getDeclarationAccessTarget"));
            }
            return accessTarget;
        }

        @Override
        public void visitParenthesizedExpression(@NotNull KtParenthesizedExpression expression) {
            if (expression == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/cfg/ControlFlowProcessor$CFPVisitor", "visitParenthesizedExpression"));
            }
            this.mark(expression);
            KtExpression innerExpression = expression.getExpression();
            if (innerExpression != null) {
                this.generateInstructions(innerExpression);
                this.copyValue(innerExpression, expression);
            }
        }

        @Override
        public void visitAnnotatedExpression(@NotNull KtAnnotatedExpression expression) {
            if (expression == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/cfg/ControlFlowProcessor$CFPVisitor", "visitAnnotatedExpression"));
            }
            KtExpression baseExpression = expression.getBaseExpression();
            if (baseExpression != null) {
                this.generateInstructions(baseExpression);
                this.copyValue(baseExpression, expression);
            }
        }

        @Override
        public void visitThisExpression(@NotNull KtThisExpression expression) {
            if (expression == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/cfg/ControlFlowProcessor$CFPVisitor", "visitThisExpression"));
            }
            ResolvedCall<? extends CallableDescriptor> resolvedCall = CallUtilKt.getResolvedCall(expression, ControlFlowProcessor.this.trace.getBindingContext());
            if (resolvedCall == null) {
                this.createNonSyntheticValue((KtElement)expression, MagicKind.UNRESOLVED_CALL, new KtElement[0]);
                return;
            }
            CallableDescriptor resultingDescriptor = resolvedCall.getResultingDescriptor();
            if (resultingDescriptor instanceof ReceiverParameterDescriptor) {
                this.builder.readVariable(expression, resolvedCall, this.getReceiverValues(resolvedCall));
            }
            this.copyValue(expression, expression.getInstanceReference());
        }

        @Override
        public void visitConstantExpression(@NotNull KtConstantExpression expression) {
            if (expression == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/cfg/ControlFlowProcessor$CFPVisitor", "visitConstantExpression"));
            }
            CompileTimeConstant<?> constant = ConstantExpressionEvaluator.getConstant(expression, ControlFlowProcessor.this.trace.getBindingContext());
            this.builder.loadConstant(expression, constant);
        }

        @Override
        public void visitSimpleNameExpression(@NotNull KtSimpleNameExpression expression) {
            if (expression == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/cfg/ControlFlowProcessor$CFPVisitor", "visitSimpleNameExpression"));
            }
            ResolvedCall<? extends CallableDescriptor> resolvedCall = CallUtilKt.getResolvedCall(expression, ControlFlowProcessor.this.trace.getBindingContext());
            if (resolvedCall instanceof VariableAsFunctionResolvedCall) {
                VariableAsFunctionResolvedCall variableAsFunctionResolvedCall = (VariableAsFunctionResolvedCall)((Object)resolvedCall);
                this.generateCall(variableAsFunctionResolvedCall.getVariableCall());
            } else if (!this.generateCall(expression) && !(expression.getParent() instanceof KtCallExpression)) {
                this.createNonSyntheticValue((KtElement)expression, MagicKind.UNRESOLVED_CALL, this.generateAndGetReceiverIfAny(expression));
            }
        }

        @Override
        public void visitLabeledExpression(@NotNull KtLabeledExpression expression) {
            if (expression == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/cfg/ControlFlowProcessor$CFPVisitor", "visitLabeledExpression"));
            }
            this.mark(expression);
            KtExpression baseExpression = expression.getBaseExpression();
            if (baseExpression != null) {
                this.generateInstructions(baseExpression);
                this.copyValue(baseExpression, expression);
            }
        }

        @Override
        public void visitBinaryExpression(@NotNull KtBinaryExpression expression) {
            if (expression == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/cfg/ControlFlowProcessor$CFPVisitor", "visitBinaryExpression"));
            }
            KtSimpleNameExpression operationReference = expression.getOperationReference();
            IElementType operationType = operationReference.getReferencedNameElementType();
            KtExpression left = expression.getLeft();
            KtExpression right = expression.getRight();
            if (operationType == KtTokens.ANDAND || operationType == KtTokens.OROR) {
                this.generateBooleanOperation(expression);
            } else if (operationType == KtTokens.EQ) {
                this.visitAssignment(left, this.getDeferredValue(right), expression);
            } else if (OperatorConventions.ASSIGNMENT_OPERATIONS.containsKey(operationType)) {
                ResolvedCall<? extends CallableDescriptor> resolvedCall = CallUtilKt.getResolvedCall(expression, ControlFlowProcessor.this.trace.getBindingContext());
                if (resolvedCall != null) {
                    PseudoValue rhsValue = this.generateCall(resolvedCall).getOutputValue();
                    Name assignMethodName = OperatorConventions.getNameForOperationSymbol((KtToken)expression.getOperationToken());
                    if (!resolvedCall.getResultingDescriptor().getName().equals(assignMethodName)) {
                        this.visitAssignment(left, this.getValueAsFunction(rhsValue), expression);
                    }
                } else {
                    this.generateBothArgumentsAndMark(expression);
                }
            } else if (operationType == KtTokens.ELVIS) {
                this.generateInstructions(left);
                this.mark(expression);
                Label afterElvis = this.builder.createUnboundLabel("after elvis operator");
                this.builder.jumpOnTrue(afterElvis, expression, this.builder.getBoundValue(left));
                if (right != null) {
                    this.generateInstructions(right);
                }
                this.builder.bindLabel(afterElvis);
                this.mergeValues(Arrays.asList(left, right), expression);
            } else if (!this.generateCall(expression)) {
                this.generateBothArgumentsAndMark(expression);
            }
        }

        private void generateBooleanOperation(KtBinaryExpression expression) {
            IElementType operationType = expression.getOperationReference().getReferencedNameElementType();
            KtExpression left = expression.getLeft();
            KtExpression right = expression.getRight();
            Label resultLabel = this.builder.createUnboundLabel("result of boolean operation");
            this.generateInstructions(left);
            if (operationType == KtTokens.ANDAND) {
                this.builder.jumpOnFalse(resultLabel, expression, this.builder.getBoundValue(left));
            } else {
                this.builder.jumpOnTrue(resultLabel, expression, this.builder.getBoundValue(left));
            }
            if (right != null) {
                this.generateInstructions(right);
            }
            this.builder.bindLabel(resultLabel);
            ControlFlowBuilder.PredefinedOperation operation = operationType == KtTokens.ANDAND ? ControlFlowBuilder.PredefinedOperation.AND : ControlFlowBuilder.PredefinedOperation.OR;
            this.builder.predefinedOperation(expression, operation, this.elementsToValues(Arrays.asList(left, right)));
        }

        private Function0<PseudoValue> getValueAsFunction(final PseudoValue value) {
            return new Function0<PseudoValue>(){

                @Override
                public PseudoValue invoke() {
                    return value;
                }
            };
        }

        private Function0<PseudoValue> getDeferredValue(final KtExpression expression) {
            return new Function0<PseudoValue>(){

                @Override
                public PseudoValue invoke() {
                    CFPVisitor.this.generateInstructions(expression);
                    return CFPVisitor.this.getBoundOrUnreachableValue(expression);
                }
            };
        }

        private void generateBothArgumentsAndMark(KtBinaryExpression expression) {
            KtExpression right;
            KtExpression left = KtPsiUtil.deparenthesize(expression.getLeft());
            if (left != null) {
                this.generateInstructions(left);
            }
            if ((right = expression.getRight()) != null) {
                this.generateInstructions(right);
            }
            this.mark(expression);
            this.createNonSyntheticValue((KtElement)expression, MagicKind.UNRESOLVED_CALL, left, right);
        }

        private void visitAssignment(KtExpression lhs, @NotNull Function0<PseudoValue> rhsDeferredValue, KtExpression parentExpression) {
            PseudoValue rightValue;
            if (rhsDeferredValue == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rhsDeferredValue", "org/jetbrains/kotlin/cfg/ControlFlowProcessor$CFPVisitor", "visitAssignment"));
            }
            KtExpression left = KtPsiUtil.deparenthesize(lhs);
            if (left == null) {
                List<PseudoValue> arguments2 = Collections.singletonList(rhsDeferredValue.invoke());
                this.builder.magic(parentExpression, parentExpression, arguments2, MagicKind.UNSUPPORTED_ELEMENT);
                return;
            }
            if (left instanceof KtArrayAccessExpression) {
                this.generateArrayAssignment((KtArrayAccessExpression)left, rhsDeferredValue, parentExpression);
                return;
            }
            SmartFMap<PseudoValue, ReceiverValue> receiverValues = SmartFMap.emptyMap();
            AccessTarget accessTarget = AccessTarget.BlackBox.INSTANCE;
            if (left instanceof KtSimpleNameExpression || left instanceof KtQualifiedExpression) {
                accessTarget = this.getResolvedCallAccessTarget(KtPsiUtilKt.getQualifiedElementSelector(left));
                if (accessTarget instanceof AccessTarget.Call) {
                    receiverValues = this.getReceiverValues(((AccessTarget.Call)accessTarget).getResolvedCall());
                }
            } else if (left instanceof KtProperty) {
                accessTarget = this.getDeclarationAccessTarget(left);
            }
            if (accessTarget == AccessTarget.BlackBox.INSTANCE && !(left instanceof KtProperty)) {
                this.generateInstructions(left);
                this.createSyntheticValue(left, MagicKind.VALUE_CONSUMER, left);
            }
            PseudoValue rValue = (rightValue = rhsDeferredValue.invoke()) != null ? rightValue : this.createSyntheticValue(parentExpression, MagicKind.UNRECOGNIZED_WRITE_RHS, new KtElement[0]);
            this.builder.write(parentExpression, left, rValue, accessTarget, receiverValues);
        }

        private void generateArrayAssignment(KtArrayAccessExpression lhs, @NotNull Function0<PseudoValue> rhsDeferredValue, @NotNull KtExpression parentExpression) {
            if (rhsDeferredValue == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rhsDeferredValue", "org/jetbrains/kotlin/cfg/ControlFlowProcessor$CFPVisitor", "generateArrayAssignment"));
            }
            if (parentExpression == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentExpression", "org/jetbrains/kotlin/cfg/ControlFlowProcessor$CFPVisitor", "generateArrayAssignment"));
            }
            ResolvedCall<FunctionDescriptor> setResolvedCall = ControlFlowProcessor.this.trace.get(BindingContext.INDEXED_LVALUE_SET, lhs);
            if (setResolvedCall == null) {
                this.generateArrayAccess(lhs, null);
                List<PseudoValue> arguments2 = CollectionsKt.filterNotNull(Arrays.asList(this.getBoundOrUnreachableValue(lhs), rhsDeferredValue.invoke()));
                this.builder.magic(parentExpression, parentExpression, arguments2, MagicKind.UNRESOLVED_CALL);
                return;
            }
            if (((KtOperationExpression)parentExpression).getOperationReference().getReferencedNameElementType() == KtTokens.EQ) {
                this.mark(lhs);
            }
            this.generateInstructions(lhs.getArrayExpression());
            Map<PseudoValue, ReceiverValue> receiverValues = this.getReceiverValues(setResolvedCall);
            SmartFMap<PseudoValue, ValueParameterDescriptor> argumentValues = this.getArraySetterArguments(rhsDeferredValue, setResolvedCall);
            this.builder.call(parentExpression, setResolvedCall, receiverValues, argumentValues);
        }

        private SmartFMap<PseudoValue, ValueParameterDescriptor> getArraySetterArguments(Function0<PseudoValue> rhsDeferredValue, final ResolvedCall<FunctionDescriptor> setResolvedCall) {
            List valueArguments2 = CollectionsKt.flatMapTo(setResolvedCall.getResultingDescriptor().getValueParameters(), new ArrayList(), new Function1<ValueParameterDescriptor, Iterable<? extends ValueArgument>>(){

                @Override
                public Iterable<? extends ValueArgument> invoke(ValueParameterDescriptor descriptor2) {
                    ResolvedValueArgument resolvedValueArgument = setResolvedCall.getValueArguments().get(descriptor2);
                    return resolvedValueArgument != null ? resolvedValueArgument.getArguments() : Collections.emptyList();
                }
            });
            ValueArgument rhsArgument = (ValueArgument)CollectionsKt.lastOrNull(valueArguments2);
            SmartFMap<PseudoValue, ValueParameterDescriptor> argumentValues = SmartFMap.emptyMap();
            for (ValueArgument valueArgument : valueArguments2) {
                ArgumentMapping argumentMapping = setResolvedCall.getArgumentMapping(valueArgument);
                if (argumentMapping.isError() || !(argumentMapping instanceof ArgumentMatch)) continue;
                ValueParameterDescriptor parameterDescriptor = ((ArgumentMatch)argumentMapping).getValueParameter();
                if (valueArgument != rhsArgument) {
                    argumentValues = this.generateValueArgument(valueArgument, parameterDescriptor, argumentValues);
                    continue;
                }
                PseudoValue rhsValue = rhsDeferredValue.invoke();
                if (rhsValue == null) continue;
                argumentValues = argumentValues.plus(rhsValue, parameterDescriptor);
            }
            return argumentValues;
        }

        private void generateArrayAccess(KtArrayAccessExpression arrayAccessExpression, @Nullable ResolvedCall<?> resolvedCall) {
            if (this.builder.getBoundValue(arrayAccessExpression) != null) {
                return;
            }
            this.mark(arrayAccessExpression);
            if (!this.checkAndGenerateCall(resolvedCall)) {
                this.generateArrayAccessWithoutCall(arrayAccessExpression);
            }
        }

        private void generateArrayAccessWithoutCall(KtArrayAccessExpression arrayAccessExpression) {
            this.createNonSyntheticValue((KtElement)arrayAccessExpression, this.generateArrayAccessArguments(arrayAccessExpression), MagicKind.UNRESOLVED_CALL);
        }

        private List<KtExpression> generateArrayAccessArguments(KtArrayAccessExpression arrayAccessExpression) {
            ArrayList<KtExpression> inputExpressions = new ArrayList<KtExpression>();
            KtExpression arrayExpression = arrayAccessExpression.getArrayExpression();
            inputExpressions.add(arrayExpression);
            this.generateInstructions(arrayExpression);
            for (KtExpression index2 : arrayAccessExpression.getIndexExpressions()) {
                this.generateInstructions(index2);
                inputExpressions.add(index2);
            }
            return inputExpressions;
        }

        @Override
        public void visitUnaryExpression(@NotNull KtUnaryExpression expression) {
            PseudoValue rhsValue;
            if (expression == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/cfg/ControlFlowProcessor$CFPVisitor", "visitUnaryExpression"));
            }
            KtSimpleNameExpression operationSign = expression.getOperationReference();
            IElementType operationType = operationSign.getReferencedNameElementType();
            KtExpression baseExpression = expression.getBaseExpression();
            if (baseExpression == null) {
                return;
            }
            if (KtTokens.EXCLEXCL == operationType) {
                this.generateInstructions(baseExpression);
                this.builder.predefinedOperation(expression, ControlFlowBuilder.PredefinedOperation.NOT_NULL_ASSERTION, this.elementsToValues(Collections.singletonList(baseExpression)));
                return;
            }
            boolean incrementOrDecrement = this.isIncrementOrDecrement(operationType);
            ResolvedCall<? extends CallableDescriptor> resolvedCall = CallUtilKt.getResolvedCall(expression, ControlFlowProcessor.this.trace.getBindingContext());
            if (resolvedCall != null) {
                rhsValue = this.generateCall(resolvedCall).getOutputValue();
            } else {
                this.generateInstructions(baseExpression);
                rhsValue = this.createNonSyntheticValue((KtElement)expression, MagicKind.UNRESOLVED_CALL, baseExpression);
            }
            if (incrementOrDecrement) {
                this.visitAssignment(baseExpression, this.getValueAsFunction(rhsValue), expression);
                if (expression instanceof KtPostfixExpression) {
                    this.copyValue(baseExpression, expression);
                }
            }
        }

        private boolean isIncrementOrDecrement(IElementType operationType) {
            return operationType == KtTokens.PLUSPLUS || operationType == KtTokens.MINUSMINUS;
        }

        @Override
        public void visitIfExpression(@NotNull KtIfExpression expression) {
            if (expression == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/cfg/ControlFlowProcessor$CFPVisitor", "visitIfExpression"));
            }
            this.mark(expression);
            ArrayList<KtExpression> branches = new ArrayList<KtExpression>(2);
            KtExpression condition = expression.getCondition();
            if (condition != null) {
                this.generateInstructions(condition);
            }
            Label elseLabel = this.builder.createUnboundLabel("else branch");
            this.builder.jumpOnFalse(elseLabel, expression, this.builder.getBoundValue(condition));
            KtExpression thenBranch = expression.getThen();
            if (thenBranch != null) {
                branches.add(thenBranch);
                this.generateInstructions(thenBranch);
            } else {
                this.builder.loadUnit(expression);
            }
            Label resultLabel = this.builder.createUnboundLabel("'if' expression result");
            this.builder.jump(resultLabel, expression);
            this.builder.bindLabel(elseLabel);
            KtExpression elseBranch = expression.getElse();
            if (elseBranch != null) {
                branches.add(elseBranch);
                this.generateInstructions(elseBranch);
            } else {
                this.builder.loadUnit(expression);
            }
            this.builder.bindLabel(resultLabel);
            this.mergeValues(branches, expression);
        }

        @Override
        public void visitTryExpression(@NotNull KtTryExpression expression) {
            boolean hasFinally;
            if (expression == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/cfg/ControlFlowProcessor$CFPVisitor", "visitTryExpression"));
            }
            this.mark(expression);
            KtFinallySection finallyBlock = expression.getFinallyBlock();
            final FinallyBlockGenerator finallyBlockGenerator = new FinallyBlockGenerator(finallyBlock);
            boolean bl = hasFinally = finallyBlock != null;
            if (hasFinally) {
                this.builder.enterTryFinally(new GenerationTrigger(){
                    private boolean working = false;

                    @Override
                    public void generate() {
                        if (this.working) {
                            return;
                        }
                        this.working = true;
                        finallyBlockGenerator.generate();
                        this.working = false;
                    }
                });
            }
            Label onExceptionToFinallyBlock = this.generateTryAndCatches(expression);
            if (hasFinally) {
                assert (onExceptionToFinallyBlock != null) : "No finally lable generated: " + expression.getText();
                this.builder.exitTryFinally();
                Label skipFinallyToErrorBlock = this.builder.createUnboundLabel("skipFinallyToErrorBlock");
                this.builder.jump(skipFinallyToErrorBlock, expression);
                this.builder.bindLabel(onExceptionToFinallyBlock);
                finallyBlockGenerator.generate();
                this.builder.jumpToError(expression);
                this.builder.bindLabel(skipFinallyToErrorBlock);
                finallyBlockGenerator.generate();
            }
            ArrayList<KtExpression> branches = new ArrayList<KtExpression>();
            branches.add(expression.getTryBlock());
            for (KtCatchClause catchClause : expression.getCatchClauses()) {
                branches.add(catchClause.getCatchBody());
            }
            this.mergeValues(branches, expression);
        }

        @Nullable
        private Label generateTryAndCatches(@NotNull KtTryExpression expression) {
            if (expression == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/cfg/ControlFlowProcessor$CFPVisitor", "generateTryAndCatches"));
            }
            List<KtCatchClause> catchClauses = expression.getCatchClauses();
            boolean hasCatches = !catchClauses.isEmpty();
            Label onException = null;
            if (hasCatches) {
                onException = this.builder.createUnboundLabel("onException");
                this.builder.nondeterministicJump(onException, expression, null);
            }
            Label onExceptionToFinallyBlock = null;
            if (expression.getFinallyBlock() != null) {
                onExceptionToFinallyBlock = this.builder.createUnboundLabel("onExceptionToFinallyBlock");
                this.builder.nondeterministicJump(onExceptionToFinallyBlock, expression, null);
            }
            KtBlockExpression tryBlock = expression.getTryBlock();
            this.generateInstructions(tryBlock);
            if (hasCatches) {
                Label afterCatches = this.builder.createUnboundLabel("afterCatches");
                this.builder.jump(afterCatches, expression);
                this.builder.bindLabel(onException);
                LinkedList<Label> catchLabels = Lists.newLinkedList();
                int catchClausesSize = catchClauses.size();
                for (int i = 0; i < catchClausesSize - 1; ++i) {
                    catchLabels.add(this.builder.createUnboundLabel("catch " + i));
                }
                if (!catchLabels.isEmpty()) {
                    this.builder.nondeterministicJump(catchLabels, expression);
                }
                boolean isFirst = true;
                for (KtCatchClause catchClause : catchClauses) {
                    KtExpression catchBody;
                    this.builder.enterLexicalScope(catchClause);
                    if (!isFirst) {
                        this.builder.bindLabel(catchLabels.remove());
                    } else {
                        isFirst = false;
                    }
                    KtParameter catchParameter = catchClause.getCatchParameter();
                    if (catchParameter != null) {
                        this.builder.declareParameter(catchParameter);
                        this.generateInitializer(catchParameter, this.createSyntheticValue(catchParameter, MagicKind.FAKE_INITIALIZER, new KtElement[0]));
                    }
                    if ((catchBody = catchClause.getCatchBody()) != null) {
                        this.generateInstructions(catchBody);
                    }
                    this.builder.jump(afterCatches, expression);
                    this.builder.exitLexicalScope(catchClause);
                }
                this.builder.bindLabel(afterCatches);
            }
            return onExceptionToFinallyBlock;
        }

        @Override
        public void visitWhileExpression(@NotNull KtWhileExpression expression) {
            if (expression == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/cfg/ControlFlowProcessor$CFPVisitor", "visitWhileExpression"));
            }
            LoopInfo loopInfo = this.builder.enterLoop(expression);
            this.builder.bindLabel(loopInfo.getConditionEntryPoint());
            KtExpression condition = expression.getCondition();
            if (condition != null) {
                this.generateInstructions(condition);
            }
            this.mark(expression);
            if (!CompileTimeConstantUtils.canBeReducedToBooleanConstant(condition, ControlFlowProcessor.this.trace.getBindingContext(), true)) {
                this.builder.jumpOnFalse(loopInfo.getExitPoint(), expression, this.builder.getBoundValue(condition));
            } else {
                assert (condition != null) : "Invalid while condition: " + expression.getText();
                this.createSyntheticValue(condition, MagicKind.VALUE_CONSUMER, condition);
            }
            this.builder.enterLoopBody(expression);
            KtExpression body = expression.getBody();
            if (body != null) {
                this.generateInstructions(body);
            }
            this.builder.jump(loopInfo.getEntryPoint(), expression);
            this.builder.exitLoopBody(expression);
            this.builder.bindLabel(loopInfo.getExitPoint());
            this.builder.loadUnit(expression);
        }

        @Override
        public void visitDoWhileExpression(@NotNull KtDoWhileExpression expression) {
            if (expression == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/cfg/ControlFlowProcessor$CFPVisitor", "visitDoWhileExpression"));
            }
            this.builder.enterLexicalScope(expression);
            this.mark(expression);
            LoopInfo loopInfo = this.builder.enterLoop(expression);
            this.builder.enterLoopBody(expression);
            KtExpression body = expression.getBody();
            if (body != null) {
                this.generateInstructions(body);
            }
            this.builder.exitLoopBody(expression);
            this.builder.bindLabel(loopInfo.getConditionEntryPoint());
            KtExpression condition = expression.getCondition();
            if (condition != null) {
                this.generateInstructions(condition);
            }
            this.builder.jumpOnTrue(loopInfo.getEntryPoint(), expression, this.builder.getBoundValue(condition));
            this.builder.bindLabel(loopInfo.getExitPoint());
            this.builder.loadUnit(expression);
            this.builder.exitLexicalScope(expression);
        }

        @Override
        public void visitForExpression(@NotNull KtForExpression expression) {
            if (expression == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/cfg/ControlFlowProcessor$CFPVisitor", "visitForExpression"));
            }
            this.builder.enterLexicalScope(expression);
            KtExpression loopRange = expression.getLoopRange();
            if (loopRange != null) {
                this.generateInstructions(loopRange);
            }
            this.declareLoopParameter(expression);
            LoopInfo loopInfo = this.builder.enterLoop(expression);
            this.builder.bindLabel(loopInfo.getConditionEntryPoint());
            this.builder.nondeterministicJump(loopInfo.getExitPoint(), expression, null);
            this.writeLoopParameterAssignment(expression);
            this.mark(expression);
            this.builder.enterLoopBody(expression);
            KtExpression body = expression.getBody();
            if (body != null) {
                this.generateInstructions(body);
            }
            this.builder.jump(loopInfo.getEntryPoint(), expression);
            this.builder.exitLoopBody(expression);
            this.builder.bindLabel(loopInfo.getExitPoint());
            this.builder.loadUnit(expression);
            this.builder.exitLexicalScope(expression);
        }

        private void declareLoopParameter(KtForExpression expression) {
            KtParameter loopParameter = expression.getLoopParameter();
            KtDestructuringDeclaration multiDeclaration = expression.getDestructuringParameter();
            if (loopParameter != null) {
                this.builder.declareParameter(loopParameter);
            } else if (multiDeclaration != null) {
                this.visitDestructuringDeclaration(multiDeclaration, false);
            }
        }

        private void writeLoopParameterAssignment(KtForExpression expression) {
            KtParameter loopParameter = expression.getLoopParameter();
            KtDestructuringDeclaration multiDeclaration = expression.getDestructuringParameter();
            KtExpression loopRange = expression.getLoopRange();
            PseudoValue value = this.builder.magic(loopRange != null ? loopRange : expression, null, ContainerUtil.createMaybeSingletonList(this.builder.getBoundValue(loopRange)), MagicKind.LOOP_RANGE_ITERATION).getOutputValue();
            if (loopParameter != null) {
                this.generateInitializer(loopParameter, value);
            } else if (multiDeclaration != null) {
                for (KtDestructuringDeclarationEntry entry : multiDeclaration.getEntries()) {
                    this.generateInitializer(entry, value);
                }
            }
        }

        @Override
        public void visitBreakExpression(@NotNull KtBreakExpression expression) {
            if (expression == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/cfg/ControlFlowProcessor$CFPVisitor", "visitBreakExpression"));
            }
            KtElement loop = this.getCorrespondingLoop(expression);
            if (loop != null) {
                this.checkJumpDoesNotCrossFunctionBoundary(expression, loop);
                this.builder.jump(this.builder.getExitPoint(loop), expression);
            }
        }

        @Override
        public void visitContinueExpression(@NotNull KtContinueExpression expression) {
            if (expression == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/cfg/ControlFlowProcessor$CFPVisitor", "visitContinueExpression"));
            }
            KtElement loop = this.getCorrespondingLoop(expression);
            if (loop != null) {
                this.checkJumpDoesNotCrossFunctionBoundary(expression, loop);
                this.builder.jump(this.builder.getConditionEntryPoint(loop), expression);
            }
        }

        @Nullable
        private KtElement getCorrespondingLoop(KtExpressionWithLabel expression) {
            KtLoopExpression loop;
            String labelName = expression.getLabelName();
            if (labelName != null) {
                KtSimpleNameExpression targetLabel = expression.getTargetLabel();
                assert (targetLabel != null);
                PsiElement labeledElement = ControlFlowProcessor.this.trace.get(BindingContext.LABEL_TARGET, targetLabel);
                if (labeledElement instanceof KtLoopExpression) {
                    loop = (KtLoopExpression)labeledElement;
                } else {
                    ControlFlowProcessor.this.trace.report(Errors.NOT_A_LOOP_LABEL.on(expression, targetLabel.getText()));
                    loop = null;
                }
            } else {
                loop = this.builder.getCurrentLoop();
                if (loop == null) {
                    ControlFlowProcessor.this.trace.report(Errors.BREAK_OR_CONTINUE_OUTSIDE_A_LOOP.on(expression));
                } else {
                    KtWhenExpression whenExpression = PsiTreeUtil.getParentOfType((PsiElement)expression, KtWhenExpression.class, true, KtLoopExpression.class);
                    if (whenExpression != null) {
                        ControlFlowProcessor.this.trace.report(Errors.BREAK_OR_CONTINUE_IN_WHEN.on(expression));
                    }
                }
            }
            if (loop != null && loop.getBody() != null && !loop.getBody().getTextRange().contains(expression.getTextRange())) {
                ControlFlowProcessor.this.trace.report(Errors.BREAK_OR_CONTINUE_OUTSIDE_A_LOOP.on(expression));
                return null;
            }
            return loop;
        }

        private void checkJumpDoesNotCrossFunctionBoundary(@NotNull KtExpressionWithLabel jumpExpression, @NotNull KtElement jumpTarget) {
            FunctionDescriptor labelTargetEnclosingFunc;
            if (jumpExpression == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jumpExpression", "org/jetbrains/kotlin/cfg/ControlFlowProcessor$CFPVisitor", "checkJumpDoesNotCrossFunctionBoundary"));
            }
            if (jumpTarget == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jumpTarget", "org/jetbrains/kotlin/cfg/ControlFlowProcessor$CFPVisitor", "checkJumpDoesNotCrossFunctionBoundary"));
            }
            BindingContext bindingContext = ControlFlowProcessor.this.trace.getBindingContext();
            FunctionDescriptor labelExprEnclosingFunc = BindingContextUtils.getEnclosingFunctionDescriptor(bindingContext, jumpExpression);
            if (labelExprEnclosingFunc != (labelTargetEnclosingFunc = BindingContextUtils.getEnclosingFunctionDescriptor(bindingContext, jumpTarget))) {
                ControlFlowProcessor.this.trace.report(Errors.BREAK_OR_CONTINUE_JUMPS_ACROSS_FUNCTION_BOUNDARY.on(jumpExpression));
            }
        }

        @Override
        public void visitReturnExpression(@NotNull KtReturnExpression expression) {
            KtElement subroutine;
            if (expression == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/cfg/ControlFlowProcessor$CFPVisitor", "visitReturnExpression"));
            }
            KtExpression returnedExpression = expression.getReturnedExpression();
            if (returnedExpression != null) {
                this.generateInstructions(returnedExpression);
            }
            KtSimpleNameExpression labelElement = expression.getTargetLabel();
            String labelName = expression.getLabelName();
            if (labelElement != null && labelName != null) {
                PsiElement labeledElement = ControlFlowProcessor.this.trace.get(BindingContext.LABEL_TARGET, labelElement);
                if (labeledElement != null) {
                    assert (labeledElement instanceof KtElement);
                    subroutine = (KtElement)labeledElement;
                } else {
                    subroutine = null;
                }
            } else {
                subroutine = this.builder.getReturnSubroutine();
            }
            if (subroutine instanceof KtFunction || subroutine instanceof KtPropertyAccessor) {
                PseudoValue returnValue;
                PseudoValue pseudoValue = returnValue = returnedExpression != null ? this.builder.getBoundValue(returnedExpression) : null;
                if (returnValue == null) {
                    this.builder.returnNoValue(expression, subroutine);
                } else {
                    this.builder.returnValue(expression, returnValue, subroutine);
                }
            } else {
                this.createNonSyntheticValue((KtElement)expression, MagicKind.UNSUPPORTED_ELEMENT, returnedExpression);
            }
        }

        @Override
        public void visitParameter(@NotNull KtParameter parameter) {
            if (parameter == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameter", "org/jetbrains/kotlin/cfg/ControlFlowProcessor$CFPVisitor", "visitParameter"));
            }
            this.builder.declareParameter(parameter);
            KtExpression defaultValue = parameter.getDefaultValue();
            if (defaultValue != null) {
                Label skipDefaultValue = this.builder.createUnboundLabel("after default value for parameter " + parameter.getName());
                this.builder.nondeterministicJump(skipDefaultValue, defaultValue, null);
                this.generateInstructions(defaultValue);
                this.builder.bindLabel(skipDefaultValue);
            }
            this.generateInitializer(parameter, this.computePseudoValueForParameter(parameter));
        }

        @NotNull
        private PseudoValue computePseudoValueForParameter(@NotNull KtParameter parameter) {
            if (parameter == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameter", "org/jetbrains/kotlin/cfg/ControlFlowProcessor$CFPVisitor", "computePseudoValueForParameter"));
            }
            PseudoValue syntheticValue = this.createSyntheticValue(parameter, MagicKind.FAKE_INITIALIZER, new KtElement[0]);
            PseudoValue defaultValue = this.builder.getBoundValue(parameter.getDefaultValue());
            if (defaultValue == null) {
                PseudoValue pseudoValue = syntheticValue;
                if (pseudoValue == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/cfg/ControlFlowProcessor$CFPVisitor", "computePseudoValueForParameter"));
                }
                return pseudoValue;
            }
            PseudoValue pseudoValue = this.builder.merge(parameter, Lists.newArrayList(defaultValue, syntheticValue)).getOutputValue();
            if (pseudoValue == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/cfg/ControlFlowProcessor$CFPVisitor", "computePseudoValueForParameter"));
            }
            return pseudoValue;
        }

        @Override
        public void visitBlockExpression(@NotNull KtBlockExpression expression) {
            boolean declareLexicalScope;
            if (expression == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/cfg/ControlFlowProcessor$CFPVisitor", "visitBlockExpression"));
            }
            boolean bl = declareLexicalScope = !this.isBlockInDoWhile(expression);
            if (declareLexicalScope) {
                this.builder.enterLexicalScope(expression);
            }
            this.mark(expression);
            List<KtExpression> statements = expression.getStatements();
            for (KtExpression statement : statements) {
                this.generateInstructions(statement);
            }
            if (statements.isEmpty()) {
                this.builder.loadUnit(expression);
            } else {
                this.copyValue(CollectionsKt.lastOrNull(statements), expression);
            }
            if (declareLexicalScope) {
                this.builder.exitLexicalScope(expression);
            }
        }

        private boolean isBlockInDoWhile(@NotNull KtBlockExpression expression) {
            if (expression == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/cfg/ControlFlowProcessor$CFPVisitor", "isBlockInDoWhile"));
            }
            PsiElement parent2 = expression.getParent();
            if (parent2 == null) {
                return false;
            }
            return parent2.getParent() instanceof KtDoWhileExpression;
        }

        private void visitFunction(@NotNull KtFunction function) {
            boolean isAnonymousFunction;
            if (function == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "function", "org/jetbrains/kotlin/cfg/ControlFlowProcessor$CFPVisitor", "visitFunction"));
            }
            ControlFlowProcessor.this.processLocalDeclaration(function);
            boolean bl = isAnonymousFunction = function instanceof KtFunctionLiteral || function.getName() == null;
            if (isAnonymousFunction || function.isLocal() && !(function.getParent() instanceof KtBlockExpression)) {
                this.builder.createLambda(function);
            }
        }

        @Override
        public void visitNamedFunction(@NotNull KtNamedFunction function) {
            if (function == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "function", "org/jetbrains/kotlin/cfg/ControlFlowProcessor$CFPVisitor", "visitNamedFunction"));
            }
            this.visitFunction(function);
        }

        @Override
        public void visitLambdaExpression(@NotNull KtLambdaExpression lambdaExpression) {
            if (lambdaExpression == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lambdaExpression", "org/jetbrains/kotlin/cfg/ControlFlowProcessor$CFPVisitor", "visitLambdaExpression"));
            }
            this.mark(lambdaExpression);
            KtFunctionLiteral functionLiteral = lambdaExpression.getFunctionLiteral();
            this.visitFunction(functionLiteral);
            this.copyValue(functionLiteral, lambdaExpression);
        }

        @Override
        public void visitQualifiedExpression(@NotNull KtQualifiedExpression expression) {
            if (expression == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/cfg/ControlFlowProcessor$CFPVisitor", "visitQualifiedExpression"));
            }
            this.mark(expression);
            KtExpression selectorExpression = expression.getSelectorExpression();
            KtExpression receiverExpression = expression.getReceiverExpression();
            if (selectorExpression instanceof KtCallExpression || selectorExpression instanceof KtSimpleNameExpression) {
                this.generateInstructions(selectorExpression);
                this.copyValue(selectorExpression, expression);
            } else {
                this.generateInstructions(receiverExpression);
                this.createNonSyntheticValue((KtElement)expression, MagicKind.UNSUPPORTED_ELEMENT, receiverExpression);
            }
        }

        @Override
        public void visitCallExpression(@NotNull KtCallExpression expression) {
            if (expression == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/cfg/ControlFlowProcessor$CFPVisitor", "visitCallExpression"));
            }
            if (!this.generateCall(expression)) {
                ArrayList<KtExpression> inputExpressions = new ArrayList<KtExpression>();
                for (KtValueArgument argument : expression.getValueArguments()) {
                    KtExpression argumentExpression = argument.getArgumentExpression();
                    if (argumentExpression == null) continue;
                    this.generateInstructions(argumentExpression);
                    inputExpressions.add(argumentExpression);
                }
                KtExpression calleeExpression = expression.getCalleeExpression();
                this.generateInstructions(calleeExpression);
                inputExpressions.add(calleeExpression);
                inputExpressions.add(this.generateAndGetReceiverIfAny(expression));
                this.mark(expression);
                this.createNonSyntheticValue((KtElement)expression, inputExpressions, MagicKind.UNRESOLVED_CALL);
            }
        }

        @Nullable
        private KtExpression generateAndGetReceiverIfAny(KtExpression expression) {
            PsiElement parent2 = expression.getParent();
            if (!(parent2 instanceof KtQualifiedExpression)) {
                return null;
            }
            KtQualifiedExpression qualifiedExpression = (KtQualifiedExpression)parent2;
            if (qualifiedExpression.getSelectorExpression() != expression) {
                return null;
            }
            KtExpression receiverExpression = qualifiedExpression.getReceiverExpression();
            this.generateInstructions(receiverExpression);
            return receiverExpression;
        }

        @Override
        public void visitProperty(@NotNull KtProperty property) {
            KtExpression delegate2;
            if (property == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "property", "org/jetbrains/kotlin/cfg/ControlFlowProcessor$CFPVisitor", "visitProperty"));
            }
            this.builder.declareVariable(property);
            KtExpression initializer2 = property.getInitializer();
            if (initializer2 != null) {
                this.visitAssignment(property, this.getDeferredValue(initializer2), property);
            }
            if ((delegate2 = property.getDelegateExpression()) != null) {
                this.visitAssignment(property, this.getDeferredValue(null), property);
                this.generateInstructions(delegate2);
                if (this.builder.getBoundValue(delegate2) != null) {
                    this.createSyntheticValue(property, MagicKind.VALUE_CONSUMER, delegate2);
                }
            }
            if (KtPsiUtil.isLocal(property)) {
                for (KtPropertyAccessor accessor : property.getAccessors()) {
                    this.generateInstructions(accessor);
                }
            }
        }

        @Override
        public void visitDestructuringDeclaration(@NotNull KtDestructuringDeclaration declaration) {
            if (declaration == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declaration", "org/jetbrains/kotlin/cfg/ControlFlowProcessor$CFPVisitor", "visitDestructuringDeclaration"));
            }
            this.visitDestructuringDeclaration(declaration, true);
        }

        @Override
        private void visitDestructuringDeclaration(@NotNull KtDestructuringDeclaration declaration, boolean generateWriteForEntries) {
            if (declaration == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declaration", "org/jetbrains/kotlin/cfg/ControlFlowProcessor$CFPVisitor", "visitDestructuringDeclaration"));
            }
            KtExpression initializer2 = declaration.getInitializer();
            this.generateInstructions(initializer2);
            for (KtDestructuringDeclarationEntry entry : declaration.getEntries()) {
                this.builder.declareVariable(entry);
                ResolvedCall<FunctionDescriptor> resolvedCall = ControlFlowProcessor.this.trace.get(BindingContext.COMPONENT_RESOLVED_CALL, entry);
                PseudoValue writtenValue = resolvedCall != null ? this.builder.call(entry, resolvedCall, this.getReceiverValues(resolvedCall), Collections.<PseudoValue, ValueParameterDescriptor>emptyMap()).getOutputValue() : this.createSyntheticValue(entry, MagicKind.UNRESOLVED_CALL, initializer2);
                if (!generateWriteForEntries) continue;
                this.generateInitializer(entry, writtenValue != null ? writtenValue : this.createSyntheticValue(entry, MagicKind.FAKE_INITIALIZER, new KtElement[0]));
            }
        }

        @Override
        public void visitPropertyAccessor(@NotNull KtPropertyAccessor accessor) {
            if (accessor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "accessor", "org/jetbrains/kotlin/cfg/ControlFlowProcessor$CFPVisitor", "visitPropertyAccessor"));
            }
            ControlFlowProcessor.this.processLocalDeclaration(accessor);
        }

        @Override
        public void visitBinaryWithTypeRHSExpression(@NotNull KtBinaryExpressionWithTypeRHS expression) {
            if (expression == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/cfg/ControlFlowProcessor$CFPVisitor", "visitBinaryWithTypeRHSExpression"));
            }
            this.mark(expression);
            IElementType operationType = expression.getOperationReference().getReferencedNameElementType();
            KtExpression left = expression.getLeft();
            if (operationType == KtTokens.AS_KEYWORD || operationType == KtTokens.AS_SAFE) {
                this.generateInstructions(left);
                if (this.getBoundOrUnreachableValue(left) != null) {
                    this.createNonSyntheticValue((KtElement)expression, MagicKind.CAST, left);
                }
            } else {
                this.visitKtElement(expression);
                this.createNonSyntheticValue((KtElement)expression, MagicKind.UNSUPPORTED_ELEMENT, left);
            }
        }

        @Override
        public void visitThrowExpression(@NotNull KtThrowExpression expression) {
            if (expression == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/cfg/ControlFlowProcessor$CFPVisitor", "visitThrowExpression"));
            }
            this.mark(expression);
            KtExpression thrownExpression = expression.getThrownExpression();
            if (thrownExpression == null) {
                return;
            }
            this.generateInstructions(thrownExpression);
            PseudoValue thrownValue = this.builder.getBoundValue(thrownExpression);
            if (thrownValue == null) {
                return;
            }
            this.builder.throwException(expression, thrownValue);
        }

        @Override
        public void visitArrayAccessExpression(@NotNull KtArrayAccessExpression expression) {
            if (expression == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/cfg/ControlFlowProcessor$CFPVisitor", "visitArrayAccessExpression"));
            }
            this.generateArrayAccess(expression, ControlFlowProcessor.this.trace.get(BindingContext.INDEXED_LVALUE_GET, expression));
        }

        @Override
        public void visitIsExpression(@NotNull KtIsExpression expression) {
            if (expression == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/cfg/ControlFlowProcessor$CFPVisitor", "visitIsExpression"));
            }
            this.mark(expression);
            KtExpression left = expression.getLeftHandSide();
            this.generateInstructions(left);
            this.createNonSyntheticValue((KtElement)expression, MagicKind.IS, left);
        }

        @Override
        public void visitWhenExpression(@NotNull KtWhenExpression expression) {
            if (expression == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/cfg/ControlFlowProcessor$CFPVisitor", "visitWhenExpression"));
            }
            this.mark(expression);
            KtExpression subjectExpression = expression.getSubjectExpression();
            if (subjectExpression != null) {
                this.generateInstructions(subjectExpression);
            }
            ArrayList<KtExpression> branches = new ArrayList<KtExpression>();
            Label doneLabel = this.builder.createUnboundLabel("after 'when' expression");
            Label nextLabel = null;
            Iterator<KtWhenEntry> iterator2 = expression.getEntries().iterator();
            while (iterator2.hasNext()) {
                KtWhenEntry whenEntry = iterator2.next();
                this.mark(whenEntry);
                boolean isElse = whenEntry.isElse();
                if (isElse && iterator2.hasNext()) {
                    ControlFlowProcessor.this.trace.report(Errors.ELSE_MISPLACED_IN_WHEN.on(whenEntry));
                }
                Label bodyLabel = this.builder.createUnboundLabel("'when' entry body");
                KtWhenCondition[] conditions = whenEntry.getConditions();
                for (int i = 0; i < conditions.length; ++i) {
                    KtWhenCondition condition = conditions[i];
                    condition.accept(this.conditionVisitor);
                    if (i + 1 >= conditions.length) continue;
                    this.builder.nondeterministicJump(bodyLabel, expression, this.builder.getBoundValue(condition));
                }
                if (!isElse) {
                    nextLabel = this.builder.createUnboundLabel("next 'when' entry");
                    KtWhenCondition lastCondition = ArraysKt.lastOrNull(conditions);
                    this.builder.nondeterministicJump(nextLabel, expression, this.builder.getBoundValue(lastCondition));
                }
                this.builder.bindLabel(bodyLabel);
                KtExpression whenEntryExpression = whenEntry.getExpression();
                if (whenEntryExpression != null) {
                    this.generateInstructions(whenEntryExpression);
                    branches.add(whenEntryExpression);
                }
                this.builder.jump(doneLabel, expression);
                if (isElse) continue;
                this.builder.bindLabel(nextLabel);
                if (iterator2.hasNext() || !WhenChecker.isWhenExhaustive(expression, ControlFlowProcessor.this.trace)) continue;
                this.builder.magic(expression, null, Collections.<PseudoValue>emptyList(), MagicKind.EXHAUSTIVE_WHEN_ELSE);
            }
            this.builder.bindLabel(doneLabel);
            this.mergeValues(branches, expression);
        }

        @Override
        public void visitObjectLiteralExpression(@NotNull KtObjectLiteralExpression expression) {
            if (expression == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/cfg/ControlFlowProcessor$CFPVisitor", "visitObjectLiteralExpression"));
            }
            this.mark(expression);
            KtObjectDeclaration declaration = expression.getObjectDeclaration();
            this.generateInstructions(declaration);
            this.builder.createAnonymousObject(expression);
        }

        @Override
        public void visitObjectDeclaration(@NotNull KtObjectDeclaration objectDeclaration) {
            if (objectDeclaration == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "objectDeclaration", "org/jetbrains/kotlin/cfg/ControlFlowProcessor$CFPVisitor", "visitObjectDeclaration"));
            }
            this.generateHeaderDelegationSpecifiers(objectDeclaration);
            this.generateInitializersForScriptClassOrObject(objectDeclaration);
            this.generateDeclarationForLocalClassOrObjectIfNeeded(objectDeclaration);
        }

        @Override
        public void visitStringTemplateExpression(@NotNull KtStringTemplateExpression expression) {
            if (expression == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/cfg/ControlFlowProcessor$CFPVisitor", "visitStringTemplateExpression"));
            }
            this.mark(expression);
            ArrayList<KtExpression> inputExpressions = new ArrayList<KtExpression>();
            for (KtStringTemplateEntry entry : expression.getEntries()) {
                if (!(entry instanceof KtStringTemplateEntryWithExpression)) continue;
                KtExpression entryExpression = entry.getExpression();
                this.generateInstructions(entryExpression);
                inputExpressions.add(entryExpression);
            }
            this.builder.loadStringTemplate(expression, this.elementsToValues(inputExpressions));
        }

        @Override
        public void visitTypeProjection(@NotNull KtTypeProjection typeProjection) {
            if (typeProjection == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeProjection", "org/jetbrains/kotlin/cfg/ControlFlowProcessor$CFPVisitor", "visitTypeProjection"));
            }
        }

        @Override
        public void visitAnonymousInitializer(@NotNull KtAnonymousInitializer classInitializer) {
            if (classInitializer == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classInitializer", "org/jetbrains/kotlin/cfg/ControlFlowProcessor$CFPVisitor", "visitAnonymousInitializer"));
            }
            this.generateInstructions(classInitializer.getBody());
        }

        private void generateHeaderDelegationSpecifiers(@NotNull KtClassOrObject classOrObject) {
            if (classOrObject == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classOrObject", "org/jetbrains/kotlin/cfg/ControlFlowProcessor$CFPVisitor", "generateHeaderDelegationSpecifiers"));
            }
            for (KtSuperTypeListEntry specifier : classOrObject.getSuperTypeListEntries()) {
                this.generateInstructions(specifier);
            }
        }

        private void generateInitializersForScriptClassOrObject(@NotNull KtDeclarationContainer classOrObject) {
            if (classOrObject == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classOrObject", "org/jetbrains/kotlin/cfg/ControlFlowProcessor$CFPVisitor", "generateInitializersForScriptClassOrObject"));
            }
            for (KtDeclaration declaration : classOrObject.getDeclarations()) {
                if (!(declaration instanceof KtProperty) && !(declaration instanceof KtAnonymousInitializer)) continue;
                this.generateInstructions(declaration);
            }
        }

        @Override
        public void visitClass(@NotNull KtClass klass) {
            if (klass == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "klass", "org/jetbrains/kotlin/cfg/ControlFlowProcessor$CFPVisitor", "visitClass"));
            }
            if (klass.hasPrimaryConstructor()) {
                this.processParameters(klass.getPrimaryConstructorParameters());
                this.generateHeaderDelegationSpecifiers(klass);
                this.generateInitializersForScriptClassOrObject(klass);
            }
            this.generateDeclarationForLocalClassOrObjectIfNeeded(klass);
        }

        @Override
        public void visitScript(@NotNull KtScript script) {
            if (script == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "script", "org/jetbrains/kotlin/cfg/ControlFlowProcessor$CFPVisitor", "visitScript"));
            }
            this.generateInitializersForScriptClassOrObject(script);
        }

        private void generateDeclarationForLocalClassOrObjectIfNeeded(@NotNull KtClassOrObject classOrObject) {
            if (classOrObject == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classOrObject", "org/jetbrains/kotlin/cfg/ControlFlowProcessor$CFPVisitor", "generateDeclarationForLocalClassOrObjectIfNeeded"));
            }
            if (classOrObject.isLocal()) {
                for (KtDeclaration declaration : classOrObject.getDeclarations()) {
                    if (declaration instanceof KtSecondaryConstructor || declaration instanceof KtProperty || declaration instanceof KtAnonymousInitializer) continue;
                    this.generateInstructions(declaration);
                }
            }
        }

        private void processParameters(@NotNull List<KtParameter> parameters2) {
            if (parameters2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "org/jetbrains/kotlin/cfg/ControlFlowProcessor$CFPVisitor", "processParameters"));
            }
            for (KtParameter parameter : parameters2) {
                this.generateInstructions(parameter);
            }
        }

        @Override
        public void visitSecondaryConstructor(@NotNull KtSecondaryConstructor constructor) {
            if (constructor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "constructor", "org/jetbrains/kotlin/cfg/ControlFlowProcessor$CFPVisitor", "visitSecondaryConstructor"));
            }
            KtClassOrObject classOrObject = PsiTreeUtil.getParentOfType((PsiElement)constructor, KtClassOrObject.class);
            assert (classOrObject != null) : "Guaranteed by parsing contract";
            this.processParameters(constructor.getValueParameters());
            this.generateCallOrMarkUnresolved(constructor.getDelegationCall());
            if (!constructor.getDelegationCall().isCallToThis()) {
                this.generateInitializersForScriptClassOrObject(classOrObject);
            }
            this.generateInstructions(constructor.getBodyExpression());
        }

        @Override
        public void visitSuperTypeCallEntry(@NotNull KtSuperTypeCallEntry call) {
            if (call == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "call", "org/jetbrains/kotlin/cfg/ControlFlowProcessor$CFPVisitor", "visitSuperTypeCallEntry"));
            }
            this.generateCallOrMarkUnresolved(call);
        }

        private void generateCallOrMarkUnresolved(@Nullable KtCallElement call) {
            if (call == null) {
                return;
            }
            if (!this.generateCall(call)) {
                List<KtExpression> arguments2 = CollectionsKt.map(call.getValueArguments(), new Function1<ValueArgument, KtExpression>(){

                    @Override
                    public KtExpression invoke(ValueArgument valueArgument) {
                        return valueArgument.getArgumentExpression();
                    }
                });
                for (KtExpression argument : arguments2) {
                    this.generateInstructions(argument);
                }
                this.createNonSyntheticValue((KtElement)call, arguments2, MagicKind.UNRESOLVED_CALL);
            }
        }

        @Override
        public void visitDelegatedSuperTypeEntry(@NotNull KtDelegatedSuperTypeEntry specifier) {
            if (specifier == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "specifier", "org/jetbrains/kotlin/cfg/ControlFlowProcessor$CFPVisitor", "visitDelegatedSuperTypeEntry"));
            }
            KtExpression delegateExpression = specifier.getDelegateExpression();
            this.generateInstructions(delegateExpression);
            this.createSyntheticValue(specifier, MagicKind.VALUE_CONSUMER, delegateExpression);
        }

        @Override
        public void visitSuperTypeEntry(@NotNull KtSuperTypeEntry specifier) {
            if (specifier == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "specifier", "org/jetbrains/kotlin/cfg/ControlFlowProcessor$CFPVisitor", "visitSuperTypeEntry"));
            }
        }

        @Override
        public void visitSuperTypeList(@NotNull KtSuperTypeList list2) {
            if (list2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "org/jetbrains/kotlin/cfg/ControlFlowProcessor$CFPVisitor", "visitSuperTypeList"));
            }
            list2.acceptChildren(this);
        }

        @Override
        public void visitKtFile(@NotNull KtFile file) {
            if (file == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/kotlin/cfg/ControlFlowProcessor$CFPVisitor", "visitKtFile"));
            }
            for (KtDeclaration declaration : file.getDeclarations()) {
                if (!(declaration instanceof KtProperty)) continue;
                this.generateInstructions(declaration);
            }
        }

        @Override
        public void visitDoubleColonExpression(@NotNull KtDoubleColonExpression expression) {
            if (expression == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/cfg/ControlFlowProcessor$CFPVisitor", "visitDoubleColonExpression"));
            }
            this.mark(expression);
            this.createNonSyntheticValue((KtElement)expression, MagicKind.CALLABLE_REFERENCE, new KtElement[0]);
        }

        @Override
        public void visitKtElement(@NotNull KtElement element) {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/kotlin/cfg/ControlFlowProcessor$CFPVisitor", "visitKtElement"));
            }
            this.createNonSyntheticValue(element, MagicKind.UNSUPPORTED_ELEMENT, new KtElement[0]);
        }

        private boolean generateCall(@Nullable KtElement callElement) {
            if (callElement == null) {
                return false;
            }
            return this.checkAndGenerateCall(CallUtilKt.getResolvedCall(callElement, ControlFlowProcessor.this.trace.getBindingContext()));
        }

        private boolean checkAndGenerateCall(@Nullable ResolvedCall<?> resolvedCall) {
            if (resolvedCall == null) {
                return false;
            }
            this.generateCall(resolvedCall);
            return true;
        }

        @NotNull
        private InstructionWithValue generateCall(@NotNull ResolvedCall<?> resolvedCall) {
            if (resolvedCall == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolvedCall", "org/jetbrains/kotlin/cfg/ControlFlowProcessor$CFPVisitor", "generateCall"));
            }
            KtElement callElement = resolvedCall.getCall().getCallElement();
            Map<PseudoValue, ReceiverValue> receivers = this.getReceiverValues(resolvedCall);
            SmartFMap<PseudoValue, ValueParameterDescriptor> parameterValues = SmartFMap.emptyMap();
            for (ValueArgument valueArgument : resolvedCall.getCall().getValueArguments()) {
                ArgumentMapping argumentMapping = resolvedCall.getArgumentMapping(valueArgument);
                KtExpression argumentExpression = valueArgument.getArgumentExpression();
                if (argumentMapping instanceof ArgumentMatch) {
                    parameterValues = this.generateValueArgument(valueArgument, ((ArgumentMatch)argumentMapping).getValueParameter(), parameterValues);
                    continue;
                }
                if (argumentExpression == null) continue;
                this.generateInstructions(argumentExpression);
                this.createSyntheticValue(argumentExpression, MagicKind.VALUE_CONSUMER, argumentExpression);
            }
            if (resolvedCall.getResultingDescriptor() instanceof VariableDescriptor) {
                KtExpression callExpression;
                KtExpression ktExpression = callExpression = callElement instanceof KtExpression ? (KtExpression)callElement : null;
                assert (callExpression != null) : "Variable-based call without callee expression: " + callElement.getText();
                assert (parameterValues.isEmpty()) : "Variable-based call with non-empty argument list: " + callElement.getText();
                ReadValueInstruction readValueInstruction = this.builder.readVariable(callExpression, resolvedCall, receivers);
                if (readValueInstruction == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/cfg/ControlFlowProcessor$CFPVisitor", "generateCall"));
                }
                return readValueInstruction;
            }
            this.mark(resolvedCall.getCall().getCallElement());
            CallInstruction callInstruction = this.builder.call(callElement, resolvedCall, receivers, parameterValues);
            if (callInstruction == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/cfg/ControlFlowProcessor$CFPVisitor", "generateCall"));
            }
            return callInstruction;
        }

        @NotNull
        private Map<PseudoValue, ReceiverValue> getReceiverValues(ResolvedCall<?> resolvedCall) {
            PseudoValue varCallResult = null;
            ReceiverValue explicitReceiver = null;
            if (resolvedCall instanceof VariableAsFunctionResolvedCall) {
                varCallResult = this.generateCall(((VariableAsFunctionResolvedCall)((Object)resolvedCall)).getVariableCall()).getOutputValue();
                ExplicitReceiverKind kind = resolvedCall.getExplicitReceiverKind();
                switch (kind) {
                    case DISPATCH_RECEIVER: {
                        explicitReceiver = resolvedCall.getDispatchReceiver();
                        break;
                    }
                    case EXTENSION_RECEIVER: 
                    case BOTH_RECEIVERS: {
                        explicitReceiver = (ReceiverValue)resolvedCall.getExtensionReceiver();
                    }
                }
            }
            SmartFMap<PseudoValue, ReceiverValue> receiverValues = SmartFMap.emptyMap();
            if (explicitReceiver != null && varCallResult != null) {
                receiverValues = receiverValues.plus(varCallResult, explicitReceiver);
            }
            KtElement callElement = resolvedCall.getCall().getCallElement();
            receiverValues = this.getReceiverValues(callElement, resolvedCall.getDispatchReceiver(), receiverValues);
            SmartFMap<PseudoValue, ReceiverValue> smartFMap = receiverValues = this.getReceiverValues(callElement, (ReceiverValue)resolvedCall.getExtensionReceiver(), receiverValues);
            if (smartFMap == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/cfg/ControlFlowProcessor$CFPVisitor", "getReceiverValues"));
            }
            return smartFMap;
        }

        @NotNull
        private SmartFMap<PseudoValue, ReceiverValue> getReceiverValues(KtElement callElement, @Nullable ReceiverValue receiver, SmartFMap<PseudoValue, ReceiverValue> receiverValues) {
            if (receiver == null || receiverValues.containsValue(receiver)) {
                SmartFMap<PseudoValue, ReceiverValue> smartFMap = receiverValues;
                if (smartFMap == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/cfg/ControlFlowProcessor$CFPVisitor", "getReceiverValues"));
                }
                return smartFMap;
            }
            if (receiver instanceof ImplicitReceiver) {
                receiverValues = receiverValues.plus(this.createSyntheticValue(callElement, MagicKind.IMPLICIT_RECEIVER, new KtElement[0]), receiver);
            } else if (receiver instanceof ExpressionReceiver) {
                PseudoValue receiverPseudoValue;
                KtExpression expression = ((ExpressionReceiver)receiver).getExpression();
                if (this.builder.getBoundValue(expression) == null) {
                    this.generateInstructions(expression);
                }
                if ((receiverPseudoValue = this.getBoundOrUnreachableValue(expression)) != null) {
                    receiverValues = receiverValues.plus(receiverPseudoValue, receiver);
                }
            } else if (!(receiver instanceof TransientReceiver)) {
                throw new IllegalArgumentException("Unknown receiver kind: " + receiver);
            }
            SmartFMap<PseudoValue, ReceiverValue> smartFMap = receiverValues;
            if (smartFMap == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/cfg/ControlFlowProcessor$CFPVisitor", "getReceiverValues"));
            }
            return smartFMap;
        }

        @NotNull
        private SmartFMap<PseudoValue, ValueParameterDescriptor> generateValueArgument(ValueArgument valueArgument, ValueParameterDescriptor parameterDescriptor, SmartFMap<PseudoValue, ValueParameterDescriptor> parameterValues) {
            KtExpression expression = valueArgument.getArgumentExpression();
            if (expression != null) {
                PseudoValue argValue;
                if (!valueArgument.isExternal()) {
                    this.generateInstructions(expression);
                }
                if ((argValue = this.getBoundOrUnreachableValue(expression)) != null) {
                    parameterValues = parameterValues.plus(argValue, parameterDescriptor);
                }
            }
            SmartFMap<PseudoValue, ValueParameterDescriptor> smartFMap = parameterValues;
            if (smartFMap == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/cfg/ControlFlowProcessor$CFPVisitor", "generateValueArgument"));
            }
            return smartFMap;
        }

        private class FinallyBlockGenerator {
            private final KtFinallySection finallyBlock;
            private Label startFinally = null;
            private Label finishFinally = null;

            private FinallyBlockGenerator(KtFinallySection block) {
                this.finallyBlock = block;
            }

            public void generate() {
                KtBlockExpression finalExpression = this.finallyBlock.getFinalExpression();
                if (finalExpression == null) {
                    return;
                }
                if (this.startFinally != null) {
                    assert (this.finishFinally != null);
                    CFPVisitor.this.builder.repeatPseudocode(this.startFinally, this.finishFinally);
                    return;
                }
                this.startFinally = CFPVisitor.this.builder.createUnboundLabel("start finally");
                CFPVisitor.this.builder.bindLabel(this.startFinally);
                CFPVisitor.this.generateInstructions(finalExpression);
                this.finishFinally = CFPVisitor.this.builder.createUnboundLabel("finish finally");
                CFPVisitor.this.builder.bindLabel(this.finishFinally);
            }
        }
    }
}

