/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve;

import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinFileFacade;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyAccessorDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyGetterDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationUseSiteTarget;
import org.jetbrains.kotlin.descriptors.annotations.Annotations;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.resolve.DeprecatedByAnnotation;
import org.jetbrains.kotlin.resolve.DeprecatedByOverridden;
import org.jetbrains.kotlin.resolve.Deprecation;
import org.jetbrains.kotlin.resolve.DeprecationLevelValue;

@Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=2, d1={"\u0000<\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0012\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002\u001a\f\u0010\t\u001a\u0004\u0018\u00010\n*\u00020\u0006\u001a$\u0010\u000b\u001a\u0004\u0018\u00010\f*\u00020\r2\n\b\u0002\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\b\b\u0002\u0010\u0010\u001a\u00020\u0011H\u0002\u001a\f\u0010\u0012\u001a\u0004\u0018\u00010\u0006*\u00020\r\u001a\u000e\u0010\u0013\u001a\u0004\u0018\u00010\u0014*\u00020\rH\u0002\u001a\n\u0010\u0015\u001a\u00020\u0011*\u00020\r\"\u0016\u0010\u0000\u001a\u00020\u00018\u0002X\u0083\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b\u0002\u0010\u0003\"\u000e\u0010\u0004\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"HIDDEN_ANNOTATION_FQ_NAME", "Lorg/jetbrains/kotlin/name/FqName;", "HIDDEN_ANNOTATION_FQ_NAME$annotations", "()V", "JAVA_DEPRECATED", "deprecationByOverridden", "Lorg/jetbrains/kotlin/resolve/Deprecation;", "root", "Lorg/jetbrains/kotlin/descriptors/CallableMemberDescriptor;", "deprecatedByOverriddenMessage", "", "getDeclaredDeprecatedAnnotation", "Lorg/jetbrains/kotlin/descriptors/annotations/AnnotationDescriptor;", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "target", "Lorg/jetbrains/kotlin/descriptors/annotations/AnnotationUseSiteTarget;", "findAnnotationsWithoutTarget", "", "getDeprecation", "getDeprecationByAnnotation", "Lorg/jetbrains/kotlin/resolve/DeprecatedByAnnotation;", "isHiddenInResolution", "kotlin-compiler"})
@KotlinFileFacade(version={1, 1, 0}, data={"\u0000<\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0012\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002\u001a\f\u0010\t\u001a\u0004\u0018\u00010\n*\u00020\u0006\u001a$\u0010\u000b\u001a\u0004\u0018\u00010\f*\u00020\r2\n\b\u0002\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\b\b\u0002\u0010\u0010\u001a\u00020\u0011H\u0002\u001a\f\u0010\u0012\u001a\u0004\u0018\u00010\u0006*\u00020\r\u001a\u000e\u0010\u0013\u001a\u0004\u0018\u00010\u0014*\u00020\rH\u0002\u001a\n\u0010\u0015\u001a\u00020\u0011*\u00020\r\"\u0016\u0010\u0000\u001a\u00020\u00018\u0002X\u0083\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b\u0002\u0010\u0003\"\u000e\u0010\u0004\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, strings={"HIDDEN_ANNOTATION_FQ_NAME", "Lorg/jetbrains/kotlin/name/FqName;", "HIDDEN_ANNOTATION_FQ_NAME$annotations", "()V", "JAVA_DEPRECATED", "deprecationByOverridden", "Lorg/jetbrains/kotlin/resolve/Deprecation;", "root", "Lorg/jetbrains/kotlin/descriptors/CallableMemberDescriptor;", "deprecatedByOverriddenMessage", "", "getDeclaredDeprecatedAnnotation", "Lorg/jetbrains/kotlin/descriptors/annotations/AnnotationDescriptor;", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "target", "Lorg/jetbrains/kotlin/descriptors/annotations/AnnotationUseSiteTarget;", "findAnnotationsWithoutTarget", "", "getDeprecation", "getDeprecationByAnnotation", "Lorg/jetbrains/kotlin/resolve/DeprecatedByAnnotation;", "isHiddenInResolution", "kotlin-compiler"})
public final class DeprecationUtilKt {
    private static final FqName JAVA_DEPRECATED = new FqName("java.lang.Deprecated");
    private static final FqName HIDDEN_ANNOTATION_FQ_NAME = new FqName("kotlin.HiddenDeclaration");

    @Nullable
    public static final String deprecatedByOverriddenMessage(Deprecation $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Deprecation deprecation = $receiver;
        if (!(deprecation instanceof DeprecatedByOverridden)) {
            deprecation = null;
        }
        DeprecatedByOverridden deprecatedByOverridden = (DeprecatedByOverridden)deprecation;
        return deprecatedByOverridden != null ? deprecatedByOverridden.additionalMessage$kotlin_compiler() : null;
    }

    @Nullable
    public static final Deprecation getDeprecation(DeclarationDescriptor $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        DeprecatedByAnnotation deprecation = DeprecationUtilKt.getDeprecationByAnnotation($receiver);
        if (deprecation != null) {
            return deprecation;
        }
        if ($receiver instanceof CallableMemberDescriptor) {
            return DeprecationUtilKt.deprecationByOverridden((CallableMemberDescriptor)$receiver);
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private static final Deprecation deprecationByOverridden(CallableMemberDescriptor root) {
        void hasUndeprecatedOverridden;
        HashSet visited2 = new HashSet();
        LinkedHashSet deprecations = new LinkedHashSet();
        Ref.BooleanRef booleanRef = new Ref.BooleanRef();
        booleanRef.element = false;
        Function1<CallableMemberDescriptor, Unit> traverse$ = new Function1<CallableMemberDescriptor, Unit>(visited2, deprecations, (Ref.BooleanRef)hasUndeprecatedOverridden){
            final /* synthetic */ HashSet $visited;
            final /* synthetic */ LinkedHashSet $deprecations;
            final /* synthetic */ Ref.BooleanRef $hasUndeprecatedOverridden;

            /*
             * WARNING - void declaration
             */
            public final void invoke(@NotNull CallableMemberDescriptor node) {
                Intrinsics.checkParameterIsNotNull(node, "node");
                if (this.$visited.contains(node)) {
                    return;
                }
                this.$visited.add(node);
                DeprecatedByAnnotation deprecatedAnnotation = DeprecationUtilKt.access$getDeprecationByAnnotation(node);
                Collection<? extends CallableMemberDescriptor> overriddenDescriptors = node.getOverriddenDescriptors();
                if (deprecatedAnnotation != null) {
                    this.$deprecations.add(deprecatedAnnotation);
                } else {
                    void $receiver$iv;
                    if (overriddenDescriptors.isEmpty()) {
                        this.$hasUndeprecatedOverridden.element = true;
                        return;
                    }
                    Iterable iterable = overriddenDescriptors;
                    for (T element$iv : $receiver$iv) {
                        CallableMemberDescriptor it;
                        CallableMemberDescriptor callableMemberDescriptor = it = (CallableMemberDescriptor)element$iv;
                        Intrinsics.checkExpressionValueIsNotNull(callableMemberDescriptor, "it");
                        this.invoke(callableMemberDescriptor);
                    }
                }
            }
            {
                this.$visited = hashSet;
                this.$deprecations = linkedHashSet;
                this.$hasUndeprecatedOverridden = booleanRef;
                super(1);
            }
        };
        traverse$.invoke(root);
        if (hasUndeprecatedOverridden.element || deprecations.isEmpty()) {
            return null;
        }
        return new DeprecatedByOverridden(deprecations);
    }

    private static final DeprecatedByAnnotation getDeprecationByAnnotation(DeclarationDescriptor $receiver) {
        AnnotationDescriptor ownAnnotation = DeprecationUtilKt.getDeclaredDeprecatedAnnotation$default($receiver, AnnotationUseSiteTarget.Companion.getAssociatedUseSiteTarget($receiver), false, 2, null);
        if (ownAnnotation != null) {
            return new DeprecatedByAnnotation(ownAnnotation, $receiver);
        }
        DeclarationDescriptor declarationDescriptor = $receiver;
        if (declarationDescriptor instanceof ConstructorDescriptor) {
            ClassDescriptor classDescriptor = ((ConstructorDescriptor)$receiver).getContainingDeclaration();
            AnnotationDescriptor classAnnotation = DeprecationUtilKt.getDeclaredDeprecatedAnnotation$default(classDescriptor, null, false, 3, null);
            if (classAnnotation != null) {
                DeclarationDescriptor declarationDescriptor2 = classDescriptor;
                Intrinsics.checkExpressionValueIsNotNull(declarationDescriptor2, "classDescriptor");
                return new DeprecatedByAnnotation(classAnnotation, declarationDescriptor2);
            }
        } else if (declarationDescriptor instanceof PropertyAccessorDescriptor) {
            AnnotationDescriptor classAnnotation;
            ClassDescriptor classDescriptor;
            AnnotationUseSiteTarget target;
            PropertyDescriptor propertyDescriptor = ((PropertyAccessorDescriptor)$receiver).getCorrespondingProperty();
            AnnotationDescriptor useSiteAnnotationOnProperty = DeprecationUtilKt.getDeclaredDeprecatedAnnotation(propertyDescriptor, target = $receiver instanceof PropertyGetterDescriptor ? AnnotationUseSiteTarget.PROPERTY_GETTER : AnnotationUseSiteTarget.PROPERTY_SETTER, false);
            if (useSiteAnnotationOnProperty != null) {
                return new DeprecatedByAnnotation(useSiteAnnotationOnProperty, $receiver);
            }
            AnnotationDescriptor propertyAnnotation = DeprecationUtilKt.getDeclaredDeprecatedAnnotation$default(propertyDescriptor, null, false, 3, null);
            if (propertyAnnotation != null) {
                DeclarationDescriptor declarationDescriptor3 = propertyDescriptor;
                Intrinsics.checkExpressionValueIsNotNull(declarationDescriptor3, "propertyDescriptor");
                return new DeprecatedByAnnotation(propertyAnnotation, declarationDescriptor3);
            }
            DeclarationDescriptor declarationDescriptor4 = ((PropertyAccessorDescriptor)$receiver).getContainingDeclaration();
            if (!(declarationDescriptor4 instanceof ClassDescriptor)) {
                declarationDescriptor4 = null;
            }
            if ((classDescriptor = (ClassDescriptor)declarationDescriptor4) != null && classDescriptor.isCompanionObject() && (classAnnotation = DeprecationUtilKt.getDeclaredDeprecatedAnnotation$default(classDescriptor, null, false, 3, null)) != null) {
                return new DeprecatedByAnnotation(classAnnotation, classDescriptor);
            }
        }
        return null;
    }

    private static final AnnotationDescriptor getDeclaredDeprecatedAnnotation(DeclarationDescriptor $receiver, AnnotationUseSiteTarget target, boolean findAnnotationsWithoutTarget) {
        if (findAnnotationsWithoutTarget) {
            AnnotationDescriptor annotations2;
            Annotations annotations3 = $receiver.getAnnotations();
            FqName fqName2 = KotlinBuiltIns.FQ_NAMES.deprecated;
            Intrinsics.checkExpressionValueIsNotNull(fqName2, "KotlinBuiltIns.FQ_NAMES.deprecated");
            AnnotationDescriptor annotationDescriptor = annotations3.findAnnotation(fqName2);
            if (annotationDescriptor == null) {
                annotationDescriptor = annotations2 = $receiver.getAnnotations().findAnnotation(JAVA_DEPRECATED);
            }
            if (annotations2 != null) {
                return annotations2;
            }
        }
        if (target != null) {
            Annotations annotations4 = $receiver.getAnnotations();
            Intrinsics.checkExpressionValueIsNotNull(annotations4, "annotations");
            FqName fqName3 = KotlinBuiltIns.FQ_NAMES.deprecated;
            Intrinsics.checkExpressionValueIsNotNull(fqName3, "KotlinBuiltIns.FQ_NAMES.deprecated");
            AnnotationDescriptor annotationDescriptor = Annotations.Companion.findUseSiteTargetedAnnotation(annotations4, target, fqName3);
            if (annotationDescriptor == null) {
                Annotations annotations5 = $receiver.getAnnotations();
                Intrinsics.checkExpressionValueIsNotNull(annotations5, "annotations");
                annotationDescriptor = Annotations.Companion.findUseSiteTargetedAnnotation(annotations5, target, JAVA_DEPRECATED);
            }
            return annotationDescriptor;
        }
        return null;
    }

    static /* bridge */ /* synthetic */ AnnotationDescriptor getDeclaredDeprecatedAnnotation$default(DeclarationDescriptor declarationDescriptor, AnnotationUseSiteTarget annotationUseSiteTarget, boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: getDeclaredDeprecatedAnnotation");
        }
        if ((n & 1) != 0) {
            annotationUseSiteTarget = null;
        }
        if ((n & 2) != 0) {
            bl = true;
        }
        return DeprecationUtilKt.getDeclaredDeprecatedAnnotation(declarationDescriptor, annotationUseSiteTarget, bl);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isHiddenInResolution(DeclarationDescriptor $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        if ($receiver instanceof FunctionDescriptor && ((FunctionDescriptor)$receiver).isHiddenToOvercomeSignatureClash()) {
            return true;
        }
        if ($receiver.getAnnotations().findAnnotation(HIDDEN_ANNOTATION_FQ_NAME) != null) return true;
        Deprecation deprecation = DeprecationUtilKt.getDeprecation($receiver);
        if (!Intrinsics.areEqual((Object)(deprecation != null ? deprecation.getDeprecationLevel() : null), (Object)DeprecationLevelValue.HIDDEN)) return false;
        return true;
    }

    @Nullable
    public static final /* synthetic */ DeprecatedByAnnotation access$getDeprecationByAnnotation(DeclarationDescriptor $receiver) {
        return DeprecationUtilKt.getDeprecationByAnnotation($receiver);
    }
}

