/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.load.java.descriptors;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinFileFacade;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.SourceElement;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.Annotations;
import org.jetbrains.kotlin.descriptors.impl.ValueParameterDescriptorImpl;
import org.jetbrains.kotlin.load.java.lazy.descriptors.LazyJavaStaticClassScope;
import org.jetbrains.kotlin.load.kotlin.JvmPackagePartSource;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.scopes.MemberScope;
import org.jetbrains.kotlin.serialization.deserialization.descriptors.DeserializedCallableMemberDescriptor;
import org.jetbrains.kotlin.serialization.deserialization.descriptors.PackagePartSource;
import org.jetbrains.kotlin.types.KotlinType;

@Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=2, d1={"\u00002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u001a0\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00020\u00042\u0006\u0010\u0007\u001a\u00020\b\u001a\f\u0010\t\u001a\u0004\u0018\u00010\n*\u00020\u000b\u001a\f\u0010\f\u001a\u0004\u0018\u00010\r*\u00020\u000e\u00a8\u0006\u000f"}, d2={"copyValueParameters", "", "Lorg/jetbrains/kotlin/descriptors/ValueParameterDescriptor;", "newValueParametersTypes", "", "Lorg/jetbrains/kotlin/types/KotlinType;", "oldValueParameters", "newOwner", "Lorg/jetbrains/kotlin/descriptors/CallableDescriptor;", "getImplClassNameForDeserialized", "Lorg/jetbrains/kotlin/name/Name;", "Lorg/jetbrains/kotlin/serialization/deserialization/descriptors/DeserializedCallableMemberDescriptor;", "getParentJavaStaticClassScope", "Lorg/jetbrains/kotlin/load/java/lazy/descriptors/LazyJavaStaticClassScope;", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "kotlin-compiler"})
@KotlinFileFacade(version={1, 1, 0}, data={"\u00002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u001a0\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00020\u00042\u0006\u0010\u0007\u001a\u00020\b\u001a\f\u0010\t\u001a\u0004\u0018\u00010\n*\u00020\u000b\u001a\f\u0010\f\u001a\u0004\u0018\u00010\r*\u00020\u000e\u00a8\u0006\u000f"}, strings={"copyValueParameters", "", "Lorg/jetbrains/kotlin/descriptors/ValueParameterDescriptor;", "newValueParametersTypes", "", "Lorg/jetbrains/kotlin/types/KotlinType;", "oldValueParameters", "newOwner", "Lorg/jetbrains/kotlin/descriptors/CallableDescriptor;", "getImplClassNameForDeserialized", "Lorg/jetbrains/kotlin/name/Name;", "Lorg/jetbrains/kotlin/serialization/deserialization/descriptors/DeserializedCallableMemberDescriptor;", "getParentJavaStaticClassScope", "Lorg/jetbrains/kotlin/load/java/lazy/descriptors/LazyJavaStaticClassScope;", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "kotlin-compiler"})
public final class UtilKt {
    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<ValueParameterDescriptor> copyValueParameters(@NotNull Collection<? extends KotlinType> newValueParametersTypes, @NotNull Collection<? extends ValueParameterDescriptor> oldValueParameters, @NotNull CallableDescriptor newOwner) {
        void destination$iv$iv;
        void $receiver$iv$iv;
        Unit unit;
        Intrinsics.checkParameterIsNotNull(newValueParametersTypes, "newValueParametersTypes");
        Intrinsics.checkParameterIsNotNull(oldValueParameters, "oldValueParameters");
        Intrinsics.checkParameterIsNotNull(newOwner, "newOwner");
        boolean value$iv = newValueParametersTypes.size() == oldValueParameters.size();
        if (_Assertions.ENABLED) {
            if (!value$iv) {
                String message$iv = "Different value parameters sizes: Enhanced = " + newValueParametersTypes.size() + ", Old = " + oldValueParameters.size();
                throw (Throwable)((Object)new AssertionError((Object)message$iv));
            }
            unit = Unit.INSTANCE;
        } else {
            unit = Unit.INSTANCE;
        }
        Iterable $receiver$iv = CollectionsKt.zip((Iterable)newValueParametersTypes, (Iterable)oldValueParameters);
        Iterable $i$a$1 = $receiver$iv;
        Collection message$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver$iv, 10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void newType;
            void oldParameter;
            void pair;
            Pair pair2 = (Pair)item$iv$iv;
            void var9_11 = destination$iv$iv;
            Object var10_12 = pair;
            KotlinType kotlinType = (KotlinType)var10_12.component1();
            ValueParameterDescriptor valueParameterDescriptor = (ValueParameterDescriptor)var10_12.component2();
            var10_12 = null;
            int n = oldParameter.getIndex();
            Annotations annotations2 = oldParameter.getAnnotations();
            Intrinsics.checkExpressionValueIsNotNull(annotations2, "oldParameter.annotations");
            Name name = oldParameter.getName();
            Intrinsics.checkExpressionValueIsNotNull(name, "oldParameter.name");
            boolean bl = oldParameter.declaresDefaultValue();
            boolean bl2 = oldParameter.isCrossinline();
            boolean bl3 = oldParameter.isNoinline();
            KotlinType kotlinType2 = oldParameter.getVarargElementType() != null ? DescriptorUtilsKt.getModule(newOwner).getBuiltIns().getArrayElementType((KotlinType)newType) : (KotlinType)null;
            SourceElement sourceElement = oldParameter.getSource();
            Intrinsics.checkExpressionValueIsNotNull(sourceElement, "oldParameter.source");
            ValueParameterDescriptorImpl valueParameterDescriptorImpl = new ValueParameterDescriptorImpl(newOwner, (ValueParameterDescriptor)oldParameter, n, annotations2, name, (KotlinType)newType, bl, bl2, bl3, kotlinType2, sourceElement);
            var9_11.add(valueParameterDescriptorImpl);
        }
        return (List)destination$iv$iv;
    }

    @Nullable
    public static final LazyJavaStaticClassScope getParentJavaStaticClassScope(ClassDescriptor $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        ClassDescriptor classDescriptor = DescriptorUtilsKt.getSuperClassNotAny($receiver);
        if (classDescriptor == null) {
            return null;
        }
        ClassDescriptor superClassDescriptor = classDescriptor;
        MemberScope staticScope = superClassDescriptor.getStaticScope();
        if (!(staticScope instanceof LazyJavaStaticClassScope)) {
            return UtilKt.getParentJavaStaticClassScope(superClassDescriptor);
        }
        return (LazyJavaStaticClassScope)staticScope;
    }

    @Nullable
    public static final Name getImplClassNameForDeserialized(DeserializedCallableMemberDescriptor $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        PackagePartSource packagePartSource = $receiver.getPackagePartSource();
        if (!(packagePartSource instanceof JvmPackagePartSource)) {
            packagePartSource = null;
        }
        JvmPackagePartSource jvmPackagePartSource = (JvmPackagePartSource)packagePartSource;
        return jvmPackagePartSource != null ? jvmPackagePartSource.getSimpleName() : null;
    }
}

