/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.translate.expression;

import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.MemberDescriptor;
import org.jetbrains.kotlin.js.translate.context.TranslationContext;
import org.jetbrains.kotlin.js.translate.context.UsageTracker;
import org.jetbrains.kotlin.js.translate.context.UsageTrackerKt;
import org.jetbrains.kotlin.js.translate.expression.FunctionTranslator;
import org.jetbrains.kotlin.js.translate.expression.LiteralFunctionTranslatorKt;
import org.jetbrains.kotlin.js.translate.general.AbstractTranslator;
import org.jetbrains.kotlin.js.translate.utils.BindingUtils;
import org.jetbrains.kotlin.js.translate.utils.FunctionBodyTranslator;
import org.jetbrains.kotlin.js.translate.utils.TranslationUtils;
import org.jetbrains.kotlin.psi.KtDeclarationWithBody;
import org.jetbrains.kotlin.relocated.com.google.dart.compiler.backend.js.ast.JsBlock;
import org.jetbrains.kotlin.relocated.com.google.dart.compiler.backend.js.ast.JsExpression;
import org.jetbrains.kotlin.relocated.com.google.dart.compiler.backend.js.ast.JsFunction;
import org.jetbrains.kotlin.relocated.com.google.dart.compiler.backend.js.ast.JsStatement;
import org.jetbrains.kotlin.relocated.com.google.dart.compiler.backend.js.ast.metadata.MetadataProperties;

@Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/js/translate/expression/LiteralFunctionTranslator;", "Lorg/jetbrains/kotlin/js/translate/general/AbstractTranslator;", "context", "Lorg/jetbrains/kotlin/js/translate/context/TranslationContext;", "(Lorg/jetbrains/kotlin/js/translate/context/TranslationContext;)V", "translate", "Lorg/jetbrains/kotlin/relocated/com/google/dart/compiler/backend/js/ast/JsExpression;", "declaration", "Lorg/jetbrains/kotlin/psi/KtDeclarationWithBody;", "kotlin-compiler"})
@KotlinClass(version={1, 1, 0}, data={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b\u00a8\u0006\t"}, strings={"Lorg/jetbrains/kotlin/js/translate/expression/LiteralFunctionTranslator;", "Lorg/jetbrains/kotlin/js/translate/general/AbstractTranslator;", "context", "Lorg/jetbrains/kotlin/js/translate/context/TranslationContext;", "(Lorg/jetbrains/kotlin/js/translate/context/TranslationContext;)V", "translate", "Lorg/jetbrains/kotlin/relocated/com/google/dart/compiler/backend/js/ast/JsExpression;", "declaration", "Lorg/jetbrains/kotlin/psi/KtDeclarationWithBody;", "kotlin-compiler"})
public final class LiteralFunctionTranslator
extends AbstractTranslator {
    @NotNull
    public final JsExpression translate(@NotNull KtDeclarationWithBody declaration) {
        Intrinsics.checkParameterIsNotNull(declaration, "declaration");
        TranslationContext invokingContext = this.context();
        FunctionDescriptor descriptor2 = BindingUtils.getFunctionDescriptor(invokingContext.bindingContext(), declaration);
        JsFunction lambda2 = invokingContext.getFunctionObject(descriptor2);
        TranslationContext functionContext = invokingContext.newFunctionBodyWithUsageTracker(lambda2, descriptor2);
        FunctionTranslator.addParameters(lambda2.getParameters(), descriptor2, functionContext);
        JsBlock functionBody = FunctionBodyTranslator.translateFunctionBody(descriptor2, declaration, functionContext);
        List<JsStatement> list2 = lambda2.getBody().getStatements();
        Collection collection = functionBody.getStatements();
        Intrinsics.checkExpressionValueIsNotNull(collection, "functionBody.statements");
        list2.addAll(collection);
        UsageTracker usageTracker = functionContext.usageTracker();
        if (usageTracker == null) {
            Intrinsics.throwNpe();
        }
        UsageTracker tracker = usageTracker;
        DeclarationDescriptor declarationDescriptor = descriptor2;
        Intrinsics.checkExpressionValueIsNotNull(declarationDescriptor, "descriptor");
        boolean isRecursive = UsageTrackerKt.isCaptured(tracker, declarationDescriptor);
        if (isRecursive) {
            DeclarationDescriptor declarationDescriptor2 = descriptor2;
            Intrinsics.checkExpressionValueIsNotNull(declarationDescriptor2, "descriptor");
            lambda2.setName(UsageTrackerKt.getNameForCapturedDescriptor(tracker, declarationDescriptor2));
        }
        if (UsageTrackerKt.hasCapturedExceptContaining(tracker)) {
            JsFunction lambdaCreator = TranslationUtils.simpleReturnFunction(invokingContext.scope(), lambda2);
            MetadataProperties.setLocal(lambdaCreator, true);
            TranslationContext translationContext = functionContext;
            Intrinsics.checkExpressionValueIsNotNull(translationContext, "functionContext");
            TranslationContext translationContext2 = invokingContext;
            Intrinsics.checkExpressionValueIsNotNull(translationContext2, "invokingContext");
            MemberDescriptor memberDescriptor = descriptor2;
            Intrinsics.checkExpressionValueIsNotNull(memberDescriptor, "descriptor");
            return LiteralFunctionTranslatorKt.withCapturedParameters(lambdaCreator, translationContext, translationContext2, memberDescriptor);
        }
        MetadataProperties.setLocal(lambda2, true);
        JsExpression jsExpression = invokingContext.define(descriptor2, lambda2);
        Intrinsics.checkExpressionValueIsNotNull(jsExpression, "invokingContext.define(descriptor, lambda)");
        return jsExpression;
    }

    public LiteralFunctionTranslator(@NotNull TranslationContext context) {
        Intrinsics.checkParameterIsNotNull(context, "context");
        super(context);
    }
}

