/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.inline.context;

import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.js.inline.FunctionReader;
import org.jetbrains.kotlin.js.inline.context.InliningContext;
import org.jetbrains.kotlin.js.inline.context.NamingContext;
import org.jetbrains.kotlin.js.inline.util.FunctionUtilsKt;
import org.jetbrains.kotlin.js.inline.util.InvocationUtilsKt;
import org.jetbrains.kotlin.js.inline.util.NamingUtilsKt;
import org.jetbrains.kotlin.relocated.com.google.dart.compiler.backend.js.ast.JsExpression;
import org.jetbrains.kotlin.relocated.com.google.dart.compiler.backend.js.ast.JsFunction;
import org.jetbrains.kotlin.relocated.com.google.dart.compiler.backend.js.ast.JsInvocation;
import org.jetbrains.kotlin.relocated.com.google.dart.compiler.backend.js.ast.JsName;
import org.jetbrains.kotlin.relocated.com.google.dart.compiler.backend.js.ast.JsNameRef;
import org.jetbrains.kotlin.relocated.com.google.dart.compiler.backend.js.ast.JsNode;
import org.jetbrains.kotlin.relocated.com.google.dart.compiler.backend.js.ast.JsParameter;
import org.jetbrains.kotlin.relocated.com.google.dart.compiler.backend.js.ast.JsScope;
import org.jetbrains.kotlin.relocated.com.google.dart.compiler.backend.js.ast.metadata.MetadataProperties;

@Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=1, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ \u0010\f\u001a\u00020\u00032\u0006\u0010\r\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u00032\u0006\u0010\u000f\u001a\u00020\u0003H\u0002J\u000e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\r\u001a\u00020\u000bJ\u0014\u0010\u0012\u001a\u00020\u00112\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014J\u000e\u0010\u0016\u001a\u00020\u00032\u0006\u0010\r\u001a\u00020\u000bJ\u0012\u0010\u0017\u001a\u0004\u0018\u00010\u00032\u0006\u0010\r\u001a\u00020\u000bH\u0002J\u0010\u0010\u0018\u001a\u00020\u00032\u0006\u0010\r\u001a\u00020\u000bH\u0002J\u0006\u0010\u0019\u001a\u00020\u001aJ\u000e\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\r\u001a\u00020\u000bJ\u0014\u0010\u001d\u001a\u0004\u0018\u00010\u00032\b\u0010\u001e\u001a\u0004\u0018\u00010\u001fH$R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\t\u001a\u0010\u0012\u0004\u0012\u00020\u000b\u0012\u0006\u0012\u0004\u0018\u00010\u00030\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lorg/jetbrains/kotlin/js/inline/context/FunctionContext;", "", "function", "Lorg/jetbrains/kotlin/relocated/com/google/dart/compiler/backend/js/ast/JsFunction;", "inliningContext", "Lorg/jetbrains/kotlin/js/inline/context/InliningContext;", "functionReader", "Lorg/jetbrains/kotlin/js/inline/FunctionReader;", "(Lcom/google/dart/compiler/backend/js/ast/JsFunction;Lorg/jetbrains/kotlin/js/inline/context/InliningContext;Lorg/jetbrains/kotlin/js/inline/FunctionReader;)V", "functionsWithClosure", "Ljava/util/IdentityHashMap;", "Lorg/jetbrains/kotlin/relocated/com/google/dart/compiler/backend/js/ast/JsInvocation;", "applyCapturedArgs", "call", "inner", "outer", "declareFunctionConstructorCall", "", "declareFunctionConstructorCalls", "arguments", "", "Lorg/jetbrains/kotlin/relocated/com/google/dart/compiler/backend/js/ast/JsExpression;", "getFunctionDefinition", "getFunctionDefinitionImpl", "getFunctionWithClosure", "getScope", "Lorg/jetbrains/kotlin/relocated/com/google/dart/compiler/backend/js/ast/JsScope;", "hasFunctionDefinition", "", "lookUpStaticFunction", "functionName", "Lorg/jetbrains/kotlin/relocated/com/google/dart/compiler/backend/js/ast/JsName;", "kotlin-compiler"})
@KotlinClass(version={1, 1, 0}, data={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ \u0010\f\u001a\u00020\u00032\u0006\u0010\r\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u00032\u0006\u0010\u000f\u001a\u00020\u0003H\u0002J\u000e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\r\u001a\u00020\u000bJ\u0014\u0010\u0012\u001a\u00020\u00112\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014J\u000e\u0010\u0016\u001a\u00020\u00032\u0006\u0010\r\u001a\u00020\u000bJ\u0012\u0010\u0017\u001a\u0004\u0018\u00010\u00032\u0006\u0010\r\u001a\u00020\u000bH\u0002J\u0010\u0010\u0018\u001a\u00020\u00032\u0006\u0010\r\u001a\u00020\u000bH\u0002J\u0006\u0010\u0019\u001a\u00020\u001aJ\u000e\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\r\u001a\u00020\u000bJ\u0014\u0010\u001d\u001a\u0004\u0018\u00010\u00032\b\u0010\u001e\u001a\u0004\u0018\u00010\u001fH$R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\t\u001a\u0010\u0012\u0004\u0012\u00020\u000b\u0012\u0006\u0012\u0004\u0018\u00010\u00030\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, strings={"Lorg/jetbrains/kotlin/js/inline/context/FunctionContext;", "", "function", "Lorg/jetbrains/kotlin/relocated/com/google/dart/compiler/backend/js/ast/JsFunction;", "inliningContext", "Lorg/jetbrains/kotlin/js/inline/context/InliningContext;", "functionReader", "Lorg/jetbrains/kotlin/js/inline/FunctionReader;", "(Lcom/google/dart/compiler/backend/js/ast/JsFunction;Lorg/jetbrains/kotlin/js/inline/context/InliningContext;Lorg/jetbrains/kotlin/js/inline/FunctionReader;)V", "functionsWithClosure", "Ljava/util/IdentityHashMap;", "Lorg/jetbrains/kotlin/relocated/com/google/dart/compiler/backend/js/ast/JsInvocation;", "applyCapturedArgs", "call", "inner", "outer", "declareFunctionConstructorCall", "", "declareFunctionConstructorCalls", "arguments", "", "Lorg/jetbrains/kotlin/relocated/com/google/dart/compiler/backend/js/ast/JsExpression;", "getFunctionDefinition", "getFunctionDefinitionImpl", "getFunctionWithClosure", "getScope", "Lorg/jetbrains/kotlin/relocated/com/google/dart/compiler/backend/js/ast/JsScope;", "hasFunctionDefinition", "", "lookUpStaticFunction", "functionName", "Lorg/jetbrains/kotlin/relocated/com/google/dart/compiler/backend/js/ast/JsName;", "kotlin-compiler"})
public abstract class FunctionContext {
    private final IdentityHashMap<JsInvocation, JsFunction> functionsWithClosure;
    private final JsFunction function;
    private final InliningContext inliningContext;
    private final FunctionReader functionReader;

    @Nullable
    protected abstract JsFunction lookUpStaticFunction(@Nullable JsName var1);

    @NotNull
    public final JsFunction getFunctionDefinition(@NotNull JsInvocation call) {
        Intrinsics.checkParameterIsNotNull(call, "call");
        JsFunction jsFunction = this.getFunctionDefinitionImpl(call);
        if (jsFunction == null) {
            Intrinsics.throwNpe();
        }
        return jsFunction;
    }

    public final boolean hasFunctionDefinition(@NotNull JsInvocation call) {
        Intrinsics.checkParameterIsNotNull(call, "call");
        return this.getFunctionDefinitionImpl(call) != null;
    }

    @NotNull
    public final JsScope getScope() {
        JsScope jsScope = this.function.getScope();
        Intrinsics.checkExpressionValueIsNotNull(jsScope, "function.scope");
        return jsScope;
    }

    public final void declareFunctionConstructorCalls(@NotNull List<? extends JsExpression> arguments2) {
        Intrinsics.checkParameterIsNotNull(arguments2, "arguments");
        List<JsInvocation> calls = ContainerUtil.findAll((Collection)arguments2, JsInvocation.class);
        Iterator<JsInvocation> iterator2 = calls.iterator();
        while (iterator2.hasNext()) {
            JsNode functionCalled;
            JsNode staticRef;
            JsInvocation call;
            JsInvocation jsInvocation = call = iterator2.next();
            Intrinsics.checkExpressionValueIsNotNull(jsInvocation, "call");
            JsName callName = InvocationUtilsKt.getSimpleName(jsInvocation);
            if (callName == null || !((staticRef = MetadataProperties.getStaticRef(callName)) instanceof JsFunction) || !FunctionUtilsKt.isFunctionCreator((JsFunction)(functionCalled = staticRef))) continue;
            JsInvocation jsInvocation2 = call;
            Intrinsics.checkExpressionValueIsNotNull(jsInvocation2, "call");
            this.declareFunctionConstructorCall(jsInvocation2);
        }
    }

    public final void declareFunctionConstructorCall(@NotNull JsInvocation call) {
        Intrinsics.checkParameterIsNotNull(call, "call");
        this.functionsWithClosure.put(call, null);
    }

    private final JsFunction getFunctionDefinitionImpl(JsInvocation call) {
        JsNode qualifier2;
        Unit unit;
        JsNode jsNode;
        CallableDescriptor descriptor2 = MetadataProperties.getDescriptor(call);
        if (descriptor2 != null && this.functionReader.contains(descriptor2)) {
            return this.functionReader.get(descriptor2);
        }
        JsExpression jsExpression = call.getQualifier();
        Intrinsics.checkExpressionValueIsNotNull(jsExpression, "call.qualifier");
        JsNode callQualifier = jsExpression;
        if (InvocationUtilsKt.isCallInvocation(call)) {
            JsNode jsNode2 = callQualifier;
            if (jsNode2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type com.google.dart.compiler.backend.js.ast.JsNameRef");
            }
            JsExpression jsExpression2 = ((JsNameRef)jsNode2).getQualifier();
            if (jsExpression2 == null) {
                Intrinsics.throwNpe();
            }
            callQualifier = jsExpression2;
        }
        if (callQualifier instanceof JsNameRef) {
            JsNode jsNode3;
            JsName jsName = ((JsNameRef)callQualifier).getName();
            JsNode staticRef = jsName != null ? MetadataProperties.getStaticRef(jsName) : null;
            jsNode = staticRef;
            if (jsNode instanceof JsNameRef) {
                JsNode jsNode4 = staticRef;
                if (jsNode4 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type com.google.dart.compiler.backend.js.ast.JsNode");
                }
                jsNode3 = jsNode4;
            } else if (jsNode instanceof JsInvocation) {
                JsNode jsNode5 = staticRef;
                if (jsNode5 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type com.google.dart.compiler.backend.js.ast.JsNode");
                }
                jsNode3 = jsNode5;
            } else if (jsNode instanceof JsFunction || Intrinsics.areEqual(jsNode, null)) {
                jsNode3 = callQualifier;
            } else {
                throw (Throwable)((Object)new AssertionError((Object)("Unexpected static reference type " + staticRef.getClass())));
            }
            callQualifier = jsNode3;
            unit = Unit.INSTANCE;
        } else {
            unit = Unit.INSTANCE;
        }
        jsNode = qualifier2 = callQualifier;
        return jsNode instanceof JsInvocation ? this.getFunctionWithClosure((JsInvocation)qualifier2) : (jsNode instanceof JsNameRef ? this.lookUpStaticFunction(((JsNameRef)qualifier2).getName()) : (JsFunction)null);
    }

    private final JsFunction getFunctionWithClosure(JsInvocation call) {
        JsFunction constructed = this.functionsWithClosure.get(call);
        if (constructed instanceof JsFunction) {
            return constructed;
        }
        JsName jsName = InvocationUtilsKt.getSimpleName(call);
        if (jsName == null) {
            Intrinsics.throwNpe();
        }
        JsName name = jsName;
        JsFunction jsFunction = this.lookUpStaticFunction(name);
        if (jsFunction == null) {
            Intrinsics.throwNpe();
        }
        JsFunction closureCreator = jsFunction;
        JsFunction jsFunction2 = FunctionUtilsKt.getInnerFunction(closureCreator);
        if (jsFunction2 == null) {
            Intrinsics.throwNpe();
        }
        JsFunction innerFunction = jsFunction2;
        JsFunction withCapturedArgs = this.applyCapturedArgs(call, innerFunction, closureCreator);
        this.functionsWithClosure.put(call, withCapturedArgs);
        return withCapturedArgs;
    }

    private final JsFunction applyCapturedArgs(JsInvocation call, JsFunction inner, JsFunction outer) {
        JsFunction innerClone = inner.deepCopy();
        NamingContext namingContext = this.inliningContext.newNamingContext();
        List<JsExpression> arguments2 = call.getArguments();
        List<JsParameter> parameters2 = outer.getParameters();
        List<JsExpression> list2 = arguments2;
        Intrinsics.checkExpressionValueIsNotNull(list2, "arguments");
        List<JsParameter> list3 = parameters2;
        Intrinsics.checkExpressionValueIsNotNull(list3, "parameters");
        NamingUtilsKt.aliasArgumentsIfNeeded(namingContext, list2, list3);
        JsNode jsNode = innerClone;
        Intrinsics.checkExpressionValueIsNotNull(jsNode, "innerClone");
        namingContext.applyRenameTo(jsNode);
        JsFunction jsFunction = innerClone;
        Intrinsics.checkExpressionValueIsNotNull(jsFunction, "innerClone");
        return jsFunction;
    }

    public FunctionContext(@NotNull JsFunction function, @NotNull InliningContext inliningContext, @NotNull FunctionReader functionReader) {
        Intrinsics.checkParameterIsNotNull(function, "function");
        Intrinsics.checkParameterIsNotNull(inliningContext, "inliningContext");
        Intrinsics.checkParameterIsNotNull(functionReader, "functionReader");
        this.function = function;
        this.inliningContext = inliningContext;
        this.functionReader = functionReader;
        this.functionsWithClosure = new IdentityHashMap();
    }
}

