/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.cli.jvm.compiler;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.JarUtil;
import java.io.File;
import java.io.PrintStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.jar.Attributes;
import kotlin.ExceptionsKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analyzer.AnalysisResult;
import org.jetbrains.kotlin.asJava.FilteredJvmDiagnostics;
import org.jetbrains.kotlin.backend.common.output.OutputFileCollection;
import org.jetbrains.kotlin.cli.common.CLIConfigurationKeys;
import org.jetbrains.kotlin.cli.common.CompilerPlugin;
import org.jetbrains.kotlin.cli.common.CompilerPluginContext;
import org.jetbrains.kotlin.cli.common.ExitCode;
import org.jetbrains.kotlin.cli.common.messages.AnalyzerWithCompilerReport;
import org.jetbrains.kotlin.cli.common.messages.CompilerMessageLocation;
import org.jetbrains.kotlin.cli.common.messages.CompilerMessageSeverity;
import org.jetbrains.kotlin.cli.common.messages.MessageCollector;
import org.jetbrains.kotlin.cli.common.messages.MessageUtil;
import org.jetbrains.kotlin.cli.common.output.outputUtils.OutputUtilsKt;
import org.jetbrains.kotlin.cli.jvm.K2JVMCompiler;
import org.jetbrains.kotlin.cli.jvm.compiler.CliLightClassGenerationSupport;
import org.jetbrains.kotlin.cli.jvm.compiler.CompileEnvironmentUtil;
import org.jetbrains.kotlin.cli.jvm.compiler.JvmPackagePartProvider;
import org.jetbrains.kotlin.cli.jvm.compiler.KotlinCoreEnvironment;
import org.jetbrains.kotlin.cli.jvm.compiler.KotlinToJVMBytecodeCompiler;
import org.jetbrains.kotlin.cli.jvm.config.JVMConfigurationKeys;
import org.jetbrains.kotlin.cli.jvm.config.JvmContentRootsKt;
import org.jetbrains.kotlin.cli.jvm.config.ModuleNameKt;
import org.jetbrains.kotlin.codegen.ClassBuilderFactories;
import org.jetbrains.kotlin.codegen.ClassBuilderFactory;
import org.jetbrains.kotlin.codegen.ClassFileFactory;
import org.jetbrains.kotlin.codegen.CompilationErrorHandler;
import org.jetbrains.kotlin.codegen.GeneratedClassLoader;
import org.jetbrains.kotlin.codegen.KotlinCodegenFacade;
import org.jetbrains.kotlin.codegen.state.GenerationState;
import org.jetbrains.kotlin.config.CompilerConfiguration;
import org.jetbrains.kotlin.config.ContentRootsKt;
import org.jetbrains.kotlin.context.MutableModuleContext;
import org.jetbrains.kotlin.fileClasses.JvmFileClassUtil;
import org.jetbrains.kotlin.idea.MainFunctionDetector;
import org.jetbrains.kotlin.load.kotlin.ModuleVisibilityManager;
import org.jetbrains.kotlin.load.kotlin.incremental.components.IncrementalCache;
import org.jetbrains.kotlin.load.kotlin.incremental.components.IncrementalCompilationComponents;
import org.jetbrains.kotlin.modules.JavaRootPath;
import org.jetbrains.kotlin.modules.Module;
import org.jetbrains.kotlin.modules.TargetId;
import org.jetbrains.kotlin.modules.TargetIdKt;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.FqNamesUtilKt;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.progress.ProgressIndicatorAndCompilationCanceledStatus;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtPackageDirective;
import org.jetbrains.kotlin.psi.KtScript;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.diagnostics.Diagnostics;
import org.jetbrains.kotlin.resolve.jvm.JvmClassName;
import org.jetbrains.kotlin.resolve.jvm.TopDownAnalyzerFacadeForJVM;
import org.jetbrains.kotlin.util.PerformanceCounter;
import org.jetbrains.kotlin.utils.KotlinPaths;

@Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=1, d1={"\u0000\u0094\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0002J\u0010\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0005\u001a\u00020\u0006J\u001e\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0005\u001a\u00020\u00062\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eH\u0002J,\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0005\u001a\u00020\u00062\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\b0\u0017J8\u0010\u0018\u001a\u00020\f2\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\u001a2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\b0\u00172\u0006\u0010\u001d\u001a\u00020\fJL\u0010\u001e\u001a\u00020\f2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0012\u001a\u00020\u00132\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020 0\u00172\u0006\u0010!\u001a\u00020\u001a2\b\u0010\"\u001a\u0004\u0018\u00010\u001a2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\b0\u00172\u0006\u0010#\u001a\u00020\fJ$\u0010$\u001a\b\u0012\u0002\b\u0003\u0018\u00010%2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0005\u001a\u00020\u0006J$\u0010&\u001a\u00020\u00132\u0006\u0010'\u001a\u00020\u00132\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020 0\u00172\u0006\u0010!\u001a\u00020\u001aJ \u0010(\u001a\u0004\u0018\u00010)2\u0006\u0010*\u001a\u00020\n2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0017H\u0002JD\u0010+\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010,\u001a\u00020\u00042\f\u0010-\u001a\b\u0012\u0004\u0012\u00020\u000f0\u00172\b\u0010.\u001a\u0004\u0018\u00010 2\b\u0010/\u001a\u0004\u0018\u00010\u001a2\b\u00100\u001a\u0004\u0018\u00010\bH\u0002J\u001e\u00101\u001a\b\u0012\u0004\u0012\u00020\b0\u00172\u0006\u0010!\u001a\u00020\u001a2\u0006\u0010.\u001a\u00020 H\u0002J\u0018\u00102\u001a\u0006\u0012\u0002\b\u0003032\n\u00104\u001a\u0006\u0012\u0002\b\u00030%H\u0002J\u0010\u00105\u001a\u0002062\u0006\u00107\u001a\u000208H\u0002J\u001e\u00109\u001a\u0002062\u0006\u0010:\u001a\u00020;2\f\u0010<\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0017H\u0002J>\u0010=\u001a\u0002062\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010>\u001a\u00020?2\b\u0010\u001b\u001a\u0004\u0018\u00010\u001a2\b\u0010\"\u001a\u0004\u0018\u00010\u001a2\u0006\u0010#\u001a\u00020\f2\b\u0010@\u001a\u0004\u0018\u00010)H\u0002J\n\u0010:\u001a\u00020;*\u00020\u0006\u00a8\u0006A"}, d2={"Lorg/jetbrains/kotlin/cli/jvm/compiler/KotlinToJVMBytecodeCompiler;", "", "()V", "analyze", "Lorg/jetbrains/kotlin/analyzer/AnalysisResult;", "environment", "Lorg/jetbrains/kotlin/cli/jvm/compiler/KotlinCoreEnvironment;", "targetDescription", "", "analyzeAndGenerate", "Lorg/jetbrains/kotlin/codegen/state/GenerationState;", "checkKotlinPackageUsage", "", "files", "", "Lorg/jetbrains/kotlin/psi/KtFile;", "compileAndExecuteScript", "Lorg/jetbrains/kotlin/cli/common/ExitCode;", "configuration", "Lorg/jetbrains/kotlin/config/CompilerConfiguration;", "paths", "Lorg/jetbrains/kotlin/utils/KotlinPaths;", "scriptArgs", "", "compileBunchOfSources", "jar", "Ljava/io/File;", "outputDir", "friendPaths", "includeRuntime", "compileModules", "chunk", "Lorg/jetbrains/kotlin/modules/Module;", "directory", "jarPath", "jarRuntime", "compileScript", "Ljava/lang/Class;", "createCompilerConfiguration", "base", "findMainClass", "Lorg/jetbrains/kotlin/name/FqName;", "generationState", "generate", "result", "sourceFiles", "module", "outputDirectory", "moduleName", "getAbsolutePaths", "getScriptConstructor", "Ljava/lang/reflect/Constructor;", "scriptClass", "reportExceptionFromScript", "", "exception", "", "reportRuntimeConflicts", "messageCollector", "Lorg/jetbrains/kotlin/cli/common/messages/MessageCollector;", "jvmClasspathRoots", "writeOutput", "outputFiles", "Lorg/jetbrains/kotlin/codegen/ClassFileFactory;", "mainClass", "kotlin-compiler"})
@KotlinClass(version={1, 1, 0}, data={"\u0000\u0094\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0002J\u0010\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0005\u001a\u00020\u0006J\u001e\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0005\u001a\u00020\u00062\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eH\u0002J,\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0005\u001a\u00020\u00062\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\b0\u0017J8\u0010\u0018\u001a\u00020\f2\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\u001a2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\b0\u00172\u0006\u0010\u001d\u001a\u00020\fJL\u0010\u001e\u001a\u00020\f2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0012\u001a\u00020\u00132\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020 0\u00172\u0006\u0010!\u001a\u00020\u001a2\b\u0010\"\u001a\u0004\u0018\u00010\u001a2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\b0\u00172\u0006\u0010#\u001a\u00020\fJ$\u0010$\u001a\b\u0012\u0002\b\u0003\u0018\u00010%2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0005\u001a\u00020\u0006J$\u0010&\u001a\u00020\u00132\u0006\u0010'\u001a\u00020\u00132\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020 0\u00172\u0006\u0010!\u001a\u00020\u001aJ \u0010(\u001a\u0004\u0018\u00010)2\u0006\u0010*\u001a\u00020\n2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0017H\u0002JD\u0010+\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010,\u001a\u00020\u00042\f\u0010-\u001a\b\u0012\u0004\u0012\u00020\u000f0\u00172\b\u0010.\u001a\u0004\u0018\u00010 2\b\u0010/\u001a\u0004\u0018\u00010\u001a2\b\u00100\u001a\u0004\u0018\u00010\bH\u0002J\u001e\u00101\u001a\b\u0012\u0004\u0012\u00020\b0\u00172\u0006\u0010!\u001a\u00020\u001a2\u0006\u0010.\u001a\u00020 H\u0002J\u0018\u00102\u001a\u0006\u0012\u0002\b\u0003032\n\u00104\u001a\u0006\u0012\u0002\b\u00030%H\u0002J\u0010\u00105\u001a\u0002062\u0006\u00107\u001a\u000208H\u0002J\u001e\u00109\u001a\u0002062\u0006\u0010:\u001a\u00020;2\f\u0010<\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0017H\u0002J>\u0010=\u001a\u0002062\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010>\u001a\u00020?2\b\u0010\u001b\u001a\u0004\u0018\u00010\u001a2\b\u0010\"\u001a\u0004\u0018\u00010\u001a2\u0006\u0010#\u001a\u00020\f2\b\u0010@\u001a\u0004\u0018\u00010)H\u0002J\n\u0010:\u001a\u00020;*\u00020\u0006\u00a8\u0006A"}, strings={"Lorg/jetbrains/kotlin/cli/jvm/compiler/KotlinToJVMBytecodeCompiler;", "", "()V", "analyze", "Lorg/jetbrains/kotlin/analyzer/AnalysisResult;", "environment", "Lorg/jetbrains/kotlin/cli/jvm/compiler/KotlinCoreEnvironment;", "targetDescription", "", "analyzeAndGenerate", "Lorg/jetbrains/kotlin/codegen/state/GenerationState;", "checkKotlinPackageUsage", "", "files", "", "Lorg/jetbrains/kotlin/psi/KtFile;", "compileAndExecuteScript", "Lorg/jetbrains/kotlin/cli/common/ExitCode;", "configuration", "Lorg/jetbrains/kotlin/config/CompilerConfiguration;", "paths", "Lorg/jetbrains/kotlin/utils/KotlinPaths;", "scriptArgs", "", "compileBunchOfSources", "jar", "Ljava/io/File;", "outputDir", "friendPaths", "includeRuntime", "compileModules", "chunk", "Lorg/jetbrains/kotlin/modules/Module;", "directory", "jarPath", "jarRuntime", "compileScript", "Ljava/lang/Class;", "createCompilerConfiguration", "base", "findMainClass", "Lorg/jetbrains/kotlin/name/FqName;", "generationState", "generate", "result", "sourceFiles", "module", "outputDirectory", "moduleName", "getAbsolutePaths", "getScriptConstructor", "Ljava/lang/reflect/Constructor;", "scriptClass", "reportExceptionFromScript", "", "exception", "", "reportRuntimeConflicts", "messageCollector", "Lorg/jetbrains/kotlin/cli/common/messages/MessageCollector;", "jvmClasspathRoots", "writeOutput", "outputFiles", "Lorg/jetbrains/kotlin/codegen/ClassFileFactory;", "mainClass", "kotlin-compiler"})
public final class KotlinToJVMBytecodeCompiler {
    public static final KotlinToJVMBytecodeCompiler INSTANCE;

    /*
     * WARNING - void declaration
     */
    private final List<String> getAbsolutePaths(File directory, Module module) {
        void destination$iv$iv;
        void $receiver$iv$iv;
        Iterable $receiver$iv = module.getSourceFiles();
        Iterable iterable = $receiver$iv;
        Collection collection = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver$iv, 10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void sourceFile;
            String string = (String)item$iv$iv;
            void var9_9 = destination$iv$iv;
            File source = new File((String)sourceFile);
            if (!source.isAbsolute()) {
                source = new File(directory, (String)sourceFile);
            }
            String string2 = source.getAbsolutePath();
            var9_9.add(string2);
        }
        return (List)destination$iv$iv;
    }

    private final void writeOutput(CompilerConfiguration configuration, ClassFileFactory outputFiles, File outputDir, File jarPath, boolean jarRuntime, FqName mainClass) {
        if (jarPath != null) {
            CompileEnvironmentUtil.writeToJar(jarPath, jarRuntime, mainClass, outputFiles);
        } else {
            MessageCollector messageCollector = configuration.get(CLIConfigurationKeys.MESSAGE_COLLECTOR_KEY, MessageCollector.NONE);
            OutputFileCollection outputFileCollection = outputFiles;
            File file = outputDir;
            if (file == null) {
                file = new File(".");
            }
            MessageCollector messageCollector2 = messageCollector;
            Intrinsics.checkExpressionValueIsNotNull(messageCollector2, "messageCollector");
            OutputUtilsKt.writeAll(outputFileCollection, file, messageCollector2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean compileModules(@NotNull KotlinCoreEnvironment environment2, @NotNull CompilerConfiguration configuration, @NotNull List<? extends Module> chunk, @NotNull File directory, @Nullable File jarPath, @NotNull List<String> friendPaths, boolean jarRuntime) {
        Intrinsics.checkParameterIsNotNull(environment2, "environment");
        Intrinsics.checkParameterIsNotNull(configuration, "configuration");
        Intrinsics.checkParameterIsNotNull(chunk, "chunk");
        Intrinsics.checkParameterIsNotNull(directory, "directory");
        Intrinsics.checkParameterIsNotNull(friendPaths, "friendPaths");
        HashMap<Module, ClassFileFactory> outputFiles = MapsKt.hashMapOf(new Pair[0]);
        ProgressIndicatorAndCompilationCanceledStatus.checkCanceled();
        ModuleVisibilityManager moduleVisibilityManager = ModuleVisibilityManager.SERVICE.getInstance(environment2.getProject());
        for (Module module : chunk) {
            moduleVisibilityManager.addModule(module);
        }
        for (String string : friendPaths) {
            moduleVisibilityManager.addFriendPath(string);
        }
        String string = "in targets [" + CollectionsKt.joinToString$default(chunk, null, null, null, 0, null, compileModules.targetDescription.1.INSTANCE, 31, null) + "]";
        AnalysisResult analysisResult = this.analyze(environment2, string);
        if (analysisResult == null) {
            return false;
        }
        AnalysisResult result2 = analysisResult;
        ProgressIndicatorAndCompilationCanceledStatus.checkCanceled();
        result2.throwIfError();
        ArrayList<GenerationState> generationStates = new ArrayList<GenerationState>();
        for (Module module : chunk) {
            ProgressIndicatorAndCompilationCanceledStatus.checkCanceled();
            List<KtFile> ktFiles2 = CompileEnvironmentUtil.getKtFiles(environment2.getProject(), (Collection<String>)this.getAbsolutePaths(directory, module), compileModules.ktFiles.1.INSTANCE);
            Collection collection = ktFiles2;
            Intrinsics.checkExpressionValueIsNotNull(collection, "ktFiles");
            if (!this.checkKotlinPackageUsage(environment2, collection)) {
                return false;
            }
            File moduleOutputDirectory = new File(module.getOutputDirectory());
            List<KtFile> list2 = ktFiles2;
            Intrinsics.checkExpressionValueIsNotNull(list2, "ktFiles");
            GenerationState generationState = this.generate(environment2, result2, list2, module, moduleOutputDirectory, module.getModuleName());
            outputFiles.put(module, generationState.getFactory());
            generationStates.add(generationState);
        }
        try {
            for (Module module : chunk) {
                ProgressIndicatorAndCompilationCanceledStatus.checkCanceled();
                Object v = outputFiles.get(module);
                if (v == null) {
                    Intrinsics.throwNpe();
                }
                ClassFileFactory classFileFactory = (ClassFileFactory)v;
                Intrinsics.checkExpressionValueIsNotNull(classFileFactory, "outputFiles[module]!!");
                this.writeOutput(configuration, classFileFactory, new File(module.getOutputDirectory()), jarPath, jarRuntime, null);
            }
            boolean bl = true;
            return bl;
        }
        finally {
            for (GenerationState generationState : generationStates) {
                generationState.destroy();
            }
        }
    }

    @NotNull
    public final CompilerConfiguration createCompilerConfiguration(@NotNull CompilerConfiguration base, @NotNull List<? extends Module> chunk, @NotNull File directory) {
        Intrinsics.checkParameterIsNotNull(base, "base");
        Intrinsics.checkParameterIsNotNull(chunk, "chunk");
        Intrinsics.checkParameterIsNotNull(directory, "directory");
        CompilerConfiguration configuration = base.copy();
        for (Module module : chunk) {
            ContentRootsKt.addKotlinSourceRoots(configuration, this.getAbsolutePaths(directory, module));
        }
        for (Module module : chunk) {
            for (JavaRootPath javaRootPath : module.getJavaSourceRoots()) {
                JvmContentRootsKt.addJavaSourceRoot(configuration, new File(javaRootPath.getPath()), javaRootPath.getPackagePrefix());
            }
        }
        for (Module module : chunk) {
            for (String classpathRoot : module.getClasspathRoots()) {
                JvmContentRootsKt.addJvmClasspathRoot(configuration, new File(classpathRoot));
            }
        }
        configuration.addAll(JVMConfigurationKeys.MODULES, (Collection)chunk);
        CompilerConfiguration compilerConfiguration = configuration;
        Intrinsics.checkExpressionValueIsNotNull(compilerConfiguration, "configuration");
        return compilerConfiguration;
    }

    /*
     * WARNING - void declaration
     */
    private final FqName findMainClass(GenerationState generationState, List<? extends KtFile> files) {
        Object v0;
        block2: {
            void $receiver$iv;
            MainFunctionDetector mainFunctionDetector = new MainFunctionDetector(generationState.getBindingContext());
            Sequence sequence2 = SequencesKt.map(CollectionsKt.asSequence((Iterable)files), (Function1)new Function1<KtFile, FqName>(mainFunctionDetector){
                final /* synthetic */ MainFunctionDetector $mainFunctionDetector;

                @Nullable
                public final FqName invoke(@NotNull KtFile file) {
                    Intrinsics.checkParameterIsNotNull(file, "file");
                    return this.$mainFunctionDetector.hasMain(file.getDeclarations()) ? JvmFileClassUtil.getFileClassInfoNoResolve(file).getFacadeClassFqName() : (FqName)null;
                }
                {
                    this.$mainFunctionDetector = mainFunctionDetector;
                    super(1);
                }
            });
            Object single$iv = null;
            boolean found$iv = false;
            for (Object element$iv : $receiver$iv) {
                FqName it = (FqName)element$iv;
                if (!(it != null)) continue;
                if (found$iv) {
                    v0 = null;
                    break block2;
                }
                single$iv = element$iv;
                found$iv = true;
            }
            v0 = !found$iv ? null : single$iv;
        }
        return v0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean compileBunchOfSources(@NotNull KotlinCoreEnvironment environment2, @Nullable File jar, @Nullable File outputDir, @NotNull List<String> friendPaths, boolean includeRuntime) {
        Intrinsics.checkParameterIsNotNull(environment2, "environment");
        Intrinsics.checkParameterIsNotNull(friendPaths, "friendPaths");
        ModuleVisibilityManager moduleVisibilityManager = ModuleVisibilityManager.SERVICE.getInstance(environment2.getProject());
        for (String path : friendPaths) {
            moduleVisibilityManager.addFriendPath(path);
        }
        if (!this.checkKotlinPackageUsage(environment2, (Collection<? extends KtFile>)environment2.getSourceFiles())) {
            return false;
        }
        GenerationState generationState = this.analyzeAndGenerate(environment2);
        if (generationState == null) {
            return false;
        }
        GenerationState generationState2 = generationState;
        FqName mainClass = this.findMainClass(generationState2, environment2.getSourceFiles());
        try {
            this.writeOutput(environment2.getConfiguration(), generationState2.getFactory(), outputDir, jar, includeRuntime, mainClass);
            boolean bl = true;
            return bl;
        }
        finally {
            generationState2.destroy();
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final ExitCode compileAndExecuteScript(@NotNull CompilerConfiguration configuration, @NotNull KotlinPaths paths, @NotNull KotlinCoreEnvironment environment2, @NotNull List<String> scriptArgs) {
        Intrinsics.checkParameterIsNotNull(configuration, "configuration");
        Intrinsics.checkParameterIsNotNull(paths, "paths");
        Intrinsics.checkParameterIsNotNull(environment2, "environment");
        Intrinsics.checkParameterIsNotNull(scriptArgs, "scriptArgs");
        Class<?> clazz = this.compileScript(configuration, paths, environment2);
        if (clazz == null) {
            return ExitCode.COMPILATION_ERROR;
        }
        Class<?> scriptClass = clazz;
        Constructor<?> scriptConstructor = this.getScriptConstructor(scriptClass);
        try {
            void elements$iv;
            Object[] objectArray;
            Object[] $receiver$iv;
            Object[] objectArray2;
            Collection collection = scriptArgs;
            int n = 0;
            Object[] objectArray3 = objectArray2 = new Object[1];
            Constructor<?> constructor = scriptConstructor;
            void v1 = $receiver$iv;
            if (v1 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.util.Collection<T>");
            }
            Collection thisCollection$iv = (Collection)v1;
            String[] stringArray = thisCollection$iv.toArray(new String[thisCollection$iv.size()]);
            if (stringArray == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
            }
            objectArray2[n] = objectArray = (Object[])stringArray;
            $receiver$iv = objectArray3;
            objectArray3 = (Object[])elements$iv;
            constructor.newInstance(Arrays.copyOf(objectArray3, objectArray3.length));
        }
        catch (Throwable e) {
            this.reportExceptionFromScript(e);
            return ExitCode.SCRIPT_EXECUTION_ERROR;
        }
        return ExitCode.OK;
    }

    /*
     * WARNING - void declaration
     */
    private final void reportExceptionFromScript(Throwable exception) {
        PrintStream stream2 = System.err;
        Throwable cause = exception.getCause();
        if (!(exception instanceof InvocationTargetException) || cause == null) {
            void stream$iv;
            void $receiver$iv;
            Throwable throwable = exception;
            PrintStream printStream = stream2;
            Intrinsics.checkExpressionValueIsNotNull(printStream, "stream");
            PrintStream printStream2 = printStream;
            void v1 = $receiver$iv;
            if (v1 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.Throwable");
            }
            ((Throwable)v1).printStackTrace((PrintStream)stream$iv);
            return;
        }
        stream2.println(cause);
        StackTraceElement[] fullTrace = ExceptionsKt.getStackTrace(cause);
        int relevantEntries = ((Object[])fullTrace).length - ((Object[])ExceptionsKt.getStackTrace(exception)).length;
        int $i$f$printStackTrace = 0;
        int n = relevantEntries - 1;
        if ($i$f$printStackTrace <= n) {
            while (true) {
                void i;
                stream2.println("\tat " + fullTrace[i]);
                if (i == n) break;
                ++i;
            }
        }
    }

    private final Constructor<?> getScriptConstructor(Class<?> scriptClass) {
        Constructor<?> constructor = scriptClass.getConstructor(String[].class);
        Intrinsics.checkExpressionValueIsNotNull(constructor, "scriptClass.getConstruct\u2026rray<String>::class.java)");
        return constructor;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final Class<?> compileScript(@NotNull CompilerConfiguration configuration, @NotNull KotlinPaths paths, @NotNull KotlinCoreEnvironment environment2) {
        Intrinsics.checkParameterIsNotNull(configuration, "configuration");
        Intrinsics.checkParameterIsNotNull(paths, "paths");
        Intrinsics.checkParameterIsNotNull(environment2, "environment");
        GenerationState generationState = this.analyzeAndGenerate(environment2);
        if (generationState == null) {
            return null;
        }
        GenerationState state2 = generationState;
        try {
            Unit unit;
            GeneratedClassLoader generatedClassLoader;
            URLClassLoader uRLClassLoader;
            Object object;
            Object object2;
            void destination$iv;
            Collection $receiver$iv;
            ArrayList<URL> classPaths = CollectionsKt.arrayListOf(paths.getRuntimePath().toURI().toURL());
            Iterable iterable = JvmContentRootsKt.getJvmClasspathRoots(configuration);
            for (Object item$iv : $receiver$iv) {
                void it;
                File file = (File)item$iv;
                object2 = (Collection)destination$iv;
                object = it.toURI().toURL();
                object2.add(object);
            }
            Collection cfr_ignored_0 = (Collection)destination$iv;
            $receiver$iv = (Collection)destination$iv;
            URLClassLoader uRLClassLoader2 = uRLClassLoader;
            URLClassLoader uRLClassLoader3 = uRLClassLoader;
            ClassFileFactory classFileFactory = state2.getFactory();
            object = generatedClassLoader;
            object2 = generatedClassLoader;
            Collection collection = $receiver$iv;
            if (collection == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.util.Collection<T>");
            }
            Collection thisCollection$iv22 = collection;
            URL[] uRLArray = thisCollection$iv22.toArray(new URL[thisCollection$iv22.size()]);
            if (uRLArray == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
            }
            Object[] objectArray = uRLArray;
            uRLClassLoader2((URL[])objectArray, (ClassLoader)null);
            ((GeneratedClassLoader)object)(classFileFactory, (ClassLoader)uRLClassLoader3, new URL[0]);
            Object classLoader = object2;
            KtScript script = environment2.getSourceFiles().get(0).getScript();
            boolean thisCollection$iv22 = script != null;
            if (_Assertions.ENABLED) {
                void value$iv;
                if (value$iv == false) {
                    String message$iv = "Script must be parsed";
                    throw (Throwable)((Object)new AssertionError((Object)message$iv));
                }
                unit = Unit.INSTANCE;
            } else {
                unit = Unit.INSTANCE;
            }
            KtScript ktScript = script;
            if (ktScript == null) {
                Intrinsics.throwNpe();
            }
            FqName nameForScript = ktScript.getFqName();
            return ((ClassLoader)classLoader).loadClass(nameForScript.asString());
        }
        catch (Exception e) {
            throw (Throwable)new RuntimeException("Failed to evaluate script: " + e, e);
        }
    }

    @Nullable
    public final GenerationState analyzeAndGenerate(@NotNull KotlinCoreEnvironment environment2) {
        Intrinsics.checkParameterIsNotNull(environment2, "environment");
        AnalysisResult analysisResult = this.analyze(environment2, null);
        if (analysisResult == null) {
            return null;
        }
        AnalysisResult result2 = analysisResult;
        if (!result2.getShouldGenerateCode()) {
            return null;
        }
        result2.throwIfError();
        return this.generate(environment2, result2, environment2.getSourceFiles(), null, null, null);
    }

    /*
     * WARNING - void declaration
     */
    private final AnalysisResult analyze(KotlinCoreEnvironment environment2, String targetDescription2) {
        void $receiver$iv;
        void args$iv;
        MessageCollector collector2 = this.messageCollector(environment2);
        long analysisStart = PerformanceCounter.Companion.currentTime();
        AnalyzerWithCompilerReport analyzerWithCompilerReport = new AnalyzerWithCompilerReport(collector2);
        analyzerWithCompilerReport.analyzeAndReport((Collection<? extends KtFile>)environment2.getSourceFiles(), new AnalyzerWithCompilerReport.Analyzer(environment2, collector2){
            final /* synthetic */ KotlinCoreEnvironment $environment;
            final /* synthetic */ MessageCollector $collector;

            @NotNull
            public AnalysisResult analyze() {
                CliLightClassGenerationSupport.NoScopeRecordCliBindingTrace sharedTrace = new CliLightClassGenerationSupport.NoScopeRecordCliBindingTrace();
                MutableModuleContext moduleContext = TopDownAnalyzerFacadeForJVM.createContextWithSealedModule(this.$environment.getProject(), ModuleNameKt.getModuleName(this.$environment));
                AnalysisResult analysisResult = TopDownAnalyzerFacadeForJVM.analyzeFilesWithJavaIntegrationWithCustomContext(moduleContext, (Collection<KtFile>)this.$environment.getSourceFiles(), sharedTrace, this.$environment.getConfiguration().get(JVMConfigurationKeys.MODULES), this.$environment.getConfiguration().get(JVMConfigurationKeys.INCREMENTAL_COMPILATION_COMPONENTS), new JvmPackagePartProvider(this.$environment));
                Intrinsics.checkExpressionValueIsNotNull(analysisResult, "TopDownAnalyzerFacadeFor\u2026artProvider(environment))");
                return analysisResult;
            }

            public void reportEnvironmentErrors() {
                KotlinToJVMBytecodeCompiler.access$reportRuntimeConflicts(KotlinToJVMBytecodeCompiler.INSTANCE, this.$collector, JvmContentRootsKt.getJvmClasspathRoots(this.$environment.getConfiguration()));
            }
            {
                this.$environment = $captured_local_variable$0;
                this.$collector = $captured_local_variable$1;
            }
        });
        long analysisNanos = PerformanceCounter.Companion.currentTime() - analysisStart;
        int sourceLinesOfCode2 = environment2.getSourceLinesOfCode();
        int numberOfFiles = environment2.getSourceFiles().size();
        long time = TimeUnit.NANOSECONDS.toMillis(analysisNanos);
        float speed = (float)sourceLinesOfCode2 * (float)1000 / (float)time;
        StringBuilder stringBuilder = new StringBuilder();
        StringBuilder stringBuilder2 = new StringBuilder().append("ANALYZE: ").append(numberOfFiles).append(" files (").append(sourceLinesOfCode2).append(" lines) ");
        String string = targetDescription2;
        if (string == null) {
            string = "";
        }
        String string2 = "%.3f";
        Object[] objectArray = new Object[]{Float.valueOf(speed)};
        StringBuilder stringBuilder3 = new StringBuilder().append("in ").append(time).append(" ms - ");
        StringBuilder stringBuilder4 = stringBuilder.append(stringBuilder2.append(string).toString());
        void v3 = args$iv;
        String string3 = String.format((String)$receiver$iv, Arrays.copyOf(v3, ((void)v3).length));
        Intrinsics.checkExpressionValueIsNotNull(string3, "java.lang.String.format(this, *args)");
        String string4 = string3;
        String message = stringBuilder4.append(stringBuilder3.append(string4).append(" loc/s").toString()).toString();
        K2JVMCompiler.Companion.reportPerf(environment2.getConfiguration(), message);
        AnalysisResult result2 = analyzerWithCompilerReport.getAnalysisResult();
        CompilerPluginContext context = new CompilerPluginContext(environment2.getProject(), result2.getBindingContext(), environment2.getSourceFiles());
        for (CompilerPlugin plugin : environment2.getConfiguration().getList(CLIConfigurationKeys.COMPILER_PLUGINS)) {
            plugin.processFiles(context);
        }
        return analyzerWithCompilerReport.hasErrors() ? (AnalysisResult)null : result2;
    }

    /*
     * WARNING - void declaration
     */
    private final GenerationState generate(KotlinCoreEnvironment environment2, AnalysisResult result2, List<? extends KtFile> sourceFiles, Module module, File outputDirectory, String moduleName) {
        void $receiver$iv;
        void args$iv;
        CompilerConfiguration configuration = environment2.getConfiguration();
        IncrementalCompilationComponents incrementalCompilationComponents = configuration.get(JVMConfigurationKeys.INCREMENTAL_COMPILATION_COMPONENTS);
        HashSet<FqName> packagesWithObsoleteParts = SetsKt.hashSetOf(new FqName[0]);
        ArrayList<FqName> obsoleteMultifileClasses = CollectionsKt.arrayListOf(new FqName[0]);
        TargetId targetId = null;
        if (module != null && incrementalCompilationComponents != null) {
            targetId = TargetIdKt.TargetId(module);
            IncrementalCache incrementalCache = incrementalCompilationComponents.getIncrementalCache(targetId);
            for (String internalName : incrementalCache.getObsoletePackageParts()) {
                packagesWithObsoleteParts.add(JvmClassName.byInternalName(internalName).getPackageFqName());
            }
            for (String obsoleteFacadeInternalName : incrementalCache.getObsoleteMultifileClasses()) {
                obsoleteMultifileClasses.add(JvmClassName.byInternalName(obsoleteFacadeInternalName).getFqNameForClassNameWithoutDollars());
            }
        }
        Project project = environment2.getProject();
        ClassBuilderFactory classBuilderFactory = ClassBuilderFactories.BINARIES;
        Intrinsics.checkExpressionValueIsNotNull(classBuilderFactory, "ClassBuilderFactories.BINARIES");
        GenerationState generationState = new GenerationState(project, classBuilderFactory, result2.getModuleDescriptor(), result2.getBindingContext(), sourceFiles, configuration.get(JVMConfigurationKeys.DISABLE_CALL_ASSERTIONS, false), configuration.get(JVMConfigurationKeys.DISABLE_PARAM_ASSERTIONS, false), GenerationState.GenerateClassFilter.GENERATE_ALL, configuration.get(JVMConfigurationKeys.DISABLE_INLINE, false), configuration.get(JVMConfigurationKeys.DISABLE_OPTIMIZATION, false), false, packagesWithObsoleteParts, obsoleteMultifileClasses, targetId, moduleName, outputDirectory, incrementalCompilationComponents, configuration.get(JVMConfigurationKeys.MULTIFILE_FACADES_OPEN, false), null, 262144, null);
        ProgressIndicatorAndCompilationCanceledStatus.checkCanceled();
        long generationStart = PerformanceCounter.Companion.currentTime();
        KotlinCodegenFacade.compileCorrectFiles(generationState, CompilationErrorHandler.THROW_EXCEPTION);
        long generationNanos = PerformanceCounter.Companion.currentTime() - generationStart;
        String desc = module != null ? "target " + module.getModuleName() + "-" + module.getModuleType() + " " : "";
        int numberOfSourceFiles = sourceFiles.size();
        int numberOfLines = environment2.countLinesOfCode(sourceFiles);
        long time = TimeUnit.NANOSECONDS.toMillis(generationNanos);
        float speed = (float)numberOfLines * (float)1000 / (float)time;
        String string = "%.3f";
        Object[] objectArray = new Object[]{Float.valueOf(speed)};
        StringBuilder stringBuilder = new StringBuilder().append("GENERATE: ").append(numberOfSourceFiles).append(" files (").append(numberOfLines).append(" lines) ").append(desc).append("in ").append(time).append(" ms - ");
        void v2 = args$iv;
        String string2 = String.format((String)$receiver$iv, Arrays.copyOf(v2, ((void)v2).length));
        Intrinsics.checkExpressionValueIsNotNull(string2, "java.lang.String.format(this, *args)");
        String string3 = string2;
        String message = stringBuilder.append(string3).append(" loc/s").toString();
        K2JVMCompiler.Companion.reportPerf(environment2.getConfiguration(), message);
        ProgressIndicatorAndCompilationCanceledStatus.checkCanceled();
        Diagnostics diagnostics = generationState.getCollectedExtraJvmDiagnostics();
        Diagnostics diagnostics2 = result2.getBindingContext().getDiagnostics();
        Intrinsics.checkExpressionValueIsNotNull(diagnostics2, "result.bindingContext.diagnostics");
        AnalyzerWithCompilerReport.Companion.reportDiagnostics(new FilteredJvmDiagnostics(diagnostics, diagnostics2), this.messageCollector(environment2));
        BindingContext bindingContext = generationState.getExtraJvmDiagnosticsTrace().getBindingContext();
        Intrinsics.checkExpressionValueIsNotNull(bindingContext, "generationState.extraJvm\u2026sticsTrace.bindingContext");
        AnalyzerWithCompilerReport.Companion.reportBytecodeVersionErrors(bindingContext, this.messageCollector(environment2));
        ProgressIndicatorAndCompilationCanceledStatus.checkCanceled();
        return generationState;
    }

    /*
     * WARNING - void declaration
     */
    private final boolean checkKotlinPackageUsage(KotlinCoreEnvironment environment2, Collection<? extends KtFile> files) {
        void $receiver$iv;
        if (Intrinsics.areEqual(environment2.getConfiguration().get(CLIConfigurationKeys.ALLOW_KOTLIN_PACKAGE), true)) {
            return true;
        }
        MessageCollector messageCollector = environment2.getConfiguration().get(CLIConfigurationKeys.MESSAGE_COLLECTOR_KEY, MessageCollector.NONE);
        FqName kotlinPackage = FqName.topLevel(Name.identifier("kotlin"));
        Iterable iterable = files;
        for (Object element$iv : $receiver$iv) {
            KtFile it = (KtFile)element$iv;
            FqName fqName2 = it.getPackageFqName();
            FqName fqName3 = kotlinPackage;
            Intrinsics.checkExpressionValueIsNotNull(fqName3, "kotlinPackage");
            if (!FqNamesUtilKt.isSubpackageOf(fqName2, fqName3)) continue;
            KtPackageDirective ktPackageDirective = it.getPackageDirective();
            if (ktPackageDirective == null) {
                Intrinsics.throwNpe();
            }
            messageCollector.report(CompilerMessageSeverity.ERROR, "Only the Kotlin standard library is allowed to use the 'kotlin' package", MessageUtil.psiElementToMessageLocation(ktPackageDirective));
            return false;
        }
        return true;
    }

    @NotNull
    public final MessageCollector messageCollector(KotlinCoreEnvironment $receiver) {
        Unit unit;
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        MessageCollector result2 = $receiver.getConfiguration().get(CLIConfigurationKeys.MESSAGE_COLLECTOR_KEY);
        boolean value$iv = result2 != null;
        if (_Assertions.ENABLED) {
            if (!value$iv) {
                String message$iv = "Message collector not specified in compiler configuration";
                throw (Throwable)((Object)new AssertionError((Object)message$iv));
            }
            unit = Unit.INSTANCE;
        } else {
            unit = Unit.INSTANCE;
        }
        MessageCollector messageCollector = result2;
        if (messageCollector == null) {
            Intrinsics.throwNpe();
        }
        return messageCollector;
    }

    /*
     * WARNING - void declaration
     */
    private final void reportRuntimeConflicts(MessageCollector messageCollector, List<? extends File> jvmClasspathRoots) {
        void destination$iv$iv;
        void $receiver$iv$iv;
        void $receiver$iv;
        Object object;
        File it;
        void var10_10;
        Collection destination$iv$iv2;
        Iterable $receiver$iv$iv2;
        Iterable $receiver$iv2;
        reportRuntimeConflicts.1 removeIdeaVersionSuffix$ = reportRuntimeConflicts.1.INSTANCE;
        Iterable iterable = jvmClasspathRoots;
        void var5_5 = $receiver$iv2;
        Collection collection = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver$iv2, 10));
        for (Object item$iv$iv : $receiver$iv$iv2) {
            File file = (File)item$iv$iv;
            var10_10 = destination$iv$iv2;
            object = it.getCanonicalFile();
            var10_10.add(object);
        }
        $receiver$iv2 = (List)destination$iv$iv2;
        $receiver$iv$iv2 = $receiver$iv2;
        destination$iv$iv2 = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv2) {
            it = (File)element$iv$iv;
            if (!(Intrinsics.areEqual(it.getName(), "kotlin-runtime.jar") && it.exists())) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        List runtimes = (List)destination$iv$iv2;
        $receiver$iv$iv2 = runtimes;
        destination$iv$iv2 = $receiver$iv;
        Collection collection2 = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver$iv, 10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void $receiver$iv3;
            void it2;
            File $i$a$2 = (File)item$iv$iv;
            var10_10 = destination$iv$iv;
            String $i$f$filterTo = JarUtil.getJarAttribute((File)it2, Attributes.Name.IMPLEMENTATION_VERSION);
            reportRuntimeConflicts.1 var15_15 = reportRuntimeConflicts.1.INSTANCE;
            String string = $receiver$iv3;
            if (string == null) {
                string = "";
            }
            void var16_16 = string;
            object = var15_15.invoke((String)var16_16);
            var10_10.add(object);
        }
        List runtimeVersions = (List)destination$iv$iv;
        if (CollectionsKt.toSet(runtimeVersions).size() > 1) {
            messageCollector.report(CompilerMessageSeverity.ERROR, "Conflicting versions of Kotlin runtime on classpath: " + CollectionsKt.joinToString$default(runtimes, null, null, null, 0, null, reportRuntimeConflicts.2.INSTANCE, 31, null), CompilerMessageLocation.NO_LOCATION);
        }
    }

    private KotlinToJVMBytecodeCompiler() {
        INSTANCE = this;
    }

    static {
        new KotlinToJVMBytecodeCompiler();
    }

    public static final /* synthetic */ void access$reportRuntimeConflicts(KotlinToJVMBytecodeCompiler $this, @NotNull MessageCollector messageCollector, @NotNull List jvmClasspathRoots) {
        $this.reportRuntimeConflicts(messageCollector, jvmClasspathRoots);
    }
}

