/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.calls.resolvedCallUtil;

import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinFileFacade;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtPsiUtil;
import org.jetbrains.kotlin.psi.KtThisExpression;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.resolvedCallUtil.ResolvedCallUtilKt$WhenMappings;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.scopes.receivers.ExpressionReceiver;
import org.jetbrains.kotlin.resolve.scopes.receivers.ImplicitReceiver;
import org.jetbrains.kotlin.resolve.scopes.receivers.Receiver;
import org.jetbrains.kotlin.resolve.scopes.receivers.ReceiverValue;

@KotlinFileFacade(version={1, 0, 1}, abiVersion=32, data={"\u001b\u0015\u0001Q!\u0001\u0007\u0002\u000b\u0005a\u0011!B\u0001\u0005\u0004\u0015\t\u00012B\u0003\u0002\t\u0005)\u0011\u0001D\u0001\u000e\u0014!\u0001QB\u0001G\u00011\u0003)2!C\u0001\u0005\u0004a\tAka\u0001\u000e\u0014!\u0011QB\u0001G\u00011\u0003)2!C\u0001\u0005\u0004a\tAka\u0001\u000e\u0012!\u0015Q\"\u0001\r\u0004+\rI\u0011\u0001b\u0001\u0019\u0003Q\u001b\u0019!\u0004\b\t\b5\t\u0001dA\u000b\u0004\u0013\u0005!\u0019\u0001G\u0001\u001a\n!!Q\"\u0001M\u0005!\u000e\u0005Aka\u0001"}, strings={"getExplicitReceiverValue", "Lorg/jetbrains/kotlin/resolve/scopes/receivers/ReceiverValue;", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "ResolvedCallUtilKt", "getImplicitReceiverValue", "hasBothReceivers", "", "hasThisOrNoDispatchReceiver", "context", "Lorg/jetbrains/kotlin/resolve/BindingContext;"}, moduleName="kotlin-compiler")
public final class ResolvedCallUtilKt {
    public static final boolean hasThisOrNoDispatchReceiver(ResolvedCall<?> $receiver, @NotNull BindingContext context) {
        KtExpression expression;
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(context, "context");
        ReceiverValue dispatchReceiverValue = $receiver.getDispatchReceiver();
        if ($receiver.getResultingDescriptor().getDispatchReceiverParameter() == null || dispatchReceiverValue == null) {
            return true;
        }
        DeclarationDescriptor dispatchReceiverDescriptor = null;
        if (dispatchReceiverValue instanceof ImplicitReceiver) {
            dispatchReceiverDescriptor = ((ImplicitReceiver)dispatchReceiverValue).getDeclarationDescriptor();
        } else if (dispatchReceiverValue instanceof ExpressionReceiver && (expression = KtPsiUtil.deparenthesize(((ExpressionReceiver)dispatchReceiverValue).getExpression())) instanceof KtThisExpression) {
            dispatchReceiverDescriptor = (DeclarationDescriptor)context.get(BindingContext.REFERENCE_TARGET, ((KtThisExpression)expression).getInstanceReference());
        }
        return Intrinsics.areEqual(dispatchReceiverDescriptor, DescriptorUtilsKt.getOwnerForEffectiveDispatchReceiverParameter($receiver.getResultingDescriptor()));
    }

    @Nullable
    public static final ReceiverValue getExplicitReceiverValue(ResolvedCall<?> $receiver) {
        ReceiverValue receiverValue;
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        switch (ResolvedCallUtilKt$WhenMappings.$EnumSwitchMapping$0[$receiver.getExplicitReceiverKind().ordinal()]) {
            case 1: {
                receiverValue = $receiver.getDispatchReceiver();
                if (receiverValue != null) break;
                Intrinsics.throwNpe();
                break;
            }
            case 2: 
            case 3: {
                Receiver receiver = $receiver.getExtensionReceiver();
                if (receiver == null) {
                    throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.resolve.scopes.receivers.ReceiverValue");
                }
                receiverValue = (ReceiverValue)receiver;
                break;
            }
            default: {
                receiverValue = null;
            }
        }
        return receiverValue;
    }

    @Nullable
    public static final ReceiverValue getImplicitReceiverValue(ResolvedCall<?> $receiver) {
        ReceiverValue receiverValue;
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        switch (ResolvedCallUtilKt$WhenMappings.$EnumSwitchMapping$1[$receiver.getExplicitReceiverKind().ordinal()]) {
            case 1: {
                if ($receiver.getExtensionReceiver() != null) {
                    Receiver receiver = $receiver.getExtensionReceiver();
                    if (receiver == null) {
                        throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.resolve.scopes.receivers.ReceiverValue");
                    }
                    receiverValue = (ReceiverValue)receiver;
                    break;
                }
                receiverValue = $receiver.getDispatchReceiver();
                break;
            }
            case 2: {
                receiverValue = (ReceiverValue)$receiver.getExtensionReceiver();
                break;
            }
            case 3: {
                receiverValue = $receiver.getDispatchReceiver();
                break;
            }
            default: {
                receiverValue = null;
            }
        }
        return receiverValue;
    }

    public static final boolean hasBothReceivers(ResolvedCall<?> $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        return $receiver.getDispatchReceiver() != null && $receiver.getExtensionReceiver() != null;
    }
}

