/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.load.kotlin;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;

public final class OldPackageFacadeClassUtils {
    private OldPackageFacadeClassUtils() {
    }

    @NotNull
    public static String getPackageClassName(@NotNull FqName packageFQN) {
        if (packageFQN == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packageFQN", "org/jetbrains/kotlin/load/kotlin/OldPackageFacadeClassUtils", "getPackageClassName"));
        }
        if (packageFQN.isRoot()) {
            if ("_DefaultPackage" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/load/kotlin/OldPackageFacadeClassUtils", "getPackageClassName"));
            }
            return "_DefaultPackage";
        }
        String string = OldPackageFacadeClassUtils.capitalizeNonEmptyString(packageFQN.shortName().asString()) + "Package";
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/load/kotlin/OldPackageFacadeClassUtils", "getPackageClassName"));
        }
        return string;
    }

    @NotNull
    private static String capitalizeNonEmptyString(@NotNull String s) {
        if (s == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "s", "org/jetbrains/kotlin/load/kotlin/OldPackageFacadeClassUtils", "capitalizeNonEmptyString"));
        }
        String string = Character.isUpperCase(s.charAt(0)) ? s : Character.toUpperCase(s.charAt(0)) + s.substring(1);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/load/kotlin/OldPackageFacadeClassUtils", "capitalizeNonEmptyString"));
        }
        return string;
    }

    @NotNull
    public static FqName getPackageClassFqName(@NotNull FqName packageFQN) {
        if (packageFQN == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packageFQN", "org/jetbrains/kotlin/load/kotlin/OldPackageFacadeClassUtils", "getPackageClassFqName"));
        }
        FqName fqName2 = packageFQN.child(Name.identifier(OldPackageFacadeClassUtils.getPackageClassName(packageFQN)));
        if (fqName2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/load/kotlin/OldPackageFacadeClassUtils", "getPackageClassFqName"));
        }
        return fqName2;
    }

    @NotNull
    public static ClassId getPackageClassId(@NotNull FqName packageFQN) {
        if (packageFQN == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packageFQN", "org/jetbrains/kotlin/load/kotlin/OldPackageFacadeClassUtils", "getPackageClassId"));
        }
        ClassId classId = new ClassId(packageFQN, Name.identifier(OldPackageFacadeClassUtils.getPackageClassName(packageFQN)));
        if (classId == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/load/kotlin/OldPackageFacadeClassUtils", "getPackageClassId"));
        }
        return classId;
    }
}

