/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.load.kotlin;

import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinFileFacade;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptorWithSource;
import org.jetbrains.kotlin.descriptors.PackageFragmentDescriptor;
import org.jetbrains.kotlin.descriptors.SourceElement;
import org.jetbrains.kotlin.load.java.lazy.descriptors.LazyJavaPackageFragment;
import org.jetbrains.kotlin.load.kotlin.KotlinJvmBinaryClass;
import org.jetbrains.kotlin.load.kotlin.KotlinJvmBinaryPackageSourceElement;
import org.jetbrains.kotlin.load.kotlin.KotlinJvmBinarySourceElement;
import org.jetbrains.kotlin.load.kotlin.VirtualFileKotlinClass;
import org.jetbrains.kotlin.load.kotlin.incremental.IncrementalPackageFragmentProvider;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.serialization.deserialization.descriptors.DeserializedCallableMemberDescriptor;

@KotlinFileFacade(version={1, 0, 1}, abiVersion=32, data={"\u001b\u0015\u0001Q!\u0001E\u0006\u000b\u0005a\u0011!B\u0001\u0005\u0004\u0015\tA\"A\u0003\u0002\t\r)\u0011\u0001D\u0001\u000e\u0012!%Q\"\u0001\r\u00043\rAQ!D\u0001\u0019\u0003Q\u001b!!d\u0007\t\f5\t\u0001\u0014A\r\u0004\u0011\u0015i\u0011\u0001G\u0001\u001a\t!1QB\u0001G\u00011\u001b!6AAI\u000e\t\rC\u0001\u0002A\u0007\u00021\u0003)\u0012\u0001G\u0001\u001dGE\u001b1!\u0004\u0002\u0005\u0001!\rAk\u0001\u0002\u0012\u001c\u0011\t\u0005\u0002#\u0002\u000e\u0003a\u0019Q#\u0001\r\u00029\u0005\n6aA\u0007\u0003\t\u000fAA\u0001V\u0002\u0003"}, strings={"isFromIncrementalPackageFragment", "", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "(Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;)Z", "ModuleVisibilityUtilsKt", "toSourceElement", "Lorg/jetbrains/kotlin/descriptors/SourceElement;", "getToSourceElement", "(Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;)Lorg/jetbrains/kotlin/descriptors/SourceElement;", "getSourceElement", "descriptor", "isContainedByCompiledPartOfOurModule", "outDirectory", "Ljava/io/File;"}, moduleName="kotlin-compiler")
public final class ModuleVisibilityUtilsKt {
    public static final boolean isFromIncrementalPackageFragment(DeclarationDescriptor $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        return DescriptorUtils.getParentOfType($receiver, PackageFragmentDescriptor.class, false) instanceof IncrementalPackageFragmentProvider.IncrementalPackageFragment;
    }

    public static final boolean isContainedByCompiledPartOfOurModule(@NotNull DeclarationDescriptor descriptor2, @Nullable File outDirectory) {
        VirtualFile file;
        KotlinJvmBinaryClass binaryClass;
        KotlinJvmBinaryClass kotlinJvmBinaryClass;
        Intrinsics.checkParameterIsNotNull(descriptor2, "descriptor");
        PackageFragmentDescriptor packageFragment = DescriptorUtils.getParentOfType(descriptor2, PackageFragmentDescriptor.class, false);
        if (packageFragment instanceof IncrementalPackageFragmentProvider.IncrementalPackageFragment) {
            return true;
        }
        if (outDirectory == null || !(packageFragment instanceof LazyJavaPackageFragment)) {
            return false;
        }
        SourceElement source = ModuleVisibilityUtilsKt.getSourceElement(descriptor2);
        SourceElement sourceElement = source;
        if (sourceElement instanceof KotlinJvmBinarySourceElement) {
            kotlinJvmBinaryClass = ((KotlinJvmBinarySourceElement)source).getBinaryClass();
        } else if (sourceElement instanceof KotlinJvmBinaryPackageSourceElement) {
            if (descriptor2 instanceof DeserializedCallableMemberDescriptor) {
                kotlinJvmBinaryClass = ((KotlinJvmBinaryPackageSourceElement)source).getContainingBinaryClass((DeserializedCallableMemberDescriptor)descriptor2);
                if (kotlinJvmBinaryClass == null) {
                    kotlinJvmBinaryClass = ((KotlinJvmBinaryPackageSourceElement)source).getRepresentativeBinaryClass();
                }
            } else {
                kotlinJvmBinaryClass = ((KotlinJvmBinaryPackageSourceElement)source).getRepresentativeBinaryClass();
            }
        } else {
            kotlinJvmBinaryClass = binaryClass = (KotlinJvmBinaryClass)null;
        }
        if (binaryClass instanceof VirtualFileKotlinClass && Intrinsics.areEqual((file = ((VirtualFileKotlinClass)binaryClass).getFile()).getFileSystem().getProtocol(), "file")) {
            File ioFile = VfsUtilCore.virtualToIoFile(file);
            return StringsKt.startsWith$default(ioFile.getAbsolutePath(), outDirectory.getAbsolutePath() + File.separator, false, 2);
        }
        return false;
    }

    @NotNull
    public static final SourceElement getSourceElement(@NotNull DeclarationDescriptor descriptor2) {
        Intrinsics.checkParameterIsNotNull(descriptor2, "descriptor");
        return descriptor2 instanceof CallableMemberDescriptor && ((CallableMemberDescriptor)descriptor2).getSource() == SourceElement.NO_SOURCE ? ModuleVisibilityUtilsKt.getToSourceElement(((CallableMemberDescriptor)descriptor2).getContainingDeclaration()) : ModuleVisibilityUtilsKt.getToSourceElement(descriptor2);
    }

    private static final SourceElement getToSourceElement(DeclarationDescriptor $receiver) {
        return $receiver instanceof DeclarationDescriptorWithSource ? ((DeclarationDescriptorWithSource)$receiver).getSource() : SourceElement.NO_SOURCE;
    }
}

