/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.load.java;

import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.load.java.BuiltinMethodsWithDifferentJvmName;
import org.jetbrains.kotlin.load.java.BuiltinMethodsWithSpecialGenericSignature;
import org.jetbrains.kotlin.load.java.SpecialBuiltinMembers;
import org.jetbrains.kotlin.load.java.descriptors.JavaClassDescriptor;
import org.jetbrains.kotlin.resolve.ExternalOverridabilityCondition;

@KotlinClass(version={1, 0, 1}, abiVersion=32, data={"\u001f\u0015\tA\"A\u0003\u0002\u0019\u0005)\u0011\u0001B\u0001\u0006\u00031\tQ\u0001A\u0003\u0002\u0019\u0005)\u0011\u0001B\u0001\u0006\u00031\tA\u0002A\r\u00021\u0003\t+!U\u0002\u0002\u0011\u0005)\u0013\u0003B\u0006\t\u00045\t\u0001DA\r\u0004\u0011\u000bi\u0011\u0001G\u0002\u001a\u0007!\u001dQ\"\u0001\r\u00043\u0011AA!\u0004\u0002\r\u0002a%\u0001"}, strings={"Lorg/jetbrains/kotlin/load/java/BuiltinOverridabilityCondition;", "Lorg/jetbrains/kotlin/resolve/ExternalOverridabilityCondition;", "()V", "isOverridable", "Lorg/jetbrains/kotlin/resolve/ExternalOverridabilityCondition$Result;", "superDescriptor", "Lorg/jetbrains/kotlin/descriptors/CallableDescriptor;", "subDescriptor", "subClassDescriptor", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;"}, moduleName="kotlin-compiler")
public final class BuiltinOverridabilityCondition
implements ExternalOverridabilityCondition {
    @Override
    @NotNull
    public ExternalOverridabilityCondition.Result isOverridable(@NotNull CallableDescriptor superDescriptor, @NotNull CallableDescriptor subDescriptor, @Nullable ClassDescriptor subClassDescriptor) {
        Intrinsics.checkParameterIsNotNull(superDescriptor, "superDescriptor");
        Intrinsics.checkParameterIsNotNull(subDescriptor, "subDescriptor");
        if (!(superDescriptor instanceof CallableMemberDescriptor) || !(subDescriptor instanceof FunctionDescriptor) || SpecialBuiltinMembers.isFromBuiltins((CallableMemberDescriptor)subDescriptor)) {
            return ExternalOverridabilityCondition.Result.UNKNOWN;
        }
        if (!BuiltinMethodsWithSpecialGenericSignature.INSTANCE.getSameAsBuiltinMethodWithErasedValueParameters(((FunctionDescriptor)subDescriptor).getName()) && !BuiltinMethodsWithDifferentJvmName.INSTANCE.getSameAsRenamedInJvmBuiltin(((FunctionDescriptor)subDescriptor).getName())) {
            return ExternalOverridabilityCondition.Result.UNKNOWN;
        }
        CallableMemberDescriptor overriddenBuiltin = SpecialBuiltinMembers.getOverriddenSpecialBuiltin((CallableMemberDescriptor)superDescriptor);
        Boolean bl = ((FunctionDescriptor)subDescriptor).isHiddenToOvercomeSignatureClash();
        CallableDescriptor callableDescriptor = superDescriptor;
        if (!(callableDescriptor instanceof FunctionDescriptor)) {
            callableDescriptor = null;
        }
        FunctionDescriptor functionDescriptor = (FunctionDescriptor)callableDescriptor;
        boolean isOneOfDescriptorsHidden = Intrinsics.areEqual(bl, functionDescriptor != null ? Boolean.valueOf(functionDescriptor.isHiddenToOvercomeSignatureClash()) : null) ^ true;
        if ((overriddenBuiltin == null || !((FunctionDescriptor)subDescriptor).isHiddenToOvercomeSignatureClash()) && isOneOfDescriptorsHidden) {
            return ExternalOverridabilityCondition.Result.INCOMPATIBLE;
        }
        if (!(subClassDescriptor instanceof JavaClassDescriptor) || ((FunctionDescriptor)subDescriptor).getInitialSignatureDescriptor() != null) {
            return ExternalOverridabilityCondition.Result.UNKNOWN;
        }
        CallableMemberDescriptor callableMemberDescriptor = overriddenBuiltin;
        if (callableMemberDescriptor == null) {
            return ExternalOverridabilityCondition.Result.UNKNOWN;
        }
        if (SpecialBuiltinMembers.hasRealKotlinSuperClassWithOverrideOf(subClassDescriptor, callableMemberDescriptor)) {
            return ExternalOverridabilityCondition.Result.UNKNOWN;
        }
        return ExternalOverridabilityCondition.Result.INCOMPATIBLE;
    }
}

