/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.translate.intrinsic.operation;

import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.js.patterns.DescriptorPredicate;
import org.jetbrains.kotlin.js.patterns.PatternBuilder;
import org.jetbrains.kotlin.js.translate.context.TranslationContext;
import org.jetbrains.kotlin.js.translate.intrinsic.operation.AbstractBinaryOperationIntrinsic;
import org.jetbrains.kotlin.js.translate.intrinsic.operation.BinaryOperationIntrinsic;
import org.jetbrains.kotlin.js.translate.intrinsic.operation.BinaryOperationIntrinsicFactory;
import org.jetbrains.kotlin.js.translate.operation.OperatorTable;
import org.jetbrains.kotlin.js.translate.utils.JsAstUtils;
import org.jetbrains.kotlin.js.translate.utils.JsDescriptorUtils;
import org.jetbrains.kotlin.js.translate.utils.PsiUtils;
import org.jetbrains.kotlin.lexer.KtSingleValueToken;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.relocated.com.google.common.collect.ImmutableSet;
import org.jetbrains.kotlin.relocated.com.google.dart.compiler.backend.js.ast.JsBinaryOperation;
import org.jetbrains.kotlin.relocated.com.google.dart.compiler.backend.js.ast.JsBinaryOperator;
import org.jetbrains.kotlin.relocated.com.google.dart.compiler.backend.js.ast.JsExpression;
import org.jetbrains.kotlin.relocated.com.google.dart.compiler.backend.js.ast.JsNumberLiteral;
import org.jetbrains.kotlin.resolve.calls.tasks.DynamicCallsKt;
import org.jetbrains.kotlin.types.expressions.OperatorConventions;

@KotlinClass(version={1, 0, 1}, abiVersion=32, data={"1\u0015\tA\"A\u0003\u0002\u0019\u0005)\u0011\u0001B\u0001\u0006\u00031\tQ!\u0001\u0007\u0002\u000b\u0005!9!B\u0001\r\u0003\u0015\u0001Q!\u0001\u0007\u0002\u000b\u0001)\u0011\u0001D\u0001\u0006\u00031\tQ!\u0001C\u0003\t\r\fA\u0002A\r\u00021\u0003i\"A#\u0006\f\u0018\u0005\u001eA!A)\u0004\u0003!\tQ%\u0003\u0003\f\u0011\u0019i!\u0001$\u0001\u0019\u000ee\u0019\u0001bB\u0007\u00021\u001f)c\u0003B\u0006\t\u00115\u0019\u0012BB\u0005\u0006!')\"\u0001$\u0001\u0019\u0013aI\u00013C\u000b\n\u0013\u0019IQ\u0001e\u0005\u0016\u00051\u0005\u0001$\u0003\r\n\u0019\u0003A\n\u0002'\u0005*\u001a\u0011\u0019\u0005\u0002c\u0001\u000e\ba\u0011\u0011kA\u0001\u0005\u0006E\u001bA!\u0002\u0001\u000e\u0005\u0011\u0019\u0001rAU\r\t\rC\u0001\u0002BG\u00041\t\t6!\u0001C\u0003#\u000e!Q\u0001A\u0007\u0003\t\u0013A9!+\u0007\u0005\u0007\"AQ!d\u0002\u0019\u0005E\u001b\u0011\u0001\"\u0002R\u0007\u0011)\u0001!\u0004\u0002\u0005\f!\u001d\u0001"}, strings={"Lorg/jetbrains/kotlin/js/translate/intrinsic/operation/CompareToBOIF;", "Lorg/jetbrains/kotlin/js/translate/intrinsic/operation/BinaryOperationIntrinsicFactory;", "()V", "CHAR_COMPARE_TO", "Lorg/jetbrains/kotlin/js/patterns/DescriptorPredicate;", "Lorg/jetbrains/annotations/NotNull;", "getCHAR_COMPARE_TO", "()Lorg/jetbrains/kotlin/js/patterns/DescriptorPredicate;", "COMPARE_TO_CHAR", "getCOMPARE_TO_CHAR", "PRIMITIVE_COMPARE_TO", "getPRIMITIVE_COMPARE_TO", "getIntrinsic", "Lorg/jetbrains/kotlin/js/translate/intrinsic/operation/BinaryOperationIntrinsic;", "descriptor", "Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "getSupportTokens", "Lorg/jetbrains/kotlin/relocated/com/google/common/collect/ImmutableSet;", "Lorg/jetbrains/kotlin/lexer/KtSingleValueToken;", "kotlin.jvm.PlatformType", "CompareCharToPrimitiveIntrinsic", "CompareToCharIntrinsic", "CompareToFunctionIntrinsic", "CompareToIntrinsic"}, moduleName="kotlin-compiler")
public final class CompareToBOIF
implements BinaryOperationIntrinsicFactory {
    @NotNull
    public static final DescriptorPredicate COMPARE_TO_CHAR;
    @NotNull
    public static final DescriptorPredicate CHAR_COMPARE_TO;
    @NotNull
    public static final DescriptorPredicate PRIMITIVE_COMPARE_TO;
    public static final CompareToBOIF INSTANCE;
    public static final CompareToBOIF INSTANCE$;

    @NotNull
    public final DescriptorPredicate getCOMPARE_TO_CHAR() {
        return COMPARE_TO_CHAR;
    }

    @NotNull
    public final DescriptorPredicate getCHAR_COMPARE_TO() {
        return CHAR_COMPARE_TO;
    }

    @NotNull
    public final DescriptorPredicate getPRIMITIVE_COMPARE_TO() {
        return PRIMITIVE_COMPARE_TO;
    }

    public ImmutableSet<KtSingleValueToken> getSupportTokens() {
        return OperatorConventions.COMPARISON_OPERATIONS;
    }

    @Override
    @Nullable
    public BinaryOperationIntrinsic getIntrinsic(@NotNull FunctionDescriptor descriptor2) {
        Intrinsics.checkParameterIsNotNull(descriptor2, "descriptor");
        if (DynamicCallsKt.isDynamic(descriptor2)) {
            return CompareToIntrinsic.INSTANCE;
        }
        if (!JsDescriptorUtils.isBuiltin(descriptor2)) {
            return null;
        }
        return COMPARE_TO_CHAR.apply(descriptor2) ? (AbstractBinaryOperationIntrinsic)CompareToCharIntrinsic.INSTANCE : (CHAR_COMPARE_TO.apply(descriptor2) ? (AbstractBinaryOperationIntrinsic)CompareCharToPrimitiveIntrinsic.INSTANCE : (PRIMITIVE_COMPARE_TO.apply(descriptor2) ? (AbstractBinaryOperationIntrinsic)CompareToIntrinsic.INSTANCE : (AbstractBinaryOperationIntrinsic)CompareToFunctionIntrinsic.INSTANCE));
    }

    private CompareToBOIF() {
        INSTANCE = this;
        INSTANCE$ = this;
        COMPARE_TO_CHAR = PatternBuilder.pattern("Int|Short|Byte|Double|Float.compareTo(Char)");
        CHAR_COMPARE_TO = PatternBuilder.pattern("Char.compareTo(Int|Short|Byte|Double|Float)");
        PRIMITIVE_COMPARE_TO = PatternBuilder.pattern("Int|Short|Byte|Double|Float|Char|String.compareTo");
    }

    static {
        new CompareToBOIF();
    }

    @KotlinClass(version={1, 0, 1}, abiVersion=32, data={"\u001f\u0015\tA\"A\u0003\u0002\u0019\u0005)\u0011\u0001B\u0001\u0006\u00031\tQ\u0001A\u0003\u0002\u0019\u0005)\u0011\u0001b\u0001\u0006\u00031\tA!Y\u0001\r\u0001e\t\u0001\u0014AQ\u0004\t\u0005\t6!\u0001\u0005\u0002KQ!1\u0002c\u0001\u000e\u0003a\u0011\u0011d\u0001E\u0003\u001b\u0005A2!G\u0002\t\b5\t\u0001DA\r\u0004\u0011\u0011i\u0011\u0001\u0007\u0002\u001a\u0007!%Q\"\u0001\r\u0006"}, strings={"Lorg/jetbrains/kotlin/js/translate/intrinsic/operation/CompareToBOIF$CompareToIntrinsic;", "Lorg/jetbrains/kotlin/js/translate/intrinsic/operation/AbstractBinaryOperationIntrinsic;", "()V", "apply", "Lorg/jetbrains/kotlin/relocated/com/google/dart/compiler/backend/js/ast/JsExpression;", "expression", "Lorg/jetbrains/kotlin/psi/KtBinaryExpression;", "left", "right", "context", "Lorg/jetbrains/kotlin/js/translate/context/TranslationContext;"}, moduleName="kotlin-compiler")
    private static final class CompareToIntrinsic
    extends AbstractBinaryOperationIntrinsic {
        public static final CompareToIntrinsic INSTANCE;
        public static final CompareToIntrinsic INSTANCE$;

        @Override
        @NotNull
        public JsExpression apply(@NotNull KtBinaryExpression expression, @NotNull JsExpression left, @NotNull JsExpression right, @NotNull TranslationContext context) {
            Intrinsics.checkParameterIsNotNull(expression, "expression");
            Intrinsics.checkParameterIsNotNull(left, "left");
            Intrinsics.checkParameterIsNotNull(right, "right");
            Intrinsics.checkParameterIsNotNull(context, "context");
            JsBinaryOperator operator = OperatorTable.getBinaryOperator(PsiUtils.getOperationToken(expression));
            return new JsBinaryOperation(operator, left, right);
        }

        private CompareToIntrinsic() {
            INSTANCE = this;
            INSTANCE$ = this;
        }

        static {
            new CompareToIntrinsic();
        }
    }

    @KotlinClass(version={1, 0, 1}, abiVersion=32, data={"\u001f\u0015\tA\"A\u0003\u0002\u0019\u0005)\u0011\u0001B\u0001\u0006\u00031\tQ\u0001A\u0003\u0002\u0019\u0005)\u0011\u0001b\u0001\u0006\u00031\tA!Y\u0001\r\u0001e\t\u0001\u0014AQ\u0004\t\u0005\t6!\u0001\u0005\u0002KQ!1\u0002c\u0001\u000e\u0003a\u0011\u0011d\u0001E\u0003\u001b\u0005A2!G\u0002\t\b5\t\u0001DA\r\u0004\u0011\u0011i\u0011\u0001\u0007\u0002\u001a\u0007!%Q\"\u0001\r\u0006"}, strings={"Lorg/jetbrains/kotlin/js/translate/intrinsic/operation/CompareToBOIF$CompareToCharIntrinsic;", "Lorg/jetbrains/kotlin/js/translate/intrinsic/operation/AbstractBinaryOperationIntrinsic;", "()V", "apply", "Lorg/jetbrains/kotlin/relocated/com/google/dart/compiler/backend/js/ast/JsExpression;", "expression", "Lorg/jetbrains/kotlin/psi/KtBinaryExpression;", "left", "right", "context", "Lorg/jetbrains/kotlin/js/translate/context/TranslationContext;"}, moduleName="kotlin-compiler")
    private static final class CompareToCharIntrinsic
    extends AbstractBinaryOperationIntrinsic {
        public static final CompareToCharIntrinsic INSTANCE;
        public static final CompareToCharIntrinsic INSTANCE$;

        @Override
        @NotNull
        public JsExpression apply(@NotNull KtBinaryExpression expression, @NotNull JsExpression left, @NotNull JsExpression right, @NotNull TranslationContext context) {
            Intrinsics.checkParameterIsNotNull(expression, "expression");
            Intrinsics.checkParameterIsNotNull(left, "left");
            Intrinsics.checkParameterIsNotNull(right, "right");
            Intrinsics.checkParameterIsNotNull(context, "context");
            JsBinaryOperator operator = OperatorTable.getBinaryOperator(PsiUtils.getOperationToken(expression));
            return new JsBinaryOperation(operator, left, JsAstUtils.charToInt(right));
        }

        private CompareToCharIntrinsic() {
            INSTANCE = this;
            INSTANCE$ = this;
        }

        static {
            new CompareToCharIntrinsic();
        }
    }

    @KotlinClass(version={1, 0, 1}, abiVersion=32, data={"\u001f\u0015\tA\"A\u0003\u0002\u0019\u0005)\u0011\u0001B\u0001\u0006\u00031\tQ\u0001A\u0003\u0002\u0019\u0005)\u0011\u0001b\u0001\u0006\u00031\tA!Y\u0001\r\u0001e\t\u0001\u0014AQ\u0004\t\u0005\t6!\u0001\u0005\u0002KQ!1\u0002c\u0001\u000e\u0003a\u0011\u0011d\u0001E\u0003\u001b\u0005A2!G\u0002\t\b5\t\u0001DA\r\u0004\u0011\u0011i\u0011\u0001\u0007\u0002\u001a\u0007!%Q\"\u0001\r\u0006"}, strings={"Lorg/jetbrains/kotlin/js/translate/intrinsic/operation/CompareToBOIF$CompareCharToPrimitiveIntrinsic;", "Lorg/jetbrains/kotlin/js/translate/intrinsic/operation/AbstractBinaryOperationIntrinsic;", "()V", "apply", "Lorg/jetbrains/kotlin/relocated/com/google/dart/compiler/backend/js/ast/JsExpression;", "expression", "Lorg/jetbrains/kotlin/psi/KtBinaryExpression;", "left", "right", "context", "Lorg/jetbrains/kotlin/js/translate/context/TranslationContext;"}, moduleName="kotlin-compiler")
    private static final class CompareCharToPrimitiveIntrinsic
    extends AbstractBinaryOperationIntrinsic {
        public static final CompareCharToPrimitiveIntrinsic INSTANCE;
        public static final CompareCharToPrimitiveIntrinsic INSTANCE$;

        @Override
        @NotNull
        public JsExpression apply(@NotNull KtBinaryExpression expression, @NotNull JsExpression left, @NotNull JsExpression right, @NotNull TranslationContext context) {
            Intrinsics.checkParameterIsNotNull(expression, "expression");
            Intrinsics.checkParameterIsNotNull(left, "left");
            Intrinsics.checkParameterIsNotNull(right, "right");
            Intrinsics.checkParameterIsNotNull(context, "context");
            JsBinaryOperator operator = OperatorTable.getBinaryOperator(PsiUtils.getOperationToken(expression));
            return new JsBinaryOperation(operator, JsAstUtils.charToInt(left), right);
        }

        private CompareCharToPrimitiveIntrinsic() {
            INSTANCE = this;
            INSTANCE$ = this;
        }

        static {
            new CompareCharToPrimitiveIntrinsic();
        }
    }

    @KotlinClass(version={1, 0, 1}, abiVersion=32, data={"\u001f\u0015\tA\"A\u0003\u0002\u0019\u0005)\u0011\u0001B\u0001\u0006\u00031\tQ\u0001A\u0003\u0002\u0019\u0005)\u0011\u0001b\u0001\u0006\u00031\tA!Y\u0001\r\u0001e\t\u0001\u0014AQ\u0004\t\u0005\t6!\u0001\u0005\u0002KQ!1\u0002c\u0001\u000e\u0003a\u0011\u0011d\u0001E\u0003\u001b\u0005A2!G\u0002\t\b5\t\u0001DA\r\u0004\u0011\u0011i\u0011\u0001\u0007\u0002\u001a\u0007!%Q\"\u0001\r\u0006"}, strings={"Lorg/jetbrains/kotlin/js/translate/intrinsic/operation/CompareToBOIF$CompareToFunctionIntrinsic;", "Lorg/jetbrains/kotlin/js/translate/intrinsic/operation/AbstractBinaryOperationIntrinsic;", "()V", "apply", "Lorg/jetbrains/kotlin/relocated/com/google/dart/compiler/backend/js/ast/JsExpression;", "expression", "Lorg/jetbrains/kotlin/psi/KtBinaryExpression;", "left", "right", "context", "Lorg/jetbrains/kotlin/js/translate/context/TranslationContext;"}, moduleName="kotlin-compiler")
    private static final class CompareToFunctionIntrinsic
    extends AbstractBinaryOperationIntrinsic {
        public static final CompareToFunctionIntrinsic INSTANCE;
        public static final CompareToFunctionIntrinsic INSTANCE$;

        @Override
        @NotNull
        public JsExpression apply(@NotNull KtBinaryExpression expression, @NotNull JsExpression left, @NotNull JsExpression right, @NotNull TranslationContext context) {
            Intrinsics.checkParameterIsNotNull(expression, "expression");
            Intrinsics.checkParameterIsNotNull(left, "left");
            Intrinsics.checkParameterIsNotNull(right, "right");
            Intrinsics.checkParameterIsNotNull(context, "context");
            JsBinaryOperator operator = OperatorTable.getBinaryOperator(PsiUtils.getOperationToken(expression));
            JsExpression compareTo = JsAstUtils.compareTo(left, right);
            return new JsBinaryOperation(operator, compareTo, JsNumberLiteral.ZERO);
        }

        private CompareToFunctionIntrinsic() {
            INSTANCE = this;
            INSTANCE$ = this;
        }

        static {
            new CompareToFunctionIntrinsic();
        }
    }
}

