/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.translate.expression;

import java.util.Iterator;
import java.util.List;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.js.descriptorUtils.DescriptorUtilsKt;
import org.jetbrains.kotlin.js.translate.context.TranslationContext;
import org.jetbrains.kotlin.js.translate.expression.PatternTranslator;
import org.jetbrains.kotlin.js.translate.general.AbstractTranslator;
import org.jetbrains.kotlin.js.translate.general.Translation;
import org.jetbrains.kotlin.js.translate.utils.JsAstUtils;
import org.jetbrains.kotlin.psi.KtCatchClause;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.relocated.com.google.dart.compiler.backend.js.ast.JsBlock;
import org.jetbrains.kotlin.relocated.com.google.dart.compiler.backend.js.ast.JsCatch;
import org.jetbrains.kotlin.relocated.com.google.dart.compiler.backend.js.ast.JsExpression;
import org.jetbrains.kotlin.relocated.com.google.dart.compiler.backend.js.ast.JsIf;
import org.jetbrains.kotlin.relocated.com.google.dart.compiler.backend.js.ast.JsName;
import org.jetbrains.kotlin.relocated.com.google.dart.compiler.backend.js.ast.JsNameRef;
import org.jetbrains.kotlin.relocated.com.google.dart.compiler.backend.js.ast.JsScope;
import org.jetbrains.kotlin.relocated.com.google.dart.compiler.backend.js.ast.JsStatement;
import org.jetbrains.kotlin.relocated.com.google.dart.compiler.backend.js.ast.JsThrow;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingContextUtils;
import org.jetbrains.kotlin.types.KotlinType;

@KotlinClass(version={1, 0, 1}, abiVersion=32, data={"E\u0015\tA\"A\u0003\u0002\u0019\u0005)\u0001!B\u0001\t!\u0015\tA\"A\u0003\u0001\u000b\u0005a\u0011!B\u0001\u0005\u0005\u0015\t\u00012B\u0003\u0002\u0019\u0005)\u0011\u0001B\u0001\u0006\u00031\tQ\u0001A\u0003\u0002\u0019\u0005)\u0011\u0001B\u0001\u0006\u00031\tQ\u0001A\u0003\u0002\u0019\u0005)\u0011\u0001\u0003\u000b\r\u0001e\t\u0001\u0014AQ\u000e\u0013\u0019A\u0011!\u0004\u0003\n\u0005%\t\u0001D\u0001M\u0002\u0013\rA)!D\u0001\u0019\u0007E\u001b\u0011\u0001c\u0002&\t!9QB\u0001G\u00011\u001f)C\u0002B\u0001\t\u00115\t\u0001\u0014C\r\u0004\u0011\u000bi\u0011\u0001G\u0002\u001a\u0007!IQ\"\u0001\r\u0003K=!\u0011\u0001c\u0005\u000e\u0003aQ\u0011d\u0001E\u000b\u001b\u0005A2\"\u0007\u0004\t\u00035!\u0011BA\u0005\u00021\tA:\"K\u0007\u0005\u0007\"A\u0011!\u0004\u0003\n\u0005%\t\u0001D\u0001M\u0002#\u000e!Q\u0001A\u0007\u0003\t\u0011AI!\u000b\u0007\u0005\u0003\"AQ!D\u0001\u0019\fU\t\u0001D\u0002\u000f\"#\u000e\u0019QB\u0001\u0003\u0006\u0011\u001b\u0001"}, strings={"Lorg/jetbrains/kotlin/js/translate/expression/CatchTranslator;", "Lorg/jetbrains/kotlin/js/translate/general/AbstractTranslator;", "catches", "", "Lorg/jetbrains/kotlin/psi/KtCatchClause;", "context", "Lorg/jetbrains/kotlin/js/translate/context/TranslationContext;", "(Ljava/util/List;Lorg/jetbrains/kotlin/js/translate/context/TranslationContext;)V", "getCatches", "()Ljava/util/List;", "isThrowable", "", "Lorg/jetbrains/kotlin/psi/KtTypeReference;", "(Lorg/jetbrains/kotlin/psi/KtTypeReference;)Z", "translate", "Lorg/jetbrains/kotlin/relocated/com/google/dart/compiler/backend/js/ast/JsCatch;", "translateCatchBody", "Lorg/jetbrains/kotlin/relocated/com/google/dart/compiler/backend/js/ast/JsBlock;", "catchClause", "translateCatches", "Lorg/jetbrains/kotlin/relocated/com/google/dart/compiler/backend/js/ast/JsStatement;", "parameterRef", "Lorg/jetbrains/kotlin/relocated/com/google/dart/compiler/backend/js/ast/JsNameRef;", ""}, moduleName="kotlin-compiler")
public final class CatchTranslator
extends AbstractTranslator {
    @NotNull
    private final List<KtCatchClause> catches;

    @Nullable
    public final JsCatch translate() {
        if (this.catches.isEmpty()) {
            return null;
        }
        KtCatchClause firstCatch = CollectionsKt.first(this.catches);
        KtParameter catchParameter = firstCatch.getCatchParameter();
        TranslationContext translationContext = this.context();
        KtParameter ktParameter = catchParameter;
        if (ktParameter == null) {
            Intrinsics.throwNpe();
        }
        JsName parameterName = translationContext.getNameForElement(ktParameter);
        JsNameRef parameterRef = parameterName.makeRef();
        JsScope jsScope = this.context().scope();
        String string = parameterRef.getIdent();
        JsNameRef jsNameRef = parameterRef;
        Intrinsics.checkExpressionValueIsNotNull(jsNameRef, "parameterRef");
        return new JsCatch(jsScope, string, this.translateCatches(jsNameRef, this.catches.iterator()));
    }

    /*
     * WARNING - void declaration
     */
    private final JsStatement translateCatches(JsNameRef parameterRef, Iterator<? extends KtCatchClause> catches) {
        void receiver$iv;
        if (!catches.hasNext()) {
            return new JsThrow(parameterRef);
        }
        KtCatchClause ktCatchClause = catches.next();
        KtParameter ktParameter = ktCatchClause.getCatchParameter();
        if (ktParameter == null) {
            Intrinsics.throwNpe();
        }
        KtParameter param = ktParameter;
        JsName paramName = this.context().getNameForElement(param);
        KtTypeReference ktTypeReference = param.getTypeReference();
        if (ktTypeReference == null) {
            Intrinsics.throwNpe();
        }
        KtTypeReference paramType = ktTypeReference;
        TranslationContext translationContext = this.context();
        Intrinsics.checkExpressionValueIsNotNull(translationContext, "context()");
        JsBlock thenBlock = this.translateCatchBody(translationContext, ktCatchClause);
        if (Intrinsics.areEqual(paramName.getIdent(), parameterRef.getIdent()) ^ true) {
            thenBlock.getStatements().add(0, JsAstUtils.newVar(paramName, parameterRef));
        }
        if (this.isThrowable(paramType)) {
            return thenBlock;
        }
        PatternTranslator patternTranslator = Translation.patternTranslator(this.context());
        PatternTranslator $receiver = (PatternTranslator)receiver$iv;
        JsExpression typeCheck2 = $receiver.translateIsCheck(parameterRef, paramType);
        JsStatement elseBlock = this.translateCatches(parameterRef, catches);
        return new JsIf(typeCheck2, thenBlock, elseBlock);
    }

    private final JsBlock translateCatchBody(TranslationContext context, KtCatchClause catchClause) {
        KtExpression catchBody = catchClause.getCatchBody();
        JsStatement jsCatchBody = catchBody != null ? Translation.translateAsStatementAndMergeInBlockIfNeeded(catchBody, context) : context.getEmptyExpression().makeStmt();
        JsBlock jsBlock = JsAstUtils.convertToBlock(jsCatchBody);
        Intrinsics.checkExpressionValueIsNotNull(jsBlock, "convertToBlock(jsCatchBody)");
        return jsBlock;
    }

    private final boolean isThrowable(KtTypeReference $receiver) {
        KotlinType jetType = (KotlinType)BindingContextUtils.getNotNull(this.bindingContext(), BindingContext.TYPE, $receiver);
        String jetTypeName = DescriptorUtilsKt.getJetTypeFqName(jetType, false);
        return Intrinsics.areEqual(jetTypeName, KotlinBuiltIns.FQ_NAMES.throwable.asString());
    }

    @NotNull
    public final List<KtCatchClause> getCatches() {
        return this.catches;
    }

    public CatchTranslator(@NotNull List<? extends KtCatchClause> catches, @NotNull TranslationContext context) {
        Intrinsics.checkParameterIsNotNull(catches, "catches");
        Intrinsics.checkParameterIsNotNull(context, "context");
        super(context);
        this.catches = catches;
    }
}

