/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.resolve.diagnostics;

import com.intellij.psi.PsiElement;
import java.util.Collection;
import java.util.List;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.kotlin.js.parser.ParserUtilsKt;
import org.jetbrains.kotlin.js.patterns.DescriptorPredicate;
import org.jetbrains.kotlin.js.patterns.PatternBuilder;
import org.jetbrains.kotlin.js.resolve.diagnostics.ErrorsJs;
import org.jetbrains.kotlin.js.resolve.diagnostics.JsCodeErrorReporter;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtValueArgument;
import org.jetbrains.kotlin.psi.KtValueArgumentList;
import org.jetbrains.kotlin.relocated.com.google.dart.compiler.backend.js.ast.JsFunctionScope;
import org.jetbrains.kotlin.relocated.com.google.dart.compiler.backend.js.ast.JsProgram;
import org.jetbrains.kotlin.relocated.com.google.dart.compiler.backend.js.ast.JsRootScope;
import org.jetbrains.kotlin.relocated.com.google.dart.compiler.backend.js.ast.JsStatement;
import org.jetbrains.kotlin.relocated.com.google.gwt.dev.js.parserExceptions.AbortParsingException;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.TemporaryBindingTrace;
import org.jetbrains.kotlin.resolve.calls.checkers.CallChecker;
import org.jetbrains.kotlin.resolve.calls.context.BasicCallResolutionContext;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.constants.CompileTimeConstant;
import org.jetbrains.kotlin.resolve.constants.ConstantValue;
import org.jetbrains.kotlin.resolve.constants.StringValue;
import org.jetbrains.kotlin.resolve.constants.TypedCompileTimeConstant;
import org.jetbrains.kotlin.resolve.constants.evaluate.ConstantExpressionEvaluator;
import org.jetbrains.kotlin.types.TypeUtils;

@KotlinClass(version={1, 0, 1}, abiVersion=32, data={"+\u0015\tA\"A\u0003\u0002\u0019\u0005)\u0001!B\u0001\r\u0003\u0015\tA!A\u0003\u0002\u0011\u0005)\u0001!B\u0001\r\u0003\u0015\u0001Q!\u0001\u0007\u0002\u000b\u0001)\u0011\u0001D\u0001\u0006\u00011\u0001\u0001SB\r\u00021\u0003i\nQBQ\u0007\u0013\rA\u0011!D\u0001\u0019\u0004E\u001b\u0011\u0001\u0003\u0002&)\u0011Y\u0001RA\u0007\u00021\r\tB\u0001\u0002\u0001\t\bU\t\u0001\u0004B\r\u0007\u0011\u0013iA!\u0003\u0002\n\u0003\u0011\u001e\u0001$B\r\u0004\u0011\u0017i\u0011\u0001\u0007\u0004*\u000f\u0011\t\u0005\u0002C\u0001\u000e\u0003a\r\u0011kA\u0001\u0006\u0001\u0001"}, strings={"Lorg/jetbrains/kotlin/js/resolve/diagnostics/JsCallChecker;", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallChecker;", "constantExpressionEvaluator", "Lorg/jetbrains/kotlin/resolve/constants/evaluate/ConstantExpressionEvaluator;", "(Lorg/jetbrains/kotlin/resolve/constants/evaluate/ConstantExpressionEvaluator;)V", "check", "", "F", "Lorg/jetbrains/kotlin/descriptors/CallableDescriptor;", "resolvedCall", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "context", "Lorg/jetbrains/kotlin/resolve/calls/context/BasicCallResolutionContext;", "Companion"}, moduleName="kotlin-compiler")
public final class JsCallChecker
implements CallChecker {
    private final ConstantExpressionEvaluator constantExpressionEvaluator;
    private static final DescriptorPredicate JS_PATTERN;
    public static final Companion Companion;

    /*
     * WARNING - void declaration
     */
    @Override
    public <F extends CallableDescriptor> void check(@NotNull ResolvedCall<F> resolvedCall, @NotNull BasicCallResolutionContext context) {
        Intrinsics.checkParameterIsNotNull(resolvedCall, "resolvedCall");
        Intrinsics.checkParameterIsNotNull(context, "context");
        if (context.isAnnotationContext || !Companion.isJsCall(resolvedCall)) {
            return;
        }
        KtElement expression = resolvedCall.getCall().getCallElement();
        if (!(expression instanceof KtCallExpression)) {
            return;
        }
        KtValueArgumentList ktValueArgumentList = ((KtCallExpression)expression).getValueArgumentList();
        List<KtValueArgument> arguments2 = ktValueArgumentList != null ? ktValueArgumentList.getArguments() : null;
        List<KtValueArgument> list = arguments2;
        if (list == null || (list = CollectionsKt.firstOrNull(list)) == null || (list = ((KtValueArgument)((Object)list)).getArgumentExpression()) == null) {
            return;
        }
        List<KtValueArgument> argument = list;
        TemporaryBindingTrace trace = TemporaryBindingTrace.create(context.trace, "JsCallChecker");
        List<KtValueArgument> list2 = argument;
        Intrinsics.checkExpressionValueIsNotNull(list2, "argument");
        BindingTrace bindingTrace = trace;
        Intrinsics.checkExpressionValueIsNotNull(bindingTrace, "trace");
        CompileTimeConstant<?> evaluationResult = this.constantExpressionEvaluator.evaluateExpression((KtExpression)((Object)list2), bindingTrace, TypeUtils.NO_EXPECTED_TYPE);
        String code = Companion.extractStringValue(evaluationResult);
        if (code == null) {
            context.trace.report(ErrorsJs.JSCODE_ARGUMENT_SHOULD_BE_CONSTANT.on((KtExpression)((PsiElement)((Object)argument))));
            return;
        }
        trace.commit();
        List<KtValueArgument> list3 = argument;
        Intrinsics.checkExpressionValueIsNotNull(list3, "argument");
        BindingTrace bindingTrace2 = context.trace;
        Intrinsics.checkExpressionValueIsNotNull(bindingTrace2, "context.trace");
        JsCodeErrorReporter errorReporter = new JsCodeErrorReporter((KtExpression)((Object)list3), code, bindingTrace2);
        try {
            void $receiver$iv;
            JsFunctionScope parserScope = new JsFunctionScope(new JsRootScope(new JsProgram("<js checker>")), "<js fun>");
            List<JsStatement> statements = ParserUtilsKt.parse(code, errorReporter, parserScope);
            Collection collection = statements;
            if ($receiver$iv.size() == 0) {
                context.trace.report(ErrorsJs.JSCODE_NO_JAVASCRIPT_PRODUCED.on((KtExpression)((PsiElement)((Object)argument))));
            }
        }
        catch (AbortParsingException e) {
            // empty catch block
        }
    }

    public JsCallChecker(@NotNull ConstantExpressionEvaluator constantExpressionEvaluator) {
        Intrinsics.checkParameterIsNotNull(constantExpressionEvaluator, "constantExpressionEvaluator");
        this.constantExpressionEvaluator = constantExpressionEvaluator;
    }

    static {
        Companion = org.jetbrains.kotlin.js.resolve.diagnostics.JsCallChecker$Companion.INSTANCE;
        DescriptorPredicate descriptorPredicate = PatternBuilder.pattern("kotlin.js.js(String)");
        Intrinsics.checkExpressionValueIsNotNull(descriptorPredicate, "PatternBuilder.pattern(\"kotlin.js.js(String)\")");
        JS_PATTERN = descriptorPredicate;
    }

    @JvmStatic
    public static final <F extends CallableDescriptor> boolean isJsCall(ResolvedCall<F> $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        return Companion.isJsCall($receiver);
    }

    @JvmStatic
    @Nullable
    public static final String extractStringValue(@Nullable CompileTimeConstant<?> compileTimeConstant) {
        return Companion.extractStringValue(compileTimeConstant);
    }

    @KotlinClass(version={1, 0, 1}, abiVersion=32, data={"/\u0015\tA\"A\u0003\u0002\u0011\u0001)\u0011\u0001B\u0001\u0006\u00031\tQ!\u0001C\u0002\u000b\u0005Aq!\u0002\u0001\u0006\u00031\tQ\u0001A\u0003\u0002\u0011\u0017)\u0001!B\u0001\r\u0003\u0015\tA\"\u0001\u0003D\u00041\u0001\u0011$\u0001M\u0001C\u000f!\u0011!U\u0002\u0002\u0011\u0005)C\u0002b\u0002\t\b5\u0011A\u0012\u0001\r\u00053\u0019AI!\u0004\u0003\n\u0003\u0011\rA\u0012\u0001\r\u0006K=!9\u0001c\u0003\u000e\u0003a1\u0011#\u0002\u0003\u0001\u0011\u001b)\"\u0001$\u0001\u0019\u000fU!\u0011BA\u0005\u0002I\u001bAz!K\u0006\u0005\u0003\"A\u0019!D\u0001\u0019\u0005E\u001bQ!B\u0001\r\u00025\u0011AQ\u0001\u0005\u0004"}, strings={"Lorg/jetbrains/kotlin/js/resolve/diagnostics/JsCallChecker$Companion;", "", "()V", "JS_PATTERN", "Lorg/jetbrains/kotlin/js/patterns/DescriptorPredicate;", "getJS_PATTERN", "()Lorg/jetbrains/kotlin/js/patterns/DescriptorPredicate;", "extractStringValue", "", "compileTimeConstant", "Lorg/jetbrains/kotlin/resolve/constants/CompileTimeConstant;", "isJsCall", "", "F", "Lorg/jetbrains/kotlin/descriptors/CallableDescriptor;", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;"}, moduleName="kotlin-compiler")
    public static final class Companion {
        public static final Companion INSTANCE;

        private final DescriptorPredicate getJS_PATTERN() {
            return JS_PATTERN;
        }

        @JvmStatic
        public final <F extends CallableDescriptor> boolean isJsCall(ResolvedCall<F> $receiver) {
            Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
            F descriptor2 = $receiver.getResultingDescriptor();
            return descriptor2 instanceof SimpleFunctionDescriptor && this.getJS_PATTERN().apply((FunctionDescriptor)descriptor2);
        }

        @JvmStatic
        @Nullable
        public final String extractStringValue(@Nullable CompileTimeConstant<?> compileTimeConstant) {
            CompileTimeConstant<?> compileTimeConstant2 = compileTimeConstant;
            if (!(compileTimeConstant2 instanceof TypedCompileTimeConstant)) {
                compileTimeConstant2 = null;
            }
            TypedCompileTimeConstant typedCompileTimeConstant = (TypedCompileTimeConstant)compileTimeConstant2;
            ConstantValue constantValue = typedCompileTimeConstant != null ? typedCompileTimeConstant.getConstantValue() : null;
            if (!(constantValue instanceof StringValue)) {
                constantValue = null;
            }
            StringValue stringValue = (StringValue)constantValue;
            return stringValue != null ? (String)stringValue.getValue() : null;
        }

        private Companion() {
            INSTANCE = this;
        }

        static {
            new Companion();
        }
    }
}

