/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen.inline;

import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.org.objectweb.asm.commons.Remapper;

public class TypeRemapper
extends Remapper {
    private final Map<String, String> typeMapping;
    private Map<String, String> additionalMappings;

    private TypeRemapper(@NotNull Map<String, String> typeMapping) {
        if (typeMapping == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeMapping", "org/jetbrains/kotlin/codegen/inline/TypeRemapper", "<init>"));
        }
        this.typeMapping = typeMapping;
    }

    public TypeRemapper(@NotNull TypeRemapper remapper, @NotNull Map<String, String> newTypeMappings) {
        if (remapper == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "remapper", "org/jetbrains/kotlin/codegen/inline/TypeRemapper", "<init>"));
        }
        if (newTypeMappings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newTypeMappings", "org/jetbrains/kotlin/codegen/inline/TypeRemapper", "<init>"));
        }
        this(TypeRemapper.createNewAndMerge(remapper, newTypeMappings));
    }

    public static TypeRemapper createEmpty() {
        return new TypeRemapper(new HashMap<String, String>());
    }

    public static TypeRemapper createFrom(Map<String, String> mappings) {
        return new TypeRemapper(mappings);
    }

    @NotNull
    private static Map<String, String> createNewAndMerge(@NotNull TypeRemapper remapper, @NotNull Map<String, String> additionalTypeMappings) {
        if (remapper == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "remapper", "org/jetbrains/kotlin/codegen/inline/TypeRemapper", "createNewAndMerge"));
        }
        if (additionalTypeMappings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "additionalTypeMappings", "org/jetbrains/kotlin/codegen/inline/TypeRemapper", "createNewAndMerge"));
        }
        HashMap<String, String> map2 = new HashMap<String, String>(remapper.typeMapping);
        map2.putAll(additionalTypeMappings);
        HashMap<String, String> hashMap = map2;
        if (hashMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/inline/TypeRemapper", "createNewAndMerge"));
        }
        return hashMap;
    }

    public void addMapping(String type2, String newType) {
        this.typeMapping.put(type2, newType);
    }

    public boolean hasNoAdditionalMapping(String type2) {
        return this.typeMapping.containsKey(type2);
    }

    @Override
    public String map(String type2) {
        String newType = this.typeMapping.get(type2);
        if (newType != null) {
            return newType;
        }
        if (this.additionalMappings != null && (newType = this.additionalMappings.get(type2)) != null) {
            return newType;
        }
        return type2;
    }

    public void addAdditionalMappings(String oldName, String newName) {
        if (this.additionalMappings == null) {
            this.additionalMappings = new HashMap<String, String>();
        }
        this.additionalMappings.put(oldName, newName);
    }
}

