/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl;

import com.intellij.openapi.application.ReadActionProcessor;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.FileIndexFacade;
import com.intellij.openapi.roots.PackageIndex;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaDirectoryService;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassOwner;
import com.intellij.psi.PsiClassOwnerEx;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElementFinder;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.impl.file.impl.JavaFileManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.stubs.StubTreeLoader;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.HashMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsiElementFinderImpl
extends PsiElementFinder
implements DumbAware {
    private final Project myProject;
    private final JavaFileManager myFileManager;

    public PsiElementFinderImpl(Project project, JavaFileManager javaFileManager) {
        this.myProject = project;
        this.myFileManager = javaFileManager;
    }

    @Override
    public PsiClass findClass(@NotNull String qualifiedName, @NotNull GlobalSearchScope scope2) {
        if (qualifiedName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qualifiedName", "com/intellij/psi/impl/PsiElementFinderImpl", "findClass"));
        }
        if (scope2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/psi/impl/PsiElementFinderImpl", "findClass"));
        }
        return this.myFileManager.findClass(qualifiedName, scope2);
    }

    @Override
    @NotNull
    public PsiClass[] findClasses(@NotNull String qualifiedName, @NotNull GlobalSearchScope scope2) {
        if (qualifiedName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qualifiedName", "com/intellij/psi/impl/PsiElementFinderImpl", "findClasses"));
        }
        if (scope2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/psi/impl/PsiElementFinderImpl", "findClasses"));
        }
        PsiClass[] psiClassArray = this.myFileManager.findClasses(qualifiedName, scope2);
        if (psiClassArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/PsiElementFinderImpl", "findClasses"));
        }
        return psiClassArray;
    }

    @Override
    public PsiPackage findPackage(@NotNull String qualifiedName) {
        if (qualifiedName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qualifiedName", "com/intellij/psi/impl/PsiElementFinderImpl", "findPackage"));
        }
        return this.myFileManager.findPackage(qualifiedName);
    }

    @Override
    @NotNull
    public PsiPackage[] getSubPackages(@NotNull PsiPackage psiPackage, @NotNull GlobalSearchScope scope2) {
        if (psiPackage == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiPackage", "com/intellij/psi/impl/PsiElementFinderImpl", "getSubPackages"));
        }
        if (scope2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/psi/impl/PsiElementFinderImpl", "getSubPackages"));
        }
        HashMap<String, PsiPackage> packagesMap = new HashMap<String, PsiPackage>();
        String qualifiedName = psiPackage.getQualifiedName();
        for (PsiDirectory dir : psiPackage.getDirectories(scope2)) {
            PsiDirectory[] subDirs;
            for (PsiDirectory subDir : subDirs = dir.getSubdirectories()) {
                String subQualifiedName;
                PsiPackage aPackage = JavaDirectoryService.getInstance().getPackage(subDir);
                if (aPackage == null || !(subQualifiedName = aPackage.getQualifiedName()).startsWith(qualifiedName) || packagesMap.containsKey(subQualifiedName)) continue;
                packagesMap.put(aPackage.getQualifiedName(), aPackage);
            }
        }
        packagesMap.remove(qualifiedName);
        PsiPackage[] psiPackageArray = packagesMap.values().toArray(new PsiPackage[packagesMap.size()]);
        if (psiPackageArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/PsiElementFinderImpl", "getSubPackages"));
        }
        return psiPackageArray;
    }

    @Override
    @NotNull
    public PsiClass[] getClasses(@NotNull PsiPackage psiPackage, @NotNull GlobalSearchScope scope2) {
        if (psiPackage == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiPackage", "com/intellij/psi/impl/PsiElementFinderImpl", "getClasses"));
        }
        if (scope2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/psi/impl/PsiElementFinderImpl", "getClasses"));
        }
        PsiClass[] psiClassArray = this.getClasses(null, psiPackage, scope2);
        if (psiClassArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/PsiElementFinderImpl", "getClasses"));
        }
        return psiClassArray;
    }

    @Override
    @NotNull
    public PsiClass[] getClasses(@Nullable String shortName, @NotNull PsiPackage psiPackage, final @NotNull GlobalSearchScope scope2) {
        if (psiPackage == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiPackage", "com/intellij/psi/impl/PsiElementFinderImpl", "getClasses"));
        }
        if (scope2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/psi/impl/PsiElementFinderImpl", "getClasses"));
        }
        ArrayList<PsiClass> list = null;
        String packageName = psiPackage.getQualifiedName();
        for (PsiDirectory dir : psiPackage.getDirectories(scope2)) {
            PsiClass[] classes2 = JavaDirectoryService.getInstance().getClasses(dir);
            if (classes2.length == 0) continue;
            if (list == null) {
                list = new ArrayList<PsiClass>();
            }
            for (PsiClass aClass2 : classes2) {
                String qualifiedName = aClass2.getQualifiedName();
                if (qualifiedName != null) {
                    qualifiedName = StringUtil.getPackageName(qualifiedName);
                }
                if (!Comparing.strEqual(qualifiedName, packageName) || shortName != null && !shortName.equals(aClass2.getName())) continue;
                list.add(aClass2);
            }
        }
        if (list == null) {
            if (PsiClass.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/PsiElementFinderImpl", "getClasses"));
            }
            return PsiClass.EMPTY_ARRAY;
        }
        if (list.size() > 1) {
            ContainerUtil.quickSort(list, new Comparator<PsiClass>(){

                @Override
                public int compare(PsiClass o1, PsiClass o2) {
                    VirtualFile file1 = PsiUtilCore.getVirtualFile(o1);
                    VirtualFile file2 = PsiUtilCore.getVirtualFile(o2);
                    return file1 == null ? (file2 == null ? 0 : -1) : (file2 == null ? 1 : scope2.compare(file2, file1));
                }
            });
        }
        PsiClass[] psiClassArray = list.toArray(new PsiClass[list.size()]);
        if (psiClassArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/PsiElementFinderImpl", "getClasses"));
        }
        return psiClassArray;
    }

    @Override
    @NotNull
    public Set<String> getClassNames(@NotNull PsiPackage psiPackage, @NotNull GlobalSearchScope scope2) {
        if (psiPackage == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiPackage", "com/intellij/psi/impl/PsiElementFinderImpl", "getClassNames"));
        }
        if (scope2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/psi/impl/PsiElementFinderImpl", "getClassNames"));
        }
        HashSet<String> names2 = null;
        FileIndexFacade facade = FileIndexFacade.getInstance(this.myProject);
        for (PsiDirectory dir : psiPackage.getDirectories(scope2)) {
            for (PsiFile file : dir.getFiles()) {
                Set<String> inFile;
                VirtualFile vFile;
                if (!(file instanceof PsiClassOwner) || file.getViewProvider().getLanguages().size() != 1 || (vFile = file.getVirtualFile()) != null && !(file instanceof PsiCompiledElement) && !facade.isInSourceContent(vFile) && (!scope2.isForceSearchingInLibrarySources() || !StubTreeLoader.getInstance().canHaveStub(vFile))) continue;
                Set<String> set = inFile = file instanceof PsiClassOwnerEx ? ((PsiClassOwnerEx)file).getClassNames() : PsiElementFinderImpl.getClassNames(((PsiClassOwner)file).getClasses());
                if (inFile.isEmpty()) continue;
                if (names2 == null) {
                    names2 = new HashSet<String>();
                }
                names2.addAll(inFile);
            }
        }
        Set<String> set = names2 == null ? Collections.emptySet() : names2;
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/PsiElementFinderImpl", "getClassNames"));
        }
        return set;
    }

    @Override
    public boolean processPackageDirectories(@NotNull PsiPackage psiPackage, final @NotNull GlobalSearchScope scope2, final @NotNull Processor<PsiDirectory> consumer, boolean includeLibrarySources) {
        if (psiPackage == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiPackage", "com/intellij/psi/impl/PsiElementFinderImpl", "processPackageDirectories"));
        }
        if (scope2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/psi/impl/PsiElementFinderImpl", "processPackageDirectories"));
        }
        if (consumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/intellij/psi/impl/PsiElementFinderImpl", "processPackageDirectories"));
        }
        final PsiManager psiManager = PsiManager.getInstance(this.myProject);
        return PackageIndex.getInstance(this.myProject).getDirsByPackageName(psiPackage.getQualifiedName(), includeLibrarySources).forEach((Processor<VirtualFile>)new ReadActionProcessor<VirtualFile>(){

            @Override
            public boolean processInReadAction(VirtualFile dir) {
                if (!scope2.contains(dir)) {
                    return true;
                }
                PsiDirectory psiDir = psiManager.findDirectory(dir);
                return psiDir == null || consumer.process(psiDir);
            }
        });
    }
}

