/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.types.expressions;

import com.intellij.psi.PsiElement;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtExpressionWithLabel;
import org.jetbrains.kotlin.psi.KtFunctionLiteral;
import org.jetbrains.kotlin.psi.KtInstanceExpressionWithLabel;
import org.jetbrains.kotlin.psi.KtLabeledExpression;
import org.jetbrains.kotlin.psi.KtLambdaArgument;
import org.jetbrains.kotlin.psi.KtLambdaExpression;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtPsiUtil;
import org.jetbrains.kotlin.psi.KtReferenceExpression;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.KtValueArgument;
import org.jetbrains.kotlin.relocated.com.google.common.collect.Sets;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingContextUtils;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.DescriptorResolver;
import org.jetbrains.kotlin.resolve.DescriptorToSourceUtils;
import org.jetbrains.kotlin.resolve.calls.context.ResolutionContext;
import org.jetbrains.kotlin.resolve.scopes.utils.ScopeUtilsKt;

public class LabelResolver {
    public static LabelResolver INSTANCE = new LabelResolver();

    private LabelResolver() {
    }

    @NotNull
    private Set<KtElement> getElementsByLabelName(@NotNull Name labelName, @NotNull KtSimpleNameExpression labelExpression) {
        if (labelName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "labelName", "org/jetbrains/kotlin/types/expressions/LabelResolver", "getElementsByLabelName"));
        }
        if (labelExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "labelExpression", "org/jetbrains/kotlin/types/expressions/LabelResolver", "getElementsByLabelName"));
        }
        LinkedHashSet<KtElement> elements = Sets.newLinkedHashSet();
        for (PsiElement parent2 = labelExpression.getParent(); parent2 != null; parent2 = parent2.getParent()) {
            Name name = this.getLabelNameIfAny(parent2);
            if (name == null || !name.equals(labelName)) continue;
            elements.add(this.getExpressionUnderLabel((KtExpression)parent2));
        }
        LinkedHashSet<KtElement> linkedHashSet = elements;
        if (linkedHashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/types/expressions/LabelResolver", "getElementsByLabelName"));
        }
        return linkedHashSet;
    }

    @Nullable
    public Name getLabelNameIfAny(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/kotlin/types/expressions/LabelResolver", "getLabelNameIfAny"));
        }
        if (element instanceof KtLabeledExpression) {
            return ((KtLabeledExpression)element).getLabelNameAsName();
        }
        if (element instanceof KtFunctionLiteral) {
            return this.getLabelNameIfAny(element.getParent());
        }
        if (element instanceof KtLambdaExpression) {
            return this.getLabelForFunctionalExpression((KtExpression)element);
        }
        if (element instanceof KtNamedFunction) {
            Name name = ((KtNamedFunction)element).getNameAsName();
            if (name != null) {
                return name;
            }
            return this.getLabelForFunctionalExpression((KtExpression)element);
        }
        return null;
    }

    private Name getLabelForFunctionalExpression(@NotNull KtExpression element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/kotlin/types/expressions/LabelResolver", "getLabelForFunctionalExpression"));
        }
        if (element.getParent() instanceof KtLabeledExpression) {
            return this.getLabelNameIfAny(element.getParent());
        }
        return this.getCallerName(element);
    }

    @NotNull
    private KtExpression getExpressionUnderLabel(@NotNull KtExpression labeledExpression) {
        if (labeledExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "labeledExpression", "org/jetbrains/kotlin/types/expressions/LabelResolver", "getExpressionUnderLabel"));
        }
        KtExpression expression = KtPsiUtil.safeDeparenthesize(labeledExpression);
        if (expression instanceof KtLambdaExpression) {
            KtFunctionLiteral ktFunctionLiteral = ((KtLambdaExpression)expression).getFunctionLiteral();
            if (ktFunctionLiteral == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/types/expressions/LabelResolver", "getExpressionUnderLabel"));
            }
            return ktFunctionLiteral;
        }
        KtExpression ktExpression = expression;
        if (ktExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/types/expressions/LabelResolver", "getExpressionUnderLabel"));
        }
        return ktExpression;
    }

    @Nullable
    private Name getCallerName(@NotNull KtExpression expression) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/types/expressions/LabelResolver", "getCallerName"));
        }
        KtCallExpression callExpression = this.getContainingCallExpression(expression);
        if (callExpression == null) {
            return null;
        }
        KtExpression calleeExpression = callExpression.getCalleeExpression();
        if (calleeExpression instanceof KtSimpleNameExpression) {
            KtSimpleNameExpression nameExpression = (KtSimpleNameExpression)calleeExpression;
            return nameExpression.getReferencedNameAsName();
        }
        return null;
    }

    @Nullable
    private KtCallExpression getContainingCallExpression(@NotNull KtExpression expression) {
        PsiElement call;
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/types/expressions/LabelResolver", "getContainingCallExpression"));
        }
        PsiElement parent2 = expression.getParent();
        if (parent2 instanceof KtLambdaArgument && (call = parent2.getParent()) instanceof KtCallExpression) {
            return (KtCallExpression)call;
        }
        if (parent2 instanceof KtValueArgument) {
            KtValueArgument argument = (KtValueArgument)parent2;
            PsiElement argList = argument.getParent();
            if (argList == null) {
                return null;
            }
            PsiElement call2 = argList.getParent();
            if (call2 instanceof KtCallExpression) {
                return (KtCallExpression)call2;
            }
        }
        return null;
    }

    @Nullable
    public KtElement resolveControlLabel(@NotNull KtExpressionWithLabel expression, @NotNull ResolutionContext context) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/types/expressions/LabelResolver", "resolveControlLabel"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/types/expressions/LabelResolver", "resolveControlLabel"));
        }
        KtSimpleNameExpression labelElement = expression.getTargetLabel();
        Name labelName = expression.getLabelNameAsName();
        if (labelElement == null || labelName == null) {
            return null;
        }
        Collection<DeclarationDescriptor> declarationsByLabel = ScopeUtilsKt.getDeclarationsByLabel(context.scope, labelName);
        int size = declarationsByLabel.size();
        if (size > 1) {
            BindingContextUtils.reportAmbiguousLabel(context.trace, labelElement, declarationsByLabel);
            return null;
        }
        if (size == 0) {
            KtElement element = this.resolveNamedLabel(labelName, labelElement, context.trace);
            if (element == null) {
                context.trace.report(Errors.UNRESOLVED_REFERENCE.on(labelElement, labelElement));
            }
            return element;
        }
        DeclarationDescriptor declarationDescriptor = declarationsByLabel.iterator().next();
        if (!(declarationDescriptor instanceof FunctionDescriptor) && !(declarationDescriptor instanceof ClassDescriptor)) {
            throw new UnsupportedOperationException(declarationDescriptor.getClass().toString());
        }
        KtElement element = (KtElement)DescriptorToSourceUtils.descriptorToDeclaration(declarationDescriptor);
        context.trace.record(BindingContext.LABEL_TARGET, labelElement, element);
        return element;
    }

    private KtElement resolveNamedLabel(@NotNull Name labelName, @NotNull KtSimpleNameExpression labelExpression, @NotNull BindingTrace trace) {
        if (labelName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "labelName", "org/jetbrains/kotlin/types/expressions/LabelResolver", "resolveNamedLabel"));
        }
        if (labelExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "labelExpression", "org/jetbrains/kotlin/types/expressions/LabelResolver", "resolveNamedLabel"));
        }
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/kotlin/types/expressions/LabelResolver", "resolveNamedLabel"));
        }
        Set<KtElement> list = this.getElementsByLabelName(labelName, labelExpression);
        if (list.isEmpty()) {
            return null;
        }
        if (list.size() > 1) {
            trace.report(Errors.LABEL_NAME_CLASH.on(labelExpression));
        }
        KtElement result2 = list.iterator().next();
        trace.record(BindingContext.LABEL_TARGET, labelExpression, result2);
        return result2;
    }

    @NotNull
    public LabeledReceiverResolutionResult resolveThisOrSuperLabel(@NotNull KtInstanceExpressionWithLabel expression, @NotNull ResolutionContext context, @NotNull Name labelName) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/types/expressions/LabelResolver", "resolveThisOrSuperLabel"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/types/expressions/LabelResolver", "resolveThisOrSuperLabel"));
        }
        if (labelName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "labelName", "org/jetbrains/kotlin/types/expressions/LabelResolver", "resolveThisOrSuperLabel"));
        }
        KtReferenceExpression referenceExpression = expression.getInstanceReference();
        KtSimpleNameExpression targetLabel = expression.getTargetLabel();
        assert (targetLabel != null) : expression;
        Collection<DeclarationDescriptor> declarationsByLabel = ScopeUtilsKt.getDeclarationsByLabel(context.scope, labelName);
        int size = declarationsByLabel.size();
        if (size == 1) {
            ClassDescriptor classDescriptor;
            ReceiverParameterDescriptor thisReceiver;
            DeclarationDescriptor declarationDescriptor = declarationsByLabel.iterator().next();
            if (declarationDescriptor instanceof ClassDescriptor) {
                ClassDescriptor classDescriptor2 = (ClassDescriptor)declarationDescriptor;
                thisReceiver = classDescriptor2.getThisAsReceiverParameter();
            } else if (declarationDescriptor instanceof FunctionDescriptor) {
                FunctionDescriptor functionDescriptor = (FunctionDescriptor)declarationDescriptor;
                thisReceiver = functionDescriptor.getExtensionReceiverParameter();
            } else if (declarationDescriptor instanceof PropertyDescriptor) {
                PropertyDescriptor propertyDescriptor = (PropertyDescriptor)declarationDescriptor;
                thisReceiver = propertyDescriptor.getExtensionReceiverParameter();
            } else {
                throw new UnsupportedOperationException("Unsupported descriptor: " + declarationDescriptor);
            }
            PsiElement element = DescriptorToSourceUtils.descriptorToDeclaration(declarationDescriptor);
            assert (element != null) : "No PSI element for descriptor: " + declarationDescriptor;
            context.trace.record(BindingContext.LABEL_TARGET, targetLabel, element);
            context.trace.record(BindingContext.REFERENCE_TARGET, referenceExpression, declarationDescriptor);
            if (declarationDescriptor instanceof ClassDescriptor && !DescriptorResolver.checkHasOuterClassInstance(context.scope, context.trace, targetLabel, classDescriptor = (ClassDescriptor)declarationDescriptor)) {
                LabeledReceiverResolutionResult labeledReceiverResolutionResult = LabeledReceiverResolutionResult.labelResolutionFailed();
                if (labeledReceiverResolutionResult == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/types/expressions/LabelResolver", "resolveThisOrSuperLabel"));
                }
                return labeledReceiverResolutionResult;
            }
            LabeledReceiverResolutionResult labeledReceiverResolutionResult = LabeledReceiverResolutionResult.labelResolutionSuccess(thisReceiver);
            if (labeledReceiverResolutionResult == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/types/expressions/LabelResolver", "resolveThisOrSuperLabel"));
            }
            return labeledReceiverResolutionResult;
        }
        if (size == 0) {
            KtElement element = this.resolveNamedLabel(labelName, targetLabel, context.trace);
            if (element instanceof KtFunctionLiteral) {
                DeclarationDescriptor declarationDescriptor = context.trace.getBindingContext().get(BindingContext.DECLARATION_TO_DESCRIPTOR, element);
                if (declarationDescriptor instanceof FunctionDescriptor) {
                    ReceiverParameterDescriptor thisReceiver = ((FunctionDescriptor)declarationDescriptor).getExtensionReceiverParameter();
                    if (thisReceiver != null) {
                        context.trace.record(BindingContext.LABEL_TARGET, targetLabel, element);
                        context.trace.record(BindingContext.REFERENCE_TARGET, referenceExpression, declarationDescriptor);
                    }
                    LabeledReceiverResolutionResult labeledReceiverResolutionResult = LabeledReceiverResolutionResult.labelResolutionSuccess(thisReceiver);
                    if (labeledReceiverResolutionResult == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/types/expressions/LabelResolver", "resolveThisOrSuperLabel"));
                    }
                    return labeledReceiverResolutionResult;
                }
                context.trace.report(Errors.UNRESOLVED_REFERENCE.on(targetLabel, targetLabel));
            } else {
                context.trace.report(Errors.UNRESOLVED_REFERENCE.on(targetLabel, targetLabel));
            }
        } else {
            BindingContextUtils.reportAmbiguousLabel(context.trace, targetLabel, declarationsByLabel);
        }
        LabeledReceiverResolutionResult labeledReceiverResolutionResult = LabeledReceiverResolutionResult.labelResolutionFailed();
        if (labeledReceiverResolutionResult == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/types/expressions/LabelResolver", "resolveThisOrSuperLabel"));
        }
        return labeledReceiverResolutionResult;
    }

    public static final class LabeledReceiverResolutionResult {
        private final Code code;
        private final ReceiverParameterDescriptor receiverParameterDescriptor;

        public static LabeledReceiverResolutionResult labelResolutionSuccess(@Nullable ReceiverParameterDescriptor receiverParameterDescriptor) {
            if (receiverParameterDescriptor == null) {
                return new LabeledReceiverResolutionResult(Code.NO_THIS, null);
            }
            return new LabeledReceiverResolutionResult(Code.SUCCESS, receiverParameterDescriptor);
        }

        public static LabeledReceiverResolutionResult labelResolutionFailed() {
            return new LabeledReceiverResolutionResult(Code.LABEL_RESOLUTION_ERROR, null);
        }

        private LabeledReceiverResolutionResult(Code code, ReceiverParameterDescriptor receiverParameterDescriptor) {
            this.code = code;
            this.receiverParameterDescriptor = receiverParameterDescriptor;
        }

        public Code getCode() {
            return this.code;
        }

        public boolean success() {
            return this.code == Code.SUCCESS;
        }

        public ReceiverParameterDescriptor getReceiverParameterDescriptor() {
            assert (this.success()) : "Don't try to obtain the receiver when resolution failed with " + (Object)((Object)this.code);
            return this.receiverParameterDescriptor;
        }

        public static enum Code {
            LABEL_RESOLUTION_ERROR,
            NO_THIS,
            SUCCESS;

        }
    }
}

