/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.jvm.checkers;

import com.intellij.psi.PsiElement;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.ModalityKt;
import org.jetbrains.kotlin.descriptors.PackageFragmentDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.kotlin.diagnostics.DiagnosticSink;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtAnnotationEntry;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.DeclarationChecker;
import org.jetbrains.kotlin.resolve.DescriptorToSourceUtils;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.jvm.diagnostics.ErrorsJvm;

@KotlinClass(version={1, 0, 1}, abiVersion=32, data={";\u0015\tA\"A\u0003\u0002\u0019\u0005)\u0011\u0001B\u0001\u0006\u0003!\tQ\u0001A\u0003\u0002\u0019\u0005)\u0001!B\u0001\r\u0003\u0015\u0001Q!\u0001\u0007\u0002\u000b\u0001)\u0011\u0001D\u0001\u0006\u0003\u0011\tQ!\u0001\u0007\u0002\u000b\u0001)\u0011\u0001c\u0003\u0006\u00031\tA\u0002A\r\u00021\u0003\t+!U\u0002\u0002\u0011\u0005)C\u0003B\u0006\t\u00045\t\u0001DA\r\u0004\u0011\u000bi\u0011\u0001G\u0002\u001a\u0007!\u001dQ\"\u0001\r\u00053\rAI!D\u0001\u0019\u000be\u0019\u00012B\u0007\u00021\u0019)\u0003\u0003B\u0001\t\u000e5\t\u0001DA\r\u0004\u0011\u000fi\u0011\u0001\u0007\u0003\u001a\u0007!9Q\"\u0001M\b3\rAI!D\u0001\u0019\u000b\u0015BA!\u0001\u0005\t\u001b\u0005A\n\"G\u0002\t\b5\t\u0001$\u0003"}, strings={"Lorg/jetbrains/kotlin/resolve/jvm/checkers/JvmNameAnnotationChecker;", "Lorg/jetbrains/kotlin/resolve/DeclarationChecker;", "()V", "check", "", "declaration", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "descriptor", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "diagnosticHolder", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticSink;", "bindingContext", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "checkDeclaration", "annotation", "Lorg/jetbrains/kotlin/descriptors/annotations/AnnotationDescriptor;", "isRenamableFunction", "", "Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;"}, moduleName="kotlin-compiler")
public final class JvmNameAnnotationChecker
implements DeclarationChecker {
    @Override
    public void check(@NotNull KtDeclaration declaration, @NotNull DeclarationDescriptor descriptor2, @NotNull DiagnosticSink diagnosticHolder, @NotNull BindingContext bindingContext2) {
        Intrinsics.checkParameterIsNotNull(declaration, "declaration");
        Intrinsics.checkParameterIsNotNull(descriptor2, "descriptor");
        Intrinsics.checkParameterIsNotNull(diagnosticHolder, "diagnosticHolder");
        Intrinsics.checkParameterIsNotNull(bindingContext2, "bindingContext");
        AnnotationDescriptor platformNameAnnotation = DescriptorUtils.getJvmNameAnnotation(descriptor2);
        if (platformNameAnnotation != null) {
            this.checkDeclaration(descriptor2, platformNameAnnotation, diagnosticHolder);
        }
    }

    private final void checkDeclaration(DeclarationDescriptor descriptor2, AnnotationDescriptor annotation2, DiagnosticSink diagnosticHolder) {
        DeclarationDescriptor callableMemberDescriptor;
        String value;
        KtAnnotationEntry ktAnnotationEntry = DescriptorToSourceUtils.getSourceFromAnnotation(annotation2);
        if (ktAnnotationEntry == null) {
            return;
        }
        KtAnnotationEntry annotationEntry = ktAnnotationEntry;
        if (descriptor2 instanceof FunctionDescriptor && !this.isRenamableFunction((FunctionDescriptor)descriptor2)) {
            diagnosticHolder.report(ErrorsJvm.INAPPLICABLE_JVM_NAME.on(annotationEntry));
        }
        if ((value = DescriptorUtils.getJvmName(descriptor2)) == null || !Name.isValidIdentifier(value)) {
            diagnosticHolder.report(ErrorsJvm.ILLEGAL_JVM_NAME.on((KtAnnotationEntry)((PsiElement)annotationEntry)));
        }
        if (descriptor2 instanceof CallableMemberDescriptor && (DescriptorUtils.isOverride((CallableMemberDescriptor)(callableMemberDescriptor = descriptor2)) || ModalityKt.isOverridable((CallableMemberDescriptor)callableMemberDescriptor))) {
            diagnosticHolder.report(ErrorsJvm.INAPPLICABLE_JVM_NAME.on(annotationEntry));
        }
    }

    private final boolean isRenamableFunction(FunctionDescriptor descriptor2) {
        DeclarationDescriptor containingDescriptor = descriptor2.getContainingDeclaration();
        return containingDescriptor instanceof PackageFragmentDescriptor || containingDescriptor instanceof ClassDescriptor;
    }
}

