/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.constants;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.Annotations;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.TypeConstructor;

@KotlinClass(version={1, 0, 1}, abiVersion=32, data={"W\u0015\tA\"A\u0003\u0002\u0019\u0005)\u0001!B\u0001\t\n\u0015\u0001Q!\u0001\u0007\u0002\u000b\u0005!\u0011!B\u0001\r\u0003\u0015\tA\"A\u0003\u0001\u000b\u0005A\u0011!B\u0001\u0005\u0005\u0015\tA\"A\u0003\u0002\t\u0005)\u0011\u0001#\u0001\u0006\u0001\u0015\t\u0001\u0002E\u0003\u0002\u0019\u0005)\u0001!B\u0001\t\u001f\u0015\tA!A\u0003\u0002\u0011\u0017)\u0011\u0001B\u0001\u0006\u0003!9A\u0002A\r\u00021\u0003\t+\"C\u0002\t\u00035\t\u00014A\u0005\u0004\u0011\ti\u0011\u0001'\u0002R\u0007\u0005A1!\n\u000b\u0005\u0003!)Q\"\u0001M\u00063\rA\u0011!D\u0001\u0019\u0004e\u0019\u0001BB\u0007\u00021\u0007I2\u0001#\u0004\u000e\u0003a\r\u0011d\u0001\u0005\b\u001b\u0005AJ!\n\u0003\u0005\u0017!=Q\"\u0001\r\tK\u0011!1\u0002#\u0005\u000e\u0003a\u0015Q%\u0002\u0003\f\u0011%i!\u0001$\u0001\u0019\u0014\u0015:Aa\u0003\u0005\u000b\u001b\u0011I!!C\u0001\u0019\u0017aUQe\u0002\u0003\f\u0011/iA!\u0003\u0002\n\u0003a%\u0001\u0004D\u0013\u0004\u00113i\u0011\u0001g\u0001&\t\u0011Y\u0001\"D\u0007\u000217)C\u0001B\u0006\t\u001d5\t\u00014D\u0013\u0005\t-Ai\"D\u0001\u0019\u001f%:A!\u0011\u0005\t\u00055\t\u0001TA)\u0004\u0003\u0015\u0001\u0011F\u0003\u0003B\u0011!\u001dQ\u0002B\u0005\u0003\u0013\u0005AJ\u0001\u0007\u0003R\u0007\u0005)\u0001!K\u0004\u0005\u0003\"A\u0011!D\u0001\u0019\u0004E\u001b\u0011!\u0002\u0001"}, strings={"Lorg/jetbrains/kotlin/resolve/constants/IntegerValueTypeConstructor;", "Lorg/jetbrains/kotlin/types/TypeConstructor;", "value", "", "builtIns", "Lorg/jetbrains/kotlin/builtins/KotlinBuiltIns;", "(JLorg/jetbrains/kotlin/builtins/KotlinBuiltIns;)V", "supertypes", "Ljava/util/ArrayList;", "Lorg/jetbrains/kotlin/types/KotlinType;", "checkBoundsAndAddSuperType", "", "minValue", "maxValue", "kotlinType", "getAnnotations", "Lorg/jetbrains/kotlin/descriptors/annotations/Annotations;", "getBuiltIns", "getDeclarationDescriptor", "", "getParameters", "", "Lorg/jetbrains/kotlin/descriptors/TypeParameterDescriptor;", "getSupertypes", "", "getValue", "isDenotable", "", "isFinal", "toString", ""}, moduleName="kotlin-compiler")
public final class IntegerValueTypeConstructor
implements TypeConstructor {
    private final ArrayList<KotlinType> supertypes;
    private final long value;
    private final KotlinBuiltIns builtIns;

    private final void checkBoundsAndAddSuperType(long value, long minValue, long maxValue, KotlinType kotlinType) {
        if (value >= minValue && value <= maxValue) {
            this.supertypes.add(kotlinType);
        }
    }

    @Override
    @NotNull
    public Collection<KotlinType> getSupertypes() {
        return this.supertypes;
    }

    @Override
    @NotNull
    public List<TypeParameterDescriptor> getParameters() {
        return CollectionsKt.emptyList();
    }

    @Override
    public boolean isFinal() {
        return false;
    }

    @Override
    public boolean isDenotable() {
        return false;
    }

    @Nullable
    public Void getDeclarationDescriptor() {
        return null;
    }

    @Override
    @NotNull
    public Annotations getAnnotations() {
        return Annotations.Companion.getEMPTY();
    }

    public final long getValue() {
        return this.value;
    }

    @Override
    @NotNull
    public KotlinBuiltIns getBuiltIns() {
        return this.builtIns;
    }

    @NotNull
    public String toString() {
        return "IntegerValueType(" + this.value + ")";
    }

    public IntegerValueTypeConstructor(long value, @NotNull KotlinBuiltIns builtIns) {
        Intrinsics.checkParameterIsNotNull(builtIns, "builtIns");
        this.value = value;
        this.builtIns = builtIns;
        this.supertypes = new ArrayList(4);
        long l = Integer.MIN_VALUE;
        long l2 = Integer.MAX_VALUE;
        KotlinType kotlinType = this.builtIns.getIntType();
        Intrinsics.checkExpressionValueIsNotNull(kotlinType, "builtIns.getIntType()");
        this.checkBoundsAndAddSuperType(this.value, l, l2, kotlinType);
        long l3 = -128;
        long l4 = 127;
        KotlinType kotlinType2 = this.builtIns.getByteType();
        Intrinsics.checkExpressionValueIsNotNull(kotlinType2, "builtIns.getByteType()");
        this.checkBoundsAndAddSuperType(this.value, l3, l4, kotlinType2);
        long l5 = Short.MIN_VALUE;
        long l6 = Short.MAX_VALUE;
        KotlinType kotlinType3 = this.builtIns.getShortType();
        Intrinsics.checkExpressionValueIsNotNull(kotlinType3, "builtIns.getShortType()");
        this.checkBoundsAndAddSuperType(this.value, l5, l6, kotlinType3);
        this.supertypes.add(this.builtIns.getLongType());
    }
}

