/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.annotations;

import java.util.Iterator;
import java.util.Map;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinFileFacade;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyAccessorDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationUseSiteTarget;
import org.jetbrains.kotlin.descriptors.annotations.Annotations;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.resolve.annotations.AnnotationUtilKt;
import org.jetbrains.kotlin.resolve.constants.ConstantValue;

@KotlinFileFacade(version={1, 0, 1}, abiVersion=32, data={"/\u0015\u0001Q!\u0001\u0005\u0001\u000b\u0005a\u0011!\u0002\u0001\u0006\u0003!9Q!\u0001\u0003\u0002\u000b\u0005AY!B\u0001\r\u0003\u0015\tA!A\u0003\u0002\u0019\u0005)\u0001!B\u0001\r\u0003\u0015\tA!A\u0007\u000e\u0011\u0001i!\u0001$\u0001\u0019\u0002U\t\u0001$AM\u0005\u0011\u0007i\u0011\u0001\u0007\u0002Q\u0007\u0003!6QAG\u0007\u0011\ri\u0011\u0001g\u0002\u0016\u0003a!Ak!\u0002\u000e\u000e!%Q\"\u0001M\u0004+\u0005AB\u0001VB\u0003\u001bM!\u0011\u0001C\u0003\u000e\u0003a\u001dQ#\u0001M\u00063+Aa!D\u0004\n\u0005%\t\u0001\u0004B\u0005\u0003\u0013\u0005A:\u0001'\u0004Q\u0007\u0003!6QAG\u0007\u0011\u001di\u0011\u0001g\u0002\u0016\u0003a-Ak!\u0002\u000e\u000e!=Q\"\u0001M\u0004+\u0005AZ\u0001VB\u0003"}, strings={"argumentValue", "", "Lorg/jetbrains/kotlin/descriptors/annotations/AnnotationDescriptor;", "parameterName", "", "AnnotationUtilKt", "hasJvmStaticAnnotation", "", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "hasJvmSyntheticAnnotation", "isPlatformStaticIn", "Lorg/jetbrains/kotlin/descriptors/CallableDescriptor;", "predicate", "Lkotlin/Function1;", "isPlatformStaticInCompanionObject", "isPlatformStaticInObjectOrClass"}, moduleName="kotlin-compiler")
public final class AnnotationUtilKt {
    public static final boolean hasJvmStaticAnnotation(DeclarationDescriptor $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        return $receiver.getAnnotations().findAnnotation(new FqName("kotlin.jvm.JvmStatic")) != null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean hasJvmSyntheticAnnotation(DeclarationDescriptor $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        FqName jvmSyntheticName = new FqName("kotlin.jvm.JvmSynthetic");
        if ($receiver.getAnnotations().findAnnotation(jvmSyntheticName) != null) return true;
        Annotations annotations2 = $receiver.getAnnotations();
        Intrinsics.checkExpressionValueIsNotNull(annotations2, "annotations");
        if (Annotations.Companion.findUseSiteTargetedAnnotation(annotations2, AnnotationUseSiteTarget.FIELD, jvmSyntheticName) == null) return false;
        return true;
    }

    public static final boolean isPlatformStaticInObjectOrClass(CallableDescriptor $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        return AnnotationUtilKt.isPlatformStaticIn($receiver, isPlatformStaticInObjectOrClass.1.INSTANCE);
    }

    public static final boolean isPlatformStaticInCompanionObject(CallableDescriptor $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        return AnnotationUtilKt.isPlatformStaticIn($receiver, isPlatformStaticInCompanionObject.1.INSTANCE);
    }

    private static final boolean isPlatformStaticIn(CallableDescriptor $receiver, Function1<? super DeclarationDescriptor, Boolean> predicate) {
        boolean bl;
        CallableDescriptor callableDescriptor = $receiver;
        if (callableDescriptor instanceof PropertyAccessorDescriptor) {
            PropertyDescriptor propertyDescriptor = ((PropertyAccessorDescriptor)$receiver).getCorrespondingProperty();
            DeclarationDescriptor declarationDescriptor = propertyDescriptor.getContainingDeclaration();
            Intrinsics.checkExpressionValueIsNotNull(declarationDescriptor, "propertyDescriptor.getContainingDeclaration()");
            bl = predicate.invoke(declarationDescriptor).booleanValue() && (AnnotationUtilKt.hasJvmStaticAnnotation($receiver) || AnnotationUtilKt.hasJvmStaticAnnotation(propertyDescriptor));
        } else {
            DeclarationDescriptor declarationDescriptor = $receiver.getContainingDeclaration();
            Intrinsics.checkExpressionValueIsNotNull(declarationDescriptor, "getContainingDeclaration()");
            bl = predicate.invoke(declarationDescriptor) != false && AnnotationUtilKt.hasJvmStaticAnnotation($receiver);
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public static final Object argumentValue(AnnotationDescriptor $receiver, @NotNull String parameterName) {
        Object object;
        Object object2;
        block2: {
            void var3_3;
            Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
            Intrinsics.checkParameterIsNotNull(parameterName, "parameterName");
            Object $receiver$iv = $receiver.getAllValueArguments();
            $receiver$iv = $receiver$iv.entrySet();
            Object single$iv = null;
            boolean found$iv = false;
            Iterator iterator2 = $receiver$iv.iterator();
            while (iterator2.hasNext()) {
                Object element$iv = iterator2.next();
                Map.Entry it = (Map.Entry)element$iv;
                if (!Intrinsics.areEqual(((ValueParameterDescriptor)it.getKey()).getName().asString(), parameterName)) continue;
                if (found$iv) {
                    object2 = null;
                    break block2;
                }
                single$iv = element$iv;
                found$iv = true;
            }
            object2 = !found$iv ? null : var3_3;
        }
        return (object = (Map.Entry)object2) != null && (object = (ConstantValue)object.getValue()) != null ? ((ConstantValue)object).getValue() : null;
    }
}

