/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.load.kotlin;

import com.intellij.ide.highlighter.JavaClassFileType;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.FileNotFoundException;
import java.io.IOException;
import kotlin.Deprecated;
import kotlin.PreconditionsKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.load.kotlin.FileBasedKotlinClass;
import org.jetbrains.kotlin.load.kotlin.VirtualFileKotlinClass;
import org.jetbrains.kotlin.load.kotlin.header.KotlinClassHeader;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.util.PerformanceCounter;
import org.jetbrains.kotlin.utils.ExceptionUtilsKt;

@KotlinClass(version={1, 0, 1}, abiVersion=32, data={"I\u0015\tA\"A\u0003\u0002\u0019\u0005)\u0001!B\u0001\r\u0003\u0015\u0001Q!\u0001\u0007\u0002\u000b\u0001)\u0011\u0001D\u0001\u0006\u0001\u0015\tA\"A\u0003\u0002\t\t)\u0011\u0001c\u0003\u0006\u0001\u0015\t\u0001\u0002A\u0003\u0001\u000b\u0005A\u0011\"\u0002\u0001\u0006\u0003!9Q!\u0001\u0007\u0002\u000b\u0001)\u0011\u0001\u0003\u0003\u0006\u0003\u0011\tA\u0002\u0001I\r3\u0005A\n!(A\rCO!\u0011!C\u0002\t\u00035\t\u00014A\u0005\u0004\u0011\ti\u0011\u0001'\u0002\n\u0007!\u0019Q\"\u0001M\u0004\u0013\rAA!D\u0001\u0019\nE\u001b\u0011\u0001C\u0003&\u0014\u0011YE\u0001#\u0004\u000e\u0003a9\u0011\u0004\u0002E\b\u001b\ta\t\u0001\u0007\u0005&\t\u0011Q\u0001\u0012C\u0007\u00021%)k\u0001B\u0006\t\u00145\u001d\u0001DC)\u0004\u0003\u0011UQ\u0005\u0002\u0003\f\u0011-i\u0011\u0001g\u0006&\t\u0011Y\u0001\u0002D\u0007\u00021)I#\u0002B\"\t\u0011\u0005i\u0011\u0001g\u0001R\u0007\u0011)\u0001!\u0004\u0002\u0005\f!1\u0001"}, strings={"Lorg/jetbrains/kotlin/load/kotlin/VirtualFileKotlinClass;", "Lorg/jetbrains/kotlin/load/kotlin/FileBasedKotlinClass;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "className", "Lorg/jetbrains/kotlin/name/ClassId;", "classHeader", "Lorg/jetbrains/kotlin/load/kotlin/header/KotlinClassHeader;", "innerClasses", "Lorg/jetbrains/kotlin/load/kotlin/FileBasedKotlinClass$InnerClassesInfo;", "(Lcom/intellij/openapi/vfs/VirtualFile;Lorg/jetbrains/kotlin/name/ClassId;Lorg/jetbrains/kotlin/load/kotlin/header/KotlinClassHeader;Lorg/jetbrains/kotlin/load/kotlin/FileBasedKotlinClass$InnerClassesInfo;)V", "getFile", "()Lcom/intellij/openapi/vfs/VirtualFile;", "equals", "", "other", "", "getFileContents", "", "getLocation", "", "Lorg/jetbrains/annotations/NotNull;", "hashCode", "", "toString", "Factory"}, moduleName="kotlin-compiler")
public final class VirtualFileKotlinClass
extends FileBasedKotlinClass {
    @NotNull
    private final VirtualFile file;
    private static final Logger LOG;
    private static final PerformanceCounter perfCounter;
    public static final Factory Factory;

    @Override
    @NotNull
    public String getLocation() {
        return this.file.getPath();
    }

    @Override
    @NotNull
    protected byte[] getFileContents() {
        try {
            byte[] byArray = this.file.contentsToByteArray();
            Intrinsics.checkExpressionValueIsNotNull(byArray, "file.contentsToByteArray()");
            return byArray;
        }
        catch (IOException e) {
            VirtualFileKotlinClass.Factory.getLOG().error(VirtualFileKotlinClass.Factory.renderFileReadingErrorMessage(this.file), e);
            throw (Throwable)ExceptionUtilsKt.rethrow(e);
        }
    }

    @Override
    public boolean equals(@Nullable Object other) {
        return other instanceof VirtualFileKotlinClass && Intrinsics.areEqual(((VirtualFileKotlinClass)other).file, this.file);
    }

    @Override
    public int hashCode() {
        return this.file.hashCode();
    }

    @Override
    @NotNull
    public String toString() {
        return this.getClass().getSimpleName() + ": " + this.file;
    }

    @NotNull
    public final VirtualFile getFile() {
        return this.file;
    }

    private VirtualFileKotlinClass(VirtualFile file, ClassId className, KotlinClassHeader classHeader, FileBasedKotlinClass.InnerClassesInfo innerClasses) {
        super(className, classHeader, innerClasses);
        this.file = file;
    }

    static {
        Factory = org.jetbrains.kotlin.load.kotlin.VirtualFileKotlinClass$Factory.INSTANCE;
        LOG = Logger.getInstance(VirtualFileKotlinClass.class);
        perfCounter = PerformanceCounter.Companion.create$default(PerformanceCounter.Companion, "Binary class from Kotlin file", false, 2);
    }

    public /* synthetic */ VirtualFileKotlinClass(@NotNull VirtualFile file, @NotNull ClassId className, @NotNull KotlinClassHeader classHeader, @NotNull FileBasedKotlinClass.InnerClassesInfo innerClasses, DefaultConstructorMarker $constructor_marker) {
        this(file, className, classHeader, innerClasses);
    }

    @KotlinClass(version={1, 0, 1}, abiVersion=32, data={"7\u0015\tA\"A\u0003\u0002\u0011\u0001)\u0011\u0001B\u0001\u0006\u00031\tQ!\u0001\u0007\u0002\u000b\u0005!\u0019!B\u0001\r\u0003\u0015\tA1A\u0003\u0002\u0019\u0005)\u0001!B\u0001\r\u0003\u0015\u0001Q!\u0001\u0005\n\u000b\u0001)\u0011\u0001C\u0004\u0005\u0007\ba\u0001!G\u0001\u0019\u0002\u0005\u001eA!A)\u0004\u0003!\tQE\u0004C\u0004\u0011\u0019i!\u0001$\u0001\u0019\u000ee\u0019\u0001bB\u0007\u00021\u001fIB\u0001\u0003\u0005\u000e\u00051\u0005\u0001\u0014C\u0013\t\t\u0005A\u0011\"D\u0001\u0019\u0014e\u0019\u0001bB\u0007\u00021\u001fI[\u0002B!\t\u0011\u0007i9\u0001\u0007\u0002R\u0007\u0005!)!U\u0002\u0006\u000b\u0005a\t!\u0004\u0002\u0005\u0007!\u001d\u0011f\u0003\u0003B\u0011!!Q\"\u0001M\u0005#\u000e)Q!\u0001G\u0001\u001b\t!Q\u0001c\u0003"}, strings={"Lorg/jetbrains/kotlin/load/kotlin/VirtualFileKotlinClass$Factory;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "getLOG", "()Lcom/intellij/openapi/diagnostic/Logger;", "perfCounter", "Lorg/jetbrains/kotlin/util/PerformanceCounter;", "getPerfCounter", "()Lorg/jetbrains/kotlin/util/PerformanceCounter;", "create", "Lorg/jetbrains/kotlin/load/kotlin/VirtualFileKotlinClass;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "fileContent", "", "renderFileReadingErrorMessage", ""}, moduleName="kotlin-compiler")
    public static final class Factory {
        public static final Factory INSTANCE;

        private final Logger getLOG() {
            return LOG;
        }

        private final PerformanceCounter getPerfCounter() {
            return perfCounter;
        }

        @Deprecated(message="Use KotlinBinaryClassCache")
        @Nullable
        public final VirtualFileKotlinClass create(@NotNull VirtualFile file, @Nullable byte[] fileContent) {
            Intrinsics.checkParameterIsNotNull(file, "file");
            return (VirtualFileKotlinClass)this.getPerfCounter().time((Function0)new Function0<VirtualFileKotlinClass>(file, fileContent){
                final /* synthetic */ VirtualFile $file;
                final /* synthetic */ byte[] $fileContent;

                @Nullable
                public final VirtualFileKotlinClass invoke() {
                    Unit unit;
                    boolean value$iv = Intrinsics.areEqual(this.$file.getFileType(), JavaClassFileType.INSTANCE);
                    if (PreconditionsKt.getASSERTIONS_ENABLED()) {
                        if (!value$iv) {
                            String message$iv = "Trying to read binary data from a non-class file " + this.$file;
                            throw (Throwable)((Object)new AssertionError((Object)message$iv));
                        }
                        unit = Unit.INSTANCE;
                    } else {
                        unit = Unit.INSTANCE;
                    }
                    try {
                        byte[] byArray = this.$fileContent;
                        if (this.$fileContent == null) {
                            byte[] byArray2 = this.$file.contentsToByteArray(false);
                            byArray = byArray2;
                            Intrinsics.checkExpressionValueIsNotNull(byArray2, "file.contentsToByteArray(false)");
                        }
                        byte[] byteContent = byArray;
                        if (!ArraysKt.isEmpty(byteContent)) {
                            return (VirtualFileKotlinClass)FileBasedKotlinClass.create(byteContent, (Function3)new Function3<ClassId, KotlinClassHeader, FileBasedKotlinClass.InnerClassesInfo, VirtualFileKotlinClass>(this){
                                final /* synthetic */ create.1 this$0;

                                @NotNull
                                public final VirtualFileKotlinClass invoke(ClassId name, KotlinClassHeader header, FileBasedKotlinClass.InnerClassesInfo innerClasses) {
                                    VirtualFile virtualFile = this.this$0.$file;
                                    ClassId classId = name;
                                    Intrinsics.checkExpressionValueIsNotNull(classId, "name");
                                    KotlinClassHeader kotlinClassHeader = header;
                                    Intrinsics.checkExpressionValueIsNotNull(kotlinClassHeader, "header");
                                    FileBasedKotlinClass.InnerClassesInfo innerClassesInfo = innerClasses;
                                    Intrinsics.checkExpressionValueIsNotNull(innerClassesInfo, "innerClasses");
                                    return new VirtualFileKotlinClass(virtualFile, classId, kotlinClassHeader, innerClassesInfo, null);
                                }
                                {
                                    this.this$0 = var1_1;
                                    super(3);
                                }
                            });
                        }
                    }
                    catch (FileNotFoundException e) {
                    }
                    catch (Throwable e) {
                        org.jetbrains.kotlin.load.kotlin.VirtualFileKotlinClass$Factory.access$getLOG$p(VirtualFileKotlinClass.Factory).warn(org.jetbrains.kotlin.load.kotlin.VirtualFileKotlinClass$Factory.access$renderFileReadingErrorMessage(VirtualFileKotlinClass.Factory, this.$file));
                    }
                    return null;
                }
                {
                    this.$file = virtualFile;
                    this.$fileContent = byArray;
                    super(0);
                }
            });
        }

        private final String renderFileReadingErrorMessage(VirtualFile file) {
            return "Could not read file: " + file.getPath() + "; size in bytes: " + file.getLength() + "; file type: " + file.getFileType().getName();
        }

        private Factory() {
            INSTANCE = this;
        }

        static {
            new Factory();
        }
    }
}

