/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen.intrinsics;

import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.codegen.AsmUtil;
import org.jetbrains.kotlin.codegen.Callable;
import org.jetbrains.kotlin.codegen.CallableMethod;
import org.jetbrains.kotlin.codegen.intrinsics.IntrinsicCallable;
import org.jetbrains.kotlin.codegen.intrinsics.IntrinsicMethod;
import org.jetbrains.kotlin.resolve.jvm.AsmTypes;
import org.jetbrains.org.objectweb.asm.Type;
import org.jetbrains.org.objectweb.asm.commons.InstructionAdapter;

@KotlinClass(version={1, 0, 1}, abiVersion=32, data={"#\u0015\tA\"A\u0003\u0002\u0019\u0005)\u0011\u0001B\u0001\u0006\u0003!9Q\u0001A\u0003\u0002\u0019\u0005)\u0001!B\u0001\r\u0003\u0015\u0001Q!\u0001\u0007\u0002\u0019\u0001I\u0012\u0001'\u0001\"\u0006E\u001b\u0011\u0001C\u0001&\u0011\u0011\t\u00012A\u0007\u00021\tI2\u0001#\u0002\u000e\u0003a\u0019Q\u0005\u0003\u0003\u000b\u0011\u000fi\u0011\u0001\u0007\u0003\u001a\u0007!%Q\"\u0001\r\u0006"}, strings={"Lorg/jetbrains/kotlin/codegen/intrinsics/IteratorNext;", "Lorg/jetbrains/kotlin/codegen/intrinsics/IntrinsicMethod;", "()V", "getIteratorName", "", "returnType", "Lorg/jetbrains/org/objectweb/asm/Type;", "toCallable", "Lorg/jetbrains/kotlin/codegen/Callable;", "method", "Lorg/jetbrains/kotlin/codegen/CallableMethod;"}, moduleName="kotlin-compiler")
public final class IteratorNext
extends IntrinsicMethod {
    private final String getIteratorName(Type returnType2) {
        String string;
        Type type2 = returnType2;
        if (Intrinsics.areEqual(type2, Type.CHAR_TYPE)) {
            string = "Char";
        } else if (Intrinsics.areEqual(type2, Type.BOOLEAN_TYPE)) {
            string = "Boolean";
        } else if (Intrinsics.areEqual(type2, Type.BYTE_TYPE)) {
            string = "Byte";
        } else if (Intrinsics.areEqual(type2, Type.SHORT_TYPE)) {
            string = "Short";
        } else if (Intrinsics.areEqual(type2, Type.INT_TYPE)) {
            string = "Int";
        } else if (Intrinsics.areEqual(type2, Type.LONG_TYPE)) {
            string = "Long";
        } else if (Intrinsics.areEqual(type2, Type.FLOAT_TYPE)) {
            string = "Float";
        } else if (Intrinsics.areEqual(type2, Type.DOUBLE_TYPE)) {
            string = "Double";
        } else {
            throw (Throwable)new UnsupportedOperationException("Can't get correct name for iterator from type: " + returnType2);
        }
        return string;
    }

    @Override
    @NotNull
    protected Callable toCallable(@NotNull CallableMethod method) {
        Type type2;
        Intrinsics.checkParameterIsNotNull(method, "method");
        Type type3 = type2 = AsmUtil.unboxType(method.getReturnType());
        Intrinsics.checkExpressionValueIsNotNull(type3, "type");
        return new IntrinsicCallable(this, type3, CollectionsKt.listOf(), AsmTypes.OBJECT_TYPE, (Type)null){
            final /* synthetic */ IteratorNext this$0;

            public void invokeIntrinsic(@NotNull InstructionAdapter v) {
                Intrinsics.checkParameterIsNotNull(v, "v");
                String name = IteratorNext.access$getIteratorName(this.this$0, this.getReturnType());
                v.invokevirtual(KotlinBuiltIns.BUILT_INS_PACKAGE_FQ_NAME.asString() + "/" + name + "Iterator", "next" + name, "()" + this.getReturnType().getDescriptor(), false);
            }
            {
                this.this$0 = $outer;
                super($super_call_param$1, $super_call_param$2, $super_call_param$3, $super_call_param$4, null, 16, null);
            }
        };
    }

    @NotNull
    public static final /* synthetic */ String access$getIteratorName(IteratorNext $this, @NotNull Type returnType2) {
        return $this.getIteratorName(returnType2);
    }
}

