/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.serialization.deserialization;

import java.util.Collection;
import java.util.List;
import kotlin.PreconditionsKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.PackageFragmentDescriptor;
import org.jetbrains.kotlin.descriptors.PackageFragmentProvider;
import org.jetbrains.kotlin.descriptors.SourceElement;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.serialization.ClassData;
import org.jetbrains.kotlin.serialization.ClassDataWithSource;
import org.jetbrains.kotlin.serialization.ProtoBuf;
import org.jetbrains.kotlin.serialization.deserialization.DeserializationComponents;
import org.jetbrains.kotlin.serialization.deserialization.DeserializationContext;
import org.jetbrains.kotlin.serialization.deserialization.DeserializedPackageFragment;
import org.jetbrains.kotlin.serialization.deserialization.NameResolver;
import org.jetbrains.kotlin.serialization.deserialization.TypeTable;
import org.jetbrains.kotlin.serialization.deserialization.descriptors.DeserializedClassDescriptor;

@KotlinClass(version={1, 0, 1}, abiVersion=32, data={"/\u0015\tA\"A\u0003\u0002\u0011\u0001)\u0001!B\u0001\r\u0003\u0015\tA!A\u0003\u0002\u0019\u0005)\u0011\u0001D\u0001\u0006\u00031\tQ!\u0001\u0003\u0003\u000b\u0005a\u0011!\u0002\u0001\u0006\u00031\tQ\u0001\u0001\u0007\u00013\u0005A\n!(\u0001\tC\u001bI1\u0001C\u0001\u000e\u0003a\r\u0011kA\u0001\t\u0005\u0015JA!\u0001E\u0005\u001b\ta\t\u0001\u0007\u0003\u001a\u0007!)Q\"\u0001M\u0004K9AY!\u0004\u0002\r\u0002a!\u0011d\u0001\u0005\u0007\u001b\u0005Aj!G\u0003\u0005\u0003!9QB\u0001G\u00011\u001fIc\u0002B!\t\u0011\u000bi\u0001\"\u0003\u0002\n\u0003a\u001d\u0011bA\u0005\u0003\u0019\u0003AB\u0001G\u0002R\u0007\u0005)\u0001!K\u0004\u0005\u0003\"A\u0011!D\u0001\u0019\u0004E\u001b\u0011!\u0002\u0001"}, strings={"Lorg/jetbrains/kotlin/serialization/deserialization/ClassDeserializer;", "", "components", "Lorg/jetbrains/kotlin/serialization/deserialization/DeserializationComponents;", "(Lorg/jetbrains/kotlin/serialization/deserialization/DeserializationComponents;)V", "classes", "Lkotlin/Function1;", "Lorg/jetbrains/kotlin/serialization/deserialization/ClassDeserializer$ClassKey;", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "createClass", "key", "deserializeClass", "classId", "Lorg/jetbrains/kotlin/name/ClassId;", "classDataWithSource", "Lorg/jetbrains/kotlin/serialization/ClassDataWithSource;", "ClassKey"}, moduleName="kotlin-compiler")
public final class ClassDeserializer {
    private final Function1<ClassKey, ClassDescriptor> classes;
    private final DeserializationComponents components;

    @Nullable
    public final ClassDescriptor deserializeClass(@NotNull ClassId classId, @Nullable ClassDataWithSource classDataWithSource) {
        Intrinsics.checkParameterIsNotNull(classId, "classId");
        return this.classes.invoke(new ClassKey(classId, classDataWithSource));
    }

    @Nullable
    public static /* bridge */ /* synthetic */ ClassDescriptor deserializeClass$default(ClassDeserializer classDeserializer, ClassId classId, ClassDataWithSource classDataWithSource, int n) {
        if ((n & 2) != 0) {
            classDataWithSource = null;
        }
        return classDeserializer.deserializeClass(classId, classDataWithSource);
    }

    /*
     * WARNING - void declaration
     */
    private final ClassDescriptor createClass(ClassKey key) {
        void sourceElement;
        void nameResolver;
        void classProto;
        DeserializationContext deserializationContext;
        void classData;
        ClassId classId = key.getClassId();
        ClassDescriptor classDescriptor = this.components.getFictitiousClassDescriptorFactory().createClass(classId);
        if (classDescriptor != null) {
            ClassDescriptor $receiver$iv = classDescriptor;
            ClassDescriptor it = $receiver$iv;
            return it;
        }
        ClassDataWithSource classDataWithSource = key.getClassDataWithSource();
        if (classDataWithSource == null) {
            classDataWithSource = this.components.getClassDataFinder().findClassData(classId);
        }
        if (classDataWithSource == null) {
            return null;
        }
        Object $i$a$1 = classDataWithSource;
        ClassData $receiver$iv = ((ClassDataWithSource)$i$a$1).component1();
        SourceElement it = ((ClassDataWithSource)$i$a$1).component2();
        $i$a$1 = null;
        Object var6_8 = classData;
        $i$a$1 = var6_8.component1();
        ProtoBuf.Class $i$f$let = var6_8.component2();
        var6_8 = null;
        if (classId.isNestedClass()) {
            ClassId classId2 = classId.getOuterClassId();
            Intrinsics.checkExpressionValueIsNotNull(classId2, "classId.outerClassId");
            ClassDescriptor classDescriptor2 = ClassDeserializer.deserializeClass$default(this, classId2, null, 2);
            if (!(classDescriptor2 instanceof DeserializedClassDescriptor)) {
                classDescriptor2 = null;
            }
            DeserializedClassDescriptor deserializedClassDescriptor = (DeserializedClassDescriptor)classDescriptor2;
            if (deserializedClassDescriptor == null) {
                return null;
            }
            DeserializedClassDescriptor outerClass = deserializedClassDescriptor;
            Name name = classId.getShortClassName();
            Intrinsics.checkExpressionValueIsNotNull(name, "classId.shortClassName");
            if (!outerClass.hasNestedClass$kotlin_compiler(name)) {
                return null;
            }
            deserializationContext = outerClass.getC();
        } else {
            Unit unit;
            void $receiver$iv22;
            PackageFragmentProvider packageFragmentProvider = this.components.getPackageFragmentProvider();
            FqName fqName2 = classId.getPackageFqName();
            Intrinsics.checkExpressionValueIsNotNull(fqName2, "classId.packageFqName");
            List<PackageFragmentDescriptor> fragments2 = packageFragmentProvider.getPackageFragments(fqName2);
            Collection collection = fragments2;
            boolean $receiver$iv22 = $receiver$iv22.size() == 1;
            if (PreconditionsKt.getASSERTIONS_ENABLED()) {
                void value$iv;
                if (value$iv == false) {
                    String message$iv = "There should be exactly one package: " + fragments2 + ", class id is " + classId;
                    throw (Throwable)((Object)new AssertionError((Object)message$iv));
                }
                unit = Unit.INSTANCE;
            } else {
                unit = Unit.INSTANCE;
            }
            PackageFragmentDescriptor fragment = CollectionsKt.single(fragments2);
            if (fragment instanceof DeserializedPackageFragment) {
                DeserializedPackageFragment deserializedPackageFragment = (DeserializedPackageFragment)fragment;
                Name name = classId.getShortClassName();
                Intrinsics.checkExpressionValueIsNotNull(name, "classId.shortClassName");
                if (!deserializedPackageFragment.hasTopLevelClass$kotlin_compiler(name)) {
                    return null;
                }
            }
            ProtoBuf.TypeTable typeTable = classProto.getTypeTable();
            Intrinsics.checkExpressionValueIsNotNull(typeTable, "classProto.typeTable");
            deserializationContext = this.components.createContext(fragment, (NameResolver)nameResolver, new TypeTable(typeTable));
        }
        DeserializationContext outerContext = deserializationContext;
        return new DeserializedClassDescriptor(outerContext, (ProtoBuf.Class)classProto, (NameResolver)nameResolver, (SourceElement)sourceElement);
    }

    public ClassDeserializer(@NotNull DeserializationComponents components2) {
        Intrinsics.checkParameterIsNotNull(components2, "components");
        this.components = components2;
        this.classes = this.components.getStorageManager().createMemoizedFunctionWithNullableValues((Function1)new Function1<ClassKey, ClassDescriptor>(this){
            final /* synthetic */ ClassDeserializer this$0;

            @Nullable
            public final ClassDescriptor invoke(@NotNull ClassKey key) {
                Intrinsics.checkParameterIsNotNull(key, "key");
                return ClassDeserializer.access$createClass(this.this$0, key);
            }
            {
                this.this$0 = classDeserializer;
                super(1);
            }
        });
    }

    @Nullable
    public static final /* synthetic */ ClassDescriptor access$createClass(ClassDeserializer $this, @NotNull ClassKey key) {
        return $this.createClass(key);
    }

    @KotlinClass(version={1, 0, 1}, abiVersion=32, data={"%\u0015\tA\"A\u0003\u0002\u0011\u0001)\u0001!B\u0001\r\u0003\u0015\u0001Q!\u0001\u0007\u0002\u000b\u0005!1!B\u0001\t\f\u0015\tA!A\u0003\u0002\u0011\u0011!\u0011\u0001\u0004\u0001\u001a\u0003a\u0005\u0011uC\u0005\u0004\u0011\u0005i\u0011\u0001g\u0001\n\t!\u0011QB\u0001G\u00011\u000b\t6!\u0001\u0005\u0004K'!1\n\u0002E\u0006\u001b\u0005Ab!\u0007\u0003\t\u000e5\u0011A\u0012\u0001M\u0001K\u0011!1\u0002C\u0004\u000e\u0003a=\u0011f\u0003\u0003D\u0011!\u0011QB\u0001G\u00011\u000b\t6\u0001B\u0003\u0001\u001b\t!9\u0001\u0003\u0003*\u0015\u0011\u0019\u0005\u0002C\u0001\u000e\u0003a\r\u0011k\u0001\u0003\u0006\u00015\u0011A\u0011\u0002\u0005\u0006"}, strings={"Lorg/jetbrains/kotlin/serialization/deserialization/ClassDeserializer$ClassKey;", "", "classId", "Lorg/jetbrains/kotlin/name/ClassId;", "classDataWithSource", "Lorg/jetbrains/kotlin/serialization/ClassDataWithSource;", "(Lorg/jetbrains/kotlin/name/ClassId;Lorg/jetbrains/kotlin/serialization/ClassDataWithSource;)V", "getClassDataWithSource", "()Lorg/jetbrains/kotlin/serialization/ClassDataWithSource;", "getClassId", "()Lorg/jetbrains/kotlin/name/ClassId;", "equals", "", "other", "hashCode", ""}, moduleName="kotlin-compiler")
    private static final class ClassKey {
        @NotNull
        private final ClassId classId;
        @Nullable
        private final ClassDataWithSource classDataWithSource;

        public boolean equals(@Nullable Object other) {
            return other instanceof ClassKey && Intrinsics.areEqual(this.classId, ((ClassKey)other).classId);
        }

        public int hashCode() {
            return this.classId.hashCode();
        }

        @NotNull
        public final ClassId getClassId() {
            return this.classId;
        }

        @Nullable
        public final ClassDataWithSource getClassDataWithSource() {
            return this.classDataWithSource;
        }

        public ClassKey(@NotNull ClassId classId, @Nullable ClassDataWithSource classDataWithSource) {
            Intrinsics.checkParameterIsNotNull(classId, "classId");
            this.classId = classId;
            this.classDataWithSource = classDataWithSource;
        }
    }
}

