/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.validation;

import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiTreeUtil;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyGetterDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtAnnotationEntry;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtCallableReferenceExpression;
import org.jetbrains.kotlin.psi.KtConstructorCalleeExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtReferenceExpression;
import org.jetbrains.kotlin.psi.KtStubbedPsiUtil;
import org.jetbrains.kotlin.psi.KtSuperTypeCallEntry;
import org.jetbrains.kotlin.psi.KtUnaryExpression;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.DeprecationLevelValue;
import org.jetbrains.kotlin.resolve.DeprecationUtilKt;
import org.jetbrains.kotlin.resolve.annotations.AnnotationUtilKt;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.validation.SymbolUsageValidator;

@KotlinClass(version={1, 0, 1}, abiVersion=32, data={"S\u0015\tA\"A\u0003\u0002\u0019\u0005)\u0011\u0001B\u0001\u0006\u00031\tQ!\u0001\u0007\u0002\u000b\u0001)\u0011\u0001D\u0001\u0006\u0001\u0015\tA\"A\u0003\u0001\u000b\u0005a\u0011!\u0002\u0001\u0006\u00031\tQ\u0001A\u0003\u0002\u0011\u0005)\u0001!B\u0001\r\u0003\u0015\u0001Q!\u0001\u0007\u0002\u000b\u0001)\u0011\u0001D\u0001\u0006\u0003\u0011\rQ!\u0001\u0007\u0002\u000b\u0001)\u0011\u0001D\u0001\r\u0001e\t\u0001\u0014AQ\u0003#\u000e\t\u0001\"A\u0013\u0011\t\u0005A1!D\u0001\u0019\be\u0019\u0001\u0002B\u0007\u00021\u0013I2\u0001C\u0003\u000e\u0003a-\u0011d\u0001\u0005\u0007\u001b\u0005Aj!\n\f\t\u000f5\t\u0001tB\r\u0007\u0011!iA!C\u0001\u0005\u00041\u0005\u0001\u0014C\r\u0004\u0011%i\u0011\u0001g\u0005\u001a\u0007!QQ\"\u0001M\u000b3\rA1\"D\u0001\u0019\n\u0015:Ba\u0003E\f\u001b\u0005Az!\u0007\u0004\t\u00115!\u0011\"\u0001C\u0002\u0019\u0003A\n\"G\u0002\t\u00195\t\u0001\u0014D\r\u0004\u0011)i\u0011\u0001'\u0006\u001a\u0007!!Q\"\u0001M\u0005KA!1\u0002C\u0007\u000e\u0003a=\u0011d\u0001\u0005\r\u001b\u0005AZ\"G\u0002\t\u00155\t\u0001TC\r\u0004\u0011\u0011i\u0011\u0001'\u0003*\u0014\u0011\t\u0005\u0002c\u0001\u000e\ba\u0011\u0011kA\u0001\u0005\u0006E\u001b\u0011!\u0002\u0001"}, strings={"Lorg/jetbrains/kotlin/resolve/validation/DeprecatedSymbolValidator;", "Lorg/jetbrains/kotlin/resolve/validation/SymbolUsageValidator;", "()V", "PROPERTY_SET_OPERATIONS", "Lcom/intellij/psi/tree/TokenSet;", "Lorg/jetbrains/annotations/NotNull;", "createDeprecationDiagnostic", "Lorg/jetbrains/kotlin/diagnostics/Diagnostic;", "element", "Lcom/intellij/psi/PsiElement;", "descriptor", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "deprecated", "Lorg/jetbrains/kotlin/descriptors/annotations/AnnotationDescriptor;", "propertyGetterWorkaround", "", "resolvedCall", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "propertyDescriptor", "Lorg/jetbrains/kotlin/descriptors/PropertyDescriptor;", "trace", "Lorg/jetbrains/kotlin/resolve/BindingTrace;", "expression", "validateCall", "targetDescriptor", "Lorg/jetbrains/kotlin/descriptors/CallableDescriptor;", "validateTypeUsage", "Lorg/jetbrains/kotlin/descriptors/ClassifierDescriptor;"}, moduleName="kotlin-compiler")
public final class DeprecatedSymbolValidator
implements SymbolUsageValidator {
    private final TokenSet PROPERTY_SET_OPERATIONS = TokenSet.create(KtTokens.EQ, KtTokens.PLUSEQ, KtTokens.MINUSEQ, KtTokens.MULTEQ, KtTokens.DIVEQ, KtTokens.PERCEQ, KtTokens.PLUSPLUS, KtTokens.MINUSMINUS);

    /*
     * WARNING - void declaration
     */
    @Override
    public void validateCall(@Nullable ResolvedCall<?> resolvedCall, @NotNull CallableDescriptor targetDescriptor, @NotNull BindingTrace trace, @NotNull PsiElement element) {
        Intrinsics.checkParameterIsNotNull(targetDescriptor, "targetDescriptor");
        Intrinsics.checkParameterIsNotNull(trace, "trace");
        Intrinsics.checkParameterIsNotNull(element, "element");
        Pair<AnnotationDescriptor, DeclarationDescriptor> deprecated = DeprecationUtilKt.getDeprecatedAnnotation(targetDescriptor);
        if (deprecated != null) {
            void annotation2;
            void target;
            Pair<AnnotationDescriptor, DeclarationDescriptor> pair = deprecated;
            AnnotationDescriptor annotationDescriptor = pair.component1();
            DeclarationDescriptor declarationDescriptor = pair.component2();
            pair = null;
            trace.report(this.createDeprecationDiagnostic(element, (DeclarationDescriptor)target, (AnnotationDescriptor)annotation2));
        } else if (targetDescriptor instanceof PropertyDescriptor) {
            this.propertyGetterWorkaround(resolvedCall, (PropertyDescriptor)targetDescriptor, trace, element);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void validateTypeUsage(@NotNull ClassifierDescriptor targetDescriptor, @NotNull BindingTrace trace, @NotNull PsiElement element) {
        KtSuperTypeCallEntry superExpression;
        Intrinsics.checkParameterIsNotNull(targetDescriptor, "targetDescriptor");
        Intrinsics.checkParameterIsNotNull(trace, "trace");
        Intrinsics.checkParameterIsNotNull(element, "element");
        KtAnnotationEntry annotationEntry = KtStubbedPsiUtil.getPsiOrStubParent(element, KtAnnotationEntry.class, true);
        if (annotationEntry != null) {
            KtConstructorCalleeExpression ktConstructorCalleeExpression = annotationEntry.getCalleeExpression();
            if (ktConstructorCalleeExpression == null) {
                Intrinsics.throwNpe();
            }
            if (Intrinsics.areEqual(ktConstructorCalleeExpression.getConstructorReferenceExpression(), element)) {
                return;
            }
        }
        if ((superExpression = KtStubbedPsiUtil.getPsiOrStubParent(element, KtSuperTypeCallEntry.class, true)) != null && Intrinsics.areEqual(superExpression.getCalleeExpression().getConstructorReferenceExpression(), element)) {
            return;
        }
        Pair<AnnotationDescriptor, DeclarationDescriptor> deprecated = DeprecationUtilKt.getDeprecatedAnnotation(targetDescriptor);
        if (deprecated != null) {
            void annotation2;
            void target;
            Pair<AnnotationDescriptor, DeclarationDescriptor> pair = deprecated;
            AnnotationDescriptor annotationDescriptor = pair.component1();
            DeclarationDescriptor declarationDescriptor = pair.component2();
            pair = null;
            trace.report(this.createDeprecationDiagnostic(element, (DeclarationDescriptor)target, (AnnotationDescriptor)annotation2));
        }
    }

    private final Diagnostic createDeprecationDiagnostic(PsiElement element, DeclarationDescriptor descriptor2, AnnotationDescriptor deprecated) {
        String message;
        String string;
        Object object = AnnotationUtilKt.argumentValue(deprecated, "message");
        if (!(object instanceof String)) {
            object = null;
        }
        if ((string = (String)object) == null) {
            string = message = "";
        }
        if (Intrinsics.areEqual((Object)DeprecationUtilKt.getDeprecatedAnnotationLevel(deprecated), (Object)DeprecationLevelValue.ERROR)) {
            Diagnostic diagnostic = Errors.DEPRECATION_ERROR.on(element, descriptor2.getOriginal(), message);
            Intrinsics.checkExpressionValueIsNotNull(diagnostic, "Errors.DEPRECATION_ERROR\u2026riptor.original, message)");
            return diagnostic;
        }
        Diagnostic diagnostic = Errors.DEPRECATION.on(element, descriptor2.getOriginal(), message);
        Intrinsics.checkExpressionValueIsNotNull(diagnostic, "Errors.DEPRECATION.on(el\u2026riptor.original, message)");
        return diagnostic;
    }

    /*
     * WARNING - void declaration
     */
    public final void propertyGetterWorkaround(@Nullable ResolvedCall<?> resolvedCall, @NotNull PropertyDescriptor propertyDescriptor, @NotNull BindingTrace trace, @NotNull PsiElement expression) {
        Unit unit;
        KtUnaryExpression unaryExpression;
        Object expr;
        IElementType operation;
        Intrinsics.checkParameterIsNotNull(propertyDescriptor, "propertyDescriptor");
        Intrinsics.checkParameterIsNotNull(trace, "trace");
        Intrinsics.checkParameterIsNotNull(expression, "expression");
        KtBinaryExpression binaryExpression = PsiTreeUtil.getParentOfType(expression, KtBinaryExpression.class);
        if (binaryExpression != null) {
            KtExpression left = binaryExpression.getLeft();
            if (Intrinsics.areEqual(left, expression) && (operation = binaryExpression.getOperationToken()) != null && this.PROPERTY_SET_OPERATIONS.contains(operation)) {
                return;
            }
            KtReferenceExpression[] jetReferenceExpressions = (KtReferenceExpression[])PsiTreeUtil.getChildrenOfType((PsiElement)left, KtReferenceExpression.class);
            if (jetReferenceExpressions != null) {
                for (int i = 0; i < jetReferenceExpressions.length; ++i) {
                    IElementType operation2;
                    expr = jetReferenceExpressions[i];
                    if (!Intrinsics.areEqual(expr, expression) || (operation2 = binaryExpression.getOperationToken()) == null || !this.PROPERTY_SET_OPERATIONS.contains(operation2)) continue;
                    return;
                }
            }
        }
        if ((unaryExpression = PsiTreeUtil.getParentOfType(expression, KtUnaryExpression.class)) != null && (operation = unaryExpression.getOperationReference().getReferencedNameElementType()) != null && this.PROPERTY_SET_OPERATIONS.contains(operation)) {
            return;
        }
        KtCallableReferenceExpression callableExpression = PsiTreeUtil.getParentOfType(expression, KtCallableReferenceExpression.class);
        if (callableExpression != null && Intrinsics.areEqual(callableExpression.getCallableReference(), expression)) {
            return;
        }
        PropertyGetterDescriptor propertyGetterDescriptor = propertyDescriptor.getGetter();
        if (propertyGetterDescriptor != null) {
            void $receiver$iv;
            expr = propertyGetterDescriptor;
            PropertyGetterDescriptor it = (PropertyGetterDescriptor)$receiver$iv;
            CallableDescriptor callableDescriptor = it;
            Intrinsics.checkExpressionValueIsNotNull(callableDescriptor, "it");
            this.validateCall(resolvedCall, callableDescriptor, trace, expression);
            unit = Unit.INSTANCE;
        } else {
            unit = null;
        }
    }
}

