/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.jvm.checkers;

import com.intellij.extapi.psi.ASTDelegatePsiElement;
import com.intellij.psi.PsiElement;
import java.util.Set;
import kotlin.CharIterator;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.diagnostics.DiagnosticSink;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.psi.KtCallableDeclaration;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtDestructuringDeclaration;
import org.jetbrains.kotlin.psi.KtDestructuringDeclarationEntry;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtPsiUtil;
import org.jetbrains.kotlin.psi.KtTypeParameter;
import org.jetbrains.kotlin.psi.KtTypeParameterListOwner;
import org.jetbrains.kotlin.resolve.IdentifierChecker;

@KotlinClass(version={1, 0, 1}, abiVersion=32, data={"?\u0015\tA\"A\u0003\u0002\u0019\u0005)\u0011\u0001B\u0001\u0006\u0003!\tR!\u0001\u0005\u0007\u000b\u0001)\u0011\u0001C\u0001\u0006\u0001\u0015\tA\"A\u0003\u0001\u000b\u0005a\u0011!B\u0001\u0005\u0003\u0015\tA\"A\u0003\u0001\u000b\u0005a\u0011!B\u0001\u0005\u0003\u0015\t\u0001bB\u0003\u0001\t\r\fA\u0002A\r\u00021\u0003\t;\u0001B\u0001R\u0007\u0005A\u0011!\n\u0007\u0005\u0017!\u0019Q\"\u0001M\u00043\rAA!D\u0001\u0019\ne\u0019\u0001\"B\u0007\u00021\u0017)S\u0002B\u0006\t\r5\t\u0001tA\r\u0005\u0011\u001bi!\u0001$\u0001\u0019\u000fe\u0019\u0001\"B\u0007\u00021\u0017)3\u0002c\u0004\u000e\u0003a\u001d\u0011d\u0001\u0005\u0005\u001b\u0005A\u0002\"G\u0002\t\u000b5\t\u00014B\u0013\u0011\t\u0005A\t\"D\u0001\u0019\be\u0019\u0001\"C\u0007\u00021'I2\u0001\u0003\u0006\u000e\u0003a9\u0011d\u0001\u0005\u0006\u001b\u0005AZ!\u000b\u0006\u0005\u0003\"A\u0019!\u0004\u0003\n\u0005%\t\u0001T\u0001\r\u0003#\u000e\tQ\u0001\u0001"}, strings={"Lorg/jetbrains/kotlin/resolve/jvm/checkers/JvmSimpleNameBacktickChecker;", "Lorg/jetbrains/kotlin/resolve/IdentifierChecker;", "()V", "CHARS", "", "", "checkDeclaration", "", "declaration", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "diagnosticHolder", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticSink;", "checkIdentifier", "identifier", "Lcom/intellij/psi/PsiElement;", "checkNamed", "Lorg/jetbrains/kotlin/psi/KtNamedDeclaration;", "reportIfNeeded", "name", "", "element"}, moduleName="kotlin-compiler")
public final class JvmSimpleNameBacktickChecker
implements IdentifierChecker {
    private static final Set<Character> CHARS;
    public static final JvmSimpleNameBacktickChecker INSTANCE;
    public static final JvmSimpleNameBacktickChecker INSTANCE$;

    @Override
    public void checkIdentifier(@Nullable PsiElement identifier, @NotNull DiagnosticSink diagnosticHolder) {
        Intrinsics.checkParameterIsNotNull(diagnosticHolder, "diagnosticHolder");
        if (identifier == null) {
            return;
        }
        String string = identifier.getText();
        Intrinsics.checkExpressionValueIsNotNull(string, "identifier.text");
        this.reportIfNeeded(string, identifier, diagnosticHolder);
    }

    @Override
    public void checkDeclaration(@NotNull KtDeclaration declaration, @NotNull DiagnosticSink diagnosticHolder) {
        ASTDelegatePsiElement it;
        Iterable $receiver$iv;
        Intrinsics.checkParameterIsNotNull(declaration, "declaration");
        Intrinsics.checkParameterIsNotNull(diagnosticHolder, "diagnosticHolder");
        if (declaration instanceof KtDestructuringDeclaration) {
            $receiver$iv = ((KtDestructuringDeclaration)declaration).getEntries();
            for (Object element$iv : $receiver$iv) {
                it = (KtDestructuringDeclarationEntry)element$iv;
                KtNamedDeclaration ktNamedDeclaration = it;
                Intrinsics.checkExpressionValueIsNotNull(ktNamedDeclaration, "it");
                INSTANCE.checkNamed(ktNamedDeclaration, diagnosticHolder);
            }
        }
        if (declaration instanceof KtCallableDeclaration) {
            $receiver$iv = ((KtCallableDeclaration)declaration).getValueParameters();
            for (Object element$iv : $receiver$iv) {
                it = (KtParameter)element$iv;
                KtNamedDeclaration ktNamedDeclaration = it;
                Intrinsics.checkExpressionValueIsNotNull(ktNamedDeclaration, "it");
                INSTANCE.checkNamed(ktNamedDeclaration, diagnosticHolder);
            }
        }
        if (declaration instanceof KtTypeParameterListOwner) {
            $receiver$iv = ((KtTypeParameterListOwner)declaration).getTypeParameters();
            for (Object element$iv : $receiver$iv) {
                it = (KtTypeParameter)element$iv;
                KtNamedDeclaration ktNamedDeclaration = it;
                Intrinsics.checkExpressionValueIsNotNull(ktNamedDeclaration, "it");
                INSTANCE.checkNamed(ktNamedDeclaration, diagnosticHolder);
            }
        }
        if (declaration instanceof KtNamedDeclaration) {
            this.checkNamed((KtNamedDeclaration)declaration, diagnosticHolder);
        }
    }

    public final void checkNamed(@NotNull KtNamedDeclaration declaration, @NotNull DiagnosticSink diagnosticHolder) {
        Intrinsics.checkParameterIsNotNull(declaration, "declaration");
        Intrinsics.checkParameterIsNotNull(diagnosticHolder, "diagnosticHolder");
        String string = declaration.getName();
        if (string == null) {
            return;
        }
        String name = string;
        PsiElement psiElement2 = declaration.getNameIdentifier();
        if (psiElement2 == null) {
            psiElement2 = declaration;
        }
        PsiElement element = psiElement2;
        String string2 = name;
        Intrinsics.checkExpressionValueIsNotNull(string2, "name");
        this.reportIfNeeded(string2, element, diagnosticHolder);
    }

    /*
     * WARNING - void declaration
     */
    private final void reportIfNeeded(String name, PsiElement element, DiagnosticSink diagnosticHolder) {
        String text = KtPsiUtil.unquoteIdentifier(name);
        if (StringsKt.isEmpty((CharSequence)text)) {
            diagnosticHolder.report(Errors.INVALID_CHARACTERS.on(element, "should not be empty"));
        } else {
            boolean bl;
            block4: {
                void $receiver$iv;
                CharSequence charSequence = text;
                CharIterator charIterator = StringsKt.iterator((CharSequence)$receiver$iv);
                while (charIterator.hasNext()) {
                    char element$iv = charIterator.nextChar();
                    char it = element$iv;
                    if (!CHARS.contains(Character.valueOf(it))) continue;
                    bl = true;
                    break block4;
                }
                bl = false;
            }
            if (bl) {
                diagnosticHolder.report(Errors.INVALID_CHARACTERS.on(element, "contains illegal characters: " + CollectionsKt.joinToString$default((Iterable)CollectionsKt.intersect((Iterable)CHARS, (Iterable)StringsKt.toSet((CharSequence)text)), (CharSequence)"", null, null, 0, null, null, 62)));
            }
        }
    }

    private JvmSimpleNameBacktickChecker() {
        INSTANCE = this;
        INSTANCE$ = this;
        CHARS = SetsKt.setOf(Character.valueOf('.'), Character.valueOf(';'), Character.valueOf('['), Character.valueOf(']'), Character.valueOf('/'), Character.valueOf('<'), Character.valueOf('>'), Character.valueOf(':'), Character.valueOf('\\'));
    }

    static {
        new JvmSimpleNameBacktickChecker();
    }
}

