/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve;

import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.descriptors.ModalityKt;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtDelegatedSuperTypeEntry;
import org.jetbrains.kotlin.psi.KtSuperTypeListEntry;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.OverridingUtil;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.TypeUtils;

@KotlinClass(version={1, 0, 1}, abiVersion=32, data={"K\u0015\tA\"A\u0003\u0001\u000b\u0005a\u0011!B\u0001\t\u0001\u0015\u0001Q!\u0001\u0007\u0002\u000b\u0001)\u0011\u0001D\u0001\u0006\u0001\u0015\t\u0001bD\u0003\u0002\u0019\u0005)\u0001!B\u0001\r\u0003\u0015\u0001Q!\u0001\u0007\u0002\u000b\u0001)\u0011\u0001D\u0001\u0006\u0003\u0011\tQ!\u0001E\u0006\u000b\u0005!9!B\u0001\r\u0003\u0015\tAa\u0001\u0007\u0001!?)B\u0001\u0002\u0001\t\u0002U\t\u0001$A\r\u00021\u0007i\u001aq\u0004I\u0011C\u0007\"\u0011!C\u0002\t\u00055\t\u0001TA\u0005\u0004\u0011\ri\u0011\u0001g\u0002\n\r!!Q\u0002B\u0005\u0003\u0013\u0005AR\u0001'\u0003\n\u0007!-Q\"\u0001\r\u0007\u0013\u0019Ai!\u0004\u0003\n\u0005%\tA\u0004\u0001\r\b\u0013\rAy!D\u0001\u0019\u0011E\u001b\u0011\u0001#\u0005&$\u0011\t\u0001\"C\u0007\u00021'I2\u0001\u0003\u0006\u000e\u0003q\u0001\u0011D\u0002E\u000b\u001b\u0011I!!C\u0001\u001d\u0001a%\u0011kA\u0001\t\u0017\u0015:A!\u0001E\f\u001b\u0011I!!C\u0001\u001d\u0001a%QE\u0005\u0003\u0002\u00111iA!\u0003\u0002\n\u0003q\u0001\u0001\u0014B\r\u0007\u00113iA!\u0003\u0002\n\u0003q\u0001\u0001\u0014B\r\u0004\u00115i\u0011\u0001g\u0007&\u0017\u0011\t\u0001BD\u0007\u0005\u0013\tI\u0011\u0001\b\u0001\u0019\ne\u0019\u0001\"D\u0007\u000217)3\u0002B\u0001\t\u001e5!\u0011BA\u0005\u00029\u0001AJ!G\u0002\t\u001f5\t\u00014D\u0015\b\t\u0005C\u0001BA\u0007\u00021\u000b\t6!A\u0003\u0001S)!\u0011\t\u0003\u0005\u0005\u001b\u0011I!!C\u0001\u0019\u000ba%\u0011kA\u0001\u0006\u0001%RA!\u0011\u0005\t\u000e5!\u0011BA\u0005\u00029\u0001Ar!U\u0002\u0002\u000b\u0001Is\u0001B!\t\u0011\ri\u0011\u0001g\u0002R\u0007\u0005)\u0001!K\u0004\u0005\u0003\"AY!D\u0001\u0019\rE\u001b\u0011!\u0002\u0001*\u000f\u0011\t\u0005\u0002c\u0004\u000e\u0003aA\u0011kA\u0001\u0006\u0001\u0001"}, strings={"Lorg/jetbrains/kotlin/resolve/DelegationResolver;", "T", "Lorg/jetbrains/kotlin/descriptors/CallableMemberDescriptor;", "", "classOrObject", "Lorg/jetbrains/kotlin/psi/KtClassOrObject;", "ownerDescriptor", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "existingMembers", "", "Lorg/jetbrains/kotlin/descriptors/CallableDescriptor;", "trace", "Lorg/jetbrains/kotlin/resolve/BindingTrace;", "memberExtractor", "Lorg/jetbrains/kotlin/resolve/DelegationResolver$MemberExtractor;", "typeResolver", "Lorg/jetbrains/kotlin/resolve/DelegationResolver$TypeResolver;", "(Lorg/jetbrains/kotlin/psi/KtClassOrObject;Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;Ljava/util/Collection;Lorg/jetbrains/kotlin/resolve/BindingTrace;Lorg/jetbrains/kotlin/resolve/DelegationResolver$MemberExtractor;Lorg/jetbrains/kotlin/resolve/DelegationResolver$TypeResolver;)V", "checkClashWithOtherDelegatedMember", "", "candidate", "delegatedMembers", "(Lorg/jetbrains/kotlin/descriptors/CallableMemberDescriptor;Ljava/util/Collection;)Z", "generateDelegatedMembers", "generateDelegatesForInterface", "existingDelegates", "delegatedInterfaceType", "Lorg/jetbrains/kotlin/types/KotlinType;", "generateDelegationCandidates", "getDelegatableMembers", "interfaceType", "Companion", "MemberExtractor", "TypeResolver"}, moduleName="kotlin-compiler")
public final class DelegationResolver<T extends CallableMemberDescriptor> {
    private final KtClassOrObject classOrObject;
    private final ClassDescriptor ownerDescriptor;
    private final Collection<CallableDescriptor> existingMembers;
    private final BindingTrace trace;
    private final MemberExtractor<T> memberExtractor;
    private final TypeResolver typeResolver;
    public static final Companion Companion = org.jetbrains.kotlin.resolve.DelegationResolver$Companion.INSTANCE;

    private final Collection<T> generateDelegatedMembers() {
        HashSet<CallableMemberDescriptor> delegatedMembers = SetsKt.hashSetOf(new CallableMemberDescriptor[0]);
        for (KtSuperTypeListEntry delegationSpecifier : this.classOrObject.getSuperTypeListEntries()) {
            KtTypeReference typeReference;
            if (!(delegationSpecifier instanceof KtDelegatedSuperTypeEntry)) continue;
            if (((KtDelegatedSuperTypeEntry)delegationSpecifier).getTypeReference() == null) {
                continue;
            }
            KtTypeReference ktTypeReference = typeReference;
            Intrinsics.checkExpressionValueIsNotNull(ktTypeReference, "typeReference");
            KotlinType delegatedInterfaceType = this.typeResolver.resolve(ktTypeReference);
            if (delegatedInterfaceType == null || delegatedInterfaceType.isError()) continue;
            Collection<T> delegatesForInterface = this.generateDelegatesForInterface((Collection)delegatedMembers, delegatedInterfaceType);
            delegatedMembers.addAll(delegatesForInterface);
        }
        return delegatedMembers;
    }

    /*
     * WARNING - void declaration
     */
    private final Collection<T> generateDelegatesForInterface(Collection<? extends T> existingDelegates, KotlinType delegatedInterfaceType) {
        void destination$iv$iv;
        void $receiver$iv$iv;
        Iterable $receiver$iv = this.generateDelegationCandidates(delegatedInterfaceType);
        Iterable iterable = $receiver$iv;
        Collection collection = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            CallableMemberDescriptor candidate = (CallableMemberDescriptor)element$iv$iv;
            if (!(!DelegationResolver.Companion.isOverridingAnyOf(candidate, this.existingMembers) && !this.checkClashWithOtherDelegatedMember(candidate, existingDelegates))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private final Collection<T> generateDelegationCandidates(KotlinType delegatedInterfaceType) {
        void destination$iv$iv;
        void $receiver$iv$iv;
        Iterable $receiver$iv = this.getDelegatableMembers(delegatedInterfaceType);
        Iterable iterable = $receiver$iv;
        Collection collection = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver$iv, 10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            CallableMemberDescriptor callableMemberDescriptor;
            Modality modality;
            void memberDescriptor;
            CallableMemberDescriptor callableMemberDescriptor2 = (CallableMemberDescriptor)item$iv$iv;
            void var8_8 = destination$iv$iv;
            if (Intrinsics.areEqual((Object)memberDescriptor.getModality(), (Object)Modality.ABSTRACT)) {
                modality = Modality.OPEN;
            } else {
                Modality modality2 = memberDescriptor.getModality();
                modality = modality2;
                Intrinsics.checkExpressionValueIsNotNull((Object)modality2, "memberDescriptor.modality");
            }
            Modality newModality = modality;
            if (memberDescriptor.copy(this.ownerDescriptor, newModality, Visibilities.INHERITED, CallableMemberDescriptor.Kind.DELEGATION, false) == null) {
                throw new TypeCastException("null cannot be cast to non-null type T");
            }
            var8_8.add(callableMemberDescriptor);
        }
        return (List)destination$iv$iv;
    }

    private final boolean checkClashWithOtherDelegatedMember(T candidate, Collection<? extends T> delegatedMembers) {
        Object v0;
        block2: {
            Iterable $receiver$iv = delegatedMembers;
            for (Object element$iv : $receiver$iv) {
                CallableMemberDescriptor it = (CallableMemberDescriptor)element$iv;
                if (!DelegationResolver.Companion.isOverridableBy(it, (CallableDescriptor)candidate)) continue;
                v0 = element$iv;
                break block2;
            }
            v0 = null;
        }
        CallableMemberDescriptor alreadyDelegated = v0;
        if (alreadyDelegated != null) {
            this.trace.report(Errors.MANY_IMPL_MEMBER_NOT_IMPLEMENTED.on((KtClassOrObject)((PsiElement)this.classOrObject), this.classOrObject, alreadyDelegated));
            return true;
        }
        return false;
    }

    /*
     * Unable to fully structure code
     */
    private final Collection<T> getDelegatableMembers(KotlinType interfaceType) {
        block11: {
            block10: {
                block8: {
                    $receiver$iv = TypeUtils.getAllSupertypes(interfaceType);
                    var3_3 = $receiver$iv.iterator();
                    while (var3_3.hasNext()) {
                        element$iv = var3_3.next();
                        it = (KotlinType)element$iv;
                        typeConstructor = it.getConstructor().getDeclarationDescriptor();
                        if (!(typeConstructor instanceof ClassDescriptor != false && (Intrinsics.areEqual((Object)((ClassDescriptor)typeConstructor).getKind(), (Object)ClassKind.INTERFACE) ^ true) != false)) continue;
                        v0 = element$iv;
                        break block8;
                    }
                    v0 = null;
                }
                if ((v1 = (KotlinType)v0) == null) break block10;
                $receiver$iv = v1;
                it = (KotlinType)$receiver$iv;
                v1 = this.memberExtractor.getMembersByType((KotlinType)it);
                if (v1 != null) break block11;
            }
            v1 = CollectionsKt.emptyList();
        }
        classSupertypeMembers = v1;
        $receiver$iv = this.memberExtractor.getMembersByType(interfaceType);
        it = $receiver$iv;
        $i$a$2 = new ArrayList<E>();
        for (T element$iv$iv : $receiver$iv$iv) {
            block9: {
                descriptor = (CallableMemberDescriptor)element$iv$iv;
                if (!ModalityKt.isOverridable(descriptor)) ** GOTO lbl-1000
                $i$f$firstOrNull = classSupertypeMembers;
                for (T element$iv : $receiver$iv) {
                    it = (CallableMemberDescriptor)element$iv;
                    if (!org.jetbrains.kotlin.resolve.DelegationResolver$Companion.access$isOverridableBy(DelegationResolver.Companion, it, descriptor)) continue;
                    v2 = true;
                    break block9;
                }
                v2 = false;
            }
            if (!v2) {
                v3 = true;
            } else lbl-1000:
            // 2 sources

            {
                v3 = false;
            }
            if (!v3) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private DelegationResolver(KtClassOrObject classOrObject, ClassDescriptor ownerDescriptor, Collection<? extends CallableDescriptor> existingMembers, BindingTrace trace, MemberExtractor<T> memberExtractor, TypeResolver typeResolver) {
        this.classOrObject = classOrObject;
        this.ownerDescriptor = ownerDescriptor;
        this.existingMembers = existingMembers;
        this.trace = trace;
        this.memberExtractor = memberExtractor;
        this.typeResolver = typeResolver;
    }

    public /* synthetic */ DelegationResolver(@NotNull KtClassOrObject classOrObject, @NotNull ClassDescriptor ownerDescriptor, @NotNull Collection existingMembers, @NotNull BindingTrace trace, @NotNull MemberExtractor memberExtractor, @NotNull TypeResolver typeResolver, DefaultConstructorMarker $constructor_marker) {
        this(classOrObject, ownerDescriptor, existingMembers, trace, memberExtractor, typeResolver);
    }

    @KotlinClass(version={1, 0, 1}, abiVersion=32, data={"\u001b\u0015\tA\"A\u0003\u0001\u000b\u0005a\u0011!B\u0001\t\u0001\u0015\u0001Q!\u0001\u0005\u0010\u000b\u0001)\u0011\u0001D\u0001\u0005g1\u0001Q\u0003\u0002C\u0001\u0011\u0003)\u0012\u0001G\u0001\u001a\u0003a\rQe\u0003\u0003\u0014\u0011\tiA!\u0003\u0002\n\u0003q\u0005\u0001TA\r\u0004\u0011\ri\u0011\u0001g\u0002"}, strings={"Lorg/jetbrains/kotlin/resolve/DelegationResolver$MemberExtractor;", "T", "Lorg/jetbrains/kotlin/descriptors/CallableMemberDescriptor;", "", "getMembersByType", "", "type", "Lorg/jetbrains/kotlin/types/KotlinType;"}, moduleName="kotlin-compiler")
    public static interface MemberExtractor<T extends CallableMemberDescriptor> {
        @NotNull
        public Collection<T> getMembersByType(@NotNull KotlinType var1);
    }

    @KotlinClass(version={1, 0, 1}, abiVersion=32, data={"\u0015\u0015\tA\"A\u0003\u0002\u0011\u0001)\u0001!B\u0001\r\u0003\u0015\u0001Q!\u0001\u0007\u0002\tMb\u0001!G\u0001\u0019\u0002\u0015JAa\u0005\u0005\u0002\u001b\ta\t\u0001g\u0001\u001a\u0007!\u0011Q\"\u0001M\u0003"}, strings={"Lorg/jetbrains/kotlin/resolve/DelegationResolver$TypeResolver;", "", "resolve", "Lorg/jetbrains/kotlin/types/KotlinType;", "reference", "Lorg/jetbrains/kotlin/psi/KtTypeReference;"}, moduleName="kotlin-compiler")
    public static interface TypeResolver {
        @Nullable
        public KotlinType resolve(@NotNull KtTypeReference var1);
    }

    @KotlinClass(version={1, 0, 1}, abiVersion=32, data={"E\u0015\tA\"A\u0003\u0002\u0011\u0001)\u0011\u0001B\u0001\u0006\u0003!yQ\u0001A\u0003\u0002\u0019\u0005)\u0001!B\u0001\r\u0003\u0015\u0001Q!\u0001\u0007\u0002\u000b\u0001)\u0011\u0001D\u0001\u0006\u0001\u0015\tA\"A\u0003\u0001\u000b\u0005a\u0011!\u0002\u0001\u0006\u00031\tQ\u0001A\u0003\u0002\u0011\u0017)\u0011\u0001\"\u0002\u0005\u0007\ba\u0001!G\u0001\u0019\u0002\u0005\u001eA!A)\u0004\u0003!\tQ%\u000bE\u0002\u001b\u0011I!!C\u0001%\u0006a\u0011\u0011\u0003\u0002C\u0001\u0011\u000b)\u0012\u0001G\u0002\u001a\u0007!\u001dQ\"\u0001\r\u00053\rAI!D\u0001\u0019\u000be1\u00012B\u0007\u0005\u0013\tI\u0011\u0001\u0007\u0004\u0019\u0005e\u0019\u0001RB\u0007\u00021\u001dIb\u0001c\u0004\u000e\t%\u0011\u0011\"\u0001S\u00031!I2\u0001#\u0005\u000e\u0003aIQ\u0005\u0004\u0003\u0002\u0011'i\u0011\u0001\u0007\u0006\u001a\u0007!UQ\"\u0001\r\u00073\rA1\"D\u0001\u0019\r\u0015zA!\u0001E\f\u001b\u0005A\"\"G\u0002\t\u00195\t\u0001dA\r\u0007\u00113iA!\u0003\u0002\n\u0003a1\u0001D\u0001"}, strings={"Lorg/jetbrains/kotlin/resolve/DelegationResolver$Companion;", "", "()V", "generateDelegatedMembers", "", "T", "Lorg/jetbrains/kotlin/descriptors/CallableMemberDescriptor;", "classOrObject", "Lorg/jetbrains/kotlin/psi/KtClassOrObject;", "ownerDescriptor", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "existingMembers", "Lorg/jetbrains/kotlin/descriptors/CallableDescriptor;", "trace", "Lorg/jetbrains/kotlin/resolve/BindingTrace;", "memberExtractor", "Lorg/jetbrains/kotlin/resolve/DelegationResolver$MemberExtractor;", "typeResolver", "Lorg/jetbrains/kotlin/resolve/DelegationResolver$TypeResolver;", "isOverridableBy", "", "memberOne", "memberTwo", "isOverridingAnyOf", "candidate", "possiblyOverriddenBy"}, moduleName="kotlin-compiler")
    public static final class Companion {
        public static final Companion INSTANCE;

        @NotNull
        public final <T extends CallableMemberDescriptor> Collection<T> generateDelegatedMembers(@NotNull KtClassOrObject classOrObject, @NotNull ClassDescriptor ownerDescriptor, @NotNull Collection<? extends CallableDescriptor> existingMembers, @NotNull BindingTrace trace, @NotNull MemberExtractor<T> memberExtractor, @NotNull TypeResolver typeResolver) {
            Intrinsics.checkParameterIsNotNull(classOrObject, "classOrObject");
            Intrinsics.checkParameterIsNotNull(ownerDescriptor, "ownerDescriptor");
            Intrinsics.checkParameterIsNotNull(existingMembers, "existingMembers");
            Intrinsics.checkParameterIsNotNull(trace, "trace");
            Intrinsics.checkParameterIsNotNull(memberExtractor, "memberExtractor");
            Intrinsics.checkParameterIsNotNull(typeResolver, "typeResolver");
            return new DelegationResolver(classOrObject, ownerDescriptor, existingMembers, trace, memberExtractor, typeResolver, null).generateDelegatedMembers();
        }

        private final boolean isOverridingAnyOf(CallableMemberDescriptor candidate, Collection<? extends CallableDescriptor> possiblyOverriddenBy) {
            boolean bl;
            block1: {
                Iterable $receiver$iv = possiblyOverriddenBy;
                for (Object element$iv : $receiver$iv) {
                    CallableDescriptor it = (CallableDescriptor)element$iv;
                    if (!Companion.isOverridableBy(it, candidate)) continue;
                    bl = true;
                    break block1;
                }
                bl = false;
            }
            return bl;
        }

        private final boolean isOverridableBy(CallableDescriptor memberOne, CallableDescriptor memberTwo) {
            return Intrinsics.areEqual((Object)OverridingUtil.DEFAULT.isOverridableBy(memberOne, memberTwo, null).getResult(), (Object)OverridingUtil.OverrideCompatibilityInfo.Result.OVERRIDABLE);
        }

        private Companion() {
            INSTANCE = this;
        }

        static {
            new Companion();
        }
    }
}

