/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.psi;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.stubs.IStubElementType;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.name.SpecialNames;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtObjectLiteralExpression;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtVisitor;
import org.jetbrains.kotlin.psi.stubs.KotlinClassOrObjectStub;
import org.jetbrains.kotlin.psi.stubs.KotlinObjectStub;
import org.jetbrains.kotlin.psi.stubs.elements.KtStubElementTypes;

@KotlinClass(version={1, 0, 1}, abiVersion=32, data={"=\u0015\tA\"A\u0003\u0002\u0019\u0005)\u0001!B\u0001\r\u0003\u0015\tA!A\u0003\u0002\u0019\u0005)\u0011\u0001\u0002\u0003\u0006\u00031\tQ!\u0001C\u0002\u000b\u0005Aq!\u0002\u0001\u0006\u00031\tQ\u0001A\u0003\u0002\u0011\u0011)\u0001!B\u0001\t\f\u0015\tA1\u0001\u0007\u00013\u0005A\n!i\u0004\u0005\u0017%\u0019\u0001\"A\u0007\u00021\u0007\t6!\u0001\u0005\u0003C\u001f!1\"C\u0002\t\u00065\t\u0001dA)\u0004\u0003!\u001dQU\u0007\u0003\f\u0011\u0017i\u0011\u0001\n\u0004\u0012\u0005\u0011\u0001\u0001BB\t\u0003\t\u0003Ai!G\u0005\t\u000f59\u0011BA\u0005\u0002I\u0019I!!C\u0001%\u000ea=\u0011d\u0001\u0005\t\u001b\u0005!k!U\u0002\u0002\u0011#)S\u0001B\u0006\t\u00135\u0011A\u0012\u0001M\nK\rA!\"D\u0001\u0019\u0016\u0015\"Aa\u0003\u0005\f\u001b\u0005A:\"J\u0002\t\u00195\t\u0001\u0014D\u0013\u0004\u00115i\u0011\u0001'\u0007&\u0013\u0011Y\u00012D\u0007\u00021+IB\u0001\"\u0001\t\u001d5\t\u00014C\u0015\f\t\u0005C\u0001\u0002B\u0007\u0003\u0019\u0003A2\u0001H\u0011R\u0007\ri!\u0001\"\u0003\t\u000b\u0001"}, strings={"Lorg/jetbrains/kotlin/psi/KtObjectDeclaration;", "Lorg/jetbrains/kotlin/psi/KtClassOrObject;", "node", "Lcom/intellij/lang/ASTNode;", "(Lcom/intellij/lang/ASTNode;)V", "stub", "Lorg/jetbrains/kotlin/psi/stubs/KotlinObjectStub;", "(Lorg/jetbrains/kotlin/psi/stubs/KotlinObjectStub;)V", "_stub", "get_stub", "()Lorg/jetbrains/kotlin/psi/stubs/KotlinObjectStub;", "accept", "R", "D", "visitor", "Lorg/jetbrains/kotlin/psi/KtVisitor;", "data", "(Lorg/jetbrains/kotlin/psi/KtVisitor;Ljava/lang/Object;)Ljava/lang/Object;", "getName", "", "getObjectKeyword", "Lcom/intellij/psi/PsiElement;", "getTextOffset", "", "isCompanion", "", "isObjectLiteral", "setName", "name"}, moduleName="kotlin-compiler")
public final class KtObjectDeclaration
extends KtClassOrObject {
    private final KotlinObjectStub get_stub() {
        KotlinClassOrObjectStub kotlinClassOrObjectStub = (KotlinClassOrObjectStub)this.getStub();
        if (!(kotlinClassOrObjectStub instanceof KotlinObjectStub)) {
            kotlinClassOrObjectStub = null;
        }
        return (KotlinObjectStub)kotlinClassOrObjectStub;
    }

    @Override
    @Nullable
    public String getName() {
        String string = super.getName();
        if (string != null) {
            String $receiver$iv = string;
            String it = $receiver$iv;
            return it;
        }
        if (this.isCompanion() && !this.isTopLevel()) {
            return SpecialNames.DEFAULT_NAME_FOR_COMPANION_OBJECT.toString();
        }
        return null;
    }

    @Override
    @NotNull
    public PsiElement setName(@NonNls @NotNull String name) {
        Intrinsics.checkParameterIsNotNull(name, "name");
        if (this.getNameIdentifier() == null) {
            Project project = this.getProject();
            Intrinsics.checkExpressionValueIsNotNull(project, "project");
            KtPsiFactory psiFactory = new KtPsiFactory(project);
            PsiElement result2 = this.addAfter(psiFactory.createIdentifier(name), this.getObjectKeyword());
            this.addAfter(psiFactory.createWhiteSpace(), this.getObjectKeyword());
            PsiElement psiElement2 = result2;
            Intrinsics.checkExpressionValueIsNotNull(psiElement2, "result");
            return psiElement2;
        }
        PsiElement psiElement3 = super.setName(name);
        Intrinsics.checkExpressionValueIsNotNull(psiElement3, "super.setName(name)");
        return psiElement3;
    }

    public final boolean isCompanion() {
        KotlinObjectStub kotlinObjectStub = this.get_stub();
        return kotlinObjectStub != null ? kotlinObjectStub.isCompanion() : this.hasModifier(KtTokens.COMPANION_KEYWORD);
    }

    @Override
    public int getTextOffset() {
        Object object = this.getNameIdentifier();
        return object != null && (object = object.getTextRange()) != null ? ((TextRange)object).getStartOffset() : this.getObjectKeyword().getTextRange().getStartOffset();
    }

    @Override
    public <R, D> R accept(@NotNull KtVisitor<R, D> visitor2, D data) {
        Intrinsics.checkParameterIsNotNull(visitor2, "visitor");
        return visitor2.visitObjectDeclaration(this, data);
    }

    public final boolean isObjectLiteral() {
        KotlinObjectStub kotlinObjectStub = this.get_stub();
        return kotlinObjectStub != null ? kotlinObjectStub.isObjectLiteral() : this.getParent() instanceof KtObjectLiteralExpression;
    }

    @NotNull
    public final PsiElement getObjectKeyword() {
        Object t = this.findChildByType(KtTokens.OBJECT_KEYWORD);
        if (t == null) {
            Intrinsics.throwNpe();
        }
        return t;
    }

    public KtObjectDeclaration(@NotNull ASTNode node) {
        Intrinsics.checkParameterIsNotNull(node, "node");
        super(node);
    }

    public KtObjectDeclaration(@NotNull KotlinObjectStub stub) {
        Intrinsics.checkParameterIsNotNull(stub, "stub");
        KotlinClassOrObjectStub kotlinClassOrObjectStub = stub;
        IStubElementType iStubElementType = KtStubElementTypes.OBJECT_DECLARATION;
        Intrinsics.checkExpressionValueIsNotNull(iStubElementType, "KtStubElementTypes.OBJECT_DECLARATION");
        super(kotlinClassOrObjectStub, iStubElementType);
    }
}

