/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.load.java.lazy.descriptors;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.TypeCastException;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.Annotated;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.kotlin.incremental.components.NoLookupLocation;
import org.jetbrains.kotlin.load.java.JvmAnnotationNames;
import org.jetbrains.kotlin.load.java.components.DescriptorResolverUtils;
import org.jetbrains.kotlin.load.java.components.TypeUsage;
import org.jetbrains.kotlin.load.java.lazy.LazyJavaClassResolver;
import org.jetbrains.kotlin.load.java.lazy.LazyJavaResolverContext;
import org.jetbrains.kotlin.load.java.lazy.ModuleClassResolver;
import org.jetbrains.kotlin.load.java.lazy.descriptors.LazyJavaAnnotationDescriptor;
import org.jetbrains.kotlin.load.java.lazy.descriptors.LazyJavaAnnotationDescriptorKt;
import org.jetbrains.kotlin.load.java.lazy.types.LazyJavaTypeResolverKt;
import org.jetbrains.kotlin.load.java.sources.JavaSourceElement;
import org.jetbrains.kotlin.load.java.structure.JavaAnnotation;
import org.jetbrains.kotlin.load.java.structure.JavaAnnotationArgument;
import org.jetbrains.kotlin.load.java.structure.JavaAnnotationAsAnnotationArgument;
import org.jetbrains.kotlin.load.java.structure.JavaArrayAnnotationArgument;
import org.jetbrains.kotlin.load.java.structure.JavaClass;
import org.jetbrains.kotlin.load.java.structure.JavaClassObjectAnnotationArgument;
import org.jetbrains.kotlin.load.java.structure.JavaEnumValueAnnotationArgument;
import org.jetbrains.kotlin.load.java.structure.JavaField;
import org.jetbrains.kotlin.load.java.structure.JavaLiteralAnnotationArgument;
import org.jetbrains.kotlin.load.java.structure.JavaType;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.platform.JavaToKotlinClassMap;
import org.jetbrains.kotlin.renderer.DescriptorRenderer;
import org.jetbrains.kotlin.resolve.constants.ConstantValue;
import org.jetbrains.kotlin.resolve.constants.ConstantValueFactory;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.scopes.MemberScope;
import org.jetbrains.kotlin.storage.NotNullLazyValue;
import org.jetbrains.kotlin.storage.NullableLazyValue;
import org.jetbrains.kotlin.types.AbstractLazyType;
import org.jetbrains.kotlin.types.ErrorUtils;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.TypeConstructor;
import org.jetbrains.kotlin.types.TypeProjectionImpl;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.kotlin.utils.CollectionsKt;

@KotlinClass(version={1, 0, 1}, abiVersion=32, data={"\u007f\u0015\tA\"A\u0003\u0002\u0019\u0005)\u0001!B\u0001\r\u0003\u0015\u0001Q!\u0001\u0007\u0002\u000b\u0005!\u0011!B\u0001\r\u0003\u0015\t\u0001BE\u0003\u0002\u0019\u0005)\u0011\u0001D\u0001\u0006\u0001\u0015\tA\"A\u0003\u0001\u000b\u0005a\u0011!B\u0001\r\u0003\u0015\tA\"A\u0003\u0002\t\u0007)\u0011\u0001D\u0001\u0006\u0001\u0015\tA\"A\u0003\u0002\t\u0007)\u0011\u0001D\u0001\u0006\u0003\u0011\u0011Q!\u0001\u0007\u0002\u000b\u0005!\u0019!B\u0001\r\u0003\u0015\u0001Q!\u0001\u0005\u0011\u000b\u0005!\u0011!B\u0001\r\u0003\u0015\tA!A\u0003\u0002\u0019\u0005)\u0001!B\u0001\t\u000f1\u0001\u0011$\u0001M\u0001C+I1\u0001C\u0001\u000e\u0003a\r\u0011b\u0001\u0005\u0003\u001b\u0005A*!U\u0002\u0002\u0011\r)C\u0002B\u0001\t\u00195I\u0011BA\u0005\u00021\u0015IA!C\u0002\n\u0003\u0011\r\u00014\u0002M\u0005K1!1\u0002#\u0007\u000e\u0013%\u0011\u0011\"\u0001\r\u0006\u0013\u0011I1!C\u0001\u0005\u0004a-\u0001\u0014B\u0013\u0005\t\u0005AQ\"D\u0001\u0019\u001c\u0015\"Aa\u0003\u0005\u000f\u001b\u0005A*\"\n\u0003\u0005\u0017!uQ\"\u0001M\fK1!\u0011\u0001C\b\u000e\t%\tA1\u0001G\u00011\u0017IB\u0001c\b\u000e\u00051\u0005\u0001\u0004E\u0013\f\t\u0005A\t#\u0004\u0003\n\u0003\u0011\rA\u0012\u0001M\u00063\rA!!D\u0001\u0019\u0006\u0015\u0012B!\u0001\u0005\u0012\u001b\u0011I\u0011\u0001b\u0001\r\u0002a-\u0011d\u0001E\u0012\u001b\u0005A\"#\u0007\u0004\t&5!\u0011BA\u0005\u00021AA2#\n\u0007\u0005\u0003!\u001dR\u0002B\u0005\u0002\t\u0007a\t\u0001g\u0003\u001a\t!!RB\u0001G\u00011S)3\u0002B\u0001\t+5!\u0011\"\u0001C\u0002\u0019\u0003AZ!G\u0002\t,5\t\u0001DF\u0013\u0005\t-Ai#D\u0001\u0019/%\u0012B!\u0011\u0005\t\b5a\u0011BC\u0005\n\u0013\tI\u0011\u0001G\u0003\n\t%\u0019\u0011\"\u0001C\u00021\u0017AJ\u0001\u0007\u0003R\u0007\u0005)\u0001!K\u0004\u0005\u0003\"A\u0011!D\u0001\u0019\u0004E\u001b\u0011!\u0002\u0001*\u000f\u0011\t\u0005\u0002\u0003\u0004\u000e\u0003a5\u0011kA\u0001\u0006\u0001%fA!\u0011\u0005\t\u000f55\u0011\u0012BE\u00041!\t6!\u0001C\t1\u001f\t6!A\u0003\u0001S)!1\t\u0003\u0005\u0003\u001b\u0005A*!U\u0002\u0005\u000b\u0001i!\u0001B\u0005\t\u0014%:A!\u0011\u0005\t\u00155\t\u0001TC)\u0004\u0003\u0015\u0001\u0011\u0016\u0004\u0003B\u0011!YQRBE\u0005\u0013\u000fA:\"U\u0002\u0002\t#AB!U\u0002\u0002\u000b\u0001\u0001"}, strings={"Lorg/jetbrains/kotlin/load/java/lazy/descriptors/LazyJavaAnnotationDescriptor;", "Lorg/jetbrains/kotlin/descriptors/annotations/AnnotationDescriptor;", "c", "Lorg/jetbrains/kotlin/load/java/lazy/LazyJavaResolverContext;", "javaAnnotation", "Lorg/jetbrains/kotlin/load/java/structure/JavaAnnotation;", "(Lorg/jetbrains/kotlin/load/java/lazy/LazyJavaResolverContext;Lorg/jetbrains/kotlin/load/java/structure/JavaAnnotation;)V", "allValueArguments", "Lorg/jetbrains/kotlin/storage/NotNullLazyValue;", "", "Lorg/jetbrains/kotlin/descriptors/ValueParameterDescriptor;", "Lorg/jetbrains/kotlin/resolve/constants/ConstantValue;", "factory", "Lorg/jetbrains/kotlin/resolve/constants/ConstantValueFactory;", "fqName", "Lorg/jetbrains/kotlin/storage/NullableLazyValue;", "Lorg/jetbrains/kotlin/name/FqName;", "Lorg/jetbrains/annotations/NotNull;", "getJavaAnnotation", "()Lorg/jetbrains/kotlin/load/java/structure/JavaAnnotation;", "source", "Lorg/jetbrains/kotlin/load/java/sources/JavaSourceElement;", "type", "Lorg/jetbrains/kotlin/types/KotlinType;", "computeValueArguments", "getAllValueArguments", "getAnnotationClass", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "getSource", "getType", "resolveAnnotationArgument", "argument", "Lorg/jetbrains/kotlin/load/java/structure/JavaAnnotationArgument;", "resolveFromAnnotation", "resolveFromArray", "argumentName", "Lorg/jetbrains/kotlin/name/Name;", "elements", "", "resolveFromEnumValue", "element", "Lorg/jetbrains/kotlin/load/java/structure/JavaField;", "resolveFromJavaClassObjectType", "javaType", "Lorg/jetbrains/kotlin/load/java/structure/JavaType;", "toString", ""}, moduleName="kotlin-compiler")
public final class LazyJavaAnnotationDescriptor
implements AnnotationDescriptor {
    private final NullableLazyValue<FqName> fqName;
    private final NotNullLazyValue<KotlinType> type;
    private final JavaSourceElement source;
    private final ConstantValueFactory factory;
    private final NotNullLazyValue<Map<ValueParameterDescriptor, ConstantValue<?>>> allValueArguments;
    private final LazyJavaResolverContext c;
    @NotNull
    private final JavaAnnotation javaAnnotation;

    @Override
    @NotNull
    public KotlinType getType() {
        KotlinType kotlinType = (KotlinType)this.type.invoke();
        Intrinsics.checkExpressionValueIsNotNull(kotlinType, "type()");
        return kotlinType;
    }

    @Override
    @NotNull
    public Map<ValueParameterDescriptor, ConstantValue<?>> getAllValueArguments() {
        return (Map)this.allValueArguments.invoke();
    }

    @Override
    @NotNull
    public JavaSourceElement getSource() {
        return this.source;
    }

    private final Map<ValueParameterDescriptor, ConstantValue<?>> computeValueArguments() {
        Collection<ConstructorDescriptor> constructors2 = this.getAnnotationClass().getConstructors();
        if (constructors2.isEmpty()) {
            return MapsKt.mapOf();
        }
        Map nameToArg2 = CollectionsKt.valuesToMap((Iterable)this.javaAnnotation.getArguments(), (Function1)computeValueArguments.nameToArg.1.INSTANCE);
        return CollectionsKt.keysToMapExceptNulls((Iterable)((ConstructorDescriptor)kotlin.collections.CollectionsKt.first((Iterable)constructors2)).getValueParameters(), (Function1)new Function1<ValueParameterDescriptor, ConstantValue<?>>(this, nameToArg2){
            final /* synthetic */ LazyJavaAnnotationDescriptor this$0;
            final /* synthetic */ Map $nameToArg;

            @Nullable
            public final ConstantValue<?> invoke(ValueParameterDescriptor valueParameter) {
                JavaAnnotationArgument javaAnnotationArgument = (JavaAnnotationArgument)this.$nameToArg.get(valueParameter.getName());
                if (javaAnnotationArgument == null && Intrinsics.areEqual(valueParameter.getName(), JvmAnnotationNames.DEFAULT_ANNOTATION_MEMBER_NAME)) {
                    javaAnnotationArgument = (JavaAnnotationArgument)this.$nameToArg.get(null);
                }
                return LazyJavaAnnotationDescriptor.access$resolveAnnotationArgument(this.this$0, javaAnnotationArgument);
            }
            {
                this.this$0 = lazyJavaAnnotationDescriptor;
                this.$nameToArg = map2;
                super(1);
            }
        });
    }

    private final ClassDescriptor getAnnotationClass() {
        ClassifierDescriptor classifierDescriptor = this.getType().getConstructor().getDeclarationDescriptor();
        if (classifierDescriptor == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.descriptors.ClassDescriptor");
        }
        return (ClassDescriptor)classifierDescriptor;
    }

    private final ConstantValue<?> resolveAnnotationArgument(JavaAnnotationArgument argument) {
        ConstantValue<?> constantValue;
        JavaAnnotationArgument javaAnnotationArgument = argument;
        if (javaAnnotationArgument instanceof JavaLiteralAnnotationArgument) {
            constantValue = this.factory.createConstantValue(((JavaLiteralAnnotationArgument)argument).getValue());
        } else if (javaAnnotationArgument instanceof JavaEnumValueAnnotationArgument) {
            constantValue = this.resolveFromEnumValue(((JavaEnumValueAnnotationArgument)argument).resolve());
        } else if (javaAnnotationArgument instanceof JavaArrayAnnotationArgument) {
            Name name = argument.getName();
            if (name == null) {
                Name name2 = JvmAnnotationNames.DEFAULT_ANNOTATION_MEMBER_NAME;
                name = name2;
                Intrinsics.checkExpressionValueIsNotNull(name2, "DEFAULT_ANNOTATION_MEMBER_NAME");
            }
            constantValue = this.resolveFromArray(name, ((JavaArrayAnnotationArgument)argument).getElements());
        } else {
            constantValue = javaAnnotationArgument instanceof JavaAnnotationAsAnnotationArgument ? this.resolveFromAnnotation(((JavaAnnotationAsAnnotationArgument)argument).getAnnotation()) : (javaAnnotationArgument instanceof JavaClassObjectAnnotationArgument ? this.resolveFromJavaClassObjectType(((JavaClassObjectAnnotationArgument)argument).getReferencedType()) : (ConstantValue<?>)null);
        }
        return constantValue;
    }

    private final ConstantValue<?> resolveFromAnnotation(JavaAnnotation javaAnnotation) {
        LazyJavaAnnotationDescriptor lazyJavaAnnotationDescriptor = LazyJavaAnnotationDescriptorKt.resolveAnnotation(this.c, javaAnnotation);
        if (lazyJavaAnnotationDescriptor == null) {
            return null;
        }
        LazyJavaAnnotationDescriptor descriptor2 = lazyJavaAnnotationDescriptor;
        return this.factory.createAnnotationValue(descriptor2);
    }

    /*
     * WARNING - void declaration
     */
    private final ConstantValue<?> resolveFromArray(Name argumentName, List<? extends JavaAnnotationArgument> elements) {
        void destination$iv$iv;
        void $receiver$iv$iv;
        void $receiver$iv;
        if (this.getType().isError()) {
            return null;
        }
        ValueParameterDescriptor valueParameterDescriptor = DescriptorResolverUtils.getAnnotationParameterByName(argumentName, this.getAnnotationClass());
        if (valueParameterDescriptor == null) {
            return null;
        }
        ValueParameterDescriptor valueParameter = valueParameterDescriptor;
        Iterable iterable = elements;
        void var5_5 = $receiver$iv;
        Collection collection = new ArrayList(kotlin.collections.CollectionsKt.collectionSizeOrDefault($receiver$iv, 10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void argument;
            JavaAnnotationArgument javaAnnotationArgument = (JavaAnnotationArgument)item$iv$iv;
            void var10_10 = destination$iv$iv;
            ConstantValue constantValue = this.resolveAnnotationArgument((JavaAnnotationArgument)argument);
            if (constantValue == null) {
                constantValue = this.factory.createNullValue();
            }
            ConstantValue constantValue2 = constantValue;
            var10_10.add(constantValue2);
        }
        List values = (List)destination$iv$iv;
        KotlinType kotlinType = valueParameter.getType();
        Intrinsics.checkExpressionValueIsNotNull(kotlinType, "valueParameter.getType()");
        return this.factory.createArrayValue(values, kotlinType);
    }

    private final ConstantValue<?> resolveFromEnumValue(JavaField element) {
        if (element == null || !element.isEnumEntry()) {
            return null;
        }
        JavaClass containingJavaClass = element.getContainingClass();
        LazyJavaClassResolver lazyJavaClassResolver = this.c.getJavaClassResolver();
        JavaClass javaClass = containingJavaClass;
        Intrinsics.checkExpressionValueIsNotNull(javaClass, "containingJavaClass");
        ClassDescriptor classDescriptor = lazyJavaClassResolver.resolveClass(javaClass);
        if (classDescriptor == null) {
            return null;
        }
        ClassDescriptor enumClass = classDescriptor;
        MemberScope memberScope2 = enumClass.getUnsubstitutedInnerClassesScope();
        Name name = element.getName();
        Intrinsics.checkExpressionValueIsNotNull(name, "element.getName()");
        ClassifierDescriptor classifier2 = memberScope2.getContributedClassifier(name, NoLookupLocation.FROM_JAVA_LOADER);
        if (!(classifier2 instanceof ClassDescriptor)) {
            return null;
        }
        return this.factory.createEnumValue((ClassDescriptor)classifier2);
    }

    private final ConstantValue<?> resolveFromJavaClassObjectType(JavaType javaType2) {
        KotlinType type2 = TypeUtils.makeNotNullable(this.c.getTypeResolver().transformJavaType(javaType2, LazyJavaTypeResolverKt.toAttributes$default(TypeUsage.MEMBER_SIGNATURE_INVARIANT, false, false, null, 6)));
        ClassDescriptor classDescriptor = DescriptorUtilsKt.resolveTopLevelClass(this.c.getModule(), new FqName("java.lang.Class"), NoLookupLocation.FOR_NON_TRACKED_SCOPE);
        if (classDescriptor == null) {
            return null;
        }
        ClassDescriptor jlClass = classDescriptor;
        List<TypeProjectionImpl> arguments2 = kotlin.collections.CollectionsKt.listOf(new TypeProjectionImpl(type2));
        AbstractLazyType javaClassObjectType2 = new AbstractLazyType(jlClass, arguments2, this.c.getStorageManager()){
            final /* synthetic */ ClassDescriptor $jlClass;
            final /* synthetic */ List $arguments;

            @NotNull
            protected TypeConstructor computeTypeConstructor() {
                return this.$jlClass.getTypeConstructor();
            }

            @NotNull
            protected List<TypeProjectionImpl> computeArguments() {
                return this.$arguments;
            }

            @NotNull
            protected MemberScope computeMemberScope() {
                return this.$jlClass.getMemberScope(this.$arguments);
            }
            {
                this.$jlClass = $captured_local_variable$0;
                this.$arguments = $captured_local_variable$1;
                super($super_call_param$2);
            }
        };
        return this.factory.createKClassValue(javaClassObjectType2);
    }

    @NotNull
    public String toString() {
        return DescriptorRenderer.renderAnnotation$default(DescriptorRenderer.Companion.getFQ_NAMES_IN_TYPES(), this, null, 2);
    }

    @NotNull
    public final JavaAnnotation getJavaAnnotation() {
        return this.javaAnnotation;
    }

    public LazyJavaAnnotationDescriptor(@NotNull LazyJavaResolverContext c, @NotNull JavaAnnotation javaAnnotation) {
        Intrinsics.checkParameterIsNotNull(c, "c");
        Intrinsics.checkParameterIsNotNull(javaAnnotation, "javaAnnotation");
        this.c = c;
        this.javaAnnotation = javaAnnotation;
        this.fqName = this.c.getStorageManager().createNullableLazyValue((Function0)new Function0<FqName>(this){
            final /* synthetic */ LazyJavaAnnotationDescriptor this$0;

            @Nullable
            public final FqName invoke() {
                ClassId classId = this.this$0.getJavaAnnotation().getClassId();
                return classId != null ? classId.asSingleFqName() : null;
            }
            {
                this.this$0 = lazyJavaAnnotationDescriptor;
                super(0);
            }
        });
        this.type = this.c.getStorageManager().createLazyValue((Function0)new Function0<KotlinType>(this){
            final /* synthetic */ LazyJavaAnnotationDescriptor this$0;

            @NotNull
            public final KotlinType invoke() {
                ClassDescriptor annotationClass;
                Annotated annotated;
                FqName fqName2 = (FqName)LazyJavaAnnotationDescriptor.access$getFqName$p(this.this$0).invoke();
                if (fqName2 == null) {
                    return ErrorUtils.createErrorType("No fqName: " + this.this$0.getJavaAnnotation());
                }
                FqName fqName3 = fqName2;
                ClassDescriptor classDescriptor = JavaToKotlinClassMap.INSTANCE.mapJavaToKotlin(fqName3);
                if (classDescriptor == null) {
                    JavaClass javaClass = this.this$0.getJavaAnnotation().resolve();
                    if (javaClass != null) {
                        JavaClass $receiver$iv = javaClass;
                        JavaClass javaClass2 = $receiver$iv;
                        ModuleClassResolver moduleClassResolver2 = LazyJavaAnnotationDescriptor.access$getC$p(this.this$0).getComponents().getModuleClassResolver();
                        JavaClass javaClass3 = javaClass2;
                        Intrinsics.checkExpressionValueIsNotNull(javaClass3, "javaClass");
                        classDescriptor = moduleClassResolver2.resolveClass(javaClass3);
                    } else {
                        classDescriptor = null;
                    }
                }
                if ((annotated = (annotationClass = classDescriptor)) == null || (annotated = annotated.getDefaultType()) == null) {
                    annotated = ErrorUtils.createErrorType(fqName3.asString());
                }
                return annotated;
            }
            {
                this.this$0 = lazyJavaAnnotationDescriptor;
                super(0);
            }
        });
        this.source = this.c.getComponents().getSourceElementFactory().source(this.javaAnnotation);
        this.factory = new ConstantValueFactory(this.c.getModule().getBuiltIns());
        this.allValueArguments = this.c.getStorageManager().createLazyValue(new Function0<Map<ValueParameterDescriptor, ? extends ConstantValue<?>>>(this){
            final /* synthetic */ LazyJavaAnnotationDescriptor this$0;

            @NotNull
            public final Map<ValueParameterDescriptor, ConstantValue<?>> invoke() {
                return LazyJavaAnnotationDescriptor.access$computeValueArguments(this.this$0);
            }
            {
                this.this$0 = lazyJavaAnnotationDescriptor;
                super(0);
            }
        });
    }

    @Nullable
    public static final /* synthetic */ ConstantValue access$resolveAnnotationArgument(LazyJavaAnnotationDescriptor $this, @Nullable JavaAnnotationArgument argument) {
        return $this.resolveAnnotationArgument(argument);
    }

    @NotNull
    public static final /* synthetic */ NullableLazyValue access$getFqName$p(LazyJavaAnnotationDescriptor $this) {
        return $this.fqName;
    }

    @NotNull
    public static final /* synthetic */ LazyJavaResolverContext access$getC$p(LazyJavaAnnotationDescriptor $this) {
        return $this.c;
    }

    @NotNull
    public static final /* synthetic */ Map access$computeValueArguments(LazyJavaAnnotationDescriptor $this) {
        return $this.computeValueArguments();
    }
}

