/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.resolve;

import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.diagnostics.DiagnosticSink;
import org.jetbrains.kotlin.diagnostics.rendering.DiagnosticRendererUtilKt;
import org.jetbrains.kotlin.js.resolve.diagnostics.ErrorsJs;
import org.jetbrains.kotlin.js.translate.utils.AnnotationsUtils;
import org.jetbrains.kotlin.name.FqNameUnsafe;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtEnumEntry;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.KtObjectDeclaration;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.DeclarationChecker;
import org.jetbrains.kotlin.resolve.DescriptorUtils;

@KotlinClass(version={1, 0, 1}, abiVersion=32, data={")\u0015\tA\"A\u0003\u0002\u0019\u0005)\u0011\u0001B\u0001\u0006\u0003!\tQ\u0001A\u0003\u0002\u0019\u0005)\u0001!B\u0001\r\u0003\u0015\u0001Q!\u0001\u0007\u0002\u000b\u0001)\u0011\u0001D\u0001\r\u0001e\t\u0001\u0014AQ\u0003#\u000e\t\u0001\"A\u0013\u0015\t-A\u0019!D\u0001\u0019\u0005e\u0019\u0001RA\u0007\u00021\rI2\u0001c\u0002\u000e\u0003a!\u0011d\u0001E\u0005\u001b\u0005AR!G\u0002\t\f5\t\u0001D\u0002"}, strings={"Lorg/jetbrains/kotlin/js/resolve/ClassDeclarationChecker;", "Lorg/jetbrains/kotlin/resolve/DeclarationChecker;", "()V", "check", "", "declaration", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "descriptor", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "diagnosticHolder", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticSink;", "bindingContext", "Lorg/jetbrains/kotlin/resolve/BindingContext;"}, moduleName="kotlin-compiler")
public final class ClassDeclarationChecker
implements DeclarationChecker {
    @Override
    public void check(@NotNull KtDeclaration declaration, @NotNull DeclarationDescriptor descriptor2, @NotNull DiagnosticSink diagnosticHolder, @NotNull BindingContext bindingContext2) {
        Intrinsics.checkParameterIsNotNull(declaration, "declaration");
        Intrinsics.checkParameterIsNotNull(descriptor2, "descriptor");
        Intrinsics.checkParameterIsNotNull(diagnosticHolder, "diagnosticHolder");
        Intrinsics.checkParameterIsNotNull(bindingContext2, "bindingContext");
        if (!(declaration instanceof KtClassOrObject) || declaration instanceof KtObjectDeclaration || declaration instanceof KtEnumEntry) {
            return;
        }
        FqNameUnsafe fqNameUnsafe = DescriptorUtils.getFqName(descriptor2);
        if (StringsKt.startsWith$default(fqNameUnsafe.asString(), "kotlin.", false, 2)) {
            return;
        }
        if (!DescriptorUtils.isTopLevelDeclaration(descriptor2) && !AnnotationsUtils.isNativeObject(descriptor2)) {
            DeclarationDescriptor declarationDescriptor = descriptor2;
            if (declarationDescriptor == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.descriptors.ClassDescriptor");
            }
            diagnosticHolder.report(ErrorsJs.NON_TOPLEVEL_CLASS_DECLARATION.on((KtNamedDeclaration)declaration, DiagnosticRendererUtilKt.renderKind((ClassDescriptor)declarationDescriptor)));
        }
    }
}

