/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.inline.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Pair;
import kotlin.PreconditionsKt;
import kotlin.Sequence;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinFileFacade;
import org.jetbrains.annotations.NotNull;

@KotlinFileFacade(version={1, 0, 1}, abiVersion=32, data={"'\u0015\u0001Q!\u0001E\u0012\u000b\u0005!\u0019!B\u0001\t\u001f\u0015\tA\"A\u0003\u0001\u000b\u0005A\u0001#B\u0001\r\u0003\u0015\u0001Q!\u0001\u0005\u000f\u000b\u0005!\u0019!$\u0006\t\u00015!\u0011BA\u0005\u0002I\u0005A\n!\u0005\u0002\u0005\u0001!\tAka\u0001\u000e !\u0011Q\u0002B\u0005\u0003\u0013\u0005!\u0013\u0001'\u0001\u0012\u0005\u0011\u0001\u0001\"A\u000b\u0005\u0013\tI\u0011\u0001J\u0001\u0019\u0006Q\u001b\u0019!d\b\t\u00055!\u0011BA\u0005\u0002I\u0005A\n!\u0005\u0002\u0005\u0001!\tQ\u0003B\u0005\u0003\u0013\u0005!\u0013\u0001G\u0002U\u0007\u0007i\u0011\u0006c\u0002\u000e\u0015%A\u0011bB\u0005\u0003\u0013\u0005!\u0013!\u0003\u0002\n\u0003\u0011*\u0001\u0014\u0002\r\u0005#\t!\u0001\u0001C\u0001\u0012\u0005\u0011\u0005\u0001\"B\u000b\u0005\u0013\tI\u0011\u0001J\u0001\u0019\fe=\u0001BB\u0007\u0005\u0013\tI\u0011\u0001J\u0003\u0019\fA\u001b\t!'\u0003\t\u000e5\tA%\u0001)\u0004\u0003E\u001b\u0011\u0001C\u0004U\u0007\u0007\u0001"}, strings={"IdentitySet", "", "T", "CollectionUtilsKt", "toIdentitySet", "", "Lkotlin/Sequence;", "zipWithDefault", "", "Lkotlin/Pair;", "R", "", "other", "defaultT", "(Ljava/lang/Iterable;Ljava/lang/Iterable;Ljava/lang/Object;)Ljava/util/List;"}, moduleName="kotlin-compiler")
public final class CollectionUtilsKt {
    @NotNull
    public static final <T> Set<T> IdentitySet() {
        Set set = Collections.newSetFromMap(new IdentityHashMap());
        Intrinsics.checkExpressionValueIsNotNull(set, "Collections.newSetFromMa\u2026ityHashMap<T, Boolean>())");
        return set;
    }

    @NotNull
    public static final <T> Set<T> toIdentitySet(Collection<? extends T> $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Set<T> result2 = CollectionUtilsKt.IdentitySet();
        for (T element : $receiver) {
            result2.add(element);
        }
        return result2;
    }

    @NotNull
    public static final <T> Set<T> toIdentitySet(Sequence<? extends T> $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Set<T> result2 = CollectionUtilsKt.IdentitySet();
        Iterator<T> iterator2 = $receiver.iterator();
        while (iterator2.hasNext()) {
            T element = iterator2.next();
            result2.add(element);
        }
        return result2;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final <T, R> List<Pair<T, R>> zipWithDefault(Iterable<? extends T> $receiver, @NotNull Iterable<? extends R> other, T defaultT) {
        Unit unit;
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(other, "other");
        Iterator<T> itT = $receiver.iterator();
        Iterator<R> itR = other.iterator();
        ArrayList<Pair> result2 = CollectionsKt.arrayListOf(new Pair[0]);
        while (itT.hasNext() && itR.hasNext()) {
            result2.add(TuplesKt.to(itT.next(), itR.next()));
        }
        boolean bl = !itT.hasNext();
        if (PreconditionsKt.getASSERTIONS_ENABLED()) {
            void value$iv;
            if (value$iv == false) {
                String message$iv = "First collection is bigger than second";
                throw (Throwable)((Object)new AssertionError((Object)message$iv));
            }
            unit = Unit.INSTANCE;
        } else {
            unit = Unit.INSTANCE;
        }
        while (itR.hasNext()) {
            result2.add(TuplesKt.to(defaultT, itR.next()));
        }
        return result2;
    }
}

