/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.types.expressions;

import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.PreconditionsKt;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.Annotations;
import org.jetbrains.kotlin.descriptors.impl.AnonymousFunctionDescriptor;
import org.jetbrains.kotlin.descriptors.impl.SimpleFunctionDescriptorImpl;
import org.jetbrains.kotlin.diagnostics.DiagnosticSink;
import org.jetbrains.kotlin.diagnostics.DiagnosticUtils;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtFunctionLiteral;
import org.jetbrains.kotlin.psi.KtFunctionLiteralExpression;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtReturnExpression;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.KtTreeVisitor;
import org.jetbrains.kotlin.psi.KtVisitor;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import org.jetbrains.kotlin.relocated.com.google.common.collect.Lists;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingContextUtils;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.DeclarationsCheckerKt;
import org.jetbrains.kotlin.resolve.FunctionDescriptorResolver;
import org.jetbrains.kotlin.resolve.FunctionDescriptorUtil;
import org.jetbrains.kotlin.resolve.IdentifierChecker;
import org.jetbrains.kotlin.resolve.UnderscoreChecker;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowInfo;
import org.jetbrains.kotlin.resolve.lazy.ForceResolveUtil;
import org.jetbrains.kotlin.resolve.scopes.LexicalScope;
import org.jetbrains.kotlin.resolve.scopes.LexicalWritableScope;
import org.jetbrains.kotlin.resolve.source.KotlinSourceElementKt;
import org.jetbrains.kotlin.types.CommonSupertypes;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.kotlin.types.expressions.CoercionStrategy;
import org.jetbrains.kotlin.types.expressions.ExpressionTypingContext;
import org.jetbrains.kotlin.types.expressions.ExpressionTypingInternals;
import org.jetbrains.kotlin.types.expressions.ExpressionTypingServices;
import org.jetbrains.kotlin.types.expressions.ExpressionTypingVisitor;
import org.jetbrains.kotlin.types.expressions.KotlinTypeInfo;
import org.jetbrains.kotlin.types.expressions.ValueParameterResolver;
import org.jetbrains.kotlin.types.expressions.typeInfoFactory.TypeInfoFactoryKt;
import org.jetbrains.kotlin.utils.CollectionsKt;

@KotlinClass(version={1, 0, 0}, abiVersion=32, data={"i\u0015\tA\"A\u0003\u0002\u0019\u0005)\u0001!B\u0001\r\u0003\u0015\tA!A\u0003\u0002\u0011=)\u0011\u0001D\u0001\u0006\u0001\u0015\tA\"A\u0003\u0001\u000b\u0005a\u0011!\u0002\u0001\u0006\u00031\tQ\u0001A\u0003\u0002\u0019\u0005)\u0001!B\u0001\r\u0003\u0015\u0001Q!\u0001\u0007\u0002\u000b\u0001)\u0011\u0001c\u0003\u0006\u0003\u0011\u0015Q!\u0001\u0007\u0002\u000b\u0001)\u0011\u0001D\u0001\u0006\u0001\u0015\tA\"A\u0003\u0002\t\u0005)\u0011\u0001D\u0001\u0006\u0003\u0011\rQ!\u0001\u0007\u0002\t\u0001a\u0001!G\u0001\u0019\u0002\u00056\u0011b\u0001\u0005\u0002\u001b\u0005A\u001a!U\u0002\u0002\u0011\t)s\u0002B\u0001\t\u00065!\u0011BA\u0005\u00021\u000fA2!G\u0002\t\t5\t\u0001\u0014B\r\u0004\u0011\u0015i\u0011\u0001g\u0003&)\u0011\t\u0001BB\u0007\u00021\u001bI2\u0001C\u0004\u000e\u0003a=\u0011d\u0001\u0005\t\u001b\u0005A\n\"G\u0002\t\u00135\t\u00014C\r\u0004\u0011)i\u0011\u0001'\u0006&%\u0011\t\u0001bC\u0007\u0003\u0019\u0003Aj!G\u0002\t\t5\t\u0001\u0014B\r\u0004\u0011!i\u0011\u0001'\u0005\u001a\t!]QB\u0001G\u00011\u001b)c\u0003B\u0001\t\u00195\u0011A\u0012\u0001M\u00073\rAq!D\u0001\u0019\u0010e\u0019\u0001\u0002C\u0007\u00021#I2\u0001C\u0005\u000e\u0003aM\u0011\u0004\u0002E\r\u001b\ta\t\u0001'\u0004&\u0019\u0011\t\u0001\"D\u0007\u000217I2\u0001C\u0004\u000e\u0003a=\u0011d\u0001\u0005\t\u001b\u0005A\n\"J\u0005\u0005\u0003!qQB\u0001G\u00011\u001bI2\u0001C\u0005\u000e\u0003auQ%\u0004\u0003\f\u0011=i!\u0001$\u0001\u0019 e\u0019\u0001bB\u0007\u00021\u001fI2\u0001\u0003\u0005\u000e\u0003aEQ\u0005\u0004\u0003\f\u0011Ai\u0011\u0001g\b\u001a\u0007!\u0005R\"\u0001\r\u00123\rA\u0019#D\u0001\u0019\u0012\u0015\"\u0002\u0002E\u0007\u00021?I2\u0001#\t\u000e\u0003a\t\u0012d\u0001\u0005\t\u001b\u0005A\n\"G\u0002\t%5\t\u0001TC\r\u0005\u0011Ki!\u0001$\u0001\u0019'\u0001"}, strings={"Lorg/jetbrains/kotlin/types/expressions/FunctionsTypingVisitor;", "Lorg/jetbrains/kotlin/types/expressions/ExpressionTypingVisitor;", "facade", "Lorg/jetbrains/kotlin/types/expressions/ExpressionTypingInternals;", "(Lorg/jetbrains/kotlin/types/expressions/ExpressionTypingInternals;)V", "collectReturns", "", "Lorg/jetbrains/kotlin/psi/KtReturnExpression;", "functionLiteral", "Lorg/jetbrains/kotlin/psi/KtFunctionLiteral;", "trace", "Lorg/jetbrains/kotlin/resolve/BindingTrace;", "computeReturnType", "Lorg/jetbrains/kotlin/types/KotlinType;", "expression", "Lorg/jetbrains/kotlin/psi/KtFunctionLiteralExpression;", "context", "Lorg/jetbrains/kotlin/types/expressions/ExpressionTypingContext;", "functionDescriptor", "Lorg/jetbrains/kotlin/descriptors/impl/SimpleFunctionDescriptorImpl;", "functionTypeExpected", "", "computeReturnTypeBasedOnReturnExpressions", "typeOfBodyExpression", "computeUnsafeReturnType", "expectedReturnType", "createFunctionLiteralDescriptor", "Lorg/jetbrains/kotlin/descriptors/impl/AnonymousFunctionDescriptor;", "createFunctionType", "Lorg/jetbrains/kotlin/descriptors/SimpleFunctionDescriptor;", "visitFunctionLiteralExpression", "Lorg/jetbrains/kotlin/types/expressions/KotlinTypeInfo;", "visitNamedFunction", "function", "Lorg/jetbrains/kotlin/psi/KtNamedFunction;", "data", "isStatement", "statementScope", "Lorg/jetbrains/kotlin/resolve/scopes/LexicalWritableScope;"}, moduleName="kotlin-compiler")
public final class FunctionsTypingVisitor
extends ExpressionTypingVisitor {
    @Override
    @NotNull
    public KotlinTypeInfo visitNamedFunction(@NotNull KtNamedFunction function, @NotNull ExpressionTypingContext data) {
        Intrinsics.checkParameterIsNotNull(function, "function");
        Intrinsics.checkParameterIsNotNull(data, "data");
        return this.visitNamedFunction(function, data, false, null);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final KotlinTypeInfo visitNamedFunction(@NotNull KtNamedFunction function, @NotNull ExpressionTypingContext context, boolean isStatement, @Nullable LexicalWritableScope statementScope) {
        SimpleFunctionDescriptor functionDescriptor;
        Intrinsics.checkParameterIsNotNull(function, "function");
        Intrinsics.checkParameterIsNotNull(context, "context");
        if (!isStatement) {
            if (!function.getTypeParameters().isEmpty()) {
                context.trace.report(Errors.TYPE_PARAMETERS_NOT_ALLOWED.on((KtDeclaration)((PsiElement)function)));
            }
            if (function.getName() != null) {
                context.trace.report(Errors.FUNCTION_EXPRESSION_WITH_NAME.on(function.getNameIdentifier()));
            }
            for (KtParameter parameter : function.getValueParameters()) {
                if (parameter.hasDefaultValue()) {
                    context.trace.report(Errors.FUNCTION_EXPRESSION_PARAMETER_WITH_DEFAULT_VALUE.on((KtParameter)((PsiElement)parameter)));
                }
                if (!parameter.isVarArg()) continue;
                context.trace.report(Errors.USELESS_VARARG_ON_PARAMETER.on((KtParameter)((PsiElement)parameter)));
            }
        }
        if (isStatement) {
            Unit unit;
            FunctionDescriptorResolver functionDescriptorResolver = this.components.functionDescriptorResolver;
            DeclarationDescriptor declarationDescriptor = context.scope.getOwnerDescriptor();
            LexicalScope lexicalScope = context.scope;
            Intrinsics.checkExpressionValueIsNotNull(lexicalScope, "context.scope");
            BindingTrace bindingTrace = context.trace;
            Intrinsics.checkExpressionValueIsNotNull(bindingTrace, "context.trace");
            DataFlowInfo dataFlowInfo = context.dataFlowInfo;
            Intrinsics.checkExpressionValueIsNotNull(dataFlowInfo, "context.dataFlowInfo");
            functionDescriptor = functionDescriptorResolver.resolveFunctionDescriptor(declarationDescriptor, lexicalScope, function, bindingTrace, dataFlowInfo);
            boolean bl = statementScope != null;
            if (PreconditionsKt.getASSERTIONS_ENABLED()) {
                void value;
                if (value == false) {
                    String message = "statementScope must be not null for function: " + function.getName() + " at location " + DiagnosticUtils.atLocation(function);
                    throw (Throwable)((Object)new AssertionError((Object)message));
                }
                unit = Unit.INSTANCE;
            } else {
                unit = Unit.INSTANCE;
            }
            LexicalWritableScope lexicalWritableScope = statementScope;
            if (lexicalWritableScope == null) {
                Intrinsics.throwNpe();
            }
            lexicalWritableScope.addFunctionDescriptor(functionDescriptor);
        } else {
            FunctionDescriptorResolver functionDescriptorResolver = this.components.functionDescriptorResolver;
            DeclarationDescriptor declarationDescriptor = context.scope.getOwnerDescriptor();
            LexicalScope lexicalScope = context.scope;
            Intrinsics.checkExpressionValueIsNotNull(lexicalScope, "context.scope");
            BindingTrace bindingTrace = context.trace;
            Intrinsics.checkExpressionValueIsNotNull(bindingTrace, "context.trace");
            DataFlowInfo dataFlowInfo = context.dataFlowInfo;
            Intrinsics.checkExpressionValueIsNotNull(dataFlowInfo, "context.dataFlowInfo");
            KotlinType kotlinType = context.expectedType;
            Intrinsics.checkExpressionValueIsNotNull(kotlinType, "context.expectedType");
            functionDescriptor = functionDescriptorResolver.resolveFunctionExpressionDescriptor(declarationDescriptor, lexicalScope, function, bindingTrace, dataFlowInfo, kotlinType);
        }
        ForceResolveUtil.forceResolveAllContents(functionDescriptor.getAnnotations());
        LexicalScope functionInnerScope = FunctionDescriptorUtil.getFunctionInnerScope(context.scope, (FunctionDescriptor)functionDescriptor, context.trace);
        this.components.expressionTypingServices.checkFunctionReturnType(functionInnerScope, function, functionDescriptor, context.dataFlowInfo, null, context.trace);
        ValueParameterResolver valueParameterResolver = this.components.valueParameterResolver;
        List<KtParameter> list = function.getValueParameters();
        Intrinsics.checkExpressionValueIsNotNull(list, "function.getValueParameters()");
        List<ValueParameterDescriptor> list2 = functionDescriptor.getValueParameters();
        Intrinsics.checkExpressionValueIsNotNull(list2, "functionDescriptor.getValueParameters()");
        LexicalScope lexicalScope = context.scope;
        Intrinsics.checkExpressionValueIsNotNull(lexicalScope, "context.scope");
        DataFlowInfo dataFlowInfo = context.dataFlowInfo;
        Intrinsics.checkExpressionValueIsNotNull(dataFlowInfo, "context.dataFlowInfo");
        BindingTrace bindingTrace = context.trace;
        Intrinsics.checkExpressionValueIsNotNull(bindingTrace, "context.trace");
        ValueParameterResolver.resolveValueParameters$default(valueParameterResolver, list, list2, lexicalScope, dataFlowInfo, bindingTrace, null, 32);
        KtDeclaration ktDeclaration = function;
        BindingTrace bindingTrace2 = context.trace;
        Intrinsics.checkExpressionValueIsNotNull(bindingTrace2, "context.trace");
        DeclarationsCheckerKt.checkTypeReferences(ktDeclaration, bindingTrace2);
        this.components.modifiersChecker.withTrace(context.trace).checkModifiersForLocalDeclaration(function, functionDescriptor);
        IdentifierChecker identifierChecker = this.components.identifierChecker;
        KtDeclaration ktDeclaration2 = function;
        DiagnosticSink diagnosticSink = context.trace;
        Intrinsics.checkExpressionValueIsNotNull(diagnosticSink, "context.trace");
        identifierChecker.checkDeclaration(ktDeclaration2, diagnosticSink);
        if (!function.hasBody() && !function.hasModifier(KtTokens.EXTERNAL_KEYWORD)) {
            context.trace.report(Errors.NON_MEMBER_FUNCTION_NO_BODY.on((KtFunction)((PsiElement)function), functionDescriptor));
        }
        if (isStatement) {
            return TypeInfoFactoryKt.createTypeInfo(this.components.dataFlowAnalyzer.checkStatementType(function, context), context);
        }
        KotlinTypeInfo kotlinTypeInfo = this.components.dataFlowAnalyzer.createCheckedTypeInfo(this.createFunctionType(functionDescriptor), context, function);
        Intrinsics.checkExpressionValueIsNotNull(kotlinTypeInfo, "components.dataFlowAnaly\u2026ptor), context, function)");
        return kotlinTypeInfo;
    }

    /*
     * WARNING - void declaration
     */
    private final KotlinType createFunctionType(SimpleFunctionDescriptor functionDescriptor) {
        void destination;
        void $receiver;
        void $receiver2;
        ReceiverParameterDescriptor receiverParameterDescriptor = functionDescriptor.getExtensionReceiverParameter();
        KotlinType receiverType = receiverParameterDescriptor != null ? receiverParameterDescriptor.getType() : null;
        KotlinType returnType2 = functionDescriptor.getReturnType();
        if (returnType2 == null) {
            return null;
        }
        Iterable iterable = functionDescriptor.getValueParameters();
        void var5_5 = $receiver2;
        Collection collection = new ArrayList(kotlin.CollectionsKt.collectionSizeOrDefault($receiver2, 10));
        for (Object item : $receiver) {
            void it2;
            ValueParameterDescriptor valueParameterDescriptor = (ValueParameterDescriptor)item;
            void var10_10 = destination;
            KotlinType kotlinType = it2.getType();
            var10_10.add(kotlinType);
        }
        List parameters2 = (List)destination;
        return this.components.builtIns.getFunctionType(Annotations.Companion.getEMPTY(), receiverType, parameters2, returnType2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public KotlinTypeInfo visitFunctionLiteralExpression(@NotNull KtFunctionLiteralExpression expression, @NotNull ExpressionTypingContext context) {
        void $receiver;
        Intrinsics.checkParameterIsNotNull(expression, "expression");
        Intrinsics.checkParameterIsNotNull(context, "context");
        if (!expression.getFunctionLiteral().hasBody()) {
            return null;
        }
        KotlinType expectedType = context.expectedType;
        boolean functionTypeExpected = !TypeUtils.noExpectedType(expectedType) && KotlinBuiltIns.isFunctionOrExtensionFunctionType(expectedType);
        AnonymousFunctionDescriptor functionDescriptor = this.createFunctionLiteralDescriptor(expression, context);
        Iterable iterable = expression.getValueParameters();
        for (Object element : $receiver) {
            KtParameter it2 = (KtParameter)element;
            IdentifierChecker identifierChecker = this.components.identifierChecker;
            KtDeclaration ktDeclaration = it2;
            Intrinsics.checkExpressionValueIsNotNull(ktDeclaration, "it");
            DiagnosticSink diagnosticSink = context.trace;
            Intrinsics.checkExpressionValueIsNotNull(diagnosticSink, "context.trace");
            identifierChecker.checkDeclaration(ktDeclaration, diagnosticSink);
            KtNamedDeclaration ktNamedDeclaration = it2;
            Intrinsics.checkExpressionValueIsNotNull(ktNamedDeclaration, "it");
            DiagnosticSink diagnosticSink2 = context.trace;
            Intrinsics.checkExpressionValueIsNotNull(diagnosticSink2, "context.trace");
            UnderscoreChecker.INSTANCE.checkNamed(ktNamedDeclaration, diagnosticSink2);
        }
        KotlinType safeReturnType = this.computeReturnType(expression, context, functionDescriptor, functionTypeExpected);
        functionDescriptor.setReturnType(safeReturnType);
        KotlinType kotlinType = this.createFunctionType(functionDescriptor);
        if (kotlinType == null) {
            Intrinsics.throwNpe();
        }
        KotlinType resultType = kotlinType;
        if (functionTypeExpected) {
            return TypeInfoFactoryKt.createTypeInfo(resultType, context);
        }
        return this.components.dataFlowAnalyzer.createCheckedTypeInfo(resultType, context, expression);
    }

    private final AnonymousFunctionDescriptor createFunctionLiteralDescriptor(KtFunctionLiteralExpression expression, ExpressionTypingContext context) {
        KtFunctionLiteral functionLiteral = expression.getFunctionLiteral();
        AnonymousFunctionDescriptor functionDescriptor = new AnonymousFunctionDescriptor(context.scope.getOwnerDescriptor(), this.components.annotationResolver.resolveAnnotationsWithArguments(context.scope, KtPsiUtilKt.getAnnotationEntries(expression), context.trace), CallableMemberDescriptor.Kind.DECLARATION, KotlinSourceElementKt.toSourceElement(functionLiteral));
        FunctionDescriptorResolver functionDescriptorResolver = this.components.functionDescriptorResolver;
        DeclarationDescriptor declarationDescriptor = context.scope.getOwnerDescriptor();
        LexicalScope lexicalScope = context.scope;
        Intrinsics.checkExpressionValueIsNotNull(lexicalScope, "context.scope");
        KtFunction ktFunction = functionLiteral;
        Intrinsics.checkExpressionValueIsNotNull(ktFunction, "functionLiteral");
        SimpleFunctionDescriptorImpl simpleFunctionDescriptorImpl = functionDescriptor;
        BindingTrace bindingTrace = context.trace;
        Intrinsics.checkExpressionValueIsNotNull(bindingTrace, "context.trace");
        KotlinType kotlinType = context.expectedType;
        Intrinsics.checkExpressionValueIsNotNull(kotlinType, "context.expectedType");
        functionDescriptorResolver.initializeFunctionDescriptorAndExplicitReturnType(declarationDescriptor, lexicalScope, ktFunction, simpleFunctionDescriptorImpl, bindingTrace, kotlinType);
        for (ValueParameterDescriptor parameterDescriptor : functionDescriptor.getValueParameters()) {
            ForceResolveUtil.forceResolveAllContents(parameterDescriptor.getAnnotations());
        }
        BindingContextUtils.recordFunctionDeclarationToDescriptor(context.trace, functionLiteral, functionDescriptor);
        return functionDescriptor;
    }

    private final KotlinType computeReturnType(KtFunctionLiteralExpression expression, ExpressionTypingContext context, SimpleFunctionDescriptorImpl functionDescriptor, boolean functionTypeExpected) {
        KotlinType kotlinType;
        KotlinType expectedReturnType = functionTypeExpected ? KotlinBuiltIns.getReturnTypeFromFunctionType(context.expectedType) : (KotlinType)null;
        KotlinType returnType2 = this.computeUnsafeReturnType(expression, context, functionDescriptor, expectedReturnType);
        if (!expression.getFunctionLiteral().hasDeclaredReturnType() && functionTypeExpected) {
            KotlinType kotlinType2 = expectedReturnType;
            if (kotlinType2 == null) {
                Intrinsics.throwNpe();
            }
            if (!TypeUtils.noExpectedType(kotlinType2) && KotlinBuiltIns.isUnit(expectedReturnType)) {
                KotlinType kotlinType3 = this.components.builtIns.getUnitType();
                Intrinsics.checkExpressionValueIsNotNull(kotlinType3, "components.builtIns.getUnitType()");
                return kotlinType3;
            }
        }
        if ((kotlinType = returnType2) == null) {
            KotlinType kotlinType4 = TypeUtils.CANT_INFER_FUNCTION_PARAM_TYPE;
            kotlinType = kotlinType4;
            Intrinsics.checkExpressionValueIsNotNull(kotlinType4, "CANT_INFER_FUNCTION_PARAM_TYPE");
        }
        return kotlinType;
    }

    private final KotlinType computeUnsafeReturnType(KtFunctionLiteralExpression expression, ExpressionTypingContext context, SimpleFunctionDescriptorImpl functionDescriptor, KotlinType expectedReturnType) {
        KtFunctionLiteral functionLiteral = expression.getFunctionLiteral();
        KotlinType kotlinType = expectedReturnType;
        if (kotlinType == null) {
            KotlinType kotlinType2 = TypeUtils.NO_EXPECTED_TYPE;
            kotlinType = kotlinType2;
            Intrinsics.checkExpressionValueIsNotNull(kotlinType2, "NO_EXPECTED_TYPE");
        }
        KotlinType expectedType = kotlinType;
        LexicalScope functionInnerScope = FunctionDescriptorUtil.getFunctionInnerScope(context.scope, (FunctionDescriptor)functionDescriptor, context.trace);
        ExpressionTypingContext newContext = (ExpressionTypingContext)((ExpressionTypingContext)context.replaceScope(functionInnerScope)).replaceExpectedType(expectedType);
        context.trace.record(BindingContext.EXPECTED_RETURN_TYPE, functionLiteral, expectedType);
        ExpressionTypingServices expressionTypingServices = this.components.expressionTypingServices;
        KtBlockExpression ktBlockExpression = functionLiteral.getBodyExpression();
        if (ktBlockExpression == null) {
            Intrinsics.throwNpe();
        }
        KotlinType typeOfBodyExpression = expressionTypingServices.getBlockReturnedType(ktBlockExpression, CoercionStrategy.COERCION_TO_UNIT, newContext).getType();
        KtFunctionLiteral ktFunctionLiteral = functionLiteral;
        Intrinsics.checkExpressionValueIsNotNull(ktFunctionLiteral, "functionLiteral");
        return this.computeReturnTypeBasedOnReturnExpressions(ktFunctionLiteral, context, typeOfBodyExpression);
    }

    private final KotlinType computeReturnTypeBasedOnReturnExpressions(KtFunctionLiteral functionLiteral, ExpressionTypingContext context, KotlinType typeOfBodyExpression) {
        KtExpression returnedExpression;
        ArrayList returnedExpressionTypes = Lists.newArrayList();
        boolean hasEmptyReturn = false;
        BindingTrace bindingTrace = context.trace;
        Intrinsics.checkExpressionValueIsNotNull(bindingTrace, "context.trace");
        Collection<KtReturnExpression> returnExpressions = this.collectReturns(functionLiteral, bindingTrace);
        for (KtReturnExpression returnExpression : returnExpressions) {
            returnedExpression = returnExpression.getReturnedExpression();
            if (returnedExpression == null) {
                hasEmptyReturn = true;
                continue;
            }
            CollectionsKt.addIfNotNull(returnedExpressionTypes, context.trace.getType(returnedExpression));
        }
        if (hasEmptyReturn) {
            for (KtReturnExpression returnExpression : returnExpressions) {
                KotlinType type2;
                returnedExpression = returnExpression.getReturnedExpression();
                if (returnedExpression == null || (type2 = context.trace.getType(returnedExpression)) != null && KotlinBuiltIns.isUnit(type2)) continue;
                context.trace.report(Errors.RETURN_TYPE_MISMATCH.on((KtExpression)((PsiElement)returnedExpression), this.components.builtIns.getUnitType()));
            }
            return this.components.builtIns.getUnitType();
        }
        CollectionsKt.addIfNotNull(returnedExpressionTypes, typeOfBodyExpression);
        if (returnedExpressionTypes.isEmpty()) {
            return null;
        }
        return CommonSupertypes.commonSupertype(returnedExpressionTypes);
    }

    /*
     * WARNING - void declaration
     */
    private final Collection<KtReturnExpression> collectReturns(KtFunctionLiteral functionLiteral, BindingTrace trace) {
        void destination;
        void $receiver;
        void $receiver2;
        KtBlockExpression bodyExpression;
        ArrayList result2 = Lists.newArrayList();
        KtBlockExpression ktBlockExpression = bodyExpression = functionLiteral.getBodyExpression();
        Void void_ = ktBlockExpression != null ? (Void)ktBlockExpression.accept((KtVisitor)new KtTreeVisitor<List<KtReturnExpression>>(){

            @Nullable
            public Void visitReturnExpression(@NotNull KtReturnExpression expression, @NotNull List<KtReturnExpression> data) {
                Intrinsics.checkParameterIsNotNull(expression, "expression");
                Intrinsics.checkParameterIsNotNull(data, "data");
                data.add(expression);
                return null;
            }
        }, result2) : null;
        Iterable iterable = result2;
        void var6_6 = $receiver2;
        Collection collection = new ArrayList();
        for (Object element : $receiver) {
            PsiElement psiElement2;
            KtReturnExpression it2 = (KtReturnExpression)element;
            if (it2.getTargetLabel() != null) {
                void $receiver3;
                KtSimpleNameExpression it3 = (KtSimpleNameExpression)$receiver3;
                psiElement2 = (PsiElement)trace.get(BindingContext.LABEL_TARGET, it3);
            } else {
                psiElement2 = null;
            }
            if (!Intrinsics.areEqual(psiElement2, functionLiteral)) continue;
            destination.add(element);
        }
        return (List)destination;
    }

    public FunctionsTypingVisitor(@NotNull ExpressionTypingInternals facade) {
        Intrinsics.checkParameterIsNotNull(facade, "facade");
        super(facade);
    }
}

