/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.calls.smartcasts;

import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.relocated.com.google.common.collect.ImmutableMap;
import org.jetbrains.kotlin.relocated.com.google.common.collect.ImmutableSetMultimap;
import org.jetbrains.kotlin.relocated.com.google.common.collect.LinkedHashMultimap;
import org.jetbrains.kotlin.relocated.com.google.common.collect.Maps;
import org.jetbrains.kotlin.relocated.com.google.common.collect.SetMultimap;
import org.jetbrains.kotlin.relocated.com.google.common.collect.Sets;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowInfo;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowValue;
import org.jetbrains.kotlin.resolve.calls.smartcasts.Nullability;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;

class DelegatingDataFlowInfo
implements DataFlowInfo {
    private static final ImmutableMap<DataFlowValue, Nullability> EMPTY_NULLABILITY_INFO = ImmutableMap.of();
    private static final SetMultimap<DataFlowValue, KotlinType> EMPTY_TYPE_INFO = DelegatingDataFlowInfo.newTypeInfo();
    @Nullable
    private final DataFlowInfo parent;
    @NotNull
    private final ImmutableMap<DataFlowValue, Nullability> nullabilityInfo;
    @NotNull
    private final SetMultimap<DataFlowValue, KotlinType> typeInfo;
    @Nullable
    private final DataFlowValue valueWithGivenTypeInfo;

    DelegatingDataFlowInfo(@Nullable DataFlowInfo parent2, @NotNull ImmutableMap<DataFlowValue, Nullability> nullabilityInfo, @NotNull SetMultimap<DataFlowValue, KotlinType> typeInfo) {
        if (nullabilityInfo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nullabilityInfo", "org/jetbrains/kotlin/resolve/calls/smartcasts/DelegatingDataFlowInfo", "<init>"));
        }
        if (typeInfo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeInfo", "org/jetbrains/kotlin/resolve/calls/smartcasts/DelegatingDataFlowInfo", "<init>"));
        }
        this(parent2, nullabilityInfo, typeInfo, null);
    }

    DelegatingDataFlowInfo(@Nullable DataFlowInfo parent2, @NotNull ImmutableMap<DataFlowValue, Nullability> nullabilityInfo, @NotNull SetMultimap<DataFlowValue, KotlinType> typeInfo, @Nullable DataFlowValue valueWithGivenTypeInfo) {
        if (nullabilityInfo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nullabilityInfo", "org/jetbrains/kotlin/resolve/calls/smartcasts/DelegatingDataFlowInfo", "<init>"));
        }
        if (typeInfo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeInfo", "org/jetbrains/kotlin/resolve/calls/smartcasts/DelegatingDataFlowInfo", "<init>"));
        }
        this.parent = parent2;
        this.nullabilityInfo = nullabilityInfo;
        this.typeInfo = typeInfo;
        this.valueWithGivenTypeInfo = valueWithGivenTypeInfo;
    }

    @Override
    @NotNull
    public Map<DataFlowValue, Nullability> getCompleteNullabilityInfo() {
        HashMap<DataFlowValue, Nullability> result2 = Maps.newHashMap();
        DelegatingDataFlowInfo info = this;
        while (info != null) {
            for (Map.Entry entry : info.nullabilityInfo.entrySet()) {
                DataFlowValue key = (DataFlowValue)entry.getKey();
                Nullability value = (Nullability)((Object)entry.getValue());
                if (result2.containsKey(key)) continue;
                result2.put(key, value);
            }
            info = (DelegatingDataFlowInfo)info.parent;
        }
        HashMap<DataFlowValue, Nullability> hashMap = result2;
        if (hashMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/smartcasts/DelegatingDataFlowInfo", "getCompleteNullabilityInfo"));
        }
        return hashMap;
    }

    @Override
    @NotNull
    public SetMultimap<DataFlowValue, KotlinType> getCompleteTypeInfo() {
        SetMultimap<DataFlowValue, KotlinType> result2 = DelegatingDataFlowInfo.newTypeInfo();
        HashSet<DataFlowValue> withGivenTypeInfo = new HashSet<DataFlowValue>();
        DelegatingDataFlowInfo info = this;
        while (info != null) {
            for (DataFlowValue key : info.typeInfo.keySet()) {
                if (withGivenTypeInfo.contains(key)) continue;
                result2.putAll(key, info.typeInfo.get(key));
            }
            if (info.valueWithGivenTypeInfo != null) {
                withGivenTypeInfo.add(info.valueWithGivenTypeInfo);
            }
            info = (DelegatingDataFlowInfo)info.parent;
        }
        SetMultimap<DataFlowValue, KotlinType> setMultimap = result2;
        if (setMultimap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/smartcasts/DelegatingDataFlowInfo", "getCompleteTypeInfo"));
        }
        return setMultimap;
    }

    @Override
    @NotNull
    public Nullability getNullability(@NotNull DataFlowValue key) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "org/jetbrains/kotlin/resolve/calls/smartcasts/DelegatingDataFlowInfo", "getNullability"));
        }
        Nullability nullability = this.getNullability(key, false);
        if (nullability == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/smartcasts/DelegatingDataFlowInfo", "getNullability"));
        }
        return nullability;
    }

    @Override
    @NotNull
    public Nullability getPredictableNullability(@NotNull DataFlowValue key) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "org/jetbrains/kotlin/resolve/calls/smartcasts/DelegatingDataFlowInfo", "getPredictableNullability"));
        }
        Nullability nullability = this.getNullability(key, true);
        if (nullability == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/smartcasts/DelegatingDataFlowInfo", "getPredictableNullability"));
        }
        return nullability;
    }

    @NotNull
    private Nullability getNullability(@NotNull DataFlowValue key, boolean predictableOnly) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "org/jetbrains/kotlin/resolve/calls/smartcasts/DelegatingDataFlowInfo", "getNullability"));
        }
        if (predictableOnly && !key.isPredictable()) {
            Nullability nullability = key.getImmanentNullability();
            if (nullability == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/smartcasts/DelegatingDataFlowInfo", "getNullability"));
            }
            return nullability;
        }
        Nullability nullability = this.nullabilityInfo.get(key);
        Nullability nullability2 = nullability != null ? nullability : (this.parent != null ? this.parent.getNullability(key) : key.getImmanentNullability());
        if (nullability2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/smartcasts/DelegatingDataFlowInfo", "getNullability"));
        }
        return nullability2;
    }

    private boolean putNullability(@NotNull Map<DataFlowValue, Nullability> map2, @NotNull DataFlowValue value, @NotNull Nullability nullability) {
        if (map2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "map", "org/jetbrains/kotlin/resolve/calls/smartcasts/DelegatingDataFlowInfo", "putNullability"));
        }
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "org/jetbrains/kotlin/resolve/calls/smartcasts/DelegatingDataFlowInfo", "putNullability"));
        }
        if (nullability == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nullability", "org/jetbrains/kotlin/resolve/calls/smartcasts/DelegatingDataFlowInfo", "putNullability"));
        }
        map2.put(value, nullability);
        return nullability != this.getNullability(value);
    }

    @Override
    @NotNull
    public Set<KotlinType> getPossibleTypes(@NotNull DataFlowValue key) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "org/jetbrains/kotlin/resolve/calls/smartcasts/DelegatingDataFlowInfo", "getPossibleTypes"));
        }
        KotlinType originalType = key.getType();
        Set<KotlinType> types2 = this.collectTypesFromMeAndParents(key);
        if (this.getNullability(key).canBeNull()) {
            Set<KotlinType> set = types2;
            if (set == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/smartcasts/DelegatingDataFlowInfo", "getPossibleTypes"));
            }
            return set;
        }
        HashSet<KotlinType> enrichedTypes = Sets.newHashSetWithExpectedSize(types2.size() + 1);
        if (originalType.isMarkedNullable()) {
            enrichedTypes.add(TypeUtils.makeNotNullable(originalType));
        }
        for (KotlinType type2 : types2) {
            enrichedTypes.add(TypeUtils.makeNotNullable(type2));
        }
        HashSet<KotlinType> hashSet = enrichedTypes;
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/smartcasts/DelegatingDataFlowInfo", "getPossibleTypes"));
        }
        return hashSet;
    }

    @Override
    @NotNull
    public DataFlowInfo clearValueInfo(@NotNull DataFlowValue value) {
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "org/jetbrains/kotlin/resolve/calls/smartcasts/DelegatingDataFlowInfo", "clearValueInfo"));
        }
        HashMap<DataFlowValue, Nullability> builder = Maps.newHashMap();
        this.putNullability(builder, value, Nullability.UNKNOWN);
        DelegatingDataFlowInfo delegatingDataFlowInfo = new DelegatingDataFlowInfo(this, ImmutableMap.copyOf(builder), EMPTY_TYPE_INFO, value);
        if (delegatingDataFlowInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/smartcasts/DelegatingDataFlowInfo", "clearValueInfo"));
        }
        return delegatingDataFlowInfo;
    }

    @Override
    @NotNull
    public DataFlowInfo assign(@NotNull DataFlowValue a, @NotNull DataFlowValue b) {
        if (a == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "a", "org/jetbrains/kotlin/resolve/calls/smartcasts/DelegatingDataFlowInfo", "assign"));
        }
        if (b == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "b", "org/jetbrains/kotlin/resolve/calls/smartcasts/DelegatingDataFlowInfo", "assign"));
        }
        HashMap<DataFlowValue, Nullability> nullability = Maps.newHashMap();
        Nullability nullabilityOfB = this.getNullability(b);
        this.putNullability(nullability, a, nullabilityOfB);
        SetMultimap<DataFlowValue, KotlinType> newTypeInfo = DelegatingDataFlowInfo.newTypeInfo();
        Set<KotlinType> typesForB = this.getPossibleTypes(b);
        if (nullabilityOfB.canBeNonNull() && !((Object)a.getType()).equals(b.getType())) {
            typesForB.add(b.getType());
        }
        newTypeInfo.putAll(a, typesForB);
        DelegatingDataFlowInfo delegatingDataFlowInfo = new DelegatingDataFlowInfo(this, ImmutableMap.copyOf(nullability), newTypeInfo.isEmpty() ? EMPTY_TYPE_INFO : newTypeInfo, a);
        if (delegatingDataFlowInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/smartcasts/DelegatingDataFlowInfo", "assign"));
        }
        return delegatingDataFlowInfo;
    }

    @Override
    @NotNull
    public DataFlowInfo equate(@NotNull DataFlowValue a, @NotNull DataFlowValue b) {
        if (a == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "a", "org/jetbrains/kotlin/resolve/calls/smartcasts/DelegatingDataFlowInfo", "equate"));
        }
        if (b == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "b", "org/jetbrains/kotlin/resolve/calls/smartcasts/DelegatingDataFlowInfo", "equate"));
        }
        HashMap<DataFlowValue, Nullability> builder = Maps.newHashMap();
        Nullability nullabilityOfA = this.getNullability(a);
        Nullability nullabilityOfB = this.getNullability(b);
        boolean changed = false;
        changed |= this.putNullability(builder, a, nullabilityOfA.refine(nullabilityOfB));
        changed |= this.putNullability(builder, b, nullabilityOfB.refine(nullabilityOfA));
        SetMultimap<DataFlowValue, KotlinType> newTypeInfo = DelegatingDataFlowInfo.newTypeInfo();
        newTypeInfo.putAll(a, this.collectTypesFromMeAndParents(b));
        newTypeInfo.putAll(b, this.collectTypesFromMeAndParents(a));
        if (!((Object)a.getType()).equals(b.getType())) {
            if (!TypeUtilsKt.isSubtypeOf(a.getType(), b.getType())) {
                newTypeInfo.put(a, b.getType());
            }
            if (!TypeUtilsKt.isSubtypeOf(b.getType(), a.getType())) {
                newTypeInfo.put(b, a.getType());
            }
        }
        DelegatingDataFlowInfo delegatingDataFlowInfo = !(changed |= !newTypeInfo.isEmpty()) ? this : new DelegatingDataFlowInfo(this, ImmutableMap.copyOf(builder), newTypeInfo.isEmpty() ? EMPTY_TYPE_INFO : newTypeInfo);
        if (delegatingDataFlowInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/smartcasts/DelegatingDataFlowInfo", "equate"));
        }
        return delegatingDataFlowInfo;
    }

    @NotNull
    private Set<KotlinType> collectTypesFromMeAndParents(@NotNull DataFlowValue value) {
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "org/jetbrains/kotlin/resolve/calls/smartcasts/DelegatingDataFlowInfo", "collectTypesFromMeAndParents"));
        }
        LinkedHashSet<KotlinType> types2 = new LinkedHashSet<KotlinType>();
        DataFlowInfo current = this;
        while (current != null) {
            if (current instanceof DelegatingDataFlowInfo) {
                DelegatingDataFlowInfo delegatingInfo = current;
                types2.addAll(delegatingInfo.typeInfo.get(value));
                if (value.equals(delegatingInfo.valueWithGivenTypeInfo)) {
                    current = null;
                    continue;
                }
                current = delegatingInfo.parent;
                continue;
            }
            types2.addAll(current.getPossibleTypes(value));
            break;
        }
        LinkedHashSet<KotlinType> linkedHashSet = types2;
        if (linkedHashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/smartcasts/DelegatingDataFlowInfo", "collectTypesFromMeAndParents"));
        }
        return linkedHashSet;
    }

    @Override
    @NotNull
    public DataFlowInfo disequate(@NotNull DataFlowValue a, @NotNull DataFlowValue b) {
        if (a == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "a", "org/jetbrains/kotlin/resolve/calls/smartcasts/DelegatingDataFlowInfo", "disequate"));
        }
        if (b == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "b", "org/jetbrains/kotlin/resolve/calls/smartcasts/DelegatingDataFlowInfo", "disequate"));
        }
        HashMap<DataFlowValue, Nullability> builder = Maps.newHashMap();
        Nullability nullabilityOfA = this.getNullability(a);
        Nullability nullabilityOfB = this.getNullability(b);
        boolean changed = false;
        changed |= this.putNullability(builder, a, nullabilityOfA.refine(nullabilityOfB.invert()));
        DelegatingDataFlowInfo delegatingDataFlowInfo = (changed |= this.putNullability(builder, b, nullabilityOfB.refine(nullabilityOfA.invert()))) ? new DelegatingDataFlowInfo(this, ImmutableMap.copyOf(builder), EMPTY_TYPE_INFO) : this;
        if (delegatingDataFlowInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/smartcasts/DelegatingDataFlowInfo", "disequate"));
        }
        return delegatingDataFlowInfo;
    }

    @Override
    @NotNull
    public DataFlowInfo establishSubtyping(@NotNull DataFlowValue value, @NotNull KotlinType type2) {
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "org/jetbrains/kotlin/resolve/calls/smartcasts/DelegatingDataFlowInfo", "establishSubtyping"));
        }
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/kotlin/resolve/calls/smartcasts/DelegatingDataFlowInfo", "establishSubtyping"));
        }
        if (((Object)value.getType()).equals(type2)) {
            DelegatingDataFlowInfo delegatingDataFlowInfo = this;
            if (delegatingDataFlowInfo == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/smartcasts/DelegatingDataFlowInfo", "establishSubtyping"));
            }
            return delegatingDataFlowInfo;
        }
        if (this.getPossibleTypes(value).contains(type2)) {
            DelegatingDataFlowInfo delegatingDataFlowInfo = this;
            if (delegatingDataFlowInfo == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/smartcasts/DelegatingDataFlowInfo", "establishSubtyping"));
            }
            return delegatingDataFlowInfo;
        }
        ImmutableMap<DataFlowValue, Nullability> newNullabilityInfo = type2.isMarkedNullable() ? EMPTY_NULLABILITY_INFO : ImmutableMap.of(value, Nullability.NOT_NULL);
        ImmutableSetMultimap<DataFlowValue, KotlinType> newTypeInfo = ImmutableSetMultimap.of(value, type2);
        DelegatingDataFlowInfo delegatingDataFlowInfo = new DelegatingDataFlowInfo(this, newNullabilityInfo, newTypeInfo);
        if (delegatingDataFlowInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/smartcasts/DelegatingDataFlowInfo", "establishSubtyping"));
        }
        return delegatingDataFlowInfo;
    }

    @Override
    @NotNull
    public DataFlowInfo and(@NotNull DataFlowInfo otherInfo) {
        if (otherInfo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "otherInfo", "org/jetbrains/kotlin/resolve/calls/smartcasts/DelegatingDataFlowInfo", "and"));
        }
        if (otherInfo == EMPTY) {
            DelegatingDataFlowInfo delegatingDataFlowInfo = this;
            if (delegatingDataFlowInfo == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/smartcasts/DelegatingDataFlowInfo", "and"));
            }
            return delegatingDataFlowInfo;
        }
        if (this == EMPTY) {
            DataFlowInfo dataFlowInfo = otherInfo;
            if (dataFlowInfo == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/smartcasts/DelegatingDataFlowInfo", "and"));
            }
            return dataFlowInfo;
        }
        if (this == otherInfo) {
            DelegatingDataFlowInfo delegatingDataFlowInfo = this;
            if (delegatingDataFlowInfo == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/smartcasts/DelegatingDataFlowInfo", "and"));
            }
            return delegatingDataFlowInfo;
        }
        assert (otherInfo instanceof DelegatingDataFlowInfo) : "Unknown DataFlowInfo type: " + otherInfo;
        DelegatingDataFlowInfo other = (DelegatingDataFlowInfo)otherInfo;
        HashMap<DataFlowValue, Nullability> nullabilityMapBuilder = Maps.newHashMap();
        for (Map.Entry<DataFlowValue, Nullability> entry : other.getCompleteNullabilityInfo().entrySet()) {
            DataFlowValue key = entry.getKey();
            Nullability otherFlags = entry.getValue();
            Nullability thisFlags = this.getNullability(key);
            Nullability flags = thisFlags.and(otherFlags);
            if (flags == thisFlags) continue;
            nullabilityMapBuilder.put(key, flags);
        }
        SetMultimap<DataFlowValue, KotlinType> myTypeInfo = this.getCompleteTypeInfo();
        SetMultimap<DataFlowValue, KotlinType> otherTypeInfo = other.getCompleteTypeInfo();
        if (nullabilityMapBuilder.isEmpty() && DelegatingDataFlowInfo.containsAll(myTypeInfo, otherTypeInfo)) {
            DelegatingDataFlowInfo delegatingDataFlowInfo = this;
            if (delegatingDataFlowInfo == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/smartcasts/DelegatingDataFlowInfo", "and"));
            }
            return delegatingDataFlowInfo;
        }
        DelegatingDataFlowInfo delegatingDataFlowInfo = new DelegatingDataFlowInfo(this, ImmutableMap.copyOf(nullabilityMapBuilder), otherTypeInfo);
        if (delegatingDataFlowInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/smartcasts/DelegatingDataFlowInfo", "and"));
        }
        return delegatingDataFlowInfo;
    }

    private static boolean containsAll(SetMultimap<DataFlowValue, KotlinType> first, SetMultimap<DataFlowValue, KotlinType> second) {
        return first.entries().containsAll(second.entries());
    }

    @Override
    @NotNull
    public DataFlowInfo or(@NotNull DataFlowInfo otherInfo) {
        if (otherInfo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "otherInfo", "org/jetbrains/kotlin/resolve/calls/smartcasts/DelegatingDataFlowInfo", "or"));
        }
        if (otherInfo == EMPTY) {
            DataFlowInfo dataFlowInfo = EMPTY;
            if (dataFlowInfo == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/smartcasts/DelegatingDataFlowInfo", "or"));
            }
            return dataFlowInfo;
        }
        if (this == EMPTY) {
            DataFlowInfo dataFlowInfo = EMPTY;
            if (dataFlowInfo == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/smartcasts/DelegatingDataFlowInfo", "or"));
            }
            return dataFlowInfo;
        }
        if (this == otherInfo) {
            DelegatingDataFlowInfo delegatingDataFlowInfo = this;
            if (delegatingDataFlowInfo == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/smartcasts/DelegatingDataFlowInfo", "or"));
            }
            return delegatingDataFlowInfo;
        }
        assert (otherInfo instanceof DelegatingDataFlowInfo) : "Unknown DataFlowInfo type: " + otherInfo;
        DelegatingDataFlowInfo other = (DelegatingDataFlowInfo)otherInfo;
        HashMap<DataFlowValue, Nullability> nullabilityMapBuilder = Maps.newHashMap();
        for (Map.Entry<DataFlowValue, Nullability> entry : other.getCompleteNullabilityInfo().entrySet()) {
            DataFlowValue key = entry.getKey();
            Nullability otherFlags = entry.getValue();
            Nullability thisFlags = this.getNullability(key);
            nullabilityMapBuilder.put(key, thisFlags.or(otherFlags));
        }
        SetMultimap<DataFlowValue, KotlinType> myTypeInfo = this.getCompleteTypeInfo();
        SetMultimap<DataFlowValue, KotlinType> otherTypeInfo = other.getCompleteTypeInfo();
        SetMultimap<DataFlowValue, KotlinType> newTypeInfo = DelegatingDataFlowInfo.newTypeInfo();
        for (DataFlowValue key : Sets.intersection(myTypeInfo.keySet(), otherTypeInfo.keySet())) {
            Set<KotlinType> thisTypes = myTypeInfo.get(key);
            Set<KotlinType> otherTypes = otherTypeInfo.get(key);
            newTypeInfo.putAll(key, Sets.intersection(thisTypes, otherTypes));
        }
        if (nullabilityMapBuilder.isEmpty() && newTypeInfo.isEmpty()) {
            DataFlowInfo dataFlowInfo = EMPTY;
            if (dataFlowInfo == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/smartcasts/DelegatingDataFlowInfo", "or"));
            }
            return dataFlowInfo;
        }
        DelegatingDataFlowInfo delegatingDataFlowInfo = new DelegatingDataFlowInfo(null, ImmutableMap.copyOf(nullabilityMapBuilder), newTypeInfo);
        if (delegatingDataFlowInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/smartcasts/DelegatingDataFlowInfo", "or"));
        }
        return delegatingDataFlowInfo;
    }

    @NotNull
    static SetMultimap<DataFlowValue, KotlinType> newTypeInfo() {
        LinkedHashMultimap<DataFlowValue, KotlinType> linkedHashMultimap = LinkedHashMultimap.create();
        if (linkedHashMultimap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/smartcasts/DelegatingDataFlowInfo", "newTypeInfo"));
        }
        return linkedHashMultimap;
    }

    public String toString() {
        if (this.typeInfo.isEmpty() && this.nullabilityInfo.isEmpty()) {
            return "EMPTY";
        }
        return "Non-trivial DataFlowInfo";
    }
}

