/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve;

import com.intellij.psi.PsiElement;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.PreconditionsKt;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptorWithResolutionScopes;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.EffectiveVisibility;
import org.jetbrains.kotlin.descriptors.EffectiveVisibilityKt;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.MemberDescriptor;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.descriptors.PropertyAccessorDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyGetterDescriptor;
import org.jetbrains.kotlin.descriptors.PropertySetterDescriptor;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.diagnostics.DiagnosticFactory0;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.lexer.KtModifierKeywordToken;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtAnnotated;
import org.jetbrains.kotlin.psi.KtAnnotationEntry;
import org.jetbrains.kotlin.psi.KtCallableDeclaration;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtClassBody;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtConstructor;
import org.jetbrains.kotlin.psi.KtConstructorCalleeExpression;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtDelegationSpecifier;
import org.jetbrains.kotlin.psi.KtDelegationSpecifierList;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtElementImplStub;
import org.jetbrains.kotlin.psi.KtEnumEntry;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtModifierList;
import org.jetbrains.kotlin.psi.KtModifierListOwner;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtObjectDeclaration;
import org.jetbrains.kotlin.psi.KtPackageDirective;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtPrimaryConstructor;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPropertyAccessor;
import org.jetbrains.kotlin.psi.KtPropertyDelegate;
import org.jetbrains.kotlin.psi.KtReferenceExpression;
import org.jetbrains.kotlin.psi.KtSecondaryConstructor;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.KtTypeConstraint;
import org.jetbrains.kotlin.psi.KtTypeParameter;
import org.jetbrains.kotlin.psi.KtTypeParameterList;
import org.jetbrains.kotlin.psi.KtTypeParameterListOwner;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.relocated.com.google.common.collect.ImmutableSet;
import org.jetbrains.kotlin.relocated.com.google.common.collect.Multimap;
import org.jetbrains.kotlin.relocated.com.google.common.collect.Sets;
import org.jetbrains.kotlin.resolve.AnnotationChecker;
import org.jetbrains.kotlin.resolve.AnnotationResolver;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.BodiesResolveContext;
import org.jetbrains.kotlin.resolve.DeclarationsCheckerKt;
import org.jetbrains.kotlin.resolve.DescriptorResolver;
import org.jetbrains.kotlin.resolve.DescriptorToSourceUtils;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.FiniteBoundRestrictionChecker;
import org.jetbrains.kotlin.resolve.IdentifierChecker;
import org.jetbrains.kotlin.resolve.ModifierCheckerCore;
import org.jetbrains.kotlin.resolve.ModifiersChecker;
import org.jetbrains.kotlin.resolve.NonExpansiveInheritanceRestrictionChecker;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.SubstitutionUtils;
import org.jetbrains.kotlin.types.TypeProjection;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.kotlin.types.checker.KotlinTypeChecker;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;

@KotlinClass(version={1, 0, 0}, abiVersion=32, data={"y\u0004)\u0011\u0001D\u0001\u0006\u0003!\u0001Q\u0001A\u0003\u0002\u0019\u0005)\u0001!B\u0001\r\u0003\u0015\u0001Q!\u0001\u0007\u0002\u000b\u0001)\u0011\u0001D\u0001\u0006\u0001\u0015\tA\"A\u0003\u0001\u000b\u0005a\u0011!B\u0001\r\u0003\u0015\u0001Q!\u0001\u0005\u0002\u000b\u0001)\u0011\u0001D\u0001\u0006\u0001\u0015\tA\"A\u0003\u0001\u000b\u0005a\u0011!B\u0001\u0005\u0003\u0015\tA\"A\u0003\u0002\t\u0005)\u0011\u0001D\u0001\u0006\u0003\u0011\tQ!\u0001\u0007\u0002\u000b\u0001)\u0011\u0001D\u0001\u0006\u0003\u0011\tQ!\u0001\u0007\u0002\u000b\u0005!\u0011!B\u0001\r\u0003\u0015\u0001Q!\u0001\u0007\u0002\u000b\u0005!\u0019!B\u0001\r\u0003\u0015\tAAA\u0003\u0002\u0019\u0005)\u0001!B\u0001\r\u0003\u0015\u0001Q!\u0001\u0007\u0002\u000b\u0005a\u0011!B\u0001\u0005\u0003\u0015\tA\"A\u0003\u0001\u000b\u0005a\u0011!B\u0001\u0005\u0004\u0015\tA\"A\u0003\u0001\u000b\u0005a\u0011!B\u0001\u0005\b\u0015\tA\"A\u0003\u0002\t\t)\u0011\u0001D\u0001\u0006\u0001\u0015\tA\"A\u0003\u0002\t\u0005)\u0011\u0001D\u0001\u0006\u0003\u0011\u0015Q!\u0001\u0007\u0002\u000b\u0005!\u0011!B\u0001\t\u001f\u0015\u0001Q!\u0001\u0007\u0002\u000b\u0005!\u0011!B\u0001\t\f\u0015\tA1\u0001\u0007\u0001!KJ\u0012\u0001'\u0001\u001e\u0002K\nk#C\u0002\t\u00035\t\u00014A\u0005\u0004\u0011\ti\u0011\u0001'\u0002\n\u0007!\u0019Q\"\u0001M\u0004\u0013\rAA!D\u0001\u0019\n%\u0019\u0001\"B\u0007\u00021\u0017\t6!\u0001\u0005\u0007KI!\u0011\u0001c\u0004\u000e\u0003aA\u0011d\u0001E\t\u001b\u0005A\u0012\"\u0007\u0003\t\u00145\u0011A\u0012\u0001\r\u000b3\u0011A)\"\u0004\u0002\r\u0002aYQ\u0005\u0004\u0003\u0002\u0011/i\u0011\u0001\u0007\u0005\u001a\u0007!aQ\"\u0001M\r3\rA\t\"D\u0001\u0019\u0013\u0015BA!\u0001\u0005\u000e\u001b\u0005A\u0002\"G\u0002\t\u001c5\t\u0001DD\u0013\r\t\u0005Ai\"D\u0001\u0019\u0011e\u0019\u0001bD\u0007\u00021?I2\u0001\u0003\t\u000e\u0003a\u0005R\u0005\u0004\u0003\u0002\u0011Ei\u0011\u0001\u0007\u0005\u001a\u0007!\rR\"\u0001\r\u000f3\rA\u0001#D\u0001\u0019%\u0015bA!\u0001E\u0013\u001b\u0005A\u0002\"G\u0002\t'5\t\u0001tE\r\u0004\u0011Qi\u0011\u0001'\u000b&\u0011\u0011\t\u0001\"F\u0007\u00021!I2\u0001c\t\u000e\u0003a}Q\u0005\u0004\u0003\u0002\u0011Wi\u0011\u0001\u0007\u0005\u001a\u0007!1R\"\u0001M\u00173\rA\u0001#D\u0001\u0019%\u0015bA!\u0001\u0005\u0018\u001b\u0005A\u0002\"G\u0002\t$5\t\u0001DD\r\u0004\u0011Ai\u0011\u0001\u0007\n&\u0019\u0011\t\u0001rF\u0007\u00021!I2\u0001c\t\u000e\u0003aq\u0011d\u0001\u0005\u0011\u001b\u0005A\"#\n\u0007\u0005\u0003!AR\"\u0001\r\t3\rA\t$D\u0001\u00193e\u0019\u00012G\u0007\u00021i)C\u0002B\u0001\t65\t\u0001\u0004C\r\u0004\u0011ci\u0011\u0001G\u000e\u001a\u0007!MR\"\u0001M\u001cK5!\u0011\u0001\u0003\u000f\u000e\u0003aA\u0011\u0004\u0002E\u001d\u001b\ta\t\u0001G\u000f\u001a\u0007!mR\"\u0001\r\u001fK!!\u0011\u0001#\u0010\u000e\u0003aA\u0011d\u0001\u0005\u0011\u001b\u0005A\n#\n\u0005\u0005\u0003!yR\"\u0001\r\t3\rAy$D\u0001\u0019A\u0015bA!\u0001E!\u001b\u0005A\u0002\"G\u0002\t)5\t\u0001$I\r\u0004\u0011Ai\u0011\u0001\u0007\n&\u0011\u0011\t\u00012I\u0007\u00021!I2\u0001\u0003\t\u000e\u0003a\u0005R\u0005\u0004\u0003\u0002\u0011\tj\u0011\u0001\u0007\u0005\u001a\u0007!mQ\"\u0001\r\u000f3\rA\u0001#D\u0001\u0019%\u0015bA!\u0001E#\u001b\u0005A\u0002\"G\u0002\t\u00195\t\u0001\u0014D\r\u0004\u0011#i\u0011\u0001G\u0005&!\u0011\t\u0001bI\u0007\u00021!I2\u0001\u0003\u0007\u000e\u0003ae\u0011d\u0001E\t\u001b\u0005A\u0012\"G\u0002\t!5\t\u0001DE\u0013\r\t\u0005A9%D\u0001\u0019\u0011e\u0019\u0001\u0002D\u0007\u000213I2\u0001#\u0005\u000e\u0003aIQ\u0005\u0004\u0003\u0002\u0011\u0011j\u0011\u0001\u0007\u0005\u001a\u0007!aQ\"\u0001M\r3\rA\t\"D\u0001\u0019\u0013\u0015bA!\u0001E%\u001b\u0005A\u0002\"G\u0002\t\u00195\t\u0001$J\r\u0004\u0011#i\u0011\u0001G\u0005&\u0011\u0011\t\u00012J\u0007\u00021!I2\u0001\u0003\u0014\u000e\u0003aIQ\u0005\u0004\u0003\u0002\u0011\u001bj\u0011\u0001\u0007\u0005\u001a\u0007!9S\"\u0001M(3\rA\u0001&D\u0001\u0019R\u0015BA!\u0001\u0005*\u001b\u0005A\u0002\"G\u0002\tT5\t\u0001DK\u0013\t\t\u0005A)&D\u0001\u0019\u0011e\u0019\u00012K\u0007\u00021)*\u0003\u0002B\u0001\tW5\t\u0001\u0004C\r\u0004\u00117i\u0011\u0001\u0007\b&\u0011\u0011\t\u0001rK\u0007\u00021!I2\u0001C\b\u000e\u0003a}Qe\u0002\u0005-\u001b\u0005A\u0002\"G\u0002\tZ5\t\u0001$L\u0013\u0013\t\u0005AY&D\u0001\u0019\u0011e1\u0001BL\u0007\u0005\u0013\tI\u0011\u0001'\u0015\u0019^e1\u0001bL\u0007\u0005\u0013\tI\u0011\u0001'\u0015\u0019`\u0015\u001aB!\u0001\u00051\u001b\u0005A\u0002\"F\u0001\u0019;e-A!\u0001E1\u001b\u0005A\u0012\u0007UB\u00013\u0017!\u0011\u0001c\u0019\u000e\u0003a\t\u0004kA\u0001&\r\u0011\t\u0001\u0012M\u0007\u00021!)\u0012\u0001G\u000f&\r\u0011\t\u00012M\u0007\u00021!)\u0012\u0001G\u000f&\u000b!\u0011T\"\u0001\r\t+\u0005AJ#K\u0004\u0005\u0003\"A1!D\u0001\u0019\bE\u001b\u0011!\u0002\u0001*\u000f\u0011\t\u0005\u0002C\u0001\u000e\u0003a\r\u0011kA\u0001\u0006\u0001%:A!\u0011\u0005\t\t5\t\u0001\u0014B)\u0004\u0003\u0015\u0001\u0011v\u0003\u0003B\u0011!\u0011Q2\u0002M\u0007S\u0005A*!U\u0002\u0002\t\u001d\t6!A\u0003\u0001S\u001d!\u0011\t\u0003\u0005\u0006\u001b\u0005AZ!U\u0002\u0002\u000b\u0001\u0001"}, strings={"Lorg/jetbrains/kotlin/resolve/DeclarationsChecker;", "", "descriptorResolver", "Lorg/jetbrains/kotlin/resolve/DescriptorResolver;", "modifiersChecker", "Lorg/jetbrains/kotlin/resolve/ModifiersChecker;", "annotationChecker", "Lorg/jetbrains/kotlin/resolve/AnnotationChecker;", "identifierChecker", "Lorg/jetbrains/kotlin/resolve/IdentifierChecker;", "trace", "Lorg/jetbrains/kotlin/resolve/BindingTrace;", "(Lorg/jetbrains/kotlin/resolve/DescriptorResolver;Lorg/jetbrains/kotlin/resolve/ModifiersChecker;Lorg/jetbrains/kotlin/resolve/AnnotationChecker;Lorg/jetbrains/kotlin/resolve/IdentifierChecker;Lorg/jetbrains/kotlin/resolve/BindingTrace;)V", "Lorg/jetbrains/kotlin/resolve/ModifiersChecker$ModifiersCheckingProcedure;", "Lorg/jetbrains/annotations/NotNull;", "checkAccessor", "", "propertyDescriptor", "Lorg/jetbrains/kotlin/descriptors/PropertyDescriptor;", "accessor", "Lorg/jetbrains/kotlin/psi/KtPropertyAccessor;", "accessorDescriptor", "Lorg/jetbrains/kotlin/descriptors/PropertyAccessorDescriptor;", "checkAccessors", "property", "Lorg/jetbrains/kotlin/psi/KtProperty;", "checkAnnotationClassWithBody", "classOrObject", "Lorg/jetbrains/kotlin/psi/KtClassOrObject;", "checkClass", "aClass", "Lorg/jetbrains/kotlin/psi/KtClass;", "classDescriptor", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptorWithResolutionScopes;", "checkClassExposedType", "klass", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "checkConstructorDeclaration", "constructorDescriptor", "Lorg/jetbrains/kotlin/descriptors/ConstructorDescriptor;", "declaration", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "checkConstructorInInterface", "checkEnumEntry", "enumEntry", "Lorg/jetbrains/kotlin/psi/KtEnumEntry;", "checkExposedParameterBounds", "checkExposedSupertypes", "checkFunction", "function", "Lorg/jetbrains/kotlin/psi/KtNamedFunction;", "functionDescriptor", "Lorg/jetbrains/kotlin/descriptors/SimpleFunctionDescriptor;", "checkFunctionExposedType", "Lorg/jetbrains/kotlin/psi/KtFunction;", "Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "checkMemberReceiverExposedType", "typeReference", "Lorg/jetbrains/kotlin/psi/KtTypeReference;", "memberDescriptor", "Lorg/jetbrains/kotlin/descriptors/CallableMemberDescriptor;", "checkMethodsOfAnyInInterface", "checkModifiersAndAnnotationsInPackageDirective", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "checkObject", "Lorg/jetbrains/kotlin/psi/KtObjectDeclaration;", "checkOpenMembers", "checkPrimaryConstructor", "checkProperty", "checkPropertyAbstractness", "checkPropertyExposedType", "checkPropertyInitializer", "checkPropertyLateInit", "Lorg/jetbrains/kotlin/psi/KtCallableDeclaration;", "checkPropertyTypeParametersAreUsedInReceiverType", "descriptor", "checkSupertypesForConsistency", "classifierDescriptor", "Lorg/jetbrains/kotlin/descriptors/ClassifierDescriptor;", "sourceElement", "Lcom/intellij/psi/PsiElement;", "checkTypeParameterConstraints", "typeParameterListOwner", "Lorg/jetbrains/kotlin/psi/KtTypeParameterListOwner;", "checkTypeParameters", "checkTypesInClassHeader", "checkValOnAnnotationParameter", "process", "bodiesResolveContext", "Lorg/jetbrains/kotlin/resolve/BodiesResolveContext;", "reportVisibilityModifierDiagnostics", "tokens", "", "diagnostic", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticFactory0;", "check", "checkBoundsForTypeInClassHeader", "", "checkFinalUpperBounds", "checkTypeReferences", "Companion"}, moduleName="kotlin-compiler")
public final class DeclarationsChecker {
    private static final ImmutableSet<String> METHOD_OF_ANY_NAMES;
    private final ModifiersChecker.ModifiersCheckingProcedure modifiersChecker;
    private final DescriptorResolver descriptorResolver;
    private final AnnotationChecker annotationChecker;
    private final IdentifierChecker identifierChecker;
    private final BindingTrace trace;
    public static final Companion Companion;

    static {
        Companion = org.jetbrains.kotlin.resolve.DeclarationsChecker$Companion.INSTANCE;
        METHOD_OF_ANY_NAMES = ImmutableSet.of("toString", "hashCode", "equals");
    }

    public final void checkTypeReferences(KtDeclaration $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        DeclarationsCheckerKt.checkTypeReferences($receiver, this.trace);
    }

    /*
     * WARNING - void declaration
     */
    public final void process(@NotNull BodiesResolveContext bodiesResolveContext) {
        Object propertyDescriptor;
        Object functionDescriptor;
        void $receiver;
        Object classDescriptor;
        KtClassOrObject $receiver2;
        Map.Entry $i$f$component1;
        Intrinsics.checkParameterIsNotNull(bodiesResolveContext, "bodiesResolveContext");
        Iterator<Object> iterator2 = bodiesResolveContext.getFiles().iterator();
        while (iterator2.hasNext()) {
            KtFile entry;
            KtFile ktFile = entry = iterator2.next();
            Intrinsics.checkExpressionValueIsNotNull(ktFile, "file");
            this.checkModifiersAndAnnotationsInPackageDirective(ktFile);
            KtAnnotated ktAnnotated = entry;
            Intrinsics.checkExpressionValueIsNotNull(ktAnnotated, "file");
            this.annotationChecker.check(ktAnnotated, this.trace, null);
        }
        iterator2 = bodiesResolveContext.getDeclaredClasses().entrySet().iterator();
        while (iterator2.hasNext()) {
            void $receiver22;
            Map.Entry entry;
            Map.Entry entry2 = entry = (Map.Entry)iterator2.next();
            KtClassOrObject classOrObject = (KtClassOrObject)$receiver22.getKey();
            $i$f$component1 = entry;
            classDescriptor = (ClassDescriptorWithResolutionScopes)$receiver2.getValue();
            ClassifierDescriptor classifierDescriptor = (ClassifierDescriptor)classDescriptor;
            Intrinsics.checkExpressionValueIsNotNull(classifierDescriptor, "classDescriptor");
            PsiElement psiElement2 = classOrObject;
            Intrinsics.checkExpressionValueIsNotNull(psiElement2, "classOrObject");
            this.checkSupertypesForConsistency(classifierDescriptor, psiElement2);
            KtClassOrObject ktClassOrObject = classOrObject;
            Intrinsics.checkExpressionValueIsNotNull(ktClassOrObject, "classOrObject");
            this.checkTypesInClassHeader(ktClassOrObject);
            $receiver2 = classOrObject;
            if ($receiver2 instanceof KtClass) {
                KtClass ktClass = (KtClass)classOrObject;
                Object object = classDescriptor;
                Intrinsics.checkExpressionValueIsNotNull(object, "classDescriptor");
                this.checkClass(ktClass, (ClassDescriptorWithResolutionScopes)object);
                this.descriptorResolver.checkNamesInConstraints(classOrObject, (DeclarationDescriptor)classDescriptor, classDescriptor.getScopeForClassHeaderResolution(), this.trace);
            } else if ($receiver2 instanceof KtObjectDeclaration) {
                KtObjectDeclaration ktObjectDeclaration = (KtObjectDeclaration)classOrObject;
                ClassDescriptor classDescriptor2 = (ClassDescriptor)classDescriptor;
                Intrinsics.checkExpressionValueIsNotNull(classDescriptor2, "classDescriptor");
                this.checkObject(ktObjectDeclaration, classDescriptor2);
            }
            KtClassOrObject ktClassOrObject2 = classOrObject;
            Intrinsics.checkExpressionValueIsNotNull(ktClassOrObject2, "classOrObject");
            ClassDescriptor classDescriptor3 = (ClassDescriptor)classDescriptor;
            Intrinsics.checkExpressionValueIsNotNull(classDescriptor3, "classDescriptor");
            this.checkPrimaryConstructor(ktClassOrObject2, classDescriptor3);
            this.checkTypeReferences(classOrObject);
            this.modifiersChecker.checkModifiersForDeclaration(classOrObject, (MemberDescriptor)classDescriptor);
            KtDeclaration ktDeclaration = classOrObject;
            Intrinsics.checkExpressionValueIsNotNull(ktDeclaration, "classOrObject");
            this.identifierChecker.checkDeclaration(ktDeclaration, this.trace);
            KtClassOrObject ktClassOrObject3 = classOrObject;
            Intrinsics.checkExpressionValueIsNotNull(ktClassOrObject3, "classOrObject");
            ClassDescriptor classDescriptor4 = (ClassDescriptor)classDescriptor;
            Intrinsics.checkExpressionValueIsNotNull(classDescriptor4, "classDescriptor");
            this.checkClassExposedType(ktClassOrObject3, classDescriptor4);
        }
        for (Map.Entry entry : bodiesResolveContext.getFunctions().entrySet()) {
            classDescriptor = entry;
            KtNamedFunction function = (KtNamedFunction)$receiver.getKey();
            $i$f$component1 = entry;
            functionDescriptor = (SimpleFunctionDescriptor)$receiver2.getValue();
            KtNamedFunction ktNamedFunction = function;
            Intrinsics.checkExpressionValueIsNotNull(ktNamedFunction, "function");
            Object object = functionDescriptor;
            Intrinsics.checkExpressionValueIsNotNull(object, "functionDescriptor");
            this.checkFunction(ktNamedFunction, (SimpleFunctionDescriptor)object);
            this.checkTypeReferences(function);
            this.modifiersChecker.checkModifiersForDeclaration(function, (MemberDescriptor)functionDescriptor);
            KtDeclaration ktDeclaration = function;
            Intrinsics.checkExpressionValueIsNotNull(ktDeclaration, "function");
            this.identifierChecker.checkDeclaration(ktDeclaration, this.trace);
        }
        for (Map.Entry entry : bodiesResolveContext.getProperties().entrySet()) {
            functionDescriptor = entry;
            KtProperty property = (KtProperty)$receiver.getKey();
            $i$f$component1 = entry;
            propertyDescriptor = (PropertyDescriptor)$receiver2.getValue();
            KtProperty ktProperty = property;
            Intrinsics.checkExpressionValueIsNotNull(ktProperty, "property");
            Object object = propertyDescriptor;
            Intrinsics.checkExpressionValueIsNotNull(object, "propertyDescriptor");
            this.checkProperty(ktProperty, (PropertyDescriptor)object);
            this.checkTypeReferences(property);
            this.modifiersChecker.checkModifiersForDeclaration(property, (MemberDescriptor)propertyDescriptor);
            KtDeclaration ktDeclaration = property;
            Intrinsics.checkExpressionValueIsNotNull(ktDeclaration, "property");
            this.identifierChecker.checkDeclaration(ktDeclaration, this.trace);
        }
        for (Map.Entry entry : bodiesResolveContext.getSecondaryConstructors().entrySet()) {
            ConstructorDescriptor constructorDescriptor;
            propertyDescriptor = entry;
            KtSecondaryConstructor declaration = (KtSecondaryConstructor)$receiver.getKey();
            $i$f$component1 = entry;
            ConstructorDescriptor constructorDescriptor2 = constructorDescriptor = (ConstructorDescriptor)$receiver2.getValue();
            Intrinsics.checkExpressionValueIsNotNull(constructorDescriptor2, "constructorDescriptor");
            KtDeclaration ktDeclaration = declaration;
            Intrinsics.checkExpressionValueIsNotNull(ktDeclaration, "declaration");
            this.checkConstructorDeclaration(constructorDescriptor2, ktDeclaration);
            KtFunction ktFunction = declaration;
            Intrinsics.checkExpressionValueIsNotNull(ktFunction, "declaration");
            FunctionDescriptor functionDescriptor2 = constructorDescriptor;
            Intrinsics.checkExpressionValueIsNotNull(functionDescriptor2, "constructorDescriptor");
            this.checkFunctionExposedType(ktFunction, functionDescriptor2);
        }
    }

    private final void checkConstructorDeclaration(ConstructorDescriptor constructorDescriptor, KtDeclaration declaration) {
        this.checkTypeReferences(declaration);
        this.modifiersChecker.checkModifiersForDeclaration(declaration, constructorDescriptor);
        this.identifierChecker.checkDeclaration(declaration, this.trace);
    }

    /*
     * WARNING - void declaration
     */
    private final void checkModifiersAndAnnotationsInPackageDirective(KtFile file) {
        KtPackageDirective ktPackageDirective = file.getPackageDirective();
        if (ktPackageDirective == null) {
            return;
        }
        KtPackageDirective packageDirective = ktPackageDirective;
        KtModifierList ktModifierList = packageDirective.getModifierList();
        if (ktModifierList == null) {
            return;
        }
        KtModifierList modifierList = ktModifierList;
        for (KtAnnotationEntry annotationEntry : modifierList.getAnnotationEntries()) {
            Unit unit;
            KtConstructorCalleeExpression calleeExpression = annotationEntry.getCalleeExpression();
            if (calleeExpression == null) continue;
            if (calleeExpression.getConstructorReferenceExpression() != null) {
                void $receiver;
                KtSimpleNameExpression it2 = (KtSimpleNameExpression)$receiver;
                this.trace.report(Errors.UNRESOLVED_REFERENCE.on((KtReferenceExpression)((PsiElement)it2), it2));
                unit = Unit.INSTANCE;
                continue;
            }
            unit = null;
        }
        KtAnnotated ktAnnotated = packageDirective;
        Intrinsics.checkExpressionValueIsNotNull(ktAnnotated, "packageDirective");
        this.annotationChecker.check(ktAnnotated, this.trace, null);
        KtModifierListOwner ktModifierListOwner = packageDirective;
        Intrinsics.checkExpressionValueIsNotNull(ktModifierListOwner, "packageDirective");
        ModifierCheckerCore.INSTANCE.check(ktModifierListOwner, this.trace, null);
    }

    private final void checkTypesInClassHeader(KtClassOrObject classOrObject) {
        for (KtDelegationSpecifier delegationSpecifier : classOrObject.getDelegationSpecifiers()) {
            Unit unit;
            KtTypeReference ktTypeReference = delegationSpecifier.getTypeReference();
            if (ktTypeReference != null) {
                DeclarationsChecker.check$default(this, ktTypeReference, true, false, 2);
                unit = Unit.INSTANCE;
                continue;
            }
            unit = null;
        }
        if (!(classOrObject instanceof KtClass)) {
            return;
        }
        for (KtTypeParameter jetTypeParameter : ((KtClass)classOrObject).getTypeParameters()) {
            Unit unit;
            KtTypeReference ktTypeReference = jetTypeParameter.getExtendsBound();
            if (ktTypeReference != null) {
                this.check(ktTypeReference, true, true);
                unit = Unit.INSTANCE;
                continue;
            }
            unit = null;
        }
        for (KtTypeConstraint constraint : ((KtClass)classOrObject).getTypeConstraints()) {
            Unit unit;
            KtTypeReference ktTypeReference = constraint.getBoundTypeReference();
            if (ktTypeReference != null) {
                this.check(ktTypeReference, true, true);
                unit = Unit.INSTANCE;
                continue;
            }
            unit = null;
        }
    }

    private final void checkBoundsForTypeInClassHeader(KtTypeReference $receiver) {
        Unit unit;
        KotlinType kotlinType = (KotlinType)this.trace.getBindingContext().get(BindingContext.TYPE, $receiver);
        if (kotlinType != null) {
            KotlinType $receiver2 = kotlinType;
            KotlinType it2 = $receiver2;
            DescriptorResolver.checkBounds($receiver, it2, this.trace);
            unit = Unit.INSTANCE;
        } else {
            unit = null;
        }
    }

    private final void checkFinalUpperBounds(KtTypeReference $receiver) {
        Unit unit;
        KotlinType kotlinType = (KotlinType)this.trace.getBindingContext().get(BindingContext.TYPE, $receiver);
        if (kotlinType != null) {
            KotlinType $receiver2 = kotlinType;
            KotlinType it2 = $receiver2;
            DescriptorResolver.checkUpperBoundType($receiver, it2, this.trace);
            unit = Unit.INSTANCE;
        } else {
            unit = null;
        }
    }

    private final void check(KtTypeReference $receiver, boolean checkBoundsForTypeInClassHeader, boolean checkFinalUpperBounds) {
        if (checkFinalUpperBounds) {
            this.checkFinalUpperBounds($receiver);
        } else {
            DeclarationsCheckerKt.checkNotEnumEntry($receiver, this.trace);
        }
        if (checkBoundsForTypeInClassHeader) {
            this.checkBoundsForTypeInClassHeader($receiver);
        }
    }

    static /* bridge */ /* synthetic */ void check$default(DeclarationsChecker declarationsChecker, KtTypeReference ktTypeReference, boolean bl, boolean bl2, int n) {
        if ((n & 1) != 0) {
            bl = false;
        }
        if ((n & 2) != 0) {
            bl2 = false;
        }
        declarationsChecker.check(ktTypeReference, bl, bl2);
    }

    /*
     * WARNING - void declaration
     */
    private final void checkSupertypesForConsistency(ClassifierDescriptor classifierDescriptor, PsiElement sourceElement) {
        Multimap<TypeParameterDescriptor, TypeProjection> multimap = SubstitutionUtils.buildDeepSubstitutionMultimap(classifierDescriptor.getDefaultType());
        Iterator<Map.Entry<TypeParameterDescriptor, Collection<TypeProjection>>> iterator2 = multimap.asMap().entrySet().iterator();
        while (iterator2.hasNext()) {
            ClassDescriptor containingDeclaration;
            void $receiver;
            void $receiver2;
            Map.Entry<TypeParameterDescriptor, Collection<TypeProjection>> entry;
            Map.Entry<TypeParameterDescriptor, Collection<TypeProjection>> entry2 = entry = iterator2.next();
            TypeParameterDescriptor typeParameterDescriptor = (TypeParameterDescriptor)$receiver2.getKey();
            Map.Entry<TypeParameterDescriptor, Collection<TypeProjection>> $i$f$component1 = entry;
            Collection projections = (Collection)$receiver.getValue();
            if (projections.size() <= 1) continue;
            LinkedHashSet<KotlinType> conflictingTypes = Sets.newLinkedHashSet();
            for (TypeProjection projection : projections) {
                conflictingTypes.add(projection.getType());
            }
            Set set = conflictingTypes;
            Intrinsics.checkExpressionValueIsNotNull(set, "conflictingTypes");
            DeclarationsChecker.Companion.removeDuplicateTypes(set);
            if (conflictingTypes.size() <= 1) continue;
            DeclarationDescriptor declarationDescriptor = typeParameterDescriptor.getContainingDeclaration();
            if (!(declarationDescriptor instanceof ClassDescriptor)) {
                declarationDescriptor = null;
            }
            if ((ClassDescriptor)declarationDescriptor == null) {
                throw (Throwable)((Object)new AssertionError((Object)("Not a class descriptor : " + typeParameterDescriptor.getContainingDeclaration())));
            }
            if (sourceElement instanceof KtClassOrObject) {
                KtDelegationSpecifierList delegationSpecifierList;
                if (((KtClassOrObject)sourceElement).getDelegationSpecifierList() == null) {
                    continue;
                }
                this.trace.report(Errors.INCONSISTENT_TYPE_PARAMETER_VALUES.on((KtDelegationSpecifierList)((PsiElement)delegationSpecifierList), typeParameterDescriptor, containingDeclaration, conflictingTypes));
                continue;
            }
            if (!(sourceElement instanceof KtTypeParameter)) continue;
            this.trace.report(Errors.INCONSISTENT_TYPE_PARAMETER_BOUNDS.on((KtTypeParameter)sourceElement, typeParameterDescriptor, containingDeclaration, conflictingTypes));
        }
    }

    private final void checkClassExposedType(KtClassOrObject klass, ClassDescriptor classDescriptor) {
        this.checkExposedSupertypes(klass, classDescriptor);
        this.checkExposedParameterBounds(klass, classDescriptor);
        KtPrimaryConstructor ktPrimaryConstructor = klass.getPrimaryConstructor();
        if (ktPrimaryConstructor == null) {
            return;
        }
        KtPrimaryConstructor constructor = ktPrimaryConstructor;
        ConstructorDescriptor constructorDescriptor = classDescriptor.getUnsubstitutedPrimaryConstructor();
        if (constructorDescriptor == null) {
            return;
        }
        ConstructorDescriptor constructorDescriptor2 = constructorDescriptor;
        KtFunction ktFunction = constructor;
        FunctionDescriptor functionDescriptor = constructorDescriptor2;
        Intrinsics.checkExpressionValueIsNotNull(functionDescriptor, "constructorDescriptor");
        this.checkFunctionExposedType(ktFunction, functionDescriptor);
    }

    /*
     * WARNING - void declaration
     */
    private final void checkExposedParameterBounds(KtClassOrObject klass, ClassDescriptor classDescriptor) {
        void $receiver;
        EffectiveVisibility classVisibility = EffectiveVisibilityKt.effectiveVisibility(classDescriptor);
        List<KtTypeParameter> typeParameterList = klass.getTypeParameters();
        Iterable iterable = classDescriptor.getDeclaredTypeParameters();
        int index2 = 0;
        for (Object item : $receiver) {
            void typeParameterDescriptor;
            int n = index2++;
            TypeParameterDescriptor typeParameterDescriptor2 = (TypeParameterDescriptor)item;
            int i = n;
            if (i >= typeParameterList.size()) {
                return;
            }
            for (KotlinType upperBound : typeParameterDescriptor.getUpperBounds()) {
                EffectiveVisibility upperBoundVisibility = EffectiveVisibilityKt.effectiveVisibility(upperBound);
                if (upperBoundVisibility.sameOrMorePermissive(classVisibility)) continue;
                this.trace.report(Errors.EXPOSED_TYPE_PARAMETER_BOUND.on((KtTypeParameter)((PsiElement)typeParameterList.get(i)), classVisibility, upperBoundVisibility));
                break;
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void checkExposedSupertypes(KtClassOrObject klass, ClassDescriptor classDescriptor) {
        void $receiver;
        EffectiveVisibility classVisibility = EffectiveVisibilityKt.effectiveVisibility(classDescriptor);
        boolean isInterface = Intrinsics.areEqual((Object)classDescriptor.getKind(), (Object)ClassKind.INTERFACE);
        List<KtDelegationSpecifier> delegationList = klass.getDelegationSpecifiers();
        Iterable iterable = classDescriptor.getTypeConstructor().getSupertypes();
        int index2 = 0;
        for (Object item : $receiver) {
            EffectiveVisibility superTypeVisibility;
            ClassDescriptor superDescriptor;
            void superType;
            int n = index2++;
            KotlinType kotlinType = (KotlinType)item;
            int i = n;
            if (i >= delegationList.size()) {
                return;
            }
            if (TypeUtils.getClassDescriptor((KotlinType)superType) == null) {
                continue;
            }
            boolean superIsInterface = Intrinsics.areEqual((Object)superDescriptor.getKind(), (Object)ClassKind.INTERFACE);
            if (superIsInterface != isInterface || (superTypeVisibility = EffectiveVisibilityKt.effectiveVisibility((KotlinType)superType)).sameOrMorePermissive(classVisibility)) continue;
            if (isInterface) {
                this.trace.report(Errors.EXPOSED_SUPER_INTERFACE.on((KtDelegationSpecifier)((PsiElement)delegationList.get(i)), classVisibility, superTypeVisibility));
                continue;
            }
            this.trace.report(Errors.EXPOSED_SUPER_CLASS.on((KtDelegationSpecifier)((PsiElement)delegationList.get(i)), classVisibility, superTypeVisibility));
        }
    }

    private final void checkObject(KtObjectDeclaration declaration, ClassDescriptor classDescriptor) {
        if (declaration.isLocal() && !declaration.isCompanion() && !declaration.isObjectLiteral()) {
            this.trace.report(Errors.LOCAL_OBJECT_NOT_ALLOWED.on((KtObjectDeclaration)((PsiElement)declaration), classDescriptor));
        }
    }

    private final void checkClass(KtClass aClass, ClassDescriptorWithResolutionScopes classDescriptor) {
        this.checkOpenMembers(classDescriptor);
        this.checkTypeParameters(aClass);
        this.checkTypeParameterConstraints(aClass);
        FiniteBoundRestrictionChecker.check(aClass, classDescriptor, this.trace);
        NonExpansiveInheritanceRestrictionChecker.check(aClass, classDescriptor, this.trace);
        if (aClass.isInterface()) {
            this.checkConstructorInInterface(aClass);
            this.checkMethodsOfAnyInInterface(classDescriptor);
            if (aClass.isLocal() && !(classDescriptor.getContainingDeclaration() instanceof ClassDescriptor)) {
                this.trace.report(Errors.LOCAL_INTERFACE_NOT_ALLOWED.on((KtClass)((PsiElement)aClass), classDescriptor));
            }
        } else if (Intrinsics.areEqual((Object)classDescriptor.getKind(), (Object)ClassKind.ANNOTATION_CLASS)) {
            this.checkAnnotationClassWithBody(aClass);
            this.checkValOnAnnotationParameter(aClass);
        } else if (aClass instanceof KtEnumEntry) {
            this.checkEnumEntry((KtEnumEntry)aClass, classDescriptor);
        }
        for (CallableMemberDescriptor memberDescriptor : classDescriptor.getDeclaredCallableMembers()) {
            KtFunction member;
            if (Intrinsics.areEqual((Object)memberDescriptor.getKind(), (Object)CallableMemberDescriptor.Kind.DECLARATION) ^ true) continue;
            DeclarationDescriptor declarationDescriptor = memberDescriptor;
            Intrinsics.checkExpressionValueIsNotNull(declarationDescriptor, "memberDescriptor");
            PsiElement psiElement2 = DescriptorToSourceUtils.descriptorToDeclaration(declarationDescriptor);
            if (!(psiElement2 instanceof KtFunction)) {
                psiElement2 = null;
            }
            if ((member = (KtFunction)psiElement2) == null || !(memberDescriptor instanceof FunctionDescriptor)) continue;
            this.checkFunctionExposedType(member, (FunctionDescriptor)memberDescriptor);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void checkPrimaryConstructor(KtClassOrObject classOrObject, ClassDescriptor classDescriptor) {
        ConstructorDescriptor constructorDescriptor = classDescriptor.getUnsubstitutedPrimaryConstructor();
        if (constructorDescriptor == null) {
            return;
        }
        ConstructorDescriptor primaryConstructor2 = constructorDescriptor;
        KtPrimaryConstructor ktPrimaryConstructor = classOrObject.getPrimaryConstructor();
        if (ktPrimaryConstructor == null) {
            return;
        }
        KtPrimaryConstructor declaration = ktPrimaryConstructor;
        for (KtElementImplStub parameter : declaration.getValueParameters()) {
            Unit unit;
            if ((PropertyDescriptor)this.trace.get(BindingContext.PRIMARY_CONSTRUCTOR_PARAMETER, parameter) != null) {
                void $receiver;
                PropertyDescriptor it2 = (PropertyDescriptor)$receiver;
                this.modifiersChecker.checkModifiersForDeclaration((KtDeclaration)((Object)parameter), it2);
                KtCallableDeclaration ktCallableDeclaration = parameter;
                Intrinsics.checkExpressionValueIsNotNull(ktCallableDeclaration, "parameter");
                PropertyDescriptor propertyDescriptor = it2;
                Intrinsics.checkExpressionValueIsNotNull(propertyDescriptor, "it");
                this.checkPropertyLateInit(ktCallableDeclaration, propertyDescriptor);
                unit = Unit.INSTANCE;
                continue;
            }
            unit = null;
        }
        if (!declaration.hasConstructorKeyword()) {
            Unit unit;
            KtModifierList ktModifierList = declaration.getModifierList();
            if (ktModifierList != null) {
                void $receiver;
                KtElementImplStub parameter;
                parameter = ktModifierList;
                KtModifierList it3 = (KtModifierList)$receiver;
                this.trace.report(Errors.MISSING_CONSTRUCTOR_KEYWORD.on((KtElement)((PsiElement)it3)));
                unit = Unit.INSTANCE;
            } else {
                unit = null;
            }
        }
        if (!(classOrObject instanceof KtClass)) {
            this.trace.report(Errors.CONSTRUCTOR_IN_OBJECT.on((KtDeclaration)((PsiElement)declaration)));
        }
        ConstructorDescriptor constructorDescriptor2 = primaryConstructor2;
        Intrinsics.checkExpressionValueIsNotNull(constructorDescriptor2, "primaryConstructor");
        this.checkConstructorDeclaration(constructorDescriptor2, declaration);
    }

    /*
     * WARNING - void declaration
     */
    private final void checkTypeParameters(KtTypeParameterListOwner typeParameterListOwner) {
        for (KtTypeParameter jetTypeParameter : typeParameterListOwner.getTypeParameters()) {
            Unit unit;
            AnnotationResolver.reportUnsupportedAnnotationForTypeParameter(jetTypeParameter, this.trace);
            if ((TypeParameterDescriptor)this.trace.get(BindingContext.TYPE_PARAMETER, jetTypeParameter) != null) {
                void $receiver;
                TypeParameterDescriptor it2 = (TypeParameterDescriptor)$receiver;
                DescriptorResolver.checkConflictingUpperBounds(this.trace, it2, jetTypeParameter);
                unit = Unit.INSTANCE;
                continue;
            }
            unit = null;
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void checkTypeParameterConstraints(KtTypeParameterListOwner typeParameterListOwner) {
        List<KtTypeConstraint> constraints = typeParameterListOwner.getTypeConstraints();
        if (!constraints.isEmpty()) {
            for (KtTypeParameter typeParameter : typeParameterListOwner.getTypeParameters()) {
                Unit unit;
                if (typeParameter.getExtendsBound() != null) {
                    KtTypeParameter ktTypeParameter = typeParameter;
                    Intrinsics.checkExpressionValueIsNotNull(ktTypeParameter, "typeParameter");
                    List<KtTypeConstraint> list = constraints;
                    Intrinsics.checkExpressionValueIsNotNull(list, "constraints");
                    if (DeclarationsChecker.Companion.hasConstraints(ktTypeParameter, list)) {
                        this.trace.report(Errors.MISPLACED_TYPE_PARAMETER_CONSTRAINTS.on((KtTypeParameter)((PsiElement)typeParameter)));
                    }
                }
                if ((TypeParameterDescriptor)this.trace.get(BindingContext.TYPE_PARAMETER, typeParameter) != null) {
                    void $receiver;
                    TypeParameterDescriptor it2 = (TypeParameterDescriptor)$receiver;
                    ClassifierDescriptor classifierDescriptor = it2;
                    Intrinsics.checkExpressionValueIsNotNull(classifierDescriptor, "it");
                    PsiElement psiElement2 = typeParameter;
                    Intrinsics.checkExpressionValueIsNotNull(psiElement2, "typeParameter");
                    this.checkSupertypesForConsistency(classifierDescriptor, psiElement2);
                    unit = Unit.INSTANCE;
                    continue;
                }
                unit = null;
            }
        }
    }

    private final void checkConstructorInInterface(KtClass klass) {
        Unit unit;
        KtPrimaryConstructor ktPrimaryConstructor = klass.getPrimaryConstructor();
        if (ktPrimaryConstructor != null) {
            KtPrimaryConstructor $receiver = ktPrimaryConstructor;
            KtPrimaryConstructor it2 = $receiver;
            this.trace.report(Errors.CONSTRUCTOR_IN_INTERFACE.on((KtDeclaration)((PsiElement)it2)));
            unit = Unit.INSTANCE;
        } else {
            unit = null;
        }
    }

    private final void checkMethodsOfAnyInInterface(ClassDescriptorWithResolutionScopes classDescriptor) {
        for (CallableMemberDescriptor declaredCallableMember : classDescriptor.getDeclaredCallableMembers()) {
            PsiElement declaration;
            if (!(declaredCallableMember instanceof FunctionDescriptor) || !((declaration = DescriptorToSourceUtils.descriptorToDeclaration(declaredCallableMember)) instanceof KtNamedFunction) || DeclarationsChecker.Companion.isHidingParentMemberIfPresent(declaredCallableMember) || !DeclarationsChecker.Companion.isImplementingMethodOfAny(declaredCallableMember)) continue;
            this.trace.report(Errors.METHOD_OF_ANY_IMPLEMENTED_IN_INTERFACE.on((KtDeclaration)declaration));
        }
    }

    private final void checkAnnotationClassWithBody(KtClassOrObject classOrObject) {
        Unit unit;
        KtClassBody ktClassBody = classOrObject.getBody();
        if (ktClassBody != null) {
            KtClassBody $receiver = ktClassBody;
            KtClassBody it2 = $receiver;
            this.trace.report(Errors.ANNOTATION_CLASS_WITH_BODY.on(it2));
            unit = Unit.INSTANCE;
        } else {
            unit = null;
        }
    }

    private final void checkValOnAnnotationParameter(KtClass aClass) {
        for (KtParameter parameter : aClass.getPrimaryConstructorParameters()) {
            if (parameter.hasValOrVar()) continue;
            this.trace.report(Errors.MISSING_VAL_ON_ANNOTATION_PARAMETER.on((KtParameter)((PsiElement)parameter)));
        }
    }

    private final void checkOpenMembers(ClassDescriptorWithResolutionScopes classDescriptor) {
        if (DescriptorUtils.classCanHaveOpenMembers(classDescriptor)) {
            return;
        }
        for (CallableMemberDescriptor memberDescriptor : classDescriptor.getDeclaredCallableMembers()) {
            KtNamedDeclaration member;
            if (Intrinsics.areEqual((Object)memberDescriptor.getKind(), (Object)CallableMemberDescriptor.Kind.DECLARATION) ^ true) continue;
            DeclarationDescriptor declarationDescriptor = memberDescriptor;
            Intrinsics.checkExpressionValueIsNotNull(declarationDescriptor, "memberDescriptor");
            PsiElement psiElement2 = DescriptorToSourceUtils.descriptorToDeclaration(declarationDescriptor);
            if (!(psiElement2 instanceof KtNamedDeclaration)) {
                psiElement2 = null;
            }
            if ((member = (KtNamedDeclaration)psiElement2) == null || !member.hasModifier(KtTokens.OPEN_KEYWORD)) continue;
            this.trace.report(Errors.NON_FINAL_MEMBER_IN_FINAL_CLASS.on((KtNamedDeclaration)((PsiElement)member)));
        }
    }

    private final void checkProperty(KtProperty property, PropertyDescriptor propertyDescriptor) {
        DeclarationDescriptor containingDeclaration = propertyDescriptor.getContainingDeclaration();
        if (containingDeclaration instanceof ClassDescriptor) {
            ClassDescriptor classDescriptor = (ClassDescriptor)containingDeclaration;
            Intrinsics.checkExpressionValueIsNotNull(classDescriptor, "containingDeclaration");
            this.checkPropertyAbstractness(property, propertyDescriptor, classDescriptor);
        }
        this.checkPropertyLateInit(property, propertyDescriptor);
        this.checkPropertyInitializer(property, propertyDescriptor);
        this.checkAccessors(property, propertyDescriptor);
        this.checkTypeParameterConstraints(property);
        this.checkPropertyExposedType(property, propertyDescriptor);
        this.checkPropertyTypeParametersAreUsedInReceiverType(propertyDescriptor);
    }

    private final void checkPropertyTypeParametersAreUsedInReceiverType(PropertyDescriptor descriptor2) {
        Iterator<TypeParameterDescriptor> iterator2 = descriptor2.getTypeParameters().iterator();
        while (iterator2.hasNext()) {
            TypeParameterDescriptor typeParameter;
            TypeParameterDescriptor typeParameterDescriptor = typeParameter = iterator2.next();
            Intrinsics.checkExpressionValueIsNotNull(typeParameterDescriptor, "typeParameter");
            if (DeclarationsChecker.Companion.isTypeParameterUsedInReceiverType(typeParameterDescriptor, descriptor2)) continue;
            DeclarationDescriptor declarationDescriptor = typeParameter;
            Intrinsics.checkExpressionValueIsNotNull(declarationDescriptor, "typeParameter");
            PsiElement typeParameterPsi = DescriptorToSourceUtils.getSourceFromDescriptor(declarationDescriptor);
            if (!(typeParameterPsi instanceof KtTypeParameter)) continue;
            this.trace.report(Errors.TYPE_PARAMETER_OF_PROPERTY_NOT_USED_IN_RECEIVER.on((KtTypeParameter)typeParameterPsi));
        }
    }

    private final void checkPropertyLateInit(KtCallableDeclaration property, PropertyDescriptor propertyDescriptor) {
        boolean hasBackingField;
        boolean isAbstract;
        KtModifierList ktModifierList = property.getModifierList();
        if (ktModifierList == null) {
            return;
        }
        KtModifierList modifierList = ktModifierList;
        PsiElement psiElement2 = modifierList.getModifier(KtTokens.LATEINIT_KEYWORD);
        if (psiElement2 == null) {
            return;
        }
        PsiElement modifier = psiElement2;
        if (!propertyDescriptor.isVar()) {
            this.trace.report(Errors.INAPPLICABLE_LATEINIT_MODIFIER.on(modifier, "is allowed only on mutable properties"));
        }
        boolean returnTypeIsNullable = true;
        boolean returnTypeIsPrimitive = true;
        KotlinType returnType2 = propertyDescriptor.getReturnType();
        if (returnType2 != null) {
            returnTypeIsNullable = TypeUtils.isNullableType(returnType2);
            returnTypeIsPrimitive = KotlinBuiltIns.isPrimitiveType(returnType2);
        }
        if (returnTypeIsNullable) {
            this.trace.report(Errors.INAPPLICABLE_LATEINIT_MODIFIER.on(modifier, "is not allowed on nullable properties"));
        }
        if (returnTypeIsPrimitive) {
            this.trace.report(Errors.INAPPLICABLE_LATEINIT_MODIFIER.on(modifier, "is not allowed on primitive type properties"));
        }
        if (isAbstract = Intrinsics.areEqual((Object)propertyDescriptor.getModality(), (Object)Modality.ABSTRACT)) {
            this.trace.report(Errors.INAPPLICABLE_LATEINIT_MODIFIER.on(modifier, "is not allowed on abstract properties"));
        }
        if (property instanceof KtParameter) {
            this.trace.report(Errors.INAPPLICABLE_LATEINIT_MODIFIER.on(modifier, "is not allowed on primary constructor parameters"));
        }
        boolean hasDelegateExpressionOrInitializer = false;
        if (property instanceof KtProperty && ((KtProperty)property).hasDelegateExpressionOrInitializer()) {
            hasDelegateExpressionOrInitializer = true;
            this.trace.report(Errors.INAPPLICABLE_LATEINIT_MODIFIER.on(modifier, "is not allowed on properties with initializer or on delegated properties"));
        }
        boolean hasAccessorImplementation = DeclarationsChecker.Companion.hasAccessorImplementation(propertyDescriptor);
        if (!hasDelegateExpressionOrInitializer && hasAccessorImplementation) {
            this.trace.report(Errors.INAPPLICABLE_LATEINIT_MODIFIER.on(modifier, "is not allowed on properties with a custom getter or setter"));
        }
        Boolean bl = (Boolean)this.trace.getBindingContext().get(BindingContext.BACKING_FIELD_REQUIRED, propertyDescriptor);
        boolean bl2 = hasBackingField = bl != null ? bl : false;
        if (!(isAbstract || hasAccessorImplementation || hasDelegateExpressionOrInitializer || hasBackingField)) {
            this.trace.report(Errors.INAPPLICABLE_LATEINIT_MODIFIER.on(modifier, "is not allowed on properties without backing field"));
        }
        if (propertyDescriptor.getExtensionReceiverParameter() != null) {
            this.trace.report(Errors.INAPPLICABLE_LATEINIT_MODIFIER.on(modifier, "is not allowed on extension properties"));
        }
    }

    private final void checkPropertyAbstractness(KtProperty property, PropertyDescriptor propertyDescriptor, ClassDescriptor classDescriptor) {
        KtModifierList modifierList = property.getModifierList();
        if (modifierList != null && modifierList.hasModifier(KtTokens.ABSTRACT_KEYWORD)) {
            if (!DescriptorUtils.classCanHaveAbstractMembers(classDescriptor)) {
                PsiElement psiElement2 = property;
                String string = property.getName();
                if (string == null) {
                    string = "";
                }
                this.trace.report(Errors.ABSTRACT_PROPERTY_IN_NON_ABSTRACT_CLASS.on((KtModifierListOwner)psiElement2, string, classDescriptor));
                return;
            }
            if (Intrinsics.areEqual((Object)classDescriptor.getKind(), (Object)ClassKind.INTERFACE)) {
                this.trace.report(Errors.ABSTRACT_MODIFIER_IN_INTERFACE.on((KtModifierListOwner)((PsiElement)property)));
            }
        }
        if (Intrinsics.areEqual((Object)propertyDescriptor.getModality(), (Object)Modality.ABSTRACT)) {
            KtPropertyAccessor setter;
            Unit unit;
            Unit unit2;
            KtElement it2;
            KtPropertyDelegate $receiver;
            KtExpression ktExpression = property.getInitializer();
            if (ktExpression != null) {
                KtExpression ktExpression2 = ktExpression;
                it2 = (KtExpression)((Object)$receiver);
                this.trace.report(Errors.ABSTRACT_PROPERTY_WITH_INITIALIZER.on((KtExpression)it2));
                unit2 = Unit.INSTANCE;
            } else {
                unit2 = null;
            }
            KtPropertyDelegate ktPropertyDelegate = property.getDelegate();
            if (ktPropertyDelegate != null) {
                $receiver = ktPropertyDelegate;
                it2 = $receiver;
                this.trace.report(Errors.ABSTRACT_DELEGATED_PROPERTY.on((KtPropertyDelegate)it2));
                unit = Unit.INSTANCE;
            } else {
                unit = null;
            }
            KtPropertyAccessor getter = property.getGetter();
            if (getter != null && getter.hasBody()) {
                this.trace.report(Errors.ABSTRACT_PROPERTY_WITH_GETTER.on((KtPropertyAccessor)((PsiElement)getter)));
            }
            if ((setter = property.getSetter()) != null && setter.hasBody()) {
                this.trace.report(Errors.ABSTRACT_PROPERTY_WITH_SETTER.on((KtPropertyAccessor)((PsiElement)setter)));
            }
        }
    }

    private final void checkPropertyInitializer(KtProperty property, PropertyDescriptor propertyDescriptor) {
        boolean backingFieldRequired;
        boolean inTrait;
        boolean hasAccessorImplementation = DeclarationsChecker.Companion.hasAccessorImplementation(propertyDescriptor);
        DeclarationDescriptor containingDeclaration = propertyDescriptor.getContainingDeclaration();
        boolean bl = inTrait = containingDeclaration instanceof ClassDescriptor && Intrinsics.areEqual((Object)((ClassDescriptor)containingDeclaration).getKind(), (Object)ClassKind.INTERFACE);
        if (Intrinsics.areEqual((Object)propertyDescriptor.getModality(), (Object)Modality.ABSTRACT)) {
            if (!property.hasDelegateExpressionOrInitializer() && property.getTypeReference() == null) {
                this.trace.report(Errors.PROPERTY_WITH_NO_TYPE_NO_INITIALIZER.on((KtProperty)((PsiElement)property)));
            }
            if (inTrait && property.hasModifier(KtTokens.PRIVATE_KEYWORD) && !property.hasModifier(KtTokens.ABSTRACT_KEYWORD)) {
                this.trace.report(Errors.PRIVATE_PROPERTY_IN_INTERFACE.on((KtProperty)((PsiElement)property)));
            }
            return;
        }
        Boolean bl2 = (Boolean)this.trace.getBindingContext().get(BindingContext.BACKING_FIELD_REQUIRED, propertyDescriptor);
        boolean bl3 = backingFieldRequired = bl2 != null ? bl2 : false;
        if (inTrait && backingFieldRequired && hasAccessorImplementation) {
            this.trace.report(Errors.BACKING_FIELD_IN_INTERFACE.on((KtProperty)((PsiElement)property)));
        }
        KtExpression initializer2 = property.getInitializer();
        KtPropertyDelegate delegate2 = property.getDelegate();
        if (initializer2 != null) {
            if (inTrait) {
                this.trace.report(Errors.PROPERTY_INITIALIZER_IN_INTERFACE.on((KtExpression)((PsiElement)initializer2)));
            } else if (!backingFieldRequired) {
                this.trace.report(Errors.PROPERTY_INITIALIZER_NO_BACKING_FIELD.on((KtExpression)((PsiElement)initializer2)));
            } else if (property.getReceiverTypeReference() != null) {
                this.trace.report(Errors.EXTENSION_PROPERTY_WITH_BACKING_FIELD.on((KtExpression)((PsiElement)initializer2)));
            }
        } else if (delegate2 != null) {
            if (inTrait) {
                this.trace.report(Errors.DELEGATED_PROPERTY_IN_INTERFACE.on((KtPropertyDelegate)((PsiElement)delegate2)));
            }
        } else if (backingFieldRequired && !inTrait && !propertyDescriptor.isLateInit() && Intrinsics.areEqual(Boolean.TRUE, (Boolean)this.trace.getBindingContext().get(BindingContext.IS_UNINITIALIZED, propertyDescriptor))) {
            if (!(containingDeclaration instanceof ClassDescriptor) || hasAccessorImplementation) {
                this.trace.report(Errors.MUST_BE_INITIALIZED.on((KtProperty)((PsiElement)property)));
            } else {
                this.trace.report(Errors.MUST_BE_INITIALIZED_OR_BE_ABSTRACT.on((KtProperty)((PsiElement)property)));
            }
        } else if (property.getTypeReference() == null) {
            this.trace.report(Errors.PROPERTY_WITH_NO_TYPE_NO_INITIALIZER.on((KtProperty)((PsiElement)property)));
        }
    }

    private final void checkMemberReceiverExposedType(KtTypeReference typeReference, CallableMemberDescriptor memberDescriptor) {
        if (typeReference == null) {
            return;
        }
        ReceiverParameterDescriptor receiverParameterDescriptor = memberDescriptor.getExtensionReceiverParameter();
        if (receiverParameterDescriptor == null) {
            return;
        }
        ReceiverParameterDescriptor receiverParameterDescriptor2 = receiverParameterDescriptor;
        EffectiveVisibility memberVisibility = EffectiveVisibilityKt.effectiveVisibility(memberDescriptor);
        EffectiveVisibility receiverTypeVisibility = EffectiveVisibilityKt.effectiveVisibility(receiverParameterDescriptor2.getType());
        if (!receiverTypeVisibility.sameOrMorePermissive(memberVisibility)) {
            this.trace.report(Errors.EXPOSED_RECEIVER_TYPE.on((KtTypeReference)((PsiElement)typeReference), memberVisibility, receiverTypeVisibility));
        }
    }

    private final void checkPropertyExposedType(KtProperty property, PropertyDescriptor propertyDescriptor) {
        EffectiveVisibility propertyVisibility = EffectiveVisibilityKt.effectiveVisibility(propertyDescriptor);
        EffectiveVisibility typeVisibility = EffectiveVisibilityKt.effectiveVisibility(propertyDescriptor.getType());
        if (!typeVisibility.sameOrMorePermissive(propertyVisibility)) {
            this.trace.report(Errors.EXPOSED_PROPERTY_TYPE.on((KtProperty)((PsiElement)property), propertyVisibility, typeVisibility));
        }
        this.checkMemberReceiverExposedType(property.getReceiverTypeReference(), propertyDescriptor);
    }

    /*
     * WARNING - void declaration
     */
    private final void checkFunction(KtNamedFunction function, SimpleFunctionDescriptor functionDescriptor) {
        Unit unit;
        KtTypeParameterList typeParameterList = function.getTypeParameterList();
        PsiElement nameIdentifier = function.getNameIdentifier();
        if (typeParameterList != null && nameIdentifier != null && typeParameterList.getTextRange().getStartOffset() > nameIdentifier.getTextRange().getStartOffset()) {
            this.trace.report(Errors.DEPRECATED_TYPE_PARAMETER_SYNTAX.on((KtTypeParameterList)((PsiElement)typeParameterList)));
        }
        this.checkTypeParameterConstraints(function);
        DeclarationDescriptor containingDescriptor = functionDescriptor.getContainingDeclaration();
        boolean hasAbstractModifier = function.hasModifier(KtTokens.ABSTRACT_KEYWORD);
        boolean hasExternalModifier = function.hasModifier(KtTokens.EXTERNAL_KEYWORD);
        if (containingDescriptor instanceof ClassDescriptor) {
            boolean hasBody;
            boolean inTrait = Intrinsics.areEqual((Object)((ClassDescriptor)containingDescriptor).getKind(), (Object)ClassKind.INTERFACE);
            if (hasAbstractModifier && !DescriptorUtils.classCanHaveAbstractMembers((ClassDescriptor)containingDescriptor)) {
                this.trace.report(Errors.ABSTRACT_FUNCTION_IN_NON_ABSTRACT_CLASS.on((KtFunction)((PsiElement)function), functionDescriptor.getName().asString(), (ClassDescriptor)containingDescriptor));
            }
            if (hasAbstractModifier && inTrait) {
                this.trace.report(Errors.ABSTRACT_MODIFIER_IN_INTERFACE.on((KtModifierListOwner)((PsiElement)function)));
            }
            if ((hasBody = function.hasBody()) && hasAbstractModifier) {
                this.trace.report(Errors.ABSTRACT_FUNCTION_WITH_BODY.on((KtFunction)((PsiElement)function), functionDescriptor));
            }
            if (!hasBody && inTrait && function.hasModifier(KtTokens.PRIVATE_KEYWORD)) {
                this.trace.report(Errors.PRIVATE_FUNCTION_WITH_NO_BODY.on((KtFunction)((PsiElement)function), functionDescriptor));
            }
            if (!(hasBody || hasAbstractModifier || hasExternalModifier || inTrait)) {
                this.trace.report(Errors.NON_ABSTRACT_FUNCTION_WITH_NO_BODY.on((KtFunction)((PsiElement)function), functionDescriptor));
            }
            return;
        }
        if (!(function.hasBody() || hasAbstractModifier || hasExternalModifier)) {
            this.trace.report(Errors.NON_MEMBER_FUNCTION_NO_BODY.on((KtFunction)((PsiElement)function), functionDescriptor));
        }
        KotlinType kotlinType = functionDescriptor.getReturnType();
        if (kotlinType != null) {
            void $receiver;
            KotlinType inTrait = kotlinType;
            KotlinType it2 = (KotlinType)$receiver;
            if (TypeUtilsKt.isNothing(it2) && !function.hasDeclaredReturnType()) {
                BindingTrace bindingTrace = this.trace;
                PsiElement psiElement2 = nameIdentifier;
                if (psiElement2 == null) {
                    psiElement2 = function;
                }
                bindingTrace.report(Errors.IMPLICIT_NOTHING_RETURN_TYPE.on(psiElement2));
            }
            unit = Unit.INSTANCE;
        } else {
            unit = null;
        }
        this.checkFunctionExposedType(function, functionDescriptor);
    }

    /*
     * WARNING - void declaration
     */
    private final void checkFunctionExposedType(KtFunction function, FunctionDescriptor functionDescriptor) {
        void $receiver;
        Object returnTypeVisibility;
        EffectiveVisibility functionVisibility = EffectiveVisibilityKt.effectiveVisibility(functionDescriptor);
        if (!(function instanceof KtConstructor)) {
            KotlinType kotlinType = functionDescriptor.getReturnType();
            Object object = returnTypeVisibility = kotlinType != null ? EffectiveVisibilityKt.effectiveVisibility(kotlinType) : null;
            if (returnTypeVisibility != null && !((EffectiveVisibility)returnTypeVisibility).sameOrMorePermissive(functionVisibility)) {
                PsiElement psiElement2 = function.getNameIdentifier();
                if (psiElement2 == null) {
                    psiElement2 = function;
                }
                this.trace.report(Errors.EXPOSED_FUNCTION_RETURN_TYPE.on(psiElement2, functionVisibility, (EffectiveVisibility)returnTypeVisibility));
            }
        }
        returnTypeVisibility = functionDescriptor.getValueParameters();
        int index2 = 0;
        for (Object item : $receiver) {
            void parameterDescriptor;
            int n = index2++;
            ValueParameterDescriptor valueParameterDescriptor = (ValueParameterDescriptor)item;
            int i = n;
            EffectiveVisibility typeVisibility = EffectiveVisibilityKt.effectiveVisibility(parameterDescriptor.getType());
            if (typeVisibility.sameOrMorePermissive(functionVisibility) || i >= function.getValueParameters().size()) continue;
            this.trace.report(Errors.EXPOSED_PARAMETER_TYPE.on((KtParameter)((PsiElement)function.getValueParameters().get(i)), functionVisibility, typeVisibility));
        }
        this.checkMemberReceiverExposedType(function.getReceiverTypeReference(), functionDescriptor);
    }

    private final void checkAccessors(KtProperty property, PropertyDescriptor propertyDescriptor) {
        for (KtPropertyAccessor accessor : property.getAccessors()) {
            PropertyAccessorDescriptor propertyAccessorDescriptor;
            if ((accessor.isGetter() ? (PropertyAccessorDescriptor)propertyDescriptor.getGetter() : (PropertyAccessorDescriptor)propertyDescriptor.getSetter()) == null) {
                throw (Throwable)((Object)new AssertionError((Object)("No property accessor descriptor for " + property.getText())));
            }
            propertyAccessorDescriptor = propertyAccessorDescriptor;
            this.checkTypeReferences(accessor);
            this.modifiersChecker.checkModifiersForDeclaration(accessor, propertyAccessorDescriptor);
            KtDeclaration ktDeclaration = accessor;
            Intrinsics.checkExpressionValueIsNotNull(ktDeclaration, "accessor");
            this.identifierChecker.checkDeclaration(ktDeclaration, this.trace);
        }
        this.checkAccessor(propertyDescriptor, property.getGetter(), propertyDescriptor.getGetter());
        this.checkAccessor(propertyDescriptor, property.getSetter(), propertyDescriptor.getSetter());
    }

    private final void reportVisibilityModifierDiagnostics(Collection<? extends PsiElement> tokens, DiagnosticFactory0<PsiElement> diagnostic) {
        for (PsiElement psiElement2 : tokens) {
            this.trace.report(diagnostic.on(psiElement2));
        }
    }

    private final void checkAccessor(PropertyDescriptor propertyDescriptor, KtPropertyAccessor accessor, PropertyAccessorDescriptor accessorDescriptor) {
        if (accessor == null || accessorDescriptor == null) {
            return;
        }
        KtModifierList ktModifierList = accessor.getModifierList();
        if (ktModifierList == null) {
            return;
        }
        KtModifierList accessorModifierList = ktModifierList;
        Map<KtModifierKeywordToken, PsiElement> tokens = this.modifiersChecker.getTokensCorrespondingToModifiers(accessorModifierList, (Collection<KtModifierKeywordToken>)Sets.newHashSet(KtTokens.PUBLIC_KEYWORD, KtTokens.PROTECTED_KEYWORD, KtTokens.PRIVATE_KEYWORD, KtTokens.INTERNAL_KEYWORD));
        if (accessor.isGetter()) {
            if (Intrinsics.areEqual(accessorDescriptor.getVisibility(), propertyDescriptor.getVisibility()) ^ true) {
                Collection<PsiElement> collection = tokens.values();
                DiagnosticFactory0<PsiElement> diagnosticFactory0 = Errors.GETTER_VISIBILITY_DIFFERS_FROM_PROPERTY_VISIBILITY;
                Intrinsics.checkExpressionValueIsNotNull(diagnosticFactory0, "Errors.GETTER_VISIBILITY\u2026_FROM_PROPERTY_VISIBILITY");
                this.reportVisibilityModifierDiagnostics(collection, diagnosticFactory0);
            } else {
                Collection<PsiElement> collection = tokens.values();
                DiagnosticFactory0<PsiElement> diagnosticFactory0 = Errors.REDUNDANT_MODIFIER_IN_GETTER;
                Intrinsics.checkExpressionValueIsNotNull(diagnosticFactory0, "Errors.REDUNDANT_MODIFIER_IN_GETTER");
                this.reportVisibilityModifierDiagnostics(collection, diagnosticFactory0);
            }
        } else if (Intrinsics.areEqual((Object)propertyDescriptor.getModality(), (Object)Modality.FINAL) ^ true && Intrinsics.areEqual(accessorDescriptor.getVisibility(), Visibilities.PRIVATE) && Intrinsics.areEqual(propertyDescriptor.getVisibility(), Visibilities.PRIVATE) ^ true) {
            if (Intrinsics.areEqual((Object)propertyDescriptor.getModality(), (Object)Modality.ABSTRACT)) {
                Collection<PsiElement> collection = tokens.values();
                DiagnosticFactory0<PsiElement> diagnosticFactory0 = Errors.PRIVATE_SETTER_FOR_ABSTRACT_PROPERTY;
                Intrinsics.checkExpressionValueIsNotNull(diagnosticFactory0, "Errors.PRIVATE_SETTER_FOR_ABSTRACT_PROPERTY");
                this.reportVisibilityModifierDiagnostics(collection, diagnosticFactory0);
            } else {
                Collection<PsiElement> collection = tokens.values();
                DiagnosticFactory0<PsiElement> diagnosticFactory0 = Errors.PRIVATE_SETTER_FOR_OPEN_PROPERTY;
                Intrinsics.checkExpressionValueIsNotNull(diagnosticFactory0, "Errors.PRIVATE_SETTER_FOR_OPEN_PROPERTY");
                this.reportVisibilityModifierDiagnostics(collection, diagnosticFactory0);
            }
        } else if (propertyDescriptor.isLateInit() && Intrinsics.areEqual(accessorDescriptor.getVisibility(), propertyDescriptor.getVisibility()) ^ true) {
            Collection<PsiElement> collection = tokens.values();
            DiagnosticFactory0<PsiElement> diagnosticFactory0 = Errors.SETTER_VISIBILITY_DIFFERS_FROM_LATEINIT_VISIBILITY;
            Intrinsics.checkExpressionValueIsNotNull(diagnosticFactory0, "Errors.SETTER_VISIBILITY\u2026_FROM_LATEINIT_VISIBILITY");
            this.reportVisibilityModifierDiagnostics(collection, diagnosticFactory0);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void checkEnumEntry(KtEnumEntry enumEntry, ClassDescriptor classDescriptor) {
        DeclarationDescriptor declaration = classDescriptor.getContainingDeclaration();
        if (DescriptorUtils.isEnumClass(declaration)) {
            if (!enumEntry.hasInitializer()) {
                DeclarationDescriptor declarationDescriptor = declaration;
                if (declarationDescriptor == null) {
                    throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.descriptors.ClassDescriptor");
                }
                if (!DeclarationsChecker.Companion.hasDefaultConstructor((ClassDescriptor)declarationDescriptor)) {
                    this.trace.report(Errors.ENUM_ENTRY_SHOULD_BE_INITIALIZED.on((KtClass)((PsiElement)enumEntry)));
                }
            }
        } else {
            Unit unit;
            boolean bl = DescriptorUtils.isInterface(declaration);
            if (PreconditionsKt.getASSERTIONS_ENABLED()) {
                void value;
                if (value == false) {
                    String message = "Enum entry should be declared in enum class: " + classDescriptor;
                    throw (Throwable)((Object)new AssertionError((Object)message));
                }
                unit = Unit.INSTANCE;
            } else {
                unit = Unit.INSTANCE;
            }
        }
    }

    public DeclarationsChecker(@NotNull DescriptorResolver descriptorResolver, @NotNull ModifiersChecker modifiersChecker, @NotNull AnnotationChecker annotationChecker, @NotNull IdentifierChecker identifierChecker, @NotNull BindingTrace trace) {
        Intrinsics.checkParameterIsNotNull(descriptorResolver, "descriptorResolver");
        Intrinsics.checkParameterIsNotNull(modifiersChecker, "modifiersChecker");
        Intrinsics.checkParameterIsNotNull(annotationChecker, "annotationChecker");
        Intrinsics.checkParameterIsNotNull(identifierChecker, "identifierChecker");
        Intrinsics.checkParameterIsNotNull(trace, "trace");
        this.descriptorResolver = descriptorResolver;
        this.annotationChecker = annotationChecker;
        this.identifierChecker = identifierChecker;
        this.trace = trace;
        this.modifiersChecker = modifiersChecker.withTrace(this.trace);
    }

    @KotlinClass(version={1, 0, 0}, abiVersion=32, data={"a\u0015\tA\"A\u0003\u0002\u0011\u0001)\u0011\u0001B\u0001\u0006\u00031\tQ!\u0001\u0005\b\u000b\u0005!!!B\u0001\t\f\u0015\u0001Q!\u0001\u0007\u0002\u000b\u0001)\u0011\u0001\u0003\t\u0006\u00031\tQ!\u0001\u0003\u0002\u000b\u0005a\u0011!B\u0001\u0005\u0003\u0015\tA\"A\u0003\u0002\t\u0007)\u0011\u0001c\t\u0006\u0003\u0011\tQ!\u0001\u0007\u0002\u000b\u0001)\u0011\u0001D\u0001\u0006\u0001\u0015\t\u0001\"A\u0003\u0001\u000b\u0005a\u0011!\u0002\u0001\u0005\u0007\ba\u0001!G\u0001\u0019\u0002\u0005\u001eA!A)\u0004\u0003!\tQe\u0004\u0003\u0002\u0011\u0013i\u0011\u0001G\u0003\u001a\u0007!-Q\"\u0001\r\u00073\u0019Ai!\u0004\u0003\n\u0005%\t\u0001t\u0002\r\bK!!\u0011\u0001\u0003\u0005\u000e\u0003a)\u0011d\u0001E\t\u001b\u0005A\u0012\"\n\u0005\u0005\u0003!MQ\"\u0001\r\u00063\rA!\"D\u0001\u0019\u0016\u0015BA!\u0001\u0005\f\u001b\u0005AR!G\u0002\t\u00155\t\u0001TC\u0013\u0010\t\u0005A9\"D\u0001\u0019\u000be\u0019\u0001BC\u0007\u00021+Ib\u0001\u0003\u0007\u000e\t%\u0011\u0011\"\u0001\r\n13)C\u0002B\u0001\t\u001b5\t\u0001$B\r\u0004\u00117i\u0011\u0001\u0007\b\u001a\u0007!uQ\"\u0001\r\u0010K-!\u0011\u0001c\b\u000e\u0003a\u0001\u0012D\u0002E\u0011\u001b\u0011I!!C\u0001\u0019#aeQE\u0002\u0003\u0002\u0011Gi\u0011\u0001G\u0003\u0016\u0003ay\u0011&\b\u0003B\u0011!\rQbE\u0005\u0007\u0013\u0015\u00012!\u0006\u0002\r\u0002a\u0015\u0001T\u0001\t\u0004+%Ia!C\u0003\u0011\u0007U\u0011A\u0012\u0001M\u00031\u000ba\t\u0001\u0007\u0002\u0019\u0005E\u001bQ!B\u0001\r\u00025\u0011Aq\u0001\u0005\u0005"}, strings={"Lorg/jetbrains/kotlin/resolve/DeclarationsChecker$Companion;", "", "()V", "METHOD_OF_ANY_NAMES", "Lorg/jetbrains/kotlin/relocated/com/google/common/collect/ImmutableSet;", "", "kotlin.jvm.PlatformType", "getMETHOD_OF_ANY_NAMES", "()Lcom/google/common/collect/ImmutableSet;", "hasConstraints", "", "typeParameter", "Lorg/jetbrains/kotlin/psi/KtTypeParameter;", "constraints", "", "Lorg/jetbrains/kotlin/psi/KtTypeConstraint;", "hasDefaultConstructor", "classDescriptor", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "isHidingParentMemberIfPresent", "member", "Lorg/jetbrains/kotlin/descriptors/CallableMemberDescriptor;", "isImplementingMethodOfAny", "isImplementingMethodOfAnyInternal", "visitedClasses", "", "isTypeParameterUsedInReceiverType", "parameter", "Lorg/jetbrains/kotlin/descriptors/TypeParameterDescriptor;", "descriptor", "Lorg/jetbrains/kotlin/descriptors/PropertyDescriptor;", "removeDuplicateTypes", "", "conflictingTypes", "Lorg/jetbrains/kotlin/types/KotlinType;", "hasAccessorImplementation"}, moduleName="kotlin-compiler")
    public static final class Companion {
        public static final Companion INSTANCE;

        private final void removeDuplicateTypes(Set<KotlinType> conflictingTypes) {
            Iterator<KotlinType> iterator2 = conflictingTypes.iterator();
            block0: while (iterator2.hasNext()) {
                KotlinType type2 = iterator2.next();
                for (KotlinType otherType : conflictingTypes) {
                    boolean subtypeOf = KotlinTypeChecker.DEFAULT.equalTypes(type2, otherType);
                    if (type2 == otherType || !subtypeOf) continue;
                    iterator2.remove();
                    continue block0;
                }
            }
        }

        private final boolean hasConstraints(KtTypeParameter typeParameter, List<? extends KtTypeConstraint> constraints) {
            boolean bl;
            block2: {
                if (typeParameter.getName() == null) {
                    return false;
                }
                Iterable $receiver = constraints;
                for (Object element : $receiver) {
                    KtTypeConstraint it2 = (KtTypeConstraint)element;
                    KtSimpleNameExpression ktSimpleNameExpression = it2.getSubjectTypeParameterName();
                    if (!Intrinsics.areEqual(ktSimpleNameExpression != null ? ktSimpleNameExpression.getText() : null, typeParameter.getName())) continue;
                    bl = true;
                    break block2;
                }
                bl = false;
            }
            return bl;
        }

        private final ImmutableSet<String> getMETHOD_OF_ANY_NAMES() {
            return METHOD_OF_ANY_NAMES;
        }

        private final boolean isImplementingMethodOfAny(CallableMemberDescriptor member) {
            if (!this.getMETHOD_OF_ANY_NAMES().contains(member.getName().asString())) {
                return false;
            }
            if (Intrinsics.areEqual((Object)member.getModality(), (Object)Modality.ABSTRACT)) {
                return false;
            }
            return this.isImplementingMethodOfAnyInternal(member, new HashSet());
        }

        private final boolean isImplementingMethodOfAnyInternal(CallableMemberDescriptor member, Set<ClassDescriptor> visitedClasses) {
            for (CallableMemberDescriptor callableMemberDescriptor : member.getOverriddenDescriptors()) {
                DeclarationDescriptor containingDeclaration = callableMemberDescriptor.getContainingDeclaration();
                if (!(containingDeclaration instanceof ClassDescriptor) || visitedClasses.contains(containingDeclaration)) continue;
                if (Intrinsics.areEqual(DescriptorUtils.getFqName(containingDeclaration), KotlinBuiltIns.FQ_NAMES.any)) {
                    return true;
                }
                CallableMemberDescriptor callableMemberDescriptor2 = callableMemberDescriptor;
                Intrinsics.checkExpressionValueIsNotNull(callableMemberDescriptor2, "overridden");
                if (this.isHidingParentMemberIfPresent(callableMemberDescriptor2)) continue;
                DeclarationDescriptor declarationDescriptor = containingDeclaration;
                Intrinsics.checkExpressionValueIsNotNull(declarationDescriptor, "containingDeclaration");
                visitedClasses.add((ClassDescriptor)declarationDescriptor);
                CallableMemberDescriptor callableMemberDescriptor3 = callableMemberDescriptor;
                Intrinsics.checkExpressionValueIsNotNull(callableMemberDescriptor3, "overridden");
                if (!this.isImplementingMethodOfAnyInternal(callableMemberDescriptor3, visitedClasses)) continue;
                return true;
            }
            return false;
        }

        private final boolean isHidingParentMemberIfPresent(CallableMemberDescriptor member) {
            PsiElement psiElement2 = DescriptorToSourceUtils.descriptorToDeclaration(member);
            if (!(psiElement2 instanceof KtNamedDeclaration)) {
                psiElement2 = null;
            }
            KtNamedDeclaration ktNamedDeclaration = (KtNamedDeclaration)psiElement2;
            if (ktNamedDeclaration == null) {
                return false;
            }
            KtNamedDeclaration declaration = ktNamedDeclaration;
            KtModifierList ktModifierList = declaration.getModifierList();
            if (ktModifierList == null) {
                return true;
            }
            KtModifierList modifierList = ktModifierList;
            return !modifierList.hasModifier(KtTokens.OVERRIDE_KEYWORD);
        }

        private final boolean isTypeParameterUsedInReceiverType(TypeParameterDescriptor parameter, PropertyDescriptor descriptor2) {
            ReceiverParameterDescriptor receiverParameterDescriptor = descriptor2.getExtensionReceiverParameter();
            if (receiverParameterDescriptor == null) {
                return false;
            }
            ReceiverParameterDescriptor receiverParameter = receiverParameterDescriptor;
            return TypeUtils.containsSpecialType(receiverParameter.getType(), new Function1<KotlinType, Boolean>(parameter){
                final /* synthetic */ TypeParameterDescriptor $parameter;

                public final boolean invoke(KotlinType it2) {
                    return Intrinsics.areEqual(this.$parameter, it2.getConstructor().getDeclarationDescriptor());
                }
                {
                    this.$parameter = typeParameterDescriptor;
                    super(1);
                }
            });
        }

        private final boolean hasDefaultConstructor(ClassDescriptor classDescriptor) {
            boolean bl;
            block1: {
                Iterable $receiver = classDescriptor.getConstructors();
                for (Object element : $receiver) {
                    ConstructorDescriptor it2 = (ConstructorDescriptor)element;
                    if (!it2.getValueParameters().isEmpty()) continue;
                    bl = true;
                    break block1;
                }
                bl = false;
            }
            return bl;
        }

        private final boolean hasAccessorImplementation(PropertyDescriptor $receiver) {
            Unit unit;
            Unit unit2;
            PropertyAccessorDescriptor it2;
            PropertyAccessorDescriptor $receiver2;
            PropertyGetterDescriptor propertyGetterDescriptor = $receiver.getGetter();
            if (propertyGetterDescriptor != null) {
                $receiver2 = propertyGetterDescriptor;
                it2 = $receiver2;
                if (it2.hasBody()) {
                    return true;
                }
                unit2 = Unit.INSTANCE;
            } else {
                unit2 = null;
            }
            PropertySetterDescriptor propertySetterDescriptor = $receiver.getSetter();
            if (propertySetterDescriptor != null) {
                $receiver2 = propertySetterDescriptor;
                it2 = (PropertySetterDescriptor)$receiver2;
                if (it2.hasBody()) {
                    return true;
                }
                unit = Unit.INSTANCE;
            } else {
                unit = null;
            }
            return false;
        }

        static {
            new Companion();
        }

        private Companion() {
            INSTANCE = this;
        }
    }
}

