/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.renderer;

import java.util.List;
import kotlin.CharIterator;
import kotlin.CharsKt;
import kotlin.StringsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinFileFacade;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.PackageFragmentDescriptor;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.FqNameUnsafe;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.renderer.KeywordStringsGenerated;

@KotlinFileFacade(version={1, 0, 0}, abiVersion=32, data={"1\u0015\u0001Q!\u0001\u0005\b\u000b\u0001)\u0011\u0001D\u0001\u0006\u0003\u0011\tQ!\u0001\u0007\u0002\u000b\u0005!\u0011!B\u0001\t!\u0015\tA\"A\u0003\u0001\u000b\u0005a\u0011!B\u0001\r\u0003\u0015\u0001Q!\u0001E\u0006\u001b#A\u0001!D\u0001\u0019\u0002e\u0019\u0001\"A\u0007\u00021\u0007!6AAG\u000b\t\u0005A)!\u0004\u0002\r\u0002a\u0005\u0011d\u0001\u0005\u0002\u001b\u0005A2\u0001V\u0002\u0003\u001b/A9!D\u0001\u0019\u0002e1\u0001\u0002B\u0007\u0005\u0013\tI\u0011\u0001G\u0003\u0019\nQ\u001b!!$\u0004\t\f5\t\u0001\u0014A\u000b\u00021\u0019!6AAG\u0007\u0011\u0017i\u0011\u0001'\u0001\u0016\u0003a5Ak\u0001\u0002\u000e\u000e!-Q\"\u0001M\u0001+\u0005AR\u0001V\u0002\u0003\u001b\u001f!\u0011\u0001C\u0004\u000e\u0003a=Q#\u0001\r\u0006)\u000e\u0011\u0001"}, strings={"qualifiedNameForSourceCode", "", "descriptor", "Lorg/jetbrains/kotlin/descriptors/ClassifierDescriptor;", "RenderingUtilsKt", "qualifierName", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "renderFqName", "pathSegments", "", "Lorg/jetbrains/kotlin/name/Name;", "render", "Lorg/jetbrains/kotlin/name/FqName;", "Lorg/jetbrains/kotlin/name/FqNameUnsafe;", "shouldBeEscaped", ""}, moduleName="kotlin-compiler")
public final class RenderingUtilsKt {
    @NotNull
    public static final String qualifiedNameForSourceCode(@NotNull ClassifierDescriptor descriptor2) {
        Intrinsics.checkParameterIsNotNull(descriptor2, "descriptor");
        String nameString = RenderingUtilsKt.render(descriptor2.getName());
        if (descriptor2 instanceof TypeParameterDescriptor) {
            return nameString;
        }
        DeclarationDescriptor declarationDescriptor = descriptor2.getContainingDeclaration();
        Intrinsics.checkExpressionValueIsNotNull(declarationDescriptor, "descriptor.getContainingDeclaration()");
        String qualifier2 = RenderingUtilsKt.qualifierName(declarationDescriptor);
        return qualifier2 != null && Intrinsics.areEqual(qualifier2, "") ^ true ? qualifier2 + "." + nameString : nameString;
    }

    private static final String qualifierName(DeclarationDescriptor descriptor2) {
        DeclarationDescriptor declarationDescriptor = descriptor2;
        return declarationDescriptor instanceof ClassDescriptor ? RenderingUtilsKt.qualifiedNameForSourceCode((ClassifierDescriptor)descriptor2) : (declarationDescriptor instanceof PackageFragmentDescriptor ? RenderingUtilsKt.render(((PackageFragmentDescriptor)descriptor2).getFqName().toUnsafe()) : (String)null);
    }

    @NotNull
    public static final String render(Name $receiver) {
        String string;
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        if (RenderingUtilsKt.shouldBeEscaped($receiver)) {
            StringBuilder stringBuilder = new StringBuilder();
            String string2 = $receiver.asString();
            Intrinsics.checkExpressionValueIsNotNull(string2, "asString()");
            string = stringBuilder.append(CharsKt.plus('`', string2)).append('`').toString();
        } else {
            String string3 = $receiver.asString();
            string = string3;
            Intrinsics.checkExpressionValueIsNotNull(string3, "asString()");
        }
        return string;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean shouldBeEscaped(Name $receiver) {
        boolean bl;
        if ($receiver.isSpecial()) {
            return false;
        }
        String string = $receiver.asString();
        if (KeywordStringsGenerated.KEYWORDS.contains(string)) return true;
        CharSequence $receiver2 = string;
        CharIterator charIterator = StringsKt.iterator($receiver2);
        do {
            if (!charIterator.hasNext()) return false;
            char element = charIterator.nextChar();
            char it2 = element;
            if (!Character.isLetterOrDigit(it2) && it2 != '_') {
                return true;
            }
            bl = false;
        } while (!bl);
        return true;
    }

    @NotNull
    public static final String render(FqNameUnsafe $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        List<Name> list = $receiver.pathSegments();
        Intrinsics.checkExpressionValueIsNotNull(list, "pathSegments()");
        return RenderingUtilsKt.renderFqName(list);
    }

    @NotNull
    public static final String render(FqName $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        List<Name> list = $receiver.pathSegments();
        Intrinsics.checkExpressionValueIsNotNull(list, "pathSegments()");
        return RenderingUtilsKt.renderFqName(list);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final String renderFqName(@NotNull List<? extends Name> pathSegments) {
        void var1_1;
        Intrinsics.checkParameterIsNotNull(pathSegments, "pathSegments");
        StringBuilder $receiver = new StringBuilder();
        StringBuilder $receiver2 = $receiver;
        for (Name name : pathSegments) {
            if ($receiver2.length() > 0) {
                $receiver2.append(".");
            }
            $receiver2.append(RenderingUtilsKt.render(name));
        }
        String string = ((StringBuilder)var1_1).toString();
        Intrinsics.checkExpressionValueIsNotNull(string, "StringBuilder().apply(builderAction).toString()");
        return string;
    }
}

