/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.load.kotlin;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import kotlin.SetsKt;
import kotlin.jvm.functions.Function0;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.PackageFragmentDescriptor;
import org.jetbrains.kotlin.load.kotlin.DeserializationComponentsForJava;
import org.jetbrains.kotlin.load.kotlin.KotlinJvmBinaryClass;
import org.jetbrains.kotlin.load.kotlin.KotlinJvmBinarySourceElement;
import org.jetbrains.kotlin.load.kotlin.header.KotlinClassHeader;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.relocated.javax.inject.Inject;
import org.jetbrains.kotlin.resolve.scopes.ChainedScope;
import org.jetbrains.kotlin.resolve.scopes.MemberScope;
import org.jetbrains.kotlin.serialization.ClassData;
import org.jetbrains.kotlin.serialization.ClassDataWithSource;
import org.jetbrains.kotlin.serialization.PackageData;
import org.jetbrains.kotlin.serialization.deserialization.DeserializationComponents;
import org.jetbrains.kotlin.serialization.deserialization.ErrorReporter;
import org.jetbrains.kotlin.serialization.deserialization.descriptors.DeserializedPackageMemberScope;
import org.jetbrains.kotlin.serialization.jvm.JvmProtoBufUtil;

public final class DeserializedDescriptorResolver {
    private final ErrorReporter errorReporter;
    private DeserializationComponents components;
    public static final Set<KotlinClassHeader.Kind> KOTLIN_CLASS = SetsKt.setOf(KotlinClassHeader.Kind.CLASS);
    public static final Set<KotlinClassHeader.Kind> KOTLIN_FILE_FACADE_OR_MULTIFILE_CLASS_PART = SetsKt.setOf(KotlinClassHeader.Kind.FILE_FACADE, KotlinClassHeader.Kind.MULTIFILE_CLASS_PART);

    public DeserializedDescriptorResolver(@NotNull ErrorReporter errorReporter) {
        if (errorReporter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "errorReporter", "org/jetbrains/kotlin/load/kotlin/DeserializedDescriptorResolver", "<init>"));
        }
        this.errorReporter = errorReporter;
    }

    @Inject
    public void setComponents(@NotNull DeserializationComponentsForJava context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/load/kotlin/DeserializedDescriptorResolver", "setComponents"));
        }
        this.components = context.getComponents();
    }

    @Nullable
    public ClassDescriptor resolveClass(@NotNull KotlinJvmBinaryClass kotlinClass) {
        if (kotlinClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kotlinClass", "org/jetbrains/kotlin/load/kotlin/DeserializedDescriptorResolver", "resolveClass"));
        }
        String[] data = this.readData(kotlinClass, KOTLIN_CLASS);
        if (data != null) {
            String[] strings = kotlinClass.getClassHeader().getStrings();
            assert (strings != null) : "String table not found in " + kotlinClass;
            ClassData classData = JvmProtoBufUtil.readClassDataFrom(data, strings);
            KotlinJvmBinarySourceElement sourceElement = new KotlinJvmBinarySourceElement(kotlinClass);
            return this.components.getClassDeserializer().deserializeClass(kotlinClass.getClassId(), new ClassDataWithSource(classData, sourceElement));
        }
        return null;
    }

    @Nullable
    public MemberScope createKotlinPackagePartScope(@NotNull PackageFragmentDescriptor descriptor2, @NotNull KotlinJvmBinaryClass kotlinClass) {
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/load/kotlin/DeserializedDescriptorResolver", "createKotlinPackagePartScope"));
        }
        if (kotlinClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kotlinClass", "org/jetbrains/kotlin/load/kotlin/DeserializedDescriptorResolver", "createKotlinPackagePartScope"));
        }
        String[] data = this.readData(kotlinClass, KOTLIN_FILE_FACADE_OR_MULTIFILE_CLASS_PART);
        if (data != null) {
            String[] strings = kotlinClass.getClassHeader().getStrings();
            assert (strings != null) : "String table not found in " + kotlinClass;
            PackageData packageData = JvmProtoBufUtil.readPackageDataFrom(data, strings);
            return new DeserializedPackageMemberScope(descriptor2, packageData.getPackageProto(), packageData.getNameResolver(), this.components, (Function0<? extends Collection<? extends Name>>)new Function0<Collection<Name>>(){

                @Override
                public Collection<Name> invoke() {
                    return Collections.emptyList();
                }
            });
        }
        return null;
    }

    @NotNull
    public MemberScope createKotlinPackageScope(@NotNull PackageFragmentDescriptor descriptor2, @NotNull List<KotlinJvmBinaryClass> packageParts) {
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/load/kotlin/DeserializedDescriptorResolver", "createKotlinPackageScope"));
        }
        if (packageParts == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packageParts", "org/jetbrains/kotlin/load/kotlin/DeserializedDescriptorResolver", "createKotlinPackageScope"));
        }
        ArrayList<MemberScope> list = new ArrayList<MemberScope>(packageParts.size());
        for (KotlinJvmBinaryClass callable : packageParts) {
            MemberScope scope2 = this.createKotlinPackagePartScope(descriptor2, callable);
            if (scope2 == null) continue;
            list.add(scope2);
        }
        if (list.isEmpty()) {
            MemberScope.Empty empty2 = MemberScope.Empty.INSTANCE;
            if (empty2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/load/kotlin/DeserializedDescriptorResolver", "createKotlinPackageScope"));
            }
            return empty2;
        }
        ChainedScope chainedScope = new ChainedScope("Member scope for union of package parts data", list.toArray(new MemberScope[list.size()]));
        if (chainedScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/load/kotlin/DeserializedDescriptorResolver", "createKotlinPackageScope"));
        }
        return chainedScope;
    }

    @Nullable
    public String[] readData(@NotNull KotlinJvmBinaryClass kotlinClass, @NotNull Set<KotlinClassHeader.Kind> expectedKinds) {
        if (kotlinClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kotlinClass", "org/jetbrains/kotlin/load/kotlin/DeserializedDescriptorResolver", "readData"));
        }
        if (expectedKinds == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expectedKinds", "org/jetbrains/kotlin/load/kotlin/DeserializedDescriptorResolver", "readData"));
        }
        KotlinClassHeader header = kotlinClass.getClassHeader();
        if (!header.isCompatibleAbiVersion()) {
            this.errorReporter.reportIncompatibleAbiVersion(kotlinClass.getClassId(), kotlinClass.getLocation(), header.getVersion());
        } else if (expectedKinds.contains((Object)header.getKind())) {
            return header.getAnnotationData();
        }
        return null;
    }
}

