/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.translate.utils;

import kotlin.PreconditionsKt;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinFileFacade;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.js.inline.util.InvocationUtilsKt;
import org.jetbrains.kotlin.js.translate.context.TranslationContext;
import org.jetbrains.kotlin.js.translate.reference.CallExpressionTranslator;
import org.jetbrains.kotlin.js.translate.utils.PsiUtils;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.relocated.com.google.dart.compiler.backend.js.ast.JsExpression;
import org.jetbrains.kotlin.relocated.com.google.dart.compiler.backend.js.ast.JsInvocation;
import org.jetbrains.kotlin.relocated.com.google.dart.compiler.backend.js.ast.JsName;
import org.jetbrains.kotlin.relocated.com.google.dart.compiler.backend.js.ast.JsNameRef;
import org.jetbrains.kotlin.relocated.com.google.dart.compiler.backend.js.ast.JsNode;
import org.jetbrains.kotlin.relocated.com.google.dart.compiler.backend.js.ast.RecursiveJsVisitor;
import org.jetbrains.kotlin.relocated.com.google.dart.compiler.backend.js.ast.metadata.MetadataProperties;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.inline.InlineStrategy;

@KotlinFileFacade(version={1, 0, 0}, abiVersion=32, data={"/\u0015\u0001Q!\u0001\u0007\u0002\u000b\u0005a\u0011!B\u0001\u0005\u0005\u0015\t\u0001\"A\u0003\u0002\t\u0005)\u0011\u0001D\u0001\u0006\u0001\u0015\tA\"A\u0003\u0001\u000b\u0005a\u0011!B\u0001\u0005\u0003\u0015\tA\"AG\u0017\u0011\ri\u0011\u0001g\u0002\u001a\u0007!!Q\"\u0001\r\u00023\rAI!D\u0001\u0019\u000be)\u00012B\u0007\u0004\u0013\u0005!\u0019\u0001\u0007\u0004\u001a\u0007!5Q\"\u0001\r\b)\u000e\u0015Q\u0002\u0004E\b\u001b\u0005A\n!F\u0001\u0019\u000fe%\u0001\u0002C\u0007\u00021#\u00016\u0011\u0001+\u0004\u0006E}Aa\u0011\u0005\t\u00015\u0011A\u0012\u0001M\u0001+\ta\t\u0001G\u0001\u001dGE\u001b1!\u0004\u0002\u0005\u0004!\u0011Ak!\u0002"}, strings={"name", "Lorg/jetbrains/kotlin/relocated/com/google/dart/compiler/backend/js/ast/JsName;", "Lorg/jetbrains/kotlin/relocated/com/google/dart/compiler/backend/js/ast/JsExpression;", "getName", "(Lcom/google/dart/compiler/backend/js/ast/JsExpression;)Lcom/google/dart/compiler/backend/js/ast/JsName;", "InlineUtils", "setInlineCallMetadata", "", "expression", "psiElement", "Lorg/jetbrains/kotlin/psi/KtExpression;", "resolvedCall", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "context", "Lorg/jetbrains/kotlin/js/translate/context/TranslationContext;", "aliasedName", "descriptor", "Lorg/jetbrains/kotlin/descriptors/CallableDescriptor;"}, moduleName="kotlin-compiler")
@JvmName(name="InlineUtils")
public final class InlineUtils {
    /*
     * WARNING - void declaration
     */
    public static final void setInlineCallMetadata(@NotNull JsExpression expression, @NotNull KtExpression psiElement2, @NotNull ResolvedCall<?> resolvedCall, @NotNull TranslationContext context) {
        Unit unit;
        Intrinsics.checkParameterIsNotNull(expression, "expression");
        Intrinsics.checkParameterIsNotNull(psiElement2, "psiElement");
        Intrinsics.checkParameterIsNotNull(resolvedCall, "resolvedCall");
        Intrinsics.checkParameterIsNotNull(context, "context");
        CallableDescriptor descriptor2 = PsiUtils.getFunctionDescriptor(resolvedCall);
        boolean bl = CallExpressionTranslator.shouldBeInlined(descriptor2);
        if (PreconditionsKt.getASSERTIONS_ENABLED()) {
            void value;
            if (value == false) {
                String message = "Expected descriptor of callable, that should be inlined, but got: " + descriptor2;
                throw (Throwable)((Object)new AssertionError((Object)message));
            }
            unit = Unit.INSTANCE;
        } else {
            unit = Unit.INSTANCE;
        }
        CallableDescriptor callableDescriptor = descriptor2;
        Intrinsics.checkExpressionValueIsNotNull(callableDescriptor, "descriptor");
        JsName name = InlineUtils.aliasedName(context, callableDescriptor);
        RecursiveJsVisitor visitor2 = new RecursiveJsVisitor(name, descriptor2, psiElement2){
            final /* synthetic */ JsName $name;
            final /* synthetic */ CallableDescriptor $descriptor;
            final /* synthetic */ KtExpression $psiElement;

            public void visitInvocation(@NotNull JsInvocation invocation) {
                Intrinsics.checkParameterIsNotNull(invocation, "invocation");
                super.visitInvocation(invocation);
                if (Intrinsics.areEqual(this.$name, InlineUtils.getName(invocation))) {
                    MetadataProperties.setDescriptor(invocation, this.$descriptor);
                    MetadataProperties.setInlineStrategy(invocation, InlineStrategy.IN_PLACE);
                    MetadataProperties.setPsiElement(invocation, this.$psiElement);
                }
            }
            {
                this.$name = $captured_local_variable$0;
                this.$descriptor = $captured_local_variable$1;
                this.$psiElement = $captured_local_variable$2;
            }
        };
        visitor2.accept((JsNode)expression);
    }

    @NotNull
    public static final JsName aliasedName(TranslationContext $receiver, @NotNull CallableDescriptor descriptor2) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(descriptor2, "descriptor");
        JsExpression alias = $receiver.getAliasForDescriptor(descriptor2);
        JsExpression jsExpression = alias;
        if (!(jsExpression instanceof JsNameRef)) {
            jsExpression = null;
        }
        JsNameRef jsNameRef = (JsNameRef)jsExpression;
        JsName aliasName = jsNameRef != null ? jsNameRef.getName() : null;
        JsName jsName = aliasName;
        if (jsName == null) {
            JsName jsName2 = $receiver.getNameForDescriptor(descriptor2);
            jsName = jsName2;
            Intrinsics.checkExpressionValueIsNotNull(jsName2, "getNameForDescriptor(descriptor)");
        }
        return jsName;
    }

    @Nullable
    public static final JsName getName(JsExpression $receiver) {
        JsName jsName;
        JsExpression jsExpression = $receiver;
        if (jsExpression instanceof JsInvocation) {
            JsExpression qualifier2 = ((JsInvocation)$receiver).getQualifier();
            if (InvocationUtilsKt.isCallInvocation((JsInvocation)$receiver)) {
                JsExpression jsExpression2 = qualifier2;
                if (jsExpression2 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type com.google.dart.compiler.backend.js.ast.JsNameRef");
                }
                jsName = InlineUtils.getName(((JsNameRef)jsExpression2).getQualifier());
            } else {
                jsName = InlineUtils.getName(qualifier2);
            }
        } else {
            jsName = jsExpression instanceof JsNameRef ? ((JsNameRef)$receiver).getName() : (JsName)null;
        }
        return jsName;
    }
}

