/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen.optimization.fixStack;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kotlin.CollectionsKt;
import kotlin.MapsKt;
import kotlin.Pair;
import kotlin.PreconditionsKt;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.codegen.optimization.fixStack.FixStackContext;
import org.jetbrains.kotlin.codegen.optimization.fixStack.SavedStackDescriptor;
import org.jetbrains.org.objectweb.asm.tree.AbstractInsnNode;
import org.jetbrains.org.objectweb.asm.tree.MethodNode;
import org.jetbrains.org.objectweb.asm.tree.analysis.BasicValue;

@KotlinClass(version={1, 0, 0}, abiVersion=32, data={"M\u0015\tA\"A\u0003\u0002\u0011\u0001)\u0001!B\u0001\r\u0003\u0015\u0001Q!\u0001\u0007\u0002\u000b\u0005!\u0011!B\u0001\r\u0003\u0015\tA\"A\u0003\u0002\u0019\u0005)\u0011\u0001b\u0001\u0006\u0003!!Q!\u0001C\u0002\u000b\u0005a\u0011!B\u0001\u0005\u0004\u0015\t\u0001\u0002E\u0003\u0002\u0019\u0005)\u0011\u0001b\u0003\u0006\u0003!\tQ!\u0001C\u0003\t\u0001a\u0001!G\u0001\u0019\u0002u\u0005A#)\u0006\n\u0007!\tQ\"\u0001M\u0002\u0013\rA!!D\u0001\u0019\u0006E\u001b\u0011\u0001C\u0002&'\u0011\t\u0001\u0012C\u0007\u00021%I2\u0001c\u0005\u000e\u0003a9\u0011d\u0001\u0005\u000b\u001b\u0005AJ!\u0007\u0004\t\u00165!\u0011BA\u0005\u00021/A2\"\n\b\t\u00195\t\u0001$C\r\u0004\u00113i\u0011\u0001'\u0003\u001a\r!UQ\u0002B\u0005\u0003\u0013\u0005A:\u0002G\u0006&\u001d!iQ\"\u0001\r\n3\rA!\"D\u0001\u0019\ne1\u0001RC\u0007\u0005\u0013\tI\u0011\u0001g\u0006\u0019\u0017\u0015:\u00012D\u0007\u00021\u001dI2\u0001\u0003\b\u000e\u0003a]Qe\u0002E\u000f\u001b\u0005A\u0012\"G\u0002\t\u001f5\t\u0001\u0014B\u0013\u0005\t\u0005Ay\"D\u0001\u0019\u000f\u0015:\u0001\u0002E\u0007\u00021%I2\u0001#\t\u000e\u0003a%Qe\u0002\u0005\u0012\u001b\u0005A\u001a#G\u0002\t\u001f5\t\u0001\u0014B\u0013\t\t\u0005A!#D\u0001\u0019$e\u0019\u0001BC\u0007\u00021\u0013)s\u0001#\n\u000e\u0003a\r\u0012d\u0001E\u0011\u001b\u0005AJ!\n\u0005\u0005\u0003!\u0019R\"\u0001M\u00123\rA9#D\u0001\u0019\u000f%jA!\u0011\u0005\t\b59\u0011BA\u0005\u00021\u0013I!!C\u0001\u0019\u000ba!\u0011kA\u0001\u0006\u0001%RAa\u0011\u0005\t\u00035\t\u00014A)\u0004\t\u0015\u0001QB\u0001C\u0006\u0011\u0019Is\u0001B!\t\u0011\u001bi\u0011\u0001G\u0004R\u0007\u0005)\u0001!\u000b\u0006\u0005\u0007\"A!!D\u0001\u0019\u0006E\u001bA!\u0002\u0001\u000e\u0005\u0011=\u0001\u0002\u0003"}, strings={"Lorg/jetbrains/kotlin/codegen/optimization/fixStack/LocalVariablesManager;", "", "context", "Lorg/jetbrains/kotlin/codegen/optimization/fixStack/FixStackContext;", "methodNode", "Lorg/jetbrains/org/objectweb/asm/tree/MethodNode;", "(Lorg/jetbrains/kotlin/codegen/optimization/fixStack/FixStackContext;Lorg/jetbrains/org/objectweb/asm/tree/MethodNode;)V", "allocatedHandles", "Ljava/util/HashMap;", "Lorg/jetbrains/org/objectweb/asm/tree/AbstractInsnNode;", "Lorg/jetbrains/kotlin/codegen/optimization/fixStack/LocalVariablesManager$AllocatedHandle;", "getContext", "()Lorg/jetbrains/kotlin/codegen/optimization/fixStack/FixStackContext;", "initialMaxLocals", "", "getMethodNode", "()Lorg/jetbrains/org/objectweb/asm/tree/MethodNode;", "allocateNewHandle", "Lorg/jetbrains/kotlin/codegen/optimization/fixStack/SavedStackDescriptor;", "numRestoreStackMarkers", "saveStackMarker", "savedStackValues", "", "Lorg/jetbrains/org/objectweb/asm/tree/analysis/BasicValue;", "allocateVariablesForBeforeInlineMarker", "beforeInlineMarker", "allocateVariablesForSaveStackMarker", "createReturnValueVariable", "returnValue", "getBeforeInlineDescriptor", "afterInlineMarker", "getFirstUnusedLocalVariableIndex", "getSavedStackDescriptor", "restoreStackMarker", "markAfterInlineMarkerEmitted", "", "markEmitted", "markRestoreStackMarkerEmitted", "updateMaxLocals", "newValue", "AllocatedHandle"}, moduleName="kotlin-compiler")
public final class LocalVariablesManager {
    private final int initialMaxLocals;
    private final HashMap<AbstractInsnNode, AllocatedHandle> allocatedHandles;
    @NotNull
    private final FixStackContext context;
    @NotNull
    private final MethodNode methodNode;

    private final void updateMaxLocals(int newValue) {
        this.methodNode.maxLocals = Math.max(this.methodNode.maxLocals, newValue);
    }

    @NotNull
    public final SavedStackDescriptor allocateVariablesForSaveStackMarker(@NotNull AbstractInsnNode saveStackMarker, @NotNull List<? extends BasicValue> savedStackValues) {
        Intrinsics.checkParameterIsNotNull(saveStackMarker, "saveStackMarker");
        Intrinsics.checkParameterIsNotNull(savedStackValues, "savedStackValues");
        List<AbstractInsnNode> list = this.context.getRestoreStackMarkersForSaveMarker().get(saveStackMarker);
        if (list == null) {
            Intrinsics.throwNpe();
        }
        Collection $receiver = list;
        int numRestoreStackMarkers = $receiver.size();
        return this.allocateNewHandle(numRestoreStackMarkers, saveStackMarker, savedStackValues);
    }

    private final SavedStackDescriptor allocateNewHandle(int numRestoreStackMarkers, AbstractInsnNode saveStackMarker, List<? extends BasicValue> savedStackValues) {
        int firstUnusedLocalVarIndex = this.getFirstUnusedLocalVariableIndex();
        SavedStackDescriptor savedStackDescriptor = new SavedStackDescriptor(savedStackValues, firstUnusedLocalVarIndex);
        this.updateMaxLocals(savedStackDescriptor.getFirstUnusedLocalVarIndex());
        AllocatedHandle allocatedHandle = new AllocatedHandle(savedStackDescriptor, numRestoreStackMarkers);
        MapsKt.set(this.allocatedHandles, saveStackMarker, allocatedHandle);
        return savedStackDescriptor;
    }

    @NotNull
    public final SavedStackDescriptor getSavedStackDescriptor(@NotNull AbstractInsnNode restoreStackMarker) {
        Intrinsics.checkParameterIsNotNull(restoreStackMarker, "restoreStackMarker");
        AbstractInsnNode saveStackMarker = this.context.getSaveStackMarkerForRestoreMarker().get(restoreStackMarker);
        Object v = MapsKt.get((Map)this.allocatedHandles, saveStackMarker);
        if (v == null) {
            Intrinsics.throwNpe();
        }
        return ((AllocatedHandle)v).getSavedStackDescriptor();
    }

    /*
     * WARNING - void declaration
     */
    private final int getFirstUnusedLocalVariableIndex() {
        void var3_3;
        void $receiver;
        Iterable iterable = CollectionsKt.mutableValues(this.allocatedHandles);
        int initial = this.initialMaxLocals;
        int accumulator = initial;
        for (Object element : $receiver) {
            void handle;
            AllocatedHandle allocatedHandle = (AllocatedHandle)element;
            int index2 = accumulator;
            accumulator = Math.max(index2, handle.getSavedStackDescriptor().getFirstUnusedLocalVarIndex());
        }
        return (int)var3_3;
    }

    public final void markRestoreStackMarkerEmitted(@NotNull AbstractInsnNode restoreStackMarker) {
        AbstractInsnNode saveStackMarker;
        Intrinsics.checkParameterIsNotNull(restoreStackMarker, "restoreStackMarker");
        AbstractInsnNode abstractInsnNode = saveStackMarker = this.context.getSaveStackMarkerForRestoreMarker().get(restoreStackMarker);
        if (abstractInsnNode == null) {
            Intrinsics.throwNpe();
        }
        Intrinsics.checkExpressionValueIsNotNull(abstractInsnNode, "saveStackMarker!!");
        this.markEmitted(abstractInsnNode);
    }

    @NotNull
    public final SavedStackDescriptor allocateVariablesForBeforeInlineMarker(@NotNull AbstractInsnNode beforeInlineMarker, @NotNull List<? extends BasicValue> savedStackValues) {
        Intrinsics.checkParameterIsNotNull(beforeInlineMarker, "beforeInlineMarker");
        Intrinsics.checkParameterIsNotNull(savedStackValues, "savedStackValues");
        return this.allocateNewHandle(1, beforeInlineMarker, savedStackValues);
    }

    @NotNull
    public final SavedStackDescriptor getBeforeInlineDescriptor(@NotNull AbstractInsnNode afterInlineMarker) {
        Intrinsics.checkParameterIsNotNull(afterInlineMarker, "afterInlineMarker");
        AbstractInsnNode beforeInlineMarker = this.context.getOpeningInlineMethodMarker().get(afterInlineMarker);
        Object v = MapsKt.get((Map)this.allocatedHandles, beforeInlineMarker);
        if (v == null) {
            Intrinsics.throwNpe();
        }
        return ((AllocatedHandle)v).getSavedStackDescriptor();
    }

    public final void markAfterInlineMarkerEmitted(@NotNull AbstractInsnNode afterInlineMarker) {
        AbstractInsnNode beforeInlineMarker;
        Intrinsics.checkParameterIsNotNull(afterInlineMarker, "afterInlineMarker");
        AbstractInsnNode abstractInsnNode = beforeInlineMarker = this.context.getOpeningInlineMethodMarker().get(afterInlineMarker);
        if (abstractInsnNode == null) {
            Intrinsics.throwNpe();
        }
        Intrinsics.checkExpressionValueIsNotNull(abstractInsnNode, "beforeInlineMarker!!");
        this.markEmitted(abstractInsnNode);
    }

    private final void markEmitted(AbstractInsnNode saveStackMarker) {
        AllocatedHandle allocatedHandle = this.allocatedHandles.get(saveStackMarker);
        if (allocatedHandle == null) {
            Intrinsics.throwNpe();
        }
        AllocatedHandle allocatedHandle2 = allocatedHandle;
        allocatedHandle2.markRestoreNodeEmitted();
        if (allocatedHandle2.isFullyEmitted()) {
            this.allocatedHandles.remove(saveStackMarker);
        }
    }

    public final int createReturnValueVariable(@NotNull BasicValue returnValue) {
        Intrinsics.checkParameterIsNotNull(returnValue, "returnValue");
        int returnValueIndex = this.getFirstUnusedLocalVariableIndex();
        this.updateMaxLocals(returnValueIndex + returnValue.getSize());
        return returnValueIndex;
    }

    @NotNull
    public final FixStackContext getContext() {
        return this.context;
    }

    @NotNull
    public final MethodNode getMethodNode() {
        return this.methodNode;
    }

    public LocalVariablesManager(@NotNull FixStackContext context, @NotNull MethodNode methodNode) {
        Intrinsics.checkParameterIsNotNull(context, "context");
        Intrinsics.checkParameterIsNotNull(methodNode, "methodNode");
        this.context = context;
        this.methodNode = methodNode;
        this.initialMaxLocals = this.methodNode.maxLocals;
        this.allocatedHandles = MapsKt.hashMapOf(new Pair[0]);
    }

    @KotlinClass(version={1, 0, 0}, abiVersion=32, data={"#\u0015\tA\"A\u0003\u0002\u0011\u0001)\u0001!B\u0001\r\u0003\u0015\u0001Q!\u0001\u0005\u0005\u000b\u0005!A!B\u0001\t\f\u0015\u0001Q!\u0001\u0005\u0002\t\u0005a\u0001!G\u0001\u0019\u0002\u0005V\u0011b\u0001\u0005\u0002\u001b\u0005A\u001a!C\u0002\t\u00055\t\u0001TA)\u0004\u0003!\u0019Qe\u0001E\u0007\u001b\u0005Ar!J\u0002\t\u00105\t\u0001\u0004C\u0015\u000e\t\rc\u0002BA\u0007\u00021\u000b\t6aB\u0003\u0001\u001b\t!9\u0001\u0003\u0003\u0012\u0005\u0011%\u0001\"B\u0015\u000b\t\rC\u0001\"A\u0007\u00021\u0007\t6\u0001B\u0003\u0001\u001b\t!Y\u0001\u0003\u0004"}, strings={"Lorg/jetbrains/kotlin/codegen/optimization/fixStack/LocalVariablesManager$AllocatedHandle;", "", "savedStackDescriptor", "Lorg/jetbrains/kotlin/codegen/optimization/fixStack/SavedStackDescriptor;", "numRestoreMarkers", "", "(Lorg/jetbrains/kotlin/codegen/optimization/fixStack/SavedStackDescriptor;I)V", "getNumRestoreMarkers", "()I", "setNumRestoreMarkers", "(I)V", "getSavedStackDescriptor", "()Lorg/jetbrains/kotlin/codegen/optimization/fixStack/SavedStackDescriptor;", "isFullyEmitted", "", "markRestoreNodeEmitted", ""}, moduleName="kotlin-compiler")
    private static final class AllocatedHandle {
        @NotNull
        private final SavedStackDescriptor savedStackDescriptor;
        private int numRestoreMarkers;

        public final boolean isFullyEmitted() {
            return this.numRestoreMarkers == 0;
        }

        public final void markRestoreNodeEmitted() {
            Unit unit;
            boolean value = this.numRestoreMarkers > 0;
            if (PreconditionsKt.getASSERTIONS_ENABLED()) {
                if (!value) {
                    String message = "Emitted more restore markers than expected for " + this.getSavedStackDescriptor();
                    throw (Throwable)((Object)new AssertionError((Object)message));
                }
                unit = Unit.INSTANCE;
            } else {
                unit = Unit.INSTANCE;
            }
            this.numRestoreMarkers = this.numRestoreMarkers + -1;
        }

        @NotNull
        public final SavedStackDescriptor getSavedStackDescriptor() {
            return this.savedStackDescriptor;
        }

        public final int getNumRestoreMarkers() {
            return this.numRestoreMarkers;
        }

        public final void setNumRestoreMarkers(int n) {
            this.numRestoreMarkers = n;
        }

        public AllocatedHandle(@NotNull SavedStackDescriptor savedStackDescriptor, int numRestoreMarkers) {
            Intrinsics.checkParameterIsNotNull(savedStackDescriptor, "savedStackDescriptor");
            this.savedStackDescriptor = savedStackDescriptor;
            this.numRestoreMarkers = numRestoreMarkers;
        }
    }
}

