/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.cfg.pseudocode;

import com.intellij.util.containers.Stack;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.cfg.BlockInfo;
import org.jetbrains.kotlin.cfg.BreakableBlockInfo;
import org.jetbrains.kotlin.cfg.GenerationTrigger;
import org.jetbrains.kotlin.cfg.JetControlFlowBuilder;
import org.jetbrains.kotlin.cfg.JetControlFlowBuilderAdapter;
import org.jetbrains.kotlin.cfg.Label;
import org.jetbrains.kotlin.cfg.LoopInfo;
import org.jetbrains.kotlin.cfg.pseudocode.PseudoValue;
import org.jetbrains.kotlin.cfg.pseudocode.PseudoValueFactory;
import org.jetbrains.kotlin.cfg.pseudocode.PseudoValueFactoryImpl;
import org.jetbrains.kotlin.cfg.pseudocode.Pseudocode;
import org.jetbrains.kotlin.cfg.pseudocode.PseudocodeImpl;
import org.jetbrains.kotlin.cfg.pseudocode.instructions.Instruction;
import org.jetbrains.kotlin.cfg.pseudocode.instructions.LexicalScope;
import org.jetbrains.kotlin.cfg.pseudocode.instructions.eval.AccessTarget;
import org.jetbrains.kotlin.cfg.pseudocode.instructions.eval.CallInstruction;
import org.jetbrains.kotlin.cfg.pseudocode.instructions.eval.InstructionWithValue;
import org.jetbrains.kotlin.cfg.pseudocode.instructions.eval.LoadUnitValueInstruction;
import org.jetbrains.kotlin.cfg.pseudocode.instructions.eval.MagicInstruction;
import org.jetbrains.kotlin.cfg.pseudocode.instructions.eval.MagicKind;
import org.jetbrains.kotlin.cfg.pseudocode.instructions.eval.MergeInstruction;
import org.jetbrains.kotlin.cfg.pseudocode.instructions.eval.OperationInstruction;
import org.jetbrains.kotlin.cfg.pseudocode.instructions.eval.ReadValueInstruction;
import org.jetbrains.kotlin.cfg.pseudocode.instructions.eval.WriteValueInstruction;
import org.jetbrains.kotlin.cfg.pseudocode.instructions.jumps.ConditionalJumpInstruction;
import org.jetbrains.kotlin.cfg.pseudocode.instructions.jumps.NondeterministicJumpInstruction;
import org.jetbrains.kotlin.cfg.pseudocode.instructions.jumps.ReturnNoValueInstruction;
import org.jetbrains.kotlin.cfg.pseudocode.instructions.jumps.ReturnValueInstruction;
import org.jetbrains.kotlin.cfg.pseudocode.instructions.jumps.ThrowExceptionInstruction;
import org.jetbrains.kotlin.cfg.pseudocode.instructions.jumps.UnconditionalJumpInstruction;
import org.jetbrains.kotlin.cfg.pseudocode.instructions.special.LocalFunctionDeclarationInstruction;
import org.jetbrains.kotlin.cfg.pseudocode.instructions.special.MarkInstruction;
import org.jetbrains.kotlin.cfg.pseudocode.instructions.special.SubroutineEnterInstruction;
import org.jetbrains.kotlin.cfg.pseudocode.instructions.special.SubroutineExitInstruction;
import org.jetbrains.kotlin.cfg.pseudocode.instructions.special.SubroutineSinkInstruction;
import org.jetbrains.kotlin.cfg.pseudocode.instructions.special.VariableDeclarationInstruction;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtFunctionLiteral;
import org.jetbrains.kotlin.psi.KtFunctionLiteralExpression;
import org.jetbrains.kotlin.psi.KtLoopExpression;
import org.jetbrains.kotlin.psi.KtObjectLiteralExpression;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtReturnExpression;
import org.jetbrains.kotlin.psi.KtStringTemplateExpression;
import org.jetbrains.kotlin.psi.KtThrowExpression;
import org.jetbrains.kotlin.psi.KtVariableDeclaration;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.constants.CompileTimeConstant;
import org.jetbrains.kotlin.resolve.scopes.receivers.ReceiverValue;
import org.jetbrains.kotlin.types.KotlinType;

public class JetControlFlowInstructionsGenerator
extends JetControlFlowBuilderAdapter {
    private JetControlFlowBuilder builder = null;
    private final Stack<LoopInfo> loopInfo = new Stack();
    private final Stack<LexicalScope> lexicalScopes = new Stack();
    private final Map<KtElement, BreakableBlockInfo> elementToBlockInfo = new HashMap<KtElement, BreakableBlockInfo>();
    private int labelCount = 0;
    private final Stack<JetControlFlowInstructionsGeneratorWorker> builders = new Stack();
    private final Stack<BlockInfo> allBlocks = new Stack();

    @Override
    @NotNull
    protected JetControlFlowBuilder getDelegateBuilder() {
        JetControlFlowBuilder jetControlFlowBuilder = this.builder;
        if (jetControlFlowBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/cfg/pseudocode/JetControlFlowInstructionsGenerator", "getDelegateBuilder"));
        }
        return jetControlFlowBuilder;
    }

    private void pushBuilder(KtElement scopingElement, KtElement subroutine) {
        JetControlFlowInstructionsGeneratorWorker worker = new JetControlFlowInstructionsGeneratorWorker(scopingElement, subroutine);
        this.builders.push(worker);
        this.builder = worker;
    }

    private JetControlFlowInstructionsGeneratorWorker popBuilder(@NotNull KtElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/kotlin/cfg/pseudocode/JetControlFlowInstructionsGenerator", "popBuilder"));
        }
        JetControlFlowInstructionsGeneratorWorker worker = this.builders.pop();
        this.builder = !this.builders.isEmpty() ? (JetControlFlowBuilder)this.builders.peek() : null;
        return worker;
    }

    @Override
    public void enterSubroutine(@NotNull KtElement subroutine) {
        if (subroutine == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "subroutine", "org/jetbrains/kotlin/cfg/pseudocode/JetControlFlowInstructionsGenerator", "enterSubroutine"));
        }
        if (this.builder != null && subroutine instanceof KtFunctionLiteral) {
            this.pushBuilder(subroutine, this.builder.getReturnSubroutine());
        } else {
            this.pushBuilder(subroutine, subroutine);
        }
        assert (this.builder != null);
        this.builder.enterLexicalScope(subroutine);
        this.builder.enterSubroutine(subroutine);
    }

    @Override
    @NotNull
    public Pseudocode exitSubroutine(@NotNull KtElement subroutine) {
        if (subroutine == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "subroutine", "org/jetbrains/kotlin/cfg/pseudocode/JetControlFlowInstructionsGenerator", "exitSubroutine"));
        }
        super.exitSubroutine(subroutine);
        this.builder.exitLexicalScope(subroutine);
        JetControlFlowInstructionsGeneratorWorker worker = this.popBuilder(subroutine);
        if (!this.builders.empty()) {
            JetControlFlowInstructionsGeneratorWorker builder = this.builders.peek();
            builder.declareFunction(subroutine, worker.getPseudocode());
        }
        PseudocodeImpl pseudocodeImpl = worker.getPseudocode();
        if (pseudocodeImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/cfg/pseudocode/JetControlFlowInstructionsGenerator", "exitSubroutine"));
        }
        return pseudocodeImpl;
    }

    public static class TryFinallyBlockInfo
    extends BlockInfo {
        private final GenerationTrigger finallyBlock;

        private TryFinallyBlockInfo(GenerationTrigger finallyBlock) {
            this.finallyBlock = finallyBlock;
        }

        public void generateFinallyBlock() {
            this.finallyBlock.generate();
        }
    }

    private class JetControlFlowInstructionsGeneratorWorker
    implements JetControlFlowBuilder {
        private final PseudocodeImpl pseudocode;
        private final Label error;
        private final Label sink;
        private final KtElement returnSubroutine;
        private final PseudoValueFactory valueFactory;

        private JetControlFlowInstructionsGeneratorWorker(@NotNull KtElement scopingElement, @NotNull KtElement returnSubroutine) {
            if (scopingElement == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scopingElement", "org/jetbrains/kotlin/cfg/pseudocode/JetControlFlowInstructionsGenerator$JetControlFlowInstructionsGeneratorWorker", "<init>"));
            }
            if (returnSubroutine == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "returnSubroutine", "org/jetbrains/kotlin/cfg/pseudocode/JetControlFlowInstructionsGenerator$JetControlFlowInstructionsGeneratorWorker", "<init>"));
            }
            this.valueFactory = new PseudoValueFactoryImpl(){

                @Override
                @NotNull
                public PseudoValue newValue(@Nullable KtElement element, @Nullable InstructionWithValue instruction) {
                    PseudoValue value = super.newValue(element, instruction);
                    if (element != null) {
                        JetControlFlowInstructionsGeneratorWorker.this.bindValue(value, element);
                    }
                    PseudoValue pseudoValue = value;
                    if (pseudoValue == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/cfg/pseudocode/JetControlFlowInstructionsGenerator$JetControlFlowInstructionsGeneratorWorker$1", "newValue"));
                    }
                    return pseudoValue;
                }
            };
            this.pseudocode = new PseudocodeImpl(scopingElement);
            this.error = this.pseudocode.createLabel("error", null);
            this.sink = this.pseudocode.createLabel("sink", null);
            this.returnSubroutine = returnSubroutine;
        }

        public PseudocodeImpl getPseudocode() {
            return this.pseudocode;
        }

        private void add(@NotNull Instruction instruction) {
            if (instruction == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "instruction", "org/jetbrains/kotlin/cfg/pseudocode/JetControlFlowInstructionsGenerator$JetControlFlowInstructionsGeneratorWorker", "add"));
            }
            this.pseudocode.addInstruction(instruction);
        }

        @Override
        @NotNull
        public final Label createUnboundLabel() {
            PseudocodeImpl.PseudocodeLabel pseudocodeLabel = this.pseudocode.createLabel("L" + JetControlFlowInstructionsGenerator.this.labelCount++, null);
            if (pseudocodeLabel == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/cfg/pseudocode/JetControlFlowInstructionsGenerator$JetControlFlowInstructionsGeneratorWorker", "createUnboundLabel"));
            }
            return pseudocodeLabel;
        }

        @Override
        @NotNull
        public Label createUnboundLabel(@NotNull String name) {
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/kotlin/cfg/pseudocode/JetControlFlowInstructionsGenerator$JetControlFlowInstructionsGeneratorWorker", "createUnboundLabel"));
            }
            PseudocodeImpl.PseudocodeLabel pseudocodeLabel = this.pseudocode.createLabel("L" + JetControlFlowInstructionsGenerator.this.labelCount++, name);
            if (pseudocodeLabel == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/cfg/pseudocode/JetControlFlowInstructionsGenerator$JetControlFlowInstructionsGeneratorWorker", "createUnboundLabel"));
            }
            return pseudocodeLabel;
        }

        @Override
        @NotNull
        public final LoopInfo enterLoop(@NotNull KtLoopExpression expression) {
            if (expression == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/cfg/pseudocode/JetControlFlowInstructionsGenerator$JetControlFlowInstructionsGeneratorWorker", "enterLoop"));
            }
            LoopInfo info = new LoopInfo(expression, this.createUnboundLabel("loop entry point"), this.createUnboundLabel("loop exit point"), this.createUnboundLabel("body entry point"), this.createUnboundLabel("body exit point"), this.createUnboundLabel("condition entry point"));
            this.bindLabel(info.getEntryPoint());
            JetControlFlowInstructionsGenerator.this.elementToBlockInfo.put(expression, info);
            LoopInfo loopInfo = info;
            if (loopInfo == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/cfg/pseudocode/JetControlFlowInstructionsGenerator$JetControlFlowInstructionsGeneratorWorker", "enterLoop"));
            }
            return loopInfo;
        }

        @Override
        public void enterLoopBody(@NotNull KtLoopExpression expression) {
            if (expression == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/cfg/pseudocode/JetControlFlowInstructionsGenerator$JetControlFlowInstructionsGeneratorWorker", "enterLoopBody"));
            }
            LoopInfo info = (LoopInfo)JetControlFlowInstructionsGenerator.this.elementToBlockInfo.get(expression);
            this.bindLabel(info.getBodyEntryPoint());
            JetControlFlowInstructionsGenerator.this.loopInfo.push(info);
            JetControlFlowInstructionsGenerator.this.allBlocks.push(info);
        }

        @Override
        public final void exitLoopBody(@NotNull KtLoopExpression expression) {
            if (expression == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/cfg/pseudocode/JetControlFlowInstructionsGenerator$JetControlFlowInstructionsGeneratorWorker", "exitLoopBody"));
            }
            LoopInfo info = (LoopInfo)JetControlFlowInstructionsGenerator.this.loopInfo.pop();
            JetControlFlowInstructionsGenerator.this.elementToBlockInfo.remove(expression);
            JetControlFlowInstructionsGenerator.this.allBlocks.pop();
            this.bindLabel(info.getBodyExitPoint());
        }

        @Override
        public KtLoopExpression getCurrentLoop() {
            return JetControlFlowInstructionsGenerator.this.loopInfo.empty() ? null : ((LoopInfo)JetControlFlowInstructionsGenerator.this.loopInfo.peek()).getElement();
        }

        @Override
        public void enterSubroutine(@NotNull KtElement subroutine) {
            if (subroutine == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "subroutine", "org/jetbrains/kotlin/cfg/pseudocode/JetControlFlowInstructionsGenerator$JetControlFlowInstructionsGeneratorWorker", "enterSubroutine"));
            }
            BreakableBlockInfo blockInfo = new BreakableBlockInfo(subroutine, this.createUnboundLabel(), this.createUnboundLabel());
            JetControlFlowInstructionsGenerator.this.elementToBlockInfo.put(subroutine, blockInfo);
            JetControlFlowInstructionsGenerator.this.allBlocks.push(blockInfo);
            this.bindLabel(blockInfo.getEntryPoint());
            this.add(new SubroutineEnterInstruction(subroutine, this.getCurrentScope()));
        }

        @Override
        @NotNull
        public KtElement getCurrentSubroutine() {
            KtElement ktElement = this.pseudocode.getCorrespondingElement();
            if (ktElement == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/cfg/pseudocode/JetControlFlowInstructionsGenerator$JetControlFlowInstructionsGeneratorWorker", "getCurrentSubroutine"));
            }
            return ktElement;
        }

        @Override
        public KtElement getReturnSubroutine() {
            return this.returnSubroutine;
        }

        @Override
        @NotNull
        public Label getEntryPoint(@NotNull KtElement labelElement) {
            if (labelElement == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "labelElement", "org/jetbrains/kotlin/cfg/pseudocode/JetControlFlowInstructionsGenerator$JetControlFlowInstructionsGeneratorWorker", "getEntryPoint"));
            }
            Label label = ((BreakableBlockInfo)JetControlFlowInstructionsGenerator.this.elementToBlockInfo.get(labelElement)).getEntryPoint();
            if (label == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/cfg/pseudocode/JetControlFlowInstructionsGenerator$JetControlFlowInstructionsGeneratorWorker", "getEntryPoint"));
            }
            return label;
        }

        @Override
        @NotNull
        public Label getConditionEntryPoint(@NotNull KtElement labelElement) {
            if (labelElement == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "labelElement", "org/jetbrains/kotlin/cfg/pseudocode/JetControlFlowInstructionsGenerator$JetControlFlowInstructionsGeneratorWorker", "getConditionEntryPoint"));
            }
            BreakableBlockInfo blockInfo = (BreakableBlockInfo)JetControlFlowInstructionsGenerator.this.elementToBlockInfo.get(labelElement);
            assert (blockInfo instanceof LoopInfo) : "expected LoopInfo for " + labelElement.getText();
            Label label = ((LoopInfo)blockInfo).getConditionEntryPoint();
            if (label == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/cfg/pseudocode/JetControlFlowInstructionsGenerator$JetControlFlowInstructionsGeneratorWorker", "getConditionEntryPoint"));
            }
            return label;
        }

        @Override
        @NotNull
        public Label getExitPoint(@NotNull KtElement labelElement) {
            if (labelElement == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "labelElement", "org/jetbrains/kotlin/cfg/pseudocode/JetControlFlowInstructionsGenerator$JetControlFlowInstructionsGeneratorWorker", "getExitPoint"));
            }
            BreakableBlockInfo blockInfo = (BreakableBlockInfo)JetControlFlowInstructionsGenerator.this.elementToBlockInfo.get(labelElement);
            assert (blockInfo != null) : labelElement.getText();
            Label label = blockInfo.getExitPoint();
            if (label == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/cfg/pseudocode/JetControlFlowInstructionsGenerator$JetControlFlowInstructionsGeneratorWorker", "getExitPoint"));
            }
            return label;
        }

        @NotNull
        private LexicalScope getCurrentScope() {
            LexicalScope lexicalScope = (LexicalScope)JetControlFlowInstructionsGenerator.this.lexicalScopes.peek();
            if (lexicalScope == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/cfg/pseudocode/JetControlFlowInstructionsGenerator$JetControlFlowInstructionsGeneratorWorker", "getCurrentScope"));
            }
            return lexicalScope;
        }

        @Override
        public void enterLexicalScope(@NotNull KtElement element) {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/kotlin/cfg/pseudocode/JetControlFlowInstructionsGenerator$JetControlFlowInstructionsGeneratorWorker", "enterLexicalScope"));
            }
            LexicalScope current = JetControlFlowInstructionsGenerator.this.lexicalScopes.isEmpty() ? null : this.getCurrentScope();
            LexicalScope scope2 = new LexicalScope(current, element);
            JetControlFlowInstructionsGenerator.this.lexicalScopes.push(scope2);
        }

        @Override
        public void exitLexicalScope(@NotNull KtElement element) {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/kotlin/cfg/pseudocode/JetControlFlowInstructionsGenerator$JetControlFlowInstructionsGeneratorWorker", "exitLexicalScope"));
            }
            LexicalScope currentScope = this.getCurrentScope();
            assert (currentScope.getElement() == element) : "Exit from not the current lexical scope.\nCurrent scope is for: " + currentScope.getElement() + ".\n" + "Exit from the scope for: " + element.getText();
            JetControlFlowInstructionsGenerator.this.lexicalScopes.pop();
        }

        private void handleJumpInsideTryFinally(Label jumpTarget) {
            ArrayList<TryFinallyBlockInfo> finallyBlocks = new ArrayList<TryFinallyBlockInfo>();
            for (int i = JetControlFlowInstructionsGenerator.this.allBlocks.size() - 1; i >= 0; --i) {
                BlockInfo blockInfo = (BlockInfo)JetControlFlowInstructionsGenerator.this.allBlocks.get(i);
                if (blockInfo instanceof BreakableBlockInfo) {
                    BreakableBlockInfo breakableBlockInfo = (BreakableBlockInfo)blockInfo;
                    if (!breakableBlockInfo.getReferablePoints().contains(jumpTarget) && jumpTarget != this.error) continue;
                    for (int j = finallyBlocks.size() - 1; j >= 0; --j) {
                        ((TryFinallyBlockInfo)finallyBlocks.get(j)).generateFinallyBlock();
                    }
                    break;
                }
                if (!(blockInfo instanceof TryFinallyBlockInfo)) continue;
                TryFinallyBlockInfo tryFinallyBlockInfo = (TryFinallyBlockInfo)blockInfo;
                finallyBlocks.add(tryFinallyBlockInfo);
            }
        }

        @Override
        @NotNull
        public Pseudocode exitSubroutine(@NotNull KtElement subroutine) {
            if (subroutine == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "subroutine", "org/jetbrains/kotlin/cfg/pseudocode/JetControlFlowInstructionsGenerator$JetControlFlowInstructionsGeneratorWorker", "exitSubroutine"));
            }
            this.bindLabel(this.getExitPoint(subroutine));
            this.pseudocode.addExitInstruction(new SubroutineExitInstruction(subroutine, this.getCurrentScope(), false));
            this.bindLabel(this.error);
            this.pseudocode.addErrorInstruction(new SubroutineExitInstruction(subroutine, this.getCurrentScope(), true));
            this.bindLabel(this.sink);
            this.pseudocode.addSinkInstruction(new SubroutineSinkInstruction(subroutine, this.getCurrentScope(), "<SINK>"));
            JetControlFlowInstructionsGenerator.this.elementToBlockInfo.remove(subroutine);
            JetControlFlowInstructionsGenerator.this.allBlocks.pop();
            PseudocodeImpl pseudocodeImpl = this.pseudocode;
            if (pseudocodeImpl == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/cfg/pseudocode/JetControlFlowInstructionsGenerator$JetControlFlowInstructionsGeneratorWorker", "exitSubroutine"));
            }
            return pseudocodeImpl;
        }

        @Override
        public void mark(@NotNull KtElement element) {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/kotlin/cfg/pseudocode/JetControlFlowInstructionsGenerator$JetControlFlowInstructionsGeneratorWorker", "mark"));
            }
            this.add(new MarkInstruction(element, this.getCurrentScope()));
        }

        @Override
        @Nullable
        public PseudoValue getBoundValue(@Nullable KtElement element) {
            return this.pseudocode.getElementValue(element);
        }

        @Override
        public void bindValue(@NotNull PseudoValue value, @NotNull KtElement element) {
            if (value == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "org/jetbrains/kotlin/cfg/pseudocode/JetControlFlowInstructionsGenerator$JetControlFlowInstructionsGeneratorWorker", "bindValue"));
            }
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/kotlin/cfg/pseudocode/JetControlFlowInstructionsGenerator$JetControlFlowInstructionsGeneratorWorker", "bindValue"));
            }
            this.pseudocode.bindElementToValue(element, value);
        }

        @Override
        @NotNull
        public PseudoValue newValue(@Nullable KtElement element) {
            PseudoValue pseudoValue = this.valueFactory.newValue(element, null);
            if (pseudoValue == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/cfg/pseudocode/JetControlFlowInstructionsGenerator$JetControlFlowInstructionsGeneratorWorker", "newValue"));
            }
            return pseudoValue;
        }

        @Override
        public void returnValue(@NotNull KtExpression returnExpression, @NotNull PseudoValue returnValue, @NotNull KtElement subroutine) {
            if (returnExpression == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "returnExpression", "org/jetbrains/kotlin/cfg/pseudocode/JetControlFlowInstructionsGenerator$JetControlFlowInstructionsGeneratorWorker", "returnValue"));
            }
            if (returnValue == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "returnValue", "org/jetbrains/kotlin/cfg/pseudocode/JetControlFlowInstructionsGenerator$JetControlFlowInstructionsGeneratorWorker", "returnValue"));
            }
            if (subroutine == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "subroutine", "org/jetbrains/kotlin/cfg/pseudocode/JetControlFlowInstructionsGenerator$JetControlFlowInstructionsGeneratorWorker", "returnValue"));
            }
            Label exitPoint = this.getExitPoint(subroutine);
            this.handleJumpInsideTryFinally(exitPoint);
            this.add(new ReturnValueInstruction(returnExpression, this.getCurrentScope(), exitPoint, returnValue));
        }

        @Override
        public void returnNoValue(@NotNull KtReturnExpression returnExpression, @NotNull KtElement subroutine) {
            if (returnExpression == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "returnExpression", "org/jetbrains/kotlin/cfg/pseudocode/JetControlFlowInstructionsGenerator$JetControlFlowInstructionsGeneratorWorker", "returnNoValue"));
            }
            if (subroutine == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "subroutine", "org/jetbrains/kotlin/cfg/pseudocode/JetControlFlowInstructionsGenerator$JetControlFlowInstructionsGeneratorWorker", "returnNoValue"));
            }
            Label exitPoint = this.getExitPoint(subroutine);
            this.handleJumpInsideTryFinally(exitPoint);
            this.add(new ReturnNoValueInstruction((KtElement)returnExpression, this.getCurrentScope(), exitPoint));
        }

        @Override
        public void write(@NotNull KtElement assignment, @NotNull KtElement lValue, @NotNull PseudoValue rValue, @NotNull AccessTarget target, @NotNull Map<PseudoValue, ReceiverValue> receiverValues) {
            if (assignment == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "assignment", "org/jetbrains/kotlin/cfg/pseudocode/JetControlFlowInstructionsGenerator$JetControlFlowInstructionsGeneratorWorker", "write"));
            }
            if (lValue == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lValue", "org/jetbrains/kotlin/cfg/pseudocode/JetControlFlowInstructionsGenerator$JetControlFlowInstructionsGeneratorWorker", "write"));
            }
            if (rValue == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rValue", "org/jetbrains/kotlin/cfg/pseudocode/JetControlFlowInstructionsGenerator$JetControlFlowInstructionsGeneratorWorker", "write"));
            }
            if (target == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "target", "org/jetbrains/kotlin/cfg/pseudocode/JetControlFlowInstructionsGenerator$JetControlFlowInstructionsGeneratorWorker", "write"));
            }
            if (receiverValues == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "receiverValues", "org/jetbrains/kotlin/cfg/pseudocode/JetControlFlowInstructionsGenerator$JetControlFlowInstructionsGeneratorWorker", "write"));
            }
            this.add(new WriteValueInstruction(assignment, this.getCurrentScope(), target, receiverValues, lValue, rValue));
        }

        @Override
        public void declareParameter(@NotNull KtParameter parameter) {
            if (parameter == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameter", "org/jetbrains/kotlin/cfg/pseudocode/JetControlFlowInstructionsGenerator$JetControlFlowInstructionsGeneratorWorker", "declareParameter"));
            }
            this.add(new VariableDeclarationInstruction(parameter, this.getCurrentScope()));
        }

        @Override
        public void declareVariable(@NotNull KtVariableDeclaration property) {
            if (property == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "property", "org/jetbrains/kotlin/cfg/pseudocode/JetControlFlowInstructionsGenerator$JetControlFlowInstructionsGeneratorWorker", "declareVariable"));
            }
            this.add(new VariableDeclarationInstruction(property, this.getCurrentScope()));
        }

        @Override
        public void declareFunction(@NotNull KtElement subroutine, @NotNull Pseudocode pseudocode) {
            if (subroutine == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "subroutine", "org/jetbrains/kotlin/cfg/pseudocode/JetControlFlowInstructionsGenerator$JetControlFlowInstructionsGeneratorWorker", "declareFunction"));
            }
            if (pseudocode == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pseudocode", "org/jetbrains/kotlin/cfg/pseudocode/JetControlFlowInstructionsGenerator$JetControlFlowInstructionsGeneratorWorker", "declareFunction"));
            }
            this.add(new LocalFunctionDeclarationInstruction(subroutine, pseudocode, this.getCurrentScope()));
        }

        @Override
        public void loadUnit(@NotNull KtExpression expression) {
            if (expression == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/cfg/pseudocode/JetControlFlowInstructionsGenerator$JetControlFlowInstructionsGeneratorWorker", "loadUnit"));
            }
            this.add(new LoadUnitValueInstruction(expression, this.getCurrentScope()));
        }

        @Override
        public void jump(@NotNull Label label, @NotNull KtElement element) {
            if (label == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "label", "org/jetbrains/kotlin/cfg/pseudocode/JetControlFlowInstructionsGenerator$JetControlFlowInstructionsGeneratorWorker", "jump"));
            }
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/kotlin/cfg/pseudocode/JetControlFlowInstructionsGenerator$JetControlFlowInstructionsGeneratorWorker", "jump"));
            }
            this.handleJumpInsideTryFinally(label);
            this.add(new UnconditionalJumpInstruction(element, label, this.getCurrentScope()));
        }

        @Override
        public void jumpOnFalse(@NotNull Label label, @NotNull KtElement element, @Nullable PseudoValue conditionValue) {
            if (label == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "label", "org/jetbrains/kotlin/cfg/pseudocode/JetControlFlowInstructionsGenerator$JetControlFlowInstructionsGeneratorWorker", "jumpOnFalse"));
            }
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/kotlin/cfg/pseudocode/JetControlFlowInstructionsGenerator$JetControlFlowInstructionsGeneratorWorker", "jumpOnFalse"));
            }
            this.handleJumpInsideTryFinally(label);
            this.add(new ConditionalJumpInstruction(element, false, this.getCurrentScope(), label, conditionValue));
        }

        @Override
        public void jumpOnTrue(@NotNull Label label, @NotNull KtElement element, @Nullable PseudoValue conditionValue) {
            if (label == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "label", "org/jetbrains/kotlin/cfg/pseudocode/JetControlFlowInstructionsGenerator$JetControlFlowInstructionsGeneratorWorker", "jumpOnTrue"));
            }
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/kotlin/cfg/pseudocode/JetControlFlowInstructionsGenerator$JetControlFlowInstructionsGeneratorWorker", "jumpOnTrue"));
            }
            this.handleJumpInsideTryFinally(label);
            this.add(new ConditionalJumpInstruction(element, true, this.getCurrentScope(), label, conditionValue));
        }

        @Override
        public void bindLabel(@NotNull Label label) {
            if (label == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "label", "org/jetbrains/kotlin/cfg/pseudocode/JetControlFlowInstructionsGenerator$JetControlFlowInstructionsGeneratorWorker", "bindLabel"));
            }
            this.pseudocode.bindLabel(label);
        }

        @Override
        public void nondeterministicJump(@NotNull Label label, @NotNull KtElement element, @Nullable PseudoValue inputValue) {
            if (label == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "label", "org/jetbrains/kotlin/cfg/pseudocode/JetControlFlowInstructionsGenerator$JetControlFlowInstructionsGeneratorWorker", "nondeterministicJump"));
            }
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/kotlin/cfg/pseudocode/JetControlFlowInstructionsGenerator$JetControlFlowInstructionsGeneratorWorker", "nondeterministicJump"));
            }
            this.handleJumpInsideTryFinally(label);
            this.add(new NondeterministicJumpInstruction(element, Collections.singletonList(label), this.getCurrentScope(), inputValue));
        }

        @Override
        public void nondeterministicJump(@NotNull List<Label> labels, @NotNull KtElement element) {
            if (labels == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "labels", "org/jetbrains/kotlin/cfg/pseudocode/JetControlFlowInstructionsGenerator$JetControlFlowInstructionsGeneratorWorker", "nondeterministicJump"));
            }
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/kotlin/cfg/pseudocode/JetControlFlowInstructionsGenerator$JetControlFlowInstructionsGeneratorWorker", "nondeterministicJump"));
            }
            this.add(new NondeterministicJumpInstruction(element, labels, this.getCurrentScope(), null));
        }

        @Override
        public void jumpToError(@NotNull KtElement element) {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/kotlin/cfg/pseudocode/JetControlFlowInstructionsGenerator$JetControlFlowInstructionsGeneratorWorker", "jumpToError"));
            }
            this.handleJumpInsideTryFinally(this.error);
            this.add(new UnconditionalJumpInstruction(element, this.error, this.getCurrentScope()));
        }

        @Override
        public void enterTryFinally(@NotNull GenerationTrigger generationTrigger) {
            if (generationTrigger == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "generationTrigger", "org/jetbrains/kotlin/cfg/pseudocode/JetControlFlowInstructionsGenerator$JetControlFlowInstructionsGeneratorWorker", "enterTryFinally"));
            }
            JetControlFlowInstructionsGenerator.this.allBlocks.push(new TryFinallyBlockInfo(generationTrigger));
        }

        @Override
        public void throwException(@NotNull KtThrowExpression expression, @NotNull PseudoValue thrownValue) {
            if (expression == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/cfg/pseudocode/JetControlFlowInstructionsGenerator$JetControlFlowInstructionsGeneratorWorker", "throwException"));
            }
            if (thrownValue == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "thrownValue", "org/jetbrains/kotlin/cfg/pseudocode/JetControlFlowInstructionsGenerator$JetControlFlowInstructionsGeneratorWorker", "throwException"));
            }
            this.handleJumpInsideTryFinally(this.error);
            this.add(new ThrowExceptionInstruction(expression, this.getCurrentScope(), this.error, thrownValue));
        }

        @Override
        public void exitTryFinally() {
            BlockInfo pop2 = (BlockInfo)JetControlFlowInstructionsGenerator.this.allBlocks.pop();
            assert (pop2 instanceof TryFinallyBlockInfo);
        }

        @Override
        public void repeatPseudocode(@NotNull Label startLabel, @NotNull Label finishLabel) {
            if (startLabel == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "startLabel", "org/jetbrains/kotlin/cfg/pseudocode/JetControlFlowInstructionsGenerator$JetControlFlowInstructionsGeneratorWorker", "repeatPseudocode"));
            }
            if (finishLabel == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "finishLabel", "org/jetbrains/kotlin/cfg/pseudocode/JetControlFlowInstructionsGenerator$JetControlFlowInstructionsGeneratorWorker", "repeatPseudocode"));
            }
            JetControlFlowInstructionsGenerator.this.labelCount = this.pseudocode.repeatPart(startLabel, finishLabel, JetControlFlowInstructionsGenerator.this.labelCount);
        }

        @Override
        @NotNull
        public InstructionWithValue loadConstant(@NotNull KtExpression expression, @Nullable CompileTimeConstant<?> constant) {
            if (expression == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/cfg/pseudocode/JetControlFlowInstructionsGenerator$JetControlFlowInstructionsGeneratorWorker", "loadConstant"));
            }
            ReadValueInstruction readValueInstruction = this.read(expression);
            if (readValueInstruction == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/cfg/pseudocode/JetControlFlowInstructionsGenerator$JetControlFlowInstructionsGeneratorWorker", "loadConstant"));
            }
            return readValueInstruction;
        }

        @Override
        @NotNull
        public InstructionWithValue createAnonymousObject(@NotNull KtObjectLiteralExpression expression) {
            if (expression == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/cfg/pseudocode/JetControlFlowInstructionsGenerator$JetControlFlowInstructionsGeneratorWorker", "createAnonymousObject"));
            }
            ReadValueInstruction readValueInstruction = this.read(expression);
            if (readValueInstruction == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/cfg/pseudocode/JetControlFlowInstructionsGenerator$JetControlFlowInstructionsGeneratorWorker", "createAnonymousObject"));
            }
            return readValueInstruction;
        }

        @Override
        @NotNull
        public InstructionWithValue createLambda(@NotNull KtFunction expression) {
            if (expression == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/cfg/pseudocode/JetControlFlowInstructionsGenerator$JetControlFlowInstructionsGeneratorWorker", "createLambda"));
            }
            ReadValueInstruction readValueInstruction = this.read(expression instanceof KtFunctionLiteral ? (KtFunctionLiteralExpression)expression.getParent() : expression);
            if (readValueInstruction == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/cfg/pseudocode/JetControlFlowInstructionsGenerator$JetControlFlowInstructionsGeneratorWorker", "createLambda"));
            }
            return readValueInstruction;
        }

        @Override
        @NotNull
        public InstructionWithValue loadStringTemplate(@NotNull KtStringTemplateExpression expression, @NotNull List<PseudoValue> inputValues) {
            if (expression == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/cfg/pseudocode/JetControlFlowInstructionsGenerator$JetControlFlowInstructionsGeneratorWorker", "loadStringTemplate"));
            }
            if (inputValues == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "inputValues", "org/jetbrains/kotlin/cfg/pseudocode/JetControlFlowInstructionsGenerator$JetControlFlowInstructionsGeneratorWorker", "loadStringTemplate"));
            }
            InstructionWithValue instructionWithValue = (InstructionWithValue)((Object)(inputValues.isEmpty() ? this.read(expression) : this.magic(expression, expression, inputValues, MagicKind.STRING_TEMPLATE)));
            if (instructionWithValue == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/cfg/pseudocode/JetControlFlowInstructionsGenerator$JetControlFlowInstructionsGeneratorWorker", "loadStringTemplate"));
            }
            return instructionWithValue;
        }

        @Override
        @NotNull
        public MagicInstruction magic(@NotNull KtElement instructionElement, @Nullable KtElement valueElement, @NotNull List<PseudoValue> inputValues, @NotNull MagicKind kind) {
            if (instructionElement == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "instructionElement", "org/jetbrains/kotlin/cfg/pseudocode/JetControlFlowInstructionsGenerator$JetControlFlowInstructionsGeneratorWorker", "magic"));
            }
            if (inputValues == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "inputValues", "org/jetbrains/kotlin/cfg/pseudocode/JetControlFlowInstructionsGenerator$JetControlFlowInstructionsGeneratorWorker", "magic"));
            }
            if (kind == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kind", "org/jetbrains/kotlin/cfg/pseudocode/JetControlFlowInstructionsGenerator$JetControlFlowInstructionsGeneratorWorker", "magic"));
            }
            MagicInstruction instruction = new MagicInstruction(instructionElement, valueElement, this.getCurrentScope(), inputValues, kind, this.valueFactory);
            this.add(instruction);
            MagicInstruction magicInstruction = instruction;
            if (magicInstruction == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/cfg/pseudocode/JetControlFlowInstructionsGenerator$JetControlFlowInstructionsGeneratorWorker", "magic"));
            }
            return magicInstruction;
        }

        @Override
        @NotNull
        public MergeInstruction merge(@NotNull KtExpression expression, @NotNull List<PseudoValue> inputValues) {
            if (expression == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/cfg/pseudocode/JetControlFlowInstructionsGenerator$JetControlFlowInstructionsGeneratorWorker", "merge"));
            }
            if (inputValues == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "inputValues", "org/jetbrains/kotlin/cfg/pseudocode/JetControlFlowInstructionsGenerator$JetControlFlowInstructionsGeneratorWorker", "merge"));
            }
            MergeInstruction instruction = new MergeInstruction(expression, this.getCurrentScope(), inputValues, this.valueFactory);
            this.add(instruction);
            MergeInstruction mergeInstruction = instruction;
            if (mergeInstruction == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/cfg/pseudocode/JetControlFlowInstructionsGenerator$JetControlFlowInstructionsGeneratorWorker", "merge"));
            }
            return mergeInstruction;
        }

        @Override
        @NotNull
        public ReadValueInstruction readVariable(@NotNull KtExpression expression, @NotNull ResolvedCall<?> resolvedCall, @NotNull Map<PseudoValue, ReceiverValue> receiverValues) {
            if (expression == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/cfg/pseudocode/JetControlFlowInstructionsGenerator$JetControlFlowInstructionsGeneratorWorker", "readVariable"));
            }
            if (resolvedCall == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolvedCall", "org/jetbrains/kotlin/cfg/pseudocode/JetControlFlowInstructionsGenerator$JetControlFlowInstructionsGeneratorWorker", "readVariable"));
            }
            if (receiverValues == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "receiverValues", "org/jetbrains/kotlin/cfg/pseudocode/JetControlFlowInstructionsGenerator$JetControlFlowInstructionsGeneratorWorker", "readVariable"));
            }
            ReadValueInstruction readValueInstruction = this.read(expression, resolvedCall, receiverValues);
            if (readValueInstruction == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/cfg/pseudocode/JetControlFlowInstructionsGenerator$JetControlFlowInstructionsGeneratorWorker", "readVariable"));
            }
            return readValueInstruction;
        }

        @Override
        @NotNull
        public CallInstruction call(@NotNull KtElement valueElement, @NotNull ResolvedCall<?> resolvedCall, @NotNull Map<PseudoValue, ReceiverValue> receiverValues, @NotNull Map<PseudoValue, ValueParameterDescriptor> arguments2) {
            if (valueElement == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "valueElement", "org/jetbrains/kotlin/cfg/pseudocode/JetControlFlowInstructionsGenerator$JetControlFlowInstructionsGeneratorWorker", "call"));
            }
            if (resolvedCall == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolvedCall", "org/jetbrains/kotlin/cfg/pseudocode/JetControlFlowInstructionsGenerator$JetControlFlowInstructionsGeneratorWorker", "call"));
            }
            if (receiverValues == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "receiverValues", "org/jetbrains/kotlin/cfg/pseudocode/JetControlFlowInstructionsGenerator$JetControlFlowInstructionsGeneratorWorker", "call"));
            }
            if (arguments2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "arguments", "org/jetbrains/kotlin/cfg/pseudocode/JetControlFlowInstructionsGenerator$JetControlFlowInstructionsGeneratorWorker", "call"));
            }
            KotlinType returnType2 = resolvedCall.getResultingDescriptor().getReturnType();
            CallInstruction instruction = new CallInstruction(valueElement, this.getCurrentScope(), resolvedCall, receiverValues, arguments2, (PseudoValueFactory)(returnType2 != null && KotlinBuiltIns.isNothing(returnType2) ? null : this.valueFactory));
            this.add(instruction);
            CallInstruction callInstruction = instruction;
            if (callInstruction == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/cfg/pseudocode/JetControlFlowInstructionsGenerator$JetControlFlowInstructionsGeneratorWorker", "call"));
            }
            return callInstruction;
        }

        @Override
        @NotNull
        public OperationInstruction predefinedOperation(@NotNull KtExpression expression, @NotNull JetControlFlowBuilder.PredefinedOperation operation, @NotNull List<PseudoValue> inputValues) {
            if (expression == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/cfg/pseudocode/JetControlFlowInstructionsGenerator$JetControlFlowInstructionsGeneratorWorker", "predefinedOperation"));
            }
            if (operation == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "operation", "org/jetbrains/kotlin/cfg/pseudocode/JetControlFlowInstructionsGenerator$JetControlFlowInstructionsGeneratorWorker", "predefinedOperation"));
            }
            if (inputValues == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "inputValues", "org/jetbrains/kotlin/cfg/pseudocode/JetControlFlowInstructionsGenerator$JetControlFlowInstructionsGeneratorWorker", "predefinedOperation"));
            }
            MagicInstruction magicInstruction = this.magic(expression, expression, inputValues, this.getMagicKind(operation));
            if (magicInstruction == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/cfg/pseudocode/JetControlFlowInstructionsGenerator$JetControlFlowInstructionsGeneratorWorker", "predefinedOperation"));
            }
            return magicInstruction;
        }

        @NotNull
        private MagicKind getMagicKind(@NotNull JetControlFlowBuilder.PredefinedOperation operation) {
            if (operation == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "operation", "org/jetbrains/kotlin/cfg/pseudocode/JetControlFlowInstructionsGenerator$JetControlFlowInstructionsGeneratorWorker", "getMagicKind"));
            }
            switch (operation) {
                case AND: {
                    MagicKind magicKind = MagicKind.AND;
                    if (magicKind == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/cfg/pseudocode/JetControlFlowInstructionsGenerator$JetControlFlowInstructionsGeneratorWorker", "getMagicKind"));
                    }
                    return magicKind;
                }
                case OR: {
                    MagicKind magicKind = MagicKind.OR;
                    if (magicKind == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/cfg/pseudocode/JetControlFlowInstructionsGenerator$JetControlFlowInstructionsGeneratorWorker", "getMagicKind"));
                    }
                    return magicKind;
                }
                case NOT_NULL_ASSERTION: {
                    MagicKind magicKind = MagicKind.NOT_NULL_ASSERTION;
                    if (magicKind == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/cfg/pseudocode/JetControlFlowInstructionsGenerator$JetControlFlowInstructionsGeneratorWorker", "getMagicKind"));
                    }
                    return magicKind;
                }
            }
            throw new IllegalArgumentException("Invalid operation: " + (Object)((Object)operation));
        }

        @NotNull
        private ReadValueInstruction read(@NotNull KtExpression expression, @Nullable ResolvedCall<?> resolvedCall, @NotNull Map<PseudoValue, ReceiverValue> receiverValues) {
            if (expression == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/cfg/pseudocode/JetControlFlowInstructionsGenerator$JetControlFlowInstructionsGeneratorWorker", "read"));
            }
            if (receiverValues == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "receiverValues", "org/jetbrains/kotlin/cfg/pseudocode/JetControlFlowInstructionsGenerator$JetControlFlowInstructionsGeneratorWorker", "read"));
            }
            AccessTarget accessTarget = resolvedCall != null ? new AccessTarget.Call(resolvedCall) : AccessTarget.BlackBox.INSTANCE$;
            ReadValueInstruction instruction = new ReadValueInstruction((KtElement)expression, this.getCurrentScope(), accessTarget, receiverValues, this.valueFactory);
            this.add(instruction);
            ReadValueInstruction readValueInstruction = instruction;
            if (readValueInstruction == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/cfg/pseudocode/JetControlFlowInstructionsGenerator$JetControlFlowInstructionsGeneratorWorker", "read"));
            }
            return readValueInstruction;
        }

        @NotNull
        private ReadValueInstruction read(@NotNull KtExpression expression) {
            if (expression == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/cfg/pseudocode/JetControlFlowInstructionsGenerator$JetControlFlowInstructionsGeneratorWorker", "read"));
            }
            ReadValueInstruction readValueInstruction = this.read(expression, null, Collections.<PseudoValue, ReceiverValue>emptyMap());
            if (readValueInstruction == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/cfg/pseudocode/JetControlFlowInstructionsGenerator$JetControlFlowInstructionsGeneratorWorker", "read"));
            }
            return readValueInstruction;
        }
    }
}

