/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.types;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinFileFacade;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.types.Flexibility;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.TypeProjection;
import org.jetbrains.kotlin.types.TypeProjectionImpl;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.kotlin.types.Variance;
import org.jetbrains.kotlin.types.checker.KotlinTypeChecker;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@KotlinFileFacade(version={1, 0, 0}, abiVersion=32, data={"!\u0015\u0001Q!\u0001\u0007\u0002\u000b\u0005a\u0011!B\u0001\u0005\u0003\u0015\t\u00012B\u0003\u0002\t\u0007)\u0011\u0001C\b\u0006\u00031\tQ\u0001AG\u0007\u0011\u0001i\u0011\u0001'\u0001\u0016\u0003a\tAka\u0001\u000e\u000e!\u0011Q\"\u0001M\u0003+\u0005A\u0012\u0001VB\u0002\u001b\u001bA1!D\u0001\u0019\u0006U\t\u0001$\u0001+\u0004\u000455\u0001rA\u0007\u00021\u0005)\u0012\u0001G\u0001U\u0007\u0007i)\u0002\u0003\u0003\u000e\u00051\u0005\u0001$A\u000b\u0005\u0013\tI\u0011\u0001G\u0001\u0019\nQ\u001b\u0019!$\u0006\t\t5\u0011A\u0012\u0001\r\u0006+\u0011I!!C\u0001\u0019\u000ba%Aka\u0001\u000e\u000e!-Q\"\u0001\r\u0002+\u0005A\u0012\u0001VB\u0002"}, strings={"flexibility", "Lorg/jetbrains/kotlin/types/Flexibility;", "Lorg/jetbrains/kotlin/types/KotlinType;", "FlexibleTypesKt", "isFlexible", "", "isNullabilityFlexible", "lowerIfFlexible", "singleBestRepresentative", "", "Lorg/jetbrains/kotlin/types/TypeProjection;", "upperIfFlexible"}, moduleName="kotlin-compiler")
public final class FlexibleTypesKt {
    public static final boolean isFlexible(KotlinType $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        return $receiver.getCapability(Flexibility.class) != null;
    }

    @NotNull
    public static final Flexibility flexibility(KotlinType $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Flexibility flexibility = $receiver.getCapability(Flexibility.class);
        if (flexibility == null) {
            Intrinsics.throwNpe();
        }
        return flexibility;
    }

    public static final boolean isNullabilityFlexible(KotlinType $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Flexibility flexibility = $receiver.getCapability(Flexibility.class);
        if (flexibility == null) {
            return false;
        }
        Flexibility flexibility2 = flexibility;
        return TypeUtils.isNullableType(flexibility2.getLowerBound()) != TypeUtils.isNullableType(flexibility2.getUpperBound());
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public static final KotlinType singleBestRepresentative(Collection<? extends KotlinType> $receiver) {
        KotlinType kotlinType;
        block4: {
            Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
            Iterable<KotlinType> $receiver2 = $receiver;
            if ($receiver2.size() == 1) {
                return (KotlinType)CollectionsKt.first((Iterable)$receiver);
            }
            $receiver2 = $receiver;
            Iterator<KotlinType> iterator2 = $receiver2.iterator();
            while (iterator2.hasNext()) {
                boolean bl;
                KotlinType element;
                block3: {
                    void $receiver3;
                    KotlinType candidate = element = iterator2.next();
                    Iterable iterable = $receiver;
                    for (Object element2 : $receiver3) {
                        KotlinType other = (KotlinType)element2;
                        if (Intrinsics.areEqual(candidate, other) || KotlinTypeChecker.ERROR_TYPES_ARE_EQUAL_TO_ANYTHING.equalTypes(candidate, other)) continue;
                        bl = false;
                        break block3;
                    }
                    bl = true;
                }
                if (!bl) continue;
                kotlinType = element;
                break block4;
            }
            kotlinType = null;
        }
        return kotlinType;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public static final TypeProjection singleBestRepresentative(Collection<? extends TypeProjection> $receiver) {
        void destination;
        void $receiver2;
        Object object;
        void var8_8;
        Iterable destination2;
        Iterable $receiver3;
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Collection<? extends TypeProjection> $receiver4 = $receiver;
        if ($receiver4.size() == 1) {
            return (TypeProjection)CollectionsKt.first((Iterable)$receiver);
        }
        Iterable $receiver5 = $receiver;
        Iterable iterable = $receiver5;
        Collection collection = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver5, 10));
        for (Object item : $receiver3) {
            void it2;
            TypeProjection typeProjection = (TypeProjection)item;
            var8_8 = destination2;
            object = it2.getProjectionKind();
            var8_8.add(object);
        }
        Set projectionKinds = CollectionsKt.toSet((List)destination2);
        $receiver5 = projectionKinds;
        if ($receiver5.size() != 1) {
            return null;
        }
        $receiver3 = $receiver;
        destination2 = $receiver3;
        Collection collection2 = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver3, 10));
        for (Object item : $receiver2) {
            void it3;
            TypeProjection $i$a$1 = (TypeProjection)item;
            var8_8 = destination;
            object = it3.getType();
            var8_8.add(object);
        }
        KotlinType bestType = FlexibleTypesKt.singleBestRepresentative((List)destination);
        if (bestType == null) {
            return null;
        }
        return new TypeProjectionImpl((Variance)((Object)CollectionsKt.single(projectionKinds)), bestType);
    }

    @NotNull
    public static final KotlinType lowerIfFlexible(KotlinType $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        return FlexibleTypesKt.isFlexible($receiver) ? FlexibleTypesKt.flexibility($receiver).getLowerBound() : $receiver;
    }

    @NotNull
    public static final KotlinType upperIfFlexible(KotlinType $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        return FlexibleTypesKt.isFlexible($receiver) ? FlexibleTypesKt.flexibility($receiver).getUpperBound() : $receiver;
    }
}

