/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.constants;

import java.util.List;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.kotlin.resolve.constants.AnnotationValue;
import org.jetbrains.kotlin.resolve.constants.ArrayValue;
import org.jetbrains.kotlin.resolve.constants.BooleanValue;
import org.jetbrains.kotlin.resolve.constants.ByteValue;
import org.jetbrains.kotlin.resolve.constants.CharValue;
import org.jetbrains.kotlin.resolve.constants.ConstantValue;
import org.jetbrains.kotlin.resolve.constants.DoubleValue;
import org.jetbrains.kotlin.resolve.constants.EnumValue;
import org.jetbrains.kotlin.resolve.constants.ErrorValue;
import org.jetbrains.kotlin.resolve.constants.FloatValue;
import org.jetbrains.kotlin.resolve.constants.IntValue;
import org.jetbrains.kotlin.resolve.constants.IntegerValueConstant;
import org.jetbrains.kotlin.resolve.constants.KClassValue;
import org.jetbrains.kotlin.resolve.constants.LongValue;
import org.jetbrains.kotlin.resolve.constants.NullValue;
import org.jetbrains.kotlin.resolve.constants.ShortValue;
import org.jetbrains.kotlin.resolve.constants.StringValue;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.TypeUtils;

@KotlinClass(version={1, 0, 0}, abiVersion=32, data={"1\u0004)\u0011\u0001D\u0001\u0006\u0003!\u0001Q\u0001A\u0003\u0002\u0019\u0005)\u0011\u0001B\u0001\u0006\u00031\tQ\u0001A\u0003\u0002\u0019\u0005)\u0001!B\u0001\r\u0003\u0015\t\u0001\u0002E\u0003\u0002\u0019\u0005)\u0001!B\u0001\r\u0003\u0015\u0001Q!\u0001\u0007\u0002\u000b\u0005AY!\u0002\u0001\u0006\u00031\tQ!\u0001E\u0003\u000b\u0001)\u0011\u0001D\u0001\u0006\u0003!1Q!\u0001\u0003\u0002\u000b\u0005a\u0011!B\u0001\t\u0007\u0015\u0001Q!\u0001\u0007\u0002\u000b\u0001)\u0011\u0001D\u0001\u0006\u0001\u0015\tA\"A\u0003\u0001\u000b\u0005Aq!\u0002\u0001\u0006\u00031\tQ!\u0001E\u0004\u000b\u0001)\u0011\u0001D\u0001\u0006\u0003!!Q\u0001A\u0003\u0002\u0011\u0013)\u0011\u0001B\u0001\u0006\u00031\tQ\u0001A\u0003\u0002\u0019\u0005)\u0001!B\u0001\r\u0003\u0015\u0001Q!\u0001\u0007\u0002\u000b\u0005AQ!\u0002\u0001\u0006\u00031\tA\u0002A\r\u00021\u0003\tk!C\u0002\t\u00035\t\u00014A)\u0004\u0003!\u0011Qe\u0002E\u0003\u001b\u0005A2!G\u0002\t\b5\t\u0001\u0004B\u0013\u0011\u0011\u0013i\u0011\u0001G\u0003\u001a\u0011!\u001dQBB\u0005\u0005\u0013\rI\u0011\u0001b\u0001\u0019\ra-\u0011d\u0001E\u0007\u001b\u0005Ar!J\u0004\t\u00105\t\u0001\u0004C\r\u0004\u0011\u000fi\u0011\u0001'\u0005&\u000f!IQ\"\u0001M\n3\rA9!D\u0001\u0019\u0015\u0015:\u0001RC\u0007\u00021-I2\u0001c\u0002\u000e\u0003a]Qe\u0003\u0005\r\u001b\u0011I\u0011\u0001b\u0001\r\u0002a1\u0011\u0004\u0002E\u0004\u001b\ta\t\u0001'\u0001&\u000f!eQ\"\u0001\r\u000e3\rA9!D\u0001\u0019\u001c\u0015:\u0001BD\u0007\u00021;I2\u0001C\b\u000e\u0003a}Qe\u0002\u0005\u0011\u001b\u0005A\n#G\u0002\t#5\t\u00014E\u0013\b\u0011Ii\u0011\u0001'\n\u001a\u0007!\u001dQ\"\u0001\r\u0014K\u001dA9#D\u0001\u0019)e\u0019\u0001rA\u0007\u00021S)c\u0002C\u000b\u000e\t%\tA1\u0001G\u00011\u0019I2\u0001c\u0002\u000e\u0003a-\u0012d\u0001\u0005\u0017\u001b\u0005Ar!J\u0004\t.5\t\u0001dF\r\u0004\u0011\u001bi\u0011\u0001G\u0004&\u000f!=R\"\u0001\r\u00193\rA9!D\u0001\u0019,\u0015\u001a\u0001\u0012G\u0007\u00021e)s\u0001c\r\u000e\u0003aQ\u0012d\u0001E\u0004\u001b\u0005A*$J\u0004\t75\t\u0001tG\r\u0004\u0011\u000fi\u0011\u0001g\t*\u000f\u0011\t\u0005\u0002C\u0001\u000e\u0003a\r\u0011kA\u0001\u0006\u0001\u0001"}, strings={"Lorg/jetbrains/kotlin/resolve/constants/ConstantValueFactory;", "", "builtins", "Lorg/jetbrains/kotlin/builtins/KotlinBuiltIns;", "(Lorg/jetbrains/kotlin/builtins/KotlinBuiltIns;)V", "createAnnotationValue", "Lorg/jetbrains/kotlin/resolve/constants/AnnotationValue;", "value", "Lorg/jetbrains/kotlin/descriptors/annotations/AnnotationDescriptor;", "createArrayValue", "Lorg/jetbrains/kotlin/resolve/constants/ArrayValue;", "", "Lorg/jetbrains/kotlin/resolve/constants/ConstantValue;", "type", "Lorg/jetbrains/kotlin/types/KotlinType;", "createBooleanValue", "Lorg/jetbrains/kotlin/resolve/constants/BooleanValue;", "", "createByteValue", "Lorg/jetbrains/kotlin/resolve/constants/ByteValue;", "", "createCharValue", "Lorg/jetbrains/kotlin/resolve/constants/CharValue;", "", "createConstantValue", "createDoubleValue", "Lorg/jetbrains/kotlin/resolve/constants/DoubleValue;", "", "createEnumValue", "Lorg/jetbrains/kotlin/resolve/constants/EnumValue;", "enumEntryClass", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "createErrorValue", "Lorg/jetbrains/kotlin/resolve/constants/ErrorValue;", "message", "", "createFloatValue", "Lorg/jetbrains/kotlin/resolve/constants/FloatValue;", "", "createIntValue", "Lorg/jetbrains/kotlin/resolve/constants/IntValue;", "", "createIntegerConstantValue", "", "expectedType", "createKClassValue", "Lorg/jetbrains/kotlin/resolve/constants/KClassValue;", "createLongValue", "Lorg/jetbrains/kotlin/resolve/constants/LongValue;", "createNullValue", "Lorg/jetbrains/kotlin/resolve/constants/NullValue;", "createShortValue", "Lorg/jetbrains/kotlin/resolve/constants/ShortValue;", "", "createStringValue", "Lorg/jetbrains/kotlin/resolve/constants/StringValue;"}, moduleName="kotlin-compiler")
public final class ConstantValueFactory {
    private final KotlinBuiltIns builtins;

    @NotNull
    public final LongValue createLongValue(long value) {
        return new LongValue(value, this.builtins);
    }

    @NotNull
    public final IntValue createIntValue(int value) {
        return new IntValue(value, this.builtins);
    }

    @NotNull
    public final ErrorValue createErrorValue(@NotNull String message) {
        Intrinsics.checkParameterIsNotNull(message, "message");
        return ErrorValue.Companion.create(message);
    }

    @NotNull
    public final ShortValue createShortValue(short value) {
        return new ShortValue(value, this.builtins);
    }

    @NotNull
    public final ByteValue createByteValue(byte value) {
        return new ByteValue(value, this.builtins);
    }

    @NotNull
    public final DoubleValue createDoubleValue(double value) {
        return new DoubleValue(value, this.builtins);
    }

    @NotNull
    public final FloatValue createFloatValue(float value) {
        return new FloatValue(value, this.builtins);
    }

    @NotNull
    public final BooleanValue createBooleanValue(boolean value) {
        return new BooleanValue(value, this.builtins);
    }

    @NotNull
    public final CharValue createCharValue(char value) {
        return new CharValue(value, this.builtins);
    }

    @NotNull
    public final StringValue createStringValue(@NotNull String value) {
        Intrinsics.checkParameterIsNotNull(value, "value");
        return new StringValue(value, this.builtins);
    }

    @NotNull
    public final NullValue createNullValue() {
        return new NullValue(this.builtins);
    }

    @NotNull
    public final EnumValue createEnumValue(@NotNull ClassDescriptor enumEntryClass) {
        Intrinsics.checkParameterIsNotNull(enumEntryClass, "enumEntryClass");
        return new EnumValue(enumEntryClass);
    }

    @NotNull
    public final ArrayValue createArrayValue(@NotNull List<? extends ConstantValue<?>> value, @NotNull KotlinType type2) {
        Intrinsics.checkParameterIsNotNull(value, "value");
        Intrinsics.checkParameterIsNotNull(type2, "type");
        return new ArrayValue(value, type2, this.builtins);
    }

    @NotNull
    public final AnnotationValue createAnnotationValue(@NotNull AnnotationDescriptor value) {
        Intrinsics.checkParameterIsNotNull(value, "value");
        return new AnnotationValue(value);
    }

    @NotNull
    public final KClassValue createKClassValue(@NotNull KotlinType type2) {
        Intrinsics.checkParameterIsNotNull(type2, "type");
        return new KClassValue(type2);
    }

    @Nullable
    public final ConstantValue<?> createConstantValue(@Nullable Object value) {
        Object object = value;
        return object instanceof Byte ? (ConstantValue)this.createByteValue(((Number)value).byteValue()) : (object instanceof Short ? (ConstantValue)this.createShortValue(((Number)value).shortValue()) : (object instanceof Integer ? (ConstantValue)this.createIntValue(((Number)value).intValue()) : (object instanceof Long ? (ConstantValue)this.createLongValue(((Number)value).longValue()) : (object instanceof Character ? (ConstantValue)this.createCharValue(((Character)value).charValue()) : (object instanceof Float ? (ConstantValue)this.createFloatValue(((Number)value).floatValue()) : (object instanceof Double ? (ConstantValue)this.createDoubleValue(((Number)value).doubleValue()) : (object instanceof Boolean ? (ConstantValue)this.createBooleanValue((Boolean)value) : (object instanceof String ? (ConstantValue)this.createStringValue((String)value) : (Intrinsics.areEqual(object, null) ? (ConstantValue)this.createNullValue() : (ConstantValue)null)))))))));
    }

    @Nullable
    public final ConstantValue<?> createIntegerConstantValue(long value, @NotNull KotlinType expectedType) {
        Intrinsics.checkParameterIsNotNull(expectedType, "expectedType");
        KotlinType notNullExpected = TypeUtils.makeNotNullable(expectedType);
        return KotlinBuiltIns.isLong(notNullExpected) ? (IntegerValueConstant)this.createLongValue(value) : (KotlinBuiltIns.isInt(notNullExpected) && value == (long)((int)value) ? (IntegerValueConstant)this.createIntValue((int)value) : (KotlinBuiltIns.isShort(notNullExpected) && value == (long)((short)value) ? (IntegerValueConstant)this.createShortValue((short)value) : (KotlinBuiltIns.isByte(notNullExpected) && value == (long)((byte)value) ? (IntegerValueConstant)this.createByteValue((byte)value) : (KotlinBuiltIns.isChar(notNullExpected) ? (IntegerValueConstant)this.createIntValue((int)value) : (IntegerValueConstant)null))));
    }

    public ConstantValueFactory(@NotNull KotlinBuiltIns builtins) {
        Intrinsics.checkParameterIsNotNull(builtins, "builtins");
        this.builtins = builtins;
    }
}

