/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.calls.tower;

import java.util.Collection;
import kotlin.PreconditionsKt;
import kotlin.Unit;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinFileFacade;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.resolve.calls.tower.CandidateWithBoundDispatchReceiver;
import org.jetbrains.kotlin.resolve.calls.tower.CompositeScopeTowerProcessor;
import org.jetbrains.kotlin.resolve.calls.tower.ExplicitReceiverScopeTowerProcessor;
import org.jetbrains.kotlin.resolve.calls.tower.NoExplicitReceiverScopeTowerProcessor;
import org.jetbrains.kotlin.resolve.calls.tower.QualifierScopeTowerProcessor;
import org.jetbrains.kotlin.resolve.calls.tower.ScopeTowerLevel;
import org.jetbrains.kotlin.resolve.calls.tower.ScopeTowerProcessor;
import org.jetbrains.kotlin.resolve.calls.tower.ScopeTowerProcessorsKt;
import org.jetbrains.kotlin.resolve.calls.tower.TowerContext;
import org.jetbrains.kotlin.resolve.scopes.receivers.ClassQualifier;
import org.jetbrains.kotlin.resolve.scopes.receivers.QualifierReceiver;
import org.jetbrains.kotlin.resolve.scopes.receivers.Receiver;
import org.jetbrains.kotlin.resolve.scopes.receivers.ReceiverValue;

@KotlinFileFacade(version={1, 0, 0}, abiVersion=32, data={"3\u0015\u0001Q!\u0001\u0007\u0002\u000b\u0005!\u0011!B\u0001\r\u0003\u0015\u0001Q!\u0001\u0007\u0002\u000b\u0005!\u0019!B\u0001\r\u0003\u0015\tA\"A\u0003\u0002\u0019\u0005)\u0011\u0001C\b\u0006\u00031\tQ!\u0001\u0007\u0002\u000b\u0001iy\u0003\u0002\u0001\t\u00015!\u0011BA\u0005\u0002I\u0005A\n!\u0005\u0002\u0005\u0001!\t\u0011D\u0002E\u0002\u001b\u0011I!!C\u0001%\u0003a\u0011\u0011\u0004\u0002E\u0003\u001b\ta\t\u0001G\u0002U\u0007\u000fiA\u0006B\u0001\t\t5!\u0011BA\u0005\u0002I\u0005A\n!\u0005\u0002\u0005\u0001!\t\u0011D\u0002E\u0002\u001b\u0011I!!C\u0001%\u0003a\u0011\u0011\u0004\u0002E\u0003\u001b\ta\t\u0001G\u0002\u001a(!%Q2E\u0005\u0003\u0013\u0005AZ!\u0003\u0002\n\u0003a1\u0011bB\u0005\u0007\u0013\u0011I1!C\u0001\u0005\u0004a9\u0001T\u0002\r\u0006#\u000e\tAq\u0002+\u0004\b5=B\u0001\u0001\u0005\t\u001b\u0011I!!C\u0001%\u0003a\u0005\u0011C\u0001\u0003\u0001\u0011\u0005Ib\u0001c\u0001\u000e\t%\u0011\u0011\"\u0001\u0013\u00021\tIB\u0001#\u0002\u000e\u00051\u0005\u0001d\u0001+\u0004\b\u0001"}, strings={"createFunctionProcessor", "Lorg/jetbrains/kotlin/resolve/calls/tower/ScopeTowerProcessor;", "C", "context", "Lorg/jetbrains/kotlin/resolve/calls/tower/TowerContext;", "explicitReceiver", "Lorg/jetbrains/kotlin/resolve/scopes/receivers/Receiver;", "ScopeTowerProcessorsKt", "createSimpleProcessor", "collectCandidates", "Lkotlin/Function2;", "Lorg/jetbrains/kotlin/resolve/calls/tower/ScopeTowerLevel;", "Lorg/jetbrains/kotlin/name/Name;", "", "Lorg/jetbrains/kotlin/resolve/calls/tower/CandidateWithBoundDispatchReceiver;", "Lkotlin/Extension;", "createVariableProcessor"}, moduleName="kotlin-compiler")
public final class ScopeTowerProcessorsKt {
    private static final <C> ScopeTowerProcessor<C> createSimpleProcessor(TowerContext<C> context, Receiver explicitReceiver2, Function2<? super ScopeTowerLevel, ? super Name, ? extends Collection<? extends CandidateWithBoundDispatchReceiver<?>>> collectCandidates) {
        Unit unit;
        if (explicitReceiver2 instanceof ReceiverValue) {
            return new ExplicitReceiverScopeTowerProcessor<C>(context, (ReceiverValue)explicitReceiver2, collectCandidates);
        }
        if (explicitReceiver2 instanceof QualifierReceiver) {
            Receiver receiver;
            QualifierScopeTowerProcessor<C> qualifierProcessor = new QualifierScopeTowerProcessor<C>(context, (QualifierReceiver)explicitReceiver2, collectCandidates);
            Receiver receiver2 = explicitReceiver2;
            if (!(receiver2 instanceof ClassQualifier)) {
                receiver2 = null;
            }
            if ((receiver = (ClassQualifier)receiver2) == null || (receiver = receiver.getClassValueReceiver()) == null) {
                return qualifierProcessor;
            }
            Receiver classValue = receiver;
            return new CompositeScopeTowerProcessor(qualifierProcessor, new ExplicitReceiverScopeTowerProcessor<C>(context, (ReceiverValue)classValue, collectCandidates));
        }
        boolean value = explicitReceiver2 == null;
        if (PreconditionsKt.getASSERTIONS_ENABLED()) {
            if (!value) {
                StringBuilder stringBuilder = new StringBuilder().append("Illegal explicit receiver: ").append(explicitReceiver2).append("(");
                Receiver receiver = explicitReceiver2;
                if (receiver == null) {
                    Intrinsics.throwNpe();
                }
                String message = stringBuilder.append(receiver.getClass().getSimpleName()).append(")").toString();
                throw (Throwable)((Object)new AssertionError((Object)message));
            }
            unit = Unit.INSTANCE;
        } else {
            unit = Unit.INSTANCE;
        }
        return new NoExplicitReceiverScopeTowerProcessor<C>(context, collectCandidates);
    }

    @NotNull
    public static final <C> ScopeTowerProcessor<C> createVariableProcessor(@NotNull TowerContext<C> context, @Nullable Receiver explicitReceiver2) {
        Intrinsics.checkParameterIsNotNull(context, "context");
        return ScopeTowerProcessorsKt.createSimpleProcessor(context, explicitReceiver2, (Function2)((Object)Reflection.function(createVariableProcessor.1.INSTANCE)));
    }

    @NotNull
    public static final <C> ScopeTowerProcessor<C> createFunctionProcessor(@NotNull TowerContext<C> context, @Nullable Receiver explicitReceiver2) {
        Intrinsics.checkParameterIsNotNull(context, "context");
        return ScopeTowerProcessorsKt.createSimpleProcessor(context, explicitReceiver2, (Function2)((Object)Reflection.function(createFunctionProcessor.1.INSTANCE)));
    }
}

